/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.servlet.GetDoc;
import com.imcode.imcms.servlet.UriEncodingWorkaroundWrapper;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.FallbackDecoder;
import imcode.util.Utility;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;

public class ImcmsSetupFilter
implements Filter {
    public static final String JSESSIONID_COOKIE_NAME = "JSESSIONID";

    public void doFilter(ServletRequest r, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserDomainObject user;
        r.setCharacterEncoding("UTF-8");
        Object request = (HttpServletRequest)r;
        HttpSession session = request.getSession();
        ImcmsServices service = Imcms.getServices();
        if (session.isNew()) {
            service.incrementSessionCounter();
            this.setDomainSessionCookie(response, session);
        }
        String workaroundUriEncoding = service.getConfig().getWorkaroundUriEncoding();
        FallbackDecoder fallbackDecoder = new FallbackDecoder(Charset.forName("UTF-8"), null != workaroundUriEncoding ? Charset.forName(workaroundUriEncoding) : Charset.defaultCharset());
        if (null != workaroundUriEncoding) {
            request = new UriEncodingWorkaroundWrapper((HttpServletRequest)request, fallbackDecoder);
        }
        if (null == (user = Utility.getLoggedOnUser(request))) {
            user = service.verifyUserByIpOrDefault(request.getRemoteAddr());
            assert (user.isActive());
            Utility.makeUserLoggedIn(request, user);
        }
        ResourceBundle resourceBundle = Utility.getResourceBundle(request);
        Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)new LocalizationContext(resourceBundle));
        Utility.initRequestWithApi((ServletRequest)request, user);
        NDC.setMaxDepth((int)0);
        String contextPath = request.getContextPath();
        if (!"".equals(contextPath)) {
            NDC.push((String)contextPath);
        }
        NDC.push((String)StringUtils.substringAfterLast((String)request.getRequestURI(), (String)"/"));
        this.handleDocumentUri(chain, (HttpServletRequest)request, response, service, fallbackDecoder);
        NDC.setMaxDepth((int)0);
    }

    private void handleDocumentUri(FilterChain chain, HttpServletRequest request, ServletResponse response, ImcmsServices service, FallbackDecoder fallbackDecoder) throws ServletException, IOException {
        DocumentDomainObject document;
        String path = Utility.fallbackUrlDecode(request.getRequestURI(), fallbackDecoder);
        path = StringUtils.substringAfter((String)path, (String)request.getContextPath());
        String documentIdString = ImcmsSetupFilter.getDocumentIdString(service, path);
        ServletContext servletContext = request.getSession().getServletContext();
        if (null == servletContext.getResourcePaths(path) && null != (document = service.getDocumentMapper().getDocument(documentIdString))) {
            try {
                GetDoc.viewDoc(document, request, (HttpServletResponse)response);
                return;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        chain.doFilter((ServletRequest)request, response);
    }

    public static String getDocumentIdString(ImcmsServices service, String path) {
        String documentPathPrefix = service.getConfig().getDocumentPathPrefix();
        String documentIdString = null;
        if (StringUtils.isNotBlank((String)documentPathPrefix) && path.startsWith(documentPathPrefix) && (documentIdString = path.substring(documentPathPrefix.length())).endsWith("/")) {
            documentIdString = documentIdString.substring(0, documentIdString.length() - 1);
        }
        return documentIdString;
    }

    private void setDomainSessionCookie(ServletResponse response, HttpSession session) {
        String domain = Imcms.getServices().getConfig().getSessionCookieDomain();
        if (StringUtils.isNotBlank((String)domain)) {
            Cookie cookie = new Cookie(JSESSIONID_COOKIE_NAME, session.getId());
            cookie.setDomain(domain);
            cookie.setPath("/");
            ((HttpServletResponse)response).addCookie(cookie);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

