/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.mapping.ImageCacheMapper;
import imcode.server.Imcms;
import imcode.server.document.textdocument.ImageCacheDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.util.image.Filter;
import imcode.util.image.ImageOp;
import imcode.util.image.Resize;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCacheManager {
    private static final Log log = LogFactory.getLog(ImageCacheManager.class);
    private static final int CACHE_BUCKETS_COUNT = 20;
    private static final File IMAGE_CACHE_PATH = Imcms.getServices().getConfig().getImageCachePath();
    private static final long MAX_CACHE_SIZE = Imcms.getServices().getConfig().getImageCacheMaxSize();
    private static final File DOCUMENT_IMAGE_CACHE_BUCKETS_FILE = new File(IMAGE_CACHE_PATH, "doc_image_cache");
    private static final File TEXT_IMAGE_CACHE_BUCKETS_FILE = new File(IMAGE_CACHE_PATH, "text_image_cache");

    public static File getCacheFile(ImageCacheDomainObject imageCache) {
        String cacheId = imageCache.getId();
        int bucket = ImageCacheManager.getBucket(cacheId);
        String entryPath = String.format("%d/%s", bucket, cacheId);
        File imageFile = new File(DOCUMENT_IMAGE_CACHE_BUCKETS_FILE, entryPath);
        if (!imageFile.exists() && !(imageFile = new File(TEXT_IMAGE_CACHE_BUCKETS_FILE, entryPath)).exists()) {
            return null;
        }
        if (imageCache.getMetaId() <= 0) {
            Imcms.getServices().getImageCacheMapper().incrementFrequency(imageCache.getId());
        }
        return imageFile;
    }

    public static File storeImage(ImageCacheDomainObject imageCache, File imageFile, boolean deleteFile) {
        ImageCacheMapper imageCacheMapper = Imcms.getServices().getImageCacheMapper();
        if (imageCache.getMetaId() > 0) {
            String cacheId = imageCacheMapper.deleteDocumentImageCache(imageCache.getMetaId(), imageCache.getImageIndex());
            if (cacheId != null) {
                ImageCacheManager.deleteDocumentImageCacheEntry(cacheId);
            }
        } else {
            imageCache.setFrequency(1);
            if (imageCacheMapper.getTextImageCacheFileSizeTotal() >= MAX_CACHE_SIZE) {
                imageCacheMapper.deleteTextImageCacheLFUEntries();
            }
        }
        File cacheFile = ImageCacheManager.processImage(imageCache, imageFile, deleteFile);
        if (cacheFile == null) {
            return null;
        }
        imageCache.setFileSize((int)cacheFile.length());
        imageCacheMapper.addImageCache(imageCache);
        return cacheFile;
    }

    public static void deleteTextImageCacheEntries(List<String> cacheIds) {
        for (String cacheId : cacheIds) {
            int bucket = ImageCacheManager.getBucket(cacheId);
            File entryFile = new File(TEXT_IMAGE_CACHE_BUCKETS_FILE, String.format("%d/%s", bucket, cacheId));
            if (!entryFile.exists()) continue;
            entryFile.delete();
        }
    }

    public static void deleteDocumentImageCacheEntry(String cacheId) {
        int bucket = ImageCacheManager.getBucket(cacheId);
        File entryFile = new File(DOCUMENT_IMAGE_CACHE_BUCKETS_FILE, String.format("%d/%s", bucket, cacheId));
        if (entryFile.exists()) {
            entryFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File processImage(ImageCacheDomainObject imageCache, File imageFile, boolean deleteFile) {
        int bucket;
        File bucketFile;
        File bucketsRootFile = TEXT_IMAGE_CACHE_BUCKETS_FILE;
        if (imageCache.getMetaId() > 0) {
            bucketsRootFile = DOCUMENT_IMAGE_CACHE_BUCKETS_FILE;
        }
        if (!bucketsRootFile.exists()) {
            bucketsRootFile.mkdir();
        }
        if (!(bucketFile = new File(bucketsRootFile, Integer.toString(bucket = ImageCacheManager.getBucket(imageCache.getId())))).exists()) {
            bucketFile.mkdir();
        }
        File cacheFile = new File(bucketFile, imageCache.getId());
        try {
            ImageOp operation = new ImageOp(Imcms.getServices().getConfig()).input(imageFile);
            ImageDomainObject.CropRegion cropRegion = imageCache.getCropRegion();
            int width = imageCache.getWidth();
            int height = imageCache.getHeight();
            if (cropRegion.isValid()) {
                int cropWidth = cropRegion.getWidth();
                int cropHeight = cropRegion.getHeight();
                operation.crop(cropRegion.getCropX1(), cropRegion.getCropY1(), cropWidth, cropHeight);
            }
            if (width > 0 || height > 0) {
                Integer w = width > 0 ? Integer.valueOf(width) : null;
                Integer h = height > 0 ? Integer.valueOf(height) : null;
                Resize resize = width > 0 && height > 0 ? Resize.FORCE : Resize.DEFAULT;
                operation.filter(Filter.LANCZOS);
                operation.resize(w, h, resize);
            }
            if (imageCache.getFormat() != null) {
                operation.outputFormat(imageCache.getFormat());
            }
            if (!operation.processToFile(cacheFile) && cacheFile.exists()) {
                cacheFile.delete();
            }
            File file = cacheFile;
            return file;
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
        }
        finally {
            if (deleteFile) {
                imageFile.delete();
            }
        }
        return null;
    }

    private static int getBucket(String cacheId) {
        return Math.abs(ImageCacheManager.hashCode(cacheId)) % 20;
    }

    private static int hashCode(String value) {
        int hash = 0;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            hash = hash * 31 + value.charAt(i);
        }
        return hash;
    }
}

