/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Stack;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BackDoc
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        Utility.setDefaultHtmlContentType(res);
        Stack history = (Stack)req.getSession().getAttribute("history");
        DocumentDomainObject lastTextDocument = BackDoc.getNextToLastTextDocumentFromHistory(history, imcref);
        if (null != lastTextDocument) {
            req.getSession().setAttribute("history", (Object)history);
            this.redirectToDocumentId(req, res, lastTextDocument.getId());
        } else {
            this.redirectToDocumentId(req, res, imcref.getSystemData().getStartDocument());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    private void redirectToDocumentId(HttpServletRequest request, HttpServletResponse response, int meta_id) throws IOException {
        DocumentDomainObject document = Imcms.getServices().getDocumentMapper().getDocument(meta_id);
        response.sendRedirect(Utility.getAbsolutePathToDocument(request, document));
    }

    public static DocumentDomainObject getNextToLastTextDocumentFromHistory(Stack history, ImcmsServices imcref) {
        DocumentDomainObject document;
        block1: {
            DocumentMapper documentMapper = imcref.getDocumentMapper();
            document = documentMapper.getDocument((Integer)history.pop());
            if (null == history || history.empty()) break block1;
            while (!history.empty() && !BackDoc.isTextDocument(document = documentMapper.getDocument((Integer)history.pop()))) {
            }
        }
        return document;
    }

    private static boolean isTextDocument(DocumentDomainObject document) {
        return DocumentTypeDomainObject.TEXT == document.getDocumentType();
    }
}

