/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.imcms.mapping.BatchDocumentGetter;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentInitializer;
import com.imcode.imcms.mapping.DocumentMenusMap;
import imcode.server.document.DirectDocumentReference;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.GetterDocumentReference;
import imcode.server.document.textdocument.CopyableHashMap;
import imcode.server.document.textdocument.FileDocumentImageSource;
import imcode.server.document.textdocument.ImageArchiveImageSource;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImagesPathRelativePathImageSource;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.document.textdocument.TreeSortKeyDomainObject;
import imcode.util.LazilyLoadedObject;
import imcode.util.Utility;
import imcode.util.image.Format;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TextDocumentInitializer {
    private static final Logger LOG = Logger.getLogger(TextDocumentInitializer.class);
    private final Collection documentIds;
    private final Database database;
    private final DocumentGetter documentGetter;
    private Map documentsMenuItems;
    private Map documentsImages;
    private Map documentsIncludes;
    private Map documentsTexts;
    private Map documentsTemplateIds;
    static final String SQL_GET_MENU_ITEMS = "SELECT meta_id, menus.menu_id, menu_index, sort_order, to_meta_id, manual_sort_order, tree_sort_index FROM menus,childs WHERE menus.menu_id = childs.menu_id AND meta_id ";

    public TextDocumentInitializer(Database database, DocumentGetter documentGetter, Collection documentIds) {
        this.database = database;
        this.documentGetter = documentGetter;
        this.documentIds = documentIds;
    }

    public void initialize(TextDocumentDomainObject document) {
        Integer documentId = new Integer(document.getId());
        document.setLazilyLoadedMenus(new LazilyLoadedObject(new MenusLoader(documentId)));
        document.setLazilyLoadedTexts(new LazilyLoadedObject(new TextsLoader(documentId)));
        document.setLazilyLoadedImages(new LazilyLoadedObject(new ImagesLoader(documentId)));
        document.setLazilyLoadedIncludes(new LazilyLoadedObject(new IncludesLoader(documentId)));
        document.setLazilyLoadedTemplateIds(new LazilyLoadedObject(new TemplateIdsLoader(documentId)));
    }

    private class TemplateIdsLoader
    implements LazilyLoadedObject.Loader {
        private final Integer documentId;

        TemplateIdsLoader(Integer documentId) {
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsTemplateIds();
            TextDocumentDomainObject.TemplateNames templateNames = (TextDocumentDomainObject.TemplateNames)TextDocumentInitializer.this.documentsTemplateIds.get(this.documentId);
            if (null == templateNames) {
                templateNames = new TextDocumentDomainObject.TemplateNames();
            }
            return templateNames;
        }

        private void initDocumentsTemplateIds() {
            if (null == TextDocumentInitializer.this.documentsTemplateIds) {
                TextDocumentInitializer.this.documentsTemplateIds = new HashMap();
                DocumentInitializer.executeWithAppendedIntegerInClause(TextDocumentInitializer.this.database, "SELECT meta_id, template_name, group_id, default_template, default_template_1, default_template_2 FROM text_docs WHERE meta_id ", TextDocumentInitializer.this.documentIds, new ResultSetHandler(){

                    public Object handle(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            Integer documentId = new Integer(rs.getInt("meta_id"));
                            TextDocumentDomainObject.TemplateNames templateNames = new TextDocumentDomainObject.TemplateNames();
                            templateNames.setTemplateName(rs.getString("template_name"));
                            templateNames.setTemplateGroupId(rs.getInt(3));
                            templateNames.setDefaultTemplateName(rs.getString("default_template"));
                            String defaultTemplateIdForR1 = rs.getString("default_template_1");
                            String defaultTemplateIdForR2 = rs.getString("default_template_2");
                            templateNames.setDefaultTemplateNameForRestricted1(defaultTemplateIdForR1);
                            templateNames.setDefaultTemplateNameForRestricted2(defaultTemplateIdForR2);
                            TextDocumentInitializer.this.documentsTemplateIds.put(documentId, templateNames);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private class TextsLoader
    implements LazilyLoadedObject.Loader {
        private final Integer documentId;

        TextsLoader(Integer documentId) {
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsTexts();
            CopyableHashMap documentTexts = (CopyableHashMap)TextDocumentInitializer.this.documentsTexts.get(this.documentId);
            if (null == documentTexts) {
                documentTexts = new CopyableHashMap();
            }
            return documentTexts;
        }

        private void initDocumentsTexts() {
            if (null == TextDocumentInitializer.this.documentsTexts) {
                TextDocumentInitializer.this.documentsTexts = new HashMap();
                DocumentInitializer.executeWithAppendedIntegerInClause(TextDocumentInitializer.this.database, "SELECT meta_id, name, text, type FROM texts WHERE meta_id ", TextDocumentInitializer.this.documentIds, new ResultSetHandler(){

                    public Object handle(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            Integer documentId = new Integer(rs.getInt(1));
                            Integer textIndex = new Integer(rs.getInt(2));
                            String text = rs.getString(3);
                            int textType = rs.getInt(4);
                            CopyableHashMap documentTextsMap = (CopyableHashMap)TextDocumentInitializer.this.documentsTexts.get(documentId);
                            if (null == documentTextsMap) {
                                documentTextsMap = new CopyableHashMap();
                                TextDocumentInitializer.this.documentsTexts.put(documentId, documentTextsMap);
                            }
                            documentTextsMap.put(textIndex, new TextDomainObject(text, textType));
                        }
                        return null;
                    }
                });
            }
        }
    }

    private class ImagesLoader
    implements LazilyLoadedObject.Loader {
        private final Integer documentId;

        ImagesLoader(Integer documentId) {
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsImages();
            CopyableHashMap documentImagesMap = (CopyableHashMap)TextDocumentInitializer.this.documentsImages.get(this.documentId);
            if (null == documentImagesMap) {
                documentImagesMap = new CopyableHashMap();
            }
            return documentImagesMap;
        }

        private void initDocumentsImages() {
            if (null == TextDocumentInitializer.this.documentsImages) {
                TextDocumentInitializer.this.documentsImages = new HashMap();
                DocumentInitializer.executeWithAppendedIntegerInClause(TextDocumentInitializer.this.database, "SELECT meta_id,name,image_name,imgurl,width,height,border,v_space,h_space,target,align,alt_text,low_scr,linkurl,type,archive_image_id, format, crop_x1, crop_y1, crop_x2, crop_y2  FROM images WHERE meta_id ", TextDocumentInitializer.this.documentIds, new ResultSetHandler(){

                    public Object handle(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            Integer documentId = new Integer(rs.getInt(1));
                            Map imageMap = (Map)TextDocumentInitializer.this.documentsImages.get(documentId);
                            if (null == imageMap) {
                                imageMap = new CopyableHashMap();
                                TextDocumentInitializer.this.documentsImages.put(documentId, imageMap);
                            }
                            Integer imageIndex = new Integer(rs.getInt(2));
                            ImageDomainObject image = new ImageDomainObject();
                            image.setName(rs.getString(3));
                            String imageSource = rs.getString(4);
                            image.setWidth(rs.getInt(5));
                            image.setHeight(rs.getInt(6));
                            image.setBorder(rs.getInt(7));
                            image.setVerticalSpace(rs.getInt(8));
                            image.setHorizontalSpace(rs.getInt(9));
                            image.setTarget(rs.getString(10));
                            image.setAlign(rs.getString(11));
                            image.setAlternateText(rs.getString(12));
                            image.setLowResolutionUrl(rs.getString(13));
                            image.setLinkUrl(rs.getString(14));
                            int imageType = rs.getInt(15);
                            image.setArchiveImageId((Long)rs.getObject(16));
                            image.setFormat(Format.findFormat(rs.getShort(17)));
                            ImageDomainObject.CropRegion region = new ImageDomainObject.CropRegion(rs.getInt(18), rs.getInt(19), rs.getInt(20), rs.getInt(21));
                            image.setCropRegion(region);
                            if (StringUtils.isNotBlank((String)imageSource)) {
                                if (1 == imageType) {
                                    try {
                                        int fileDocumentId = Integer.parseInt(imageSource);
                                        DocumentDomainObject document = TextDocumentInitializer.this.documentGetter.getDocument(new Integer(fileDocumentId));
                                        if (null != document) {
                                            image.setSource(new FileDocumentImageSource(new DirectDocumentReference(document)));
                                        }
                                    }
                                    catch (NumberFormatException nfe) {
                                        LOG.warn((Object)("Non-numeric document-id \"" + imageSource + "\" for image in database."));
                                    }
                                    catch (ClassCastException cce) {
                                        LOG.warn((Object)("Non-file-document-id \"" + imageSource + "\" for image in database."));
                                    }
                                } else if (0 == imageType) {
                                    image.setSource(new ImagesPathRelativePathImageSource(imageSource));
                                } else if (2 == imageType) {
                                    image.setSource(new ImageArchiveImageSource(imageSource));
                                }
                            }
                            imageMap.put(imageIndex, image);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private class IncludesLoader
    implements LazilyLoadedObject.Loader {
        private final Integer documentId;

        IncludesLoader(Integer documentId) {
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsIncludes();
            CopyableHashMap documentIncludesMap = (CopyableHashMap)TextDocumentInitializer.this.documentsIncludes.get(this.documentId);
            if (null == documentIncludesMap) {
                documentIncludesMap = new CopyableHashMap();
            }
            return documentIncludesMap;
        }

        private void initDocumentsIncludes() {
            if (null == TextDocumentInitializer.this.documentsIncludes) {
                TextDocumentInitializer.this.documentsIncludes = new HashMap();
                DocumentInitializer.executeWithAppendedIntegerInClause(TextDocumentInitializer.this.database, "SELECT meta_id, include_id, included_meta_id FROM includes WHERE meta_id ", TextDocumentInitializer.this.documentIds, new ResultSetHandler(){

                    public Object handle(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            Integer documentId = new Integer(rs.getInt(1));
                            Integer includeIndex = new Integer(rs.getInt(2));
                            Integer includedDocumentId = new Integer(rs.getInt(3));
                            CopyableHashMap documentIncludesMap = (CopyableHashMap)TextDocumentInitializer.this.documentsIncludes.get(documentId);
                            if (null == documentIncludesMap) {
                                documentIncludesMap = new CopyableHashMap();
                                TextDocumentInitializer.this.documentsIncludes.put(documentId, documentIncludesMap);
                            }
                            documentIncludesMap.put(includeIndex, includedDocumentId);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private class MenusLoader
    implements LazilyLoadedObject.Loader {
        private final Integer documentId;

        MenusLoader(Integer documentId) {
            this.documentId = documentId;
        }

        public LazilyLoadedObject.Copyable load() {
            this.initDocumentsMenuItems();
            DocumentMenusMap menusMap = (DocumentMenusMap)TextDocumentInitializer.this.documentsMenuItems.get(this.documentId);
            if (null == menusMap) {
                menusMap = new DocumentMenusMap();
            }
            return menusMap;
        }

        void initDocumentsMenuItems() {
            if (null == TextDocumentInitializer.this.documentsMenuItems) {
                TextDocumentInitializer.this.documentsMenuItems = new HashMap();
                final HashSet destinationDocumentIds = new HashSet();
                final BatchDocumentGetter batchDocumentGetter = new BatchDocumentGetter(destinationDocumentIds, TextDocumentInitializer.this.documentGetter);
                DocumentInitializer.executeWithAppendedIntegerInClause(TextDocumentInitializer.this.database, TextDocumentInitializer.SQL_GET_MENU_ITEMS, TextDocumentInitializer.this.documentIds, new ResultSetHandler(){

                    public Object handle(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            MenuDomainObject menu;
                            int documentId = rs.getInt(1);
                            int menuId = rs.getInt(2);
                            int menuIndex = rs.getInt(3);
                            int menuSortOrder = rs.getInt(4);
                            Integer destinationDocumentId = new Integer(rs.getInt(5));
                            Integer sortKey = Utility.getInteger(rs.getObject(6));
                            destinationDocumentIds.add(destinationDocumentId);
                            Map documentMenus = (Map)TextDocumentInitializer.this.documentsMenuItems.get(new Integer(documentId));
                            if (null == documentMenus) {
                                documentMenus = new DocumentMenusMap();
                                TextDocumentInitializer.this.documentsMenuItems.put(new Integer(documentId), documentMenus);
                            }
                            if (null == (menu = (MenuDomainObject)documentMenus.get(new Integer(menuIndex)))) {
                                menu = new MenuDomainObject(menuId, menuSortOrder);
                                documentMenus.put(new Integer(menuIndex), menu);
                            }
                            MenuItemDomainObject menuItem = new MenuItemDomainObject(new GetterDocumentReference(destinationDocumentId, batchDocumentGetter), sortKey, new TreeSortKeyDomainObject(rs.getString(7)));
                            menu.addMenuItemUnchecked(menuItem);
                        }
                        return null;
                    }
                });
            }
        }
    }
}

