/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.flow.EditDocumentPageFlow;
import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class EditBrowserDocumentPageFlow
extends EditDocumentPageFlow {
    public static final String REQUEST_PARAMETER__BROWSERS = "browsers";
    public static final String REQUEST_PARAMETER_PREFIX__DESTINATION = "destination_";
    public static final String URL_I15D_PAGE__BROWSERDOC = "/jsp/docadmin/browser_document.jsp";
    public static final String REQUEST_PARAMETER__ADD_BROWSERS_BUTTON = "add_browsers";
    public static final String REQUEST_ATTRIBUTE__ADDED_BROWSERS = "addedBrowsers";

    public EditBrowserDocumentPageFlow(BrowserDocumentDomainObject document, DispatchCommand returnCommand, DocumentPageFlow.SaveDocumentCommand saveDocumentCommand) {
        super(document, returnCommand, saveDocumentCommand);
    }

    protected void dispatchFromEditPage(HttpServletRequest request, HttpServletResponse response, String page) throws IOException, ServletException {
        Map addedBrowsers = this.getAddedBrowsersFromRequest(request, Imcms.getServices().getDocumentMapper());
        if (null != request.getParameter(REQUEST_PARAMETER__ADD_BROWSERS_BUTTON)) {
            this.forwardToBrowserDocumentPageWithBrowsersMap(request, response, addedBrowsers);
        }
    }

    protected void dispatchOkFromEditPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map addedBrowsers = this.getAddedBrowsersFromRequest(request, Imcms.getServices().getDocumentMapper());
        Utility.removeNullValuesFromMap(addedBrowsers);
        BrowserDocumentDomainObject browserDocument = (BrowserDocumentDomainObject)this.document;
        browserDocument.setBrowserDocuments(addedBrowsers);
    }

    protected void dispatchToFirstPage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        BrowserDocumentDomainObject browserDocument = (BrowserDocumentDomainObject)this.document;
        this.forwardToBrowserDocumentPageWithBrowsersMap(request, response, browserDocument.getBrowserDocumentIdMap());
    }

    public void forwardToBrowserDocumentPageWithBrowsersMap(HttpServletRequest request, HttpServletResponse response, Map browsersMap) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        request.setAttribute(REQUEST_ATTRIBUTE__ADDED_BROWSERS, (Object)browsersMap);
        request.getRequestDispatcher("/imcms/" + user.getLanguageIso639_2() + URL_I15D_PAGE__BROWSERDOC).forward((ServletRequest)request, (ServletResponse)response);
    }

    Map getAddedBrowsersFromRequest(HttpServletRequest request, DocumentMapper documentMapper) {
        HashMap<BrowserDocumentDomainObject.Browser, Integer> addedBrowsers = new HashMap<BrowserDocumentDomainObject.Browser, Integer>();
        addedBrowsers.put(BrowserDocumentDomainObject.Browser.DEFAULT, null);
        String[] addedBrowserIdStrings = request.getParameterValues(REQUEST_PARAMETER__BROWSERS);
        for (int i = 0; null != addedBrowserIdStrings && i < addedBrowserIdStrings.length; ++i) {
            int addedBrowserId = Integer.parseInt(addedBrowserIdStrings[i]);
            BrowserDocumentDomainObject.Browser browser = documentMapper.getBrowserById(addedBrowserId);
            addedBrowsers.put(browser, null);
        }
        Map parameterMap = request.getParameterMap();
        for (String parameterName : parameterMap.keySet()) {
            if (!parameterName.startsWith(REQUEST_PARAMETER_PREFIX__DESTINATION)) continue;
            int browserId = Integer.parseInt(StringUtils.substringAfter((String)parameterName, (String)REQUEST_PARAMETER_PREFIX__DESTINATION));
            BrowserDocumentDomainObject.Browser browser = documentMapper.getBrowserById(browserId);
            Integer destinationDocumentId = null;
            try {
                destinationDocumentId = Integer.valueOf(request.getParameter(parameterName));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            addedBrowsers.put(browser, destinationDocumentId);
        }
        return addedBrowsers;
    }
}

