/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPermissionSetPage;
import com.imcode.imcms.flow.OkCancelPage;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;

public class DocumentPermissionsPage
extends OkCancelPage {
    public static final String REQUEST_PARAMETER__ROLES_WITHOUT_PERMISSIONS = "roles_no_rights";
    public static final String REQUEST_PARAMETER_PREFIX__ROLE_PERMISSION = "role_";
    public static final String REQUEST_PARAMETER__DEFAULT_TEMPLATE_ID = "default_template";
    public static final String REQUEST_PARAMETER__ADD_ROLES = "add_roles";
    public static final String REQUEST_PARAMETER__RESTRICTED_ONE_MORE_PRIVILEGED_THAN_RESTRICTED_TWO = "restricted_one_more_privileged_than_restricted_two";
    private static final String URL_I15D_PAGE__DOCUMENT_PERMISSIONS = "/jsp/docadmin/document_permissions.jsp";
    private DocumentDomainObject document;

    public DocumentPermissionsPage(DocumentDomainObject document, DispatchCommand okCommand, DispatchCommand cancelCommand) {
        super(okCommand, cancelCommand);
        this.document = document;
    }

    public String getPath(HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        return "/imcms/" + user.getLanguageIso639_2() + URL_I15D_PAGE__DOCUMENT_PERMISSIONS;
    }

    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentPermissionSetDomainObject documentPermissionSet = null;
        boolean forNew = false;
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (Utility.parameterIsSet(request, "define_set_1") && user.canDefineRestrictedOneFor(this.document)) {
            documentPermissionSet = this.document.getPermissionSets().getRestricted1();
        } else if (Utility.parameterIsSet(request, "define_set_2") && user.canDefineRestrictedTwoFor(this.document)) {
            documentPermissionSet = this.document.getPermissionSets().getRestricted2();
        } else if (Utility.parameterIsSet(request, "define_new_set_1") && user.canDefineRestrictedOneFor(this.document)) {
            documentPermissionSet = this.document.getPermissionSetsForNewDocuments().getRestricted1();
            forNew = true;
        } else if (Utility.parameterIsSet(request, "define_new_set_2") && user.canDefineRestrictedTwoFor(this.document)) {
            documentPermissionSet = this.document.getPermissionSetsForNewDocuments().getRestricted2();
            forNew = true;
        }
        if (null != documentPermissionSet) {
            DispatchCommand returnCommand = new DispatchCommand(){

                public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    DocumentPermissionsPage.this.forward(request, response);
                }
            };
            DocumentPermissionSetPage documentPermissionSetPage = new DocumentPermissionSetPage(this.document, documentPermissionSet, forNew, returnCommand, returnCommand);
            documentPermissionSetPage.forward(request, response);
        } else {
            this.forward(request, response);
        }
    }

    protected void updateFromRequest(HttpServletRequest request) {
        this.document.setRoleIdsMappedToDocumentPermissionSetTypes(this.getRoleIdsMappedToDocumentPermissionSetTypesFromRequest(request));
        this.document.setRestrictedOneMorePrivilegedThanRestrictedTwo(Utility.parameterIsSet(request, REQUEST_PARAMETER__RESTRICTED_ONE_MORE_PRIVILEGED_THAN_RESTRICTED_TWO));
        this.document.setLinkableByOtherUsers(Utility.parameterIsSet(request, "shared"));
        this.document.setLinkedForUnauthorizedUsers(Utility.parameterIsSet(request, "show_meta"));
        if (this.document instanceof TextDocumentDomainObject) {
            String defaultTemplateIdStr = request.getParameter(REQUEST_PARAMETER__DEFAULT_TEMPLATE_ID);
            String templateName = StringUtils.isNotBlank((String)defaultTemplateIdStr) ? defaultTemplateIdStr : null;
            ((TextDocumentDomainObject)this.document).setDefaultTemplateId(templateName);
        }
    }

    private RoleIdToDocumentPermissionSetTypeMappings getRoleIdsMappedToDocumentPermissionSetTypesFromRequest(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        Collection rolesWithPermissions = CollectionUtils.collect((Collection)CollectionUtils.select(parameterMap.keySet(), (Predicate)new RolePermissionParameterPredicate()), (Transformer)new RolePermissionParameterToRoleIdTransformer());
        RoleIdToDocumentPermissionSetTypeMappings result = new RoleIdToDocumentPermissionSetTypeMappings();
        for (RoleId roleId : rolesWithPermissions) {
            int permissionSetTypeId = Integer.parseInt(request.getParameter(REQUEST_PARAMETER_PREFIX__ROLE_PERMISSION + roleId.intValue()));
            DocumentPermissionSetTypeDomainObject documentPermissionSetType = DocumentPermissionSetTypeDomainObject.fromInt(permissionSetTypeId);
            result.setPermissionSetTypeForRole(roleId, documentPermissionSetType);
        }
        String[] rolesToGiveReadPermission = request.getParameterValues(REQUEST_PARAMETER__ROLES_WITHOUT_PERMISSIONS);
        if (null != request.getParameter(REQUEST_PARAMETER__ADD_ROLES) && null != rolesToGiveReadPermission) {
            for (int i = 0; i < rolesToGiveReadPermission.length; ++i) {
                RoleId roleId = new RoleId(Integer.parseInt(rolesToGiveReadPermission[i]));
                result.setPermissionSetTypeForRole(roleId, DocumentPermissionSetTypeDomainObject.READ);
            }
        }
        return result;
    }

    public DocumentDomainObject getDocument() {
        return this.document;
    }

    private static class RolePermissionParameterToRoleIdTransformer
    implements Transformer {
        private RolePermissionParameterToRoleIdTransformer() {
        }

        public Object transform(Object input) {
            int roleId = Integer.parseInt(((String)input).substring(DocumentPermissionsPage.REQUEST_PARAMETER_PREFIX__ROLE_PERMISSION.length()));
            return new RoleId(roleId);
        }
    }

    private static class RolePermissionParameterPredicate
    implements Predicate {
        private RolePermissionParameterPredicate() {
        }

        public boolean evaluate(Object object) {
            return ((String)object).startsWith(DocumentPermissionsPage.REQUEST_PARAMETER_PREFIX__ROLE_PERMISSION);
        }
    }
}

