/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db.refactoring;

import com.imcode.db.Database;
import com.imcode.imcms.db.refactoring.DatabasePlatform;
import com.imcode.imcms.db.refactoring.model.Column;
import com.imcode.imcms.db.refactoring.model.ForeignKey;
import com.imcode.imcms.db.refactoring.model.ForeignKeyHasLocalColumnName;
import com.imcode.imcms.db.refactoring.model.Table;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class MysqlDatabasePlatform
extends DatabasePlatform {
    public MysqlDatabasePlatform(Database database) {
        super(database);
    }

    public void dropForeignKey(ForeignKey foreignKey) {
        this.update("ALTER TABLE " + foreignKey.getLocalTableName() + " DROP FOREIGN KEY " + foreignKey.getName());
    }

    public void alterColumn(Table table, String columnName, Column column) {
        ArrayList<ForeignKey> foreignKeysWithLocalColumnName = new ArrayList<ForeignKey>();
        CollectionUtils.select(table.getForeignKeys(), (Predicate)new ForeignKeyHasLocalColumnName(columnName), foreignKeysWithLocalColumnName);
        this.dropForeignKeys(foreignKeysWithLocalColumnName);
        this.update("ALTER TABLE " + table.getName() + " CHANGE COLUMN " + columnName + " " + this.createColumnDefinition(column));
    }

    protected String createColumnDefinition(Column column) {
        ArrayList<String> columnDefinition = new ArrayList<String>();
        columnDefinition.add(column.getName());
        columnDefinition.add(this.getTypeString(column));
        columnDefinition.add(column.isNullable() ? "NULL" : "NOT NULL");
        if (column.hasDefault()) {
            columnDefinition.add("DEFAULT " + column.getDefaultValue());
        } else if (column.isAutoIncremented()) {
            columnDefinition.add("AUTO_INCREMENT");
        }
        return StringUtils.join(columnDefinition.iterator(), (String)" ");
    }

    public void createTable(Table table) {
        super.createTable(table);
    }

    protected String createTableDefinition(Table table) {
        return super.createTableDefinition(table) + " ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }
}

