/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db.refactoring;

import com.imcode.db.Database;
import com.imcode.imcms.db.refactoring.DatabasePlatform;
import com.imcode.imcms.db.refactoring.model.Column;
import com.imcode.imcms.db.refactoring.model.ForeignKey;
import com.imcode.imcms.db.refactoring.model.ForeignKeyHasLocalColumnName;
import com.imcode.imcms.db.refactoring.model.Table;
import com.imcode.imcms.db.refactoring.model.TableWrapper;
import com.imcode.imcms.db.refactoring.model.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.lang.StringUtils;

public class MssqlDatabasePlatform
extends DatabasePlatform {
    public MssqlDatabasePlatform(Database database) {
        super(database);
    }

    public void dropForeignKey(ForeignKey foreignKey) {
        this.update("ALTER TABLE " + foreignKey.getLocalTableName() + " DROP CONSTRAINT " + foreignKey.getName());
    }

    public void alterColumn(Table table, final String columnName, final Column column) {
        String tableName = table.getName();
        final String temporaryTableName = tableName + "_tmp";
        TableWrapper newTable = new TableWrapper(table){

            @Override
            public String getName() {
                return temporaryTableName;
            }

            @Override
            public Collection<Column> getColumns() {
                return CollectionUtils.collect(super.getColumns(), (Transformer)new Transformer(){

                    public Object transform(Object input) {
                        Column c = (Column)input;
                        if (columnName.equals(c.getName())) {
                            return column;
                        }
                        return c;
                    }
                });
            }

            @Override
            public Collection<ForeignKey> getForeignKeys() {
                return CollectionUtils.select(super.getForeignKeys(), (Predicate)new NotPredicate((Predicate)new ForeignKeyHasLocalColumnName(columnName)));
            }
        };
        this.dropForeignKeys(table.getForeignKeys());
        this.createTable(newTable);
        this.copyTable(tableName, temporaryTableName);
        this.dropTable(tableName);
        this.renameTable(temporaryTableName, tableName);
    }

    private void renameTable(String oldName, String newName) {
        this.update("sp_rename '" + oldName + "', '" + newName + "'");
    }

    public void copyTable(String tableName, String temporaryTableName) {
        this.update("INSERT INTO " + temporaryTableName + " SELECT * FROM " + tableName);
    }

    protected String createColumnDefinition(Column column) {
        ArrayList<String> columnDefinition = new ArrayList<String>();
        columnDefinition.add(column.getName());
        columnDefinition.add(this.getTypeString(column));
        columnDefinition.add(column.isNullable() ? "NULL" : "NOT NULL");
        if (column.isAutoIncremented()) {
            columnDefinition.add("IDENTITY");
        }
        return StringUtils.join(columnDefinition.iterator(), (String)" ");
    }

    protected String getTypeString(Column column) {
        String typeString = super.getTypeString(column);
        if (column.getType() == Type.VARCHAR) {
            typeString = "N" + typeString;
        }
        return typeString;
    }
}

