/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.SingleConnectionDatabase;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.TransactionDatabaseCommand;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.db.handlers.SingleObjectHandler;
import com.imcode.imcms.db.AddVarcharColumnUpgrade;
import com.imcode.imcms.db.ColumnSizeUpgrade;
import com.imcode.imcms.db.CompositeUpgrade;
import com.imcode.imcms.db.CreateTableUpgrade;
import com.imcode.imcms.db.DatabaseVersion;
import com.imcode.imcms.db.DatabaseVersionUpgradePair;
import com.imcode.imcms.db.DdlUtilsSqlBuilderCommand;
import com.imcode.imcms.db.ImcmsDatabaseCreator;
import com.imcode.imcms.db.ImcmsDatabaseUpgrade;
import com.imcode.imcms.db.TemplateNamesUpgrade;
import com.imcode.imcms.db.UnicodeUpgrade;
import imcode.server.Imcms;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.log4j.Logger;

public class StartupDatabaseUpgrade
extends ImcmsDatabaseUpgrade {
    private static final String SQL_STATE__MISSING_TABLE = "42S02";
    private static final Logger LOG = Logger.getLogger(StartupDatabaseUpgrade.class);
    DatabaseVersionUpgradePair[] upgrades;
    private ImcmsDatabaseCreator imcmsDatabaseCreator;

    public StartupDatabaseUpgrade(Database ddl, ImcmsDatabaseCreator imcmsDatabaseCreator) {
        super(ddl);
        this.upgrades = new DatabaseVersionUpgradePair[]{new DatabaseVersionUpgradePair(4, 0, new CreateTableUpgrade(this.wantedDdl, "database_version")), new DatabaseVersionUpgradePair(4, 1, new UnicodeUpgrade(this.wantedDdl)), new DatabaseVersionUpgradePair(4, 2, new CompositeUpgrade(new ColumnSizeUpgrade(this.wantedDdl, "categories", "name", 128), new ColumnSizeUpgrade(this.wantedDdl, "category_types", "name", 128))), new DatabaseVersionUpgradePair(4, 3, new CreateTableUpgrade(this.wantedDdl, "document_properties")), new DatabaseVersionUpgradePair(4, 4, new TemplateNamesUpgrade(new File(Imcms.getPath(), "WEB-INF/templates/text"))), new DatabaseVersionUpgradePair(4, 5, new CompositeUpgrade(new CreateTableUpgrade(this.wantedDdl, "texts_history"), new CreateTableUpgrade(this.wantedDdl, "images_history"))), new DatabaseVersionUpgradePair(4, 6, new CompositeUpgrade(new CreateTableUpgrade(this.wantedDdl, "menus_history"), new CreateTableUpgrade(this.wantedDdl, "childs_history"))), new DatabaseVersionUpgradePair(4, 7, new CreateTableUpgrade(this.wantedDdl, "document_search_log")), new DatabaseVersionUpgradePair(4, 8, new CreateTableUpgrade(this.wantedDdl, "profiles")), new DatabaseVersionUpgradePair(4, 9, new CompositeUpgrade(new ColumnSizeUpgrade(this.wantedDdl, "classification", "code", 128), new ColumnSizeUpgrade(this.wantedDdl, "users", "login_name", 128), new ColumnSizeUpgrade(this.wantedDdl, "users", "first_name", 64), new ColumnSizeUpgrade(this.wantedDdl, "users", "last_name", 64), new ColumnSizeUpgrade(this.wantedDdl, "users", "title", 64), new ColumnSizeUpgrade(this.wantedDdl, "users", "company", 64), new ColumnSizeUpgrade(this.wantedDdl, "users", "address", 128), new ColumnSizeUpgrade(this.wantedDdl, "users", "city", 64), new ColumnSizeUpgrade(this.wantedDdl, "users", "zip", 64), new ColumnSizeUpgrade(this.wantedDdl, "users", "country", 64), new ColumnSizeUpgrade(this.wantedDdl, "users", "county_council", 128), new ColumnSizeUpgrade(this.wantedDdl, "users", "email", 128))), new DatabaseVersionUpgradePair(4, 10, new AddVarcharColumnUpgrade(this.wantedDdl, "users", "language", "session_id", 128, false))};
        this.imcmsDatabaseCreator = imcmsDatabaseCreator;
    }

    public void upgrade(com.imcode.db.Database database) throws DatabaseException {
        DatabaseVersion databaseVersion = this.getDatabaseVersion(database);
        if (null == databaseVersion) {
            int tableCount = (Integer)database.execute((DatabaseCommand)new DdlUtilsSqlBuilderCommand(){

                protected Object executeSqlBuilder(DatabaseConnection databaseConnection, SqlBuilder sqlBuilder) {
                    Database database = sqlBuilder.getPlatform().readModelFromDatabase(databaseConnection.getConnection(), null);
                    return new Integer(database.getTableCount());
                }
            });
            if (0 == tableCount) {
                this.createDatabaseAndSetVersion(database, this.wantedDdl);
                return;
            }
            databaseVersion = new DatabaseVersion(0, 0);
        }
        this.upgradeDatabase(databaseVersion, database);
    }

    private void upgradeDatabase(DatabaseVersion databaseVersion, com.imcode.db.Database database) {
        LOG.info((Object)("Database is version " + databaseVersion));
        if (this.getLastDatabaseVersion().compareTo(databaseVersion) > 0) {
            for (final DatabaseVersionUpgradePair versionUpgradePair : this.upgrades) {
                final DatabaseVersion upgradeVersion = versionUpgradePair.getVersion();
                if (upgradeVersion.compareTo(databaseVersion) <= 0) continue;
                LOG.info((Object)("Upgrading database to version " + upgradeVersion));
                database.execute((DatabaseCommand)new TransactionDatabaseCommand(){

                    public Object executeInTransaction(DatabaseConnection connection) throws DatabaseException {
                        SingleConnectionDatabase database = new SingleConnectionDatabase(connection);
                        versionUpgradePair.getUpgrade().upgrade((com.imcode.db.Database)database);
                        StartupDatabaseUpgrade.this.setDatabaseVersion((com.imcode.db.Database)database, upgradeVersion);
                        return null;
                    }
                });
                databaseVersion = upgradeVersion;
            }
            LOG.info((Object)("Database upgraded to version " + databaseVersion));
        }
    }

    private void setDatabaseVersion(com.imcode.db.Database database, DatabaseVersion upgradeVersion) {
        Integer rowsUpdated = (Integer)database.execute((DatabaseCommand)new SqlUpdateCommand("UPDATE database_version SET major = ?, minor = ?", new Object[]{upgradeVersion.getMajorVersion(), upgradeVersion.getMinorVersion()}));
        if (0 == rowsUpdated) {
            database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("database_version", (Object[][])new Object[][]{{"major", upgradeVersion.getMajorVersion()}, {"minor", upgradeVersion.getMinorVersion()}}));
        }
    }

    private void createDatabaseAndSetVersion(com.imcode.db.Database database, Database wantedDdl) {
        this.imcmsDatabaseCreator.createDatabase(database, wantedDdl);
        DatabaseVersion lastDatabaseVersion = this.getLastDatabaseVersion();
        this.setDatabaseVersion(database, lastDatabaseVersion);
    }

    private DatabaseVersion getLastDatabaseVersion() {
        return this.upgrades[this.upgrades.length - 1].getVersion();
    }

    private DatabaseVersion getDatabaseVersion(com.imcode.db.Database database) {
        SqlQueryCommand sqlQueryCommand = new SqlQueryCommand("SELECT major, minor FROM database_version", new Object[0], (ResultSetHandler)new SingleObjectHandler(new RowTransformer(){

            public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
                int major = resultSet.getInt("major");
                int minor = resultSet.getInt("minor");
                return new DatabaseVersion(major, minor);
            }

            public Class getClassOfCreatedObjects() {
                return DatabaseVersion.class;
            }
        }));
        try {
            return (DatabaseVersion)database.execute((DatabaseCommand)sqlQueryCommand);
        }
        catch (DatabaseException dbe) {
            for (Throwable t = dbe; null != t; t = t.getCause()) {
                if (!(t instanceof SQLException)) continue;
                for (SQLException se = (SQLException)t; null != se; se = se.getNextException()) {
                    if (!SQL_STATE__MISSING_TABLE.equals(se.getSQLState())) continue;
                    return null;
                }
            }
            throw dbe;
        }
    }
}

