/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.commands.CompositeDatabaseCommand;
import com.imcode.imcms.db.DdlUtilsPlatformCommand;
import com.imcode.imcms.util.l10n.LocalizedMessageProvider;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.log4j.Logger;

public class ImcmsDatabaseCreator {
    private final LocalizedMessageProvider localizedMessageProvider;
    private final Reader initScriptReader;
    private static final Logger LOG = Logger.getLogger(ImcmsDatabaseCreator.class);

    public ImcmsDatabaseCreator(Reader initScriptReader, LocalizedMessageProvider localizedMessageProvider) {
        this.initScriptReader = initScriptReader;
        this.localizedMessageProvider = localizedMessageProvider;
    }

    public void createDatabase(Database database, final org.apache.ddlutils.model.Database wantedDdl) {
        database.execute((DatabaseCommand)new CompositeDatabaseCommand(new DatabaseCommand[]{new DdlUtilsPlatformCommand(){

            protected Object executePlatform(DatabaseConnection databaseConnection, Platform platform) {
                CreationParameters params = new CreationParameters();
                params.addParameter(null, "ENGINE", "InnoDB");
                params.addParameter(null, "CHARACTER SET", "UTF8");
                String sql = platform.getCreateTablesSql(wantedDdl, params, false, false);
                LOG.trace((Object)sql);
                platform.evaluateBatch(sql, false);
                return null;
            }
        }, new DdlUtilsPlatformCommand(){

            protected Object executePlatform(DatabaseConnection databaseConnection, Platform platform) {
                String sql;
                try {
                    sql = IOUtils.toString((Reader)ImcmsDatabaseCreator.this.initScriptReader);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                sql = ImcmsDatabaseCreator.this.massageSql(platform, sql);
                LOG.trace((Object)sql);
                platform.evaluateBatch(sql, false);
                return null;
            }
        }}));
    }

    private String massageSql(Platform platform, String sql) {
        String platformName = platform.getName().toLowerCase();
        sql = Pattern.compile("^-- " + platformName + " ", 8).matcher(sql).replaceAll("");
        sql = Pattern.compile("^-- \\w+ (.*?)\n", 8).matcher(sql).replaceAll("");
        String language = Locale.getDefault().getISO3Language();
        if (StringUtils.isBlank((String)language)) {
            language = "eng";
        }
        sql = sql.replaceAll("@language@", language);
        sql = sql.replaceAll("@headline@", this.localizedMessageProvider.get("start_document/headline").toLocalizedString(language));
        sql = sql.replaceAll("@text1@", this.localizedMessageProvider.get("start_document/text1").toLocalizedString(language));
        sql = sql.replaceAll("@text2@", this.localizedMessageProvider.get("start_document/text2").toLocalizedString(language));
        return sql;
    }
}

