/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.imcms.db.DdlUtilsSqlBuilderCommand;
import com.imcode.imcms.db.ImcmsDatabaseUpgrade;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;

class AddVarcharColumnUpgrade
extends ImcmsDatabaseUpgrade {
    private Column column;
    private String previousColumnName;
    private String tableName;

    protected AddVarcharColumnUpgrade(Database ddl, String tableName, String previousColumnName, String name, int size, boolean required) {
        super(ddl);
        this.tableName = tableName;
        this.column = new Column();
        this.column.setType("varchar");
        this.column.setName(name);
        this.column.setSize("" + size);
        this.column.setRequired(required);
        this.previousColumnName = previousColumnName;
    }

    public void upgrade(com.imcode.db.Database database) throws DatabaseException {
        database.execute((DatabaseCommand)new DdlUtilsSqlBuilderCommand(){

            protected Object executeSqlBuilder(DatabaseConnection databaseConnection, SqlBuilder sqlBuilder) throws IOException {
                Database actualDdl = sqlBuilder.getPlatform().readModelFromDatabase(databaseConnection.getConnection(), null);
                Table actualTable = actualDdl.findTable(AddVarcharColumnUpgrade.this.tableName);
                Column previousColumn = actualTable.findColumn(AddVarcharColumnUpgrade.this.previousColumnName);
                ArrayList<AddColumnChange> changes = new ArrayList<AddColumnChange>();
                AddColumnChange acc = new AddColumnChange(actualTable, AddVarcharColumnUpgrade.this.column, previousColumn, null);
                acc.setAtEnd(true);
                changes.add(acc);
                sqlBuilder.processChanges(actualDdl, actualDdl, changes, null);
                return null;
            }
        });
    }
}

