/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Mail;
import com.imcode.imcms.api.MailException;
import com.imcode.imcms.api.MailService;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.RoleAlreadyExistsException;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserAlreadyExistsException;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.NameTooLongException;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserService {
    private ContentManagementSystem contentManagementSystem;
    private static final SecureRandom RANDOM = new SecureRandom();

    public UserService(ContentManagementSystem contentManagementSystem) {
        this.contentManagementSystem = contentManagementSystem;
    }

    private ImcmsAuthenticatorAndUserAndRoleMapper getMapper() {
        return this.contentManagementSystem.getInternal().getImcmsAuthenticatorAndUserAndRoleMapper();
    }

    public User[] getAllUsers() throws NoPermissionException {
        UserDomainObject[] internalUsers = this.getMapper().getAllUsers();
        User[] result = new User[internalUsers.length];
        for (int i = 0; i < result.length; ++i) {
            UserDomainObject internalUser = internalUsers[i];
            result[i] = new User(internalUser);
        }
        return result;
    }

    public List<User> getUsersWithRole(Role role) {
        User[] allUsersWithRole = this.getAllUsersWithRole(role);
        return new ArrayList<User>(Arrays.asList(allUsersWithRole));
    }

    public User getUser(int userId) {
        return this.wrapUser(this.getMapper().getUser(userId));
    }

    private User wrapUser(UserDomainObject internalUser) {
        if (null == internalUser) {
            return null;
        }
        return new User(internalUser);
    }

    public User getUser(String userLoginName) {
        return this.wrapUser(this.getMapper().getUser(userLoginName));
    }

    public Role[] getAllRoles() throws NoPermissionException {
        RoleDomainObject[] roleDOs = this.getMapper().getAllRoles();
        Role[] roles = new Role[roleDOs.length];
        for (int i = 0; i < roleDOs.length; ++i) {
            roles[i] = new Role(roleDOs[i]);
        }
        return roles;
    }

    public Role getRole(int roleId) {
        RoleDomainObject roleDO = this.getMapper().getRoleById(roleId);
        return null == roleDO ? null : new Role(roleDO);
    }

    public Role getRole(String roleName) {
        RoleDomainObject roleDO = this.getMapper().getRoleByName(roleName);
        return null == roleDO ? null : new Role(roleDO);
    }

    public void deleteRole(Role role) throws NoPermissionException {
        this.getMapper().deleteRole(role.getInternal());
    }

    public User[] getAllUsersWithRole(Role role) throws NoPermissionException {
        UserDomainObject[] internalUsersWithRole = this.getMapper().getAllUsersWithRole(role.getInternal());
        User[] users = new User[internalUsersWithRole.length];
        for (int i = 0; i < internalUsersWithRole.length; ++i) {
            UserDomainObject user = internalUsersWithRole[i];
            users[i] = new User(user);
        }
        return users;
    }

    public Role createNewRole(String roleName) {
        return new Role(new RoleDomainObject(roleName));
    }

    public void saveRole(Role role) throws NoPermissionException, SaveException {
        if (null == role) {
            return;
        }
        try {
            this.getMapper().saveRole(role.getInternal());
        }
        catch (imcode.server.user.RoleAlreadyExistsException icvse) {
            throw new RoleAlreadyExistsException("A role with the name \"" + role.getName() + "\" already exists.", icvse);
        }
        catch (NameTooLongException stle) {
            throw new SaveException("Role name too long.", stle);
        }
    }

    public User createNewUser(String loginName, String password) {
        UserDomainObject internalUser = new UserDomainObject();
        internalUser.setLoginName(loginName);
        internalUser.setPassword(password);
        internalUser.setLanguageIso639_2(this.contentManagementSystem.getInternal().getLanguageMapper().getDefaultLanguage());
        internalUser.setActive(true);
        return new User(internalUser);
    }

    public void saveUser(User user) throws NoPermissionException, SaveException {
        if (null == user) {
            return;
        }
        try {
            ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = this.getMapper();
            if (0 == user.getId()) {
                imcmsAuthenticatorAndUserAndRoleMapper.addUser(user.getInternal());
            } else {
                imcmsAuthenticatorAndUserAndRoleMapper.saveUser(user.getInternal());
            }
        }
        catch (imcode.server.user.UserAlreadyExistsException uaee) {
            throw new UserAlreadyExistsException("A user with the login name \"" + user.getLoginName() + "\" already exists.", uaee);
        }
    }

    public void updateUserSession(User user) {
        this.getMapper().updateUserSessionId(user.getInternal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserRememberCd(UserDomainObject user) {
        long rand = 0L;
        SecureRandom secureRandom = RANDOM;
        synchronized (secureRandom) {
            rand = RANDOM.nextLong();
        }
        String code = DigestUtils.shaHex((String)(Integer.toString(user.getId()) + Long.toString(rand)));
        user.setRememberCd(code);
        this.getMapper().updateUserRememberCd(user);
    }

    public void sendPasswordReminderMail(User user, String fromAddress, String subject, String body, String bodyPasswordPlaceHolderRegex) throws MailException {
        UserDomainObject userDO = user.getInternal();
        String password = userDO.getPassword();
        String bodyWithPassword = body.replaceAll(bodyPasswordPlaceHolderRegex, password);
        Mail mail = new Mail(fromAddress);
        mail.setSubject(subject);
        mail.setBody(bodyWithPassword);
        mail.setToAddresses(new String[]{userDO.getEmailAddress()});
        MailService mailService = this.contentManagementSystem.getMailService();
        mailService.sendMail(mail);
    }
}

