/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.Image;
import com.imcode.imcms.api.Template;
import com.imcode.imcms.api.TemplateGroup;
import com.imcode.imcms.mapping.DocumentGetter;
import imcode.server.document.DirectDocumentReference;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPredicate;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.document.textdocument.TreeSortKeyDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.CloneTransformer;
import org.apache.commons.collections.map.TransformedSortedMap;
import org.apache.commons.lang.StringUtils;

public class TextDocument
extends Document {
    public static final int TYPE_ID = 2;

    TextDocument(TextDocumentDomainObject textDocument, ContentManagementSystem contentManagementSystem) {
        super(textDocument, contentManagementSystem);
    }

    public SortedMap getTextFields() {
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object o) {
                Map.Entry entry = (Map.Entry)o;
                TextDomainObject tempTextField = (TextDomainObject)entry.getValue();
                return StringUtils.isNotEmpty((String)tempTextField.getText());
            }
        };
        Transformer fromDomainToAPITransformer = new Transformer(){

            public Object transform(Object o) {
                TextDomainObject tempTextField = (TextDomainObject)o;
                return new TextField(tempTextField);
            }
        };
        Map<Integer, TextDomainObject> textFieldsMap = this.getInternalTextDocument().getTexts();
        return this.filterAndConvertValues(textFieldsMap, predicate, fromDomainToAPITransformer);
    }

    public SortedMap getImages() {
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object o) {
                Map.Entry entry = (Map.Entry)o;
                ImageDomainObject tempImage = (ImageDomainObject)entry.getValue();
                return !tempImage.isEmpty();
            }
        };
        Transformer fromDomainToAPITransformer = new Transformer(){

            public Object transform(Object o) {
                ImageDomainObject tempImage = (ImageDomainObject)o;
                return new Image(tempImage);
            }
        };
        Map<Integer, ImageDomainObject> imagesMap = this.getInternalTextDocument().getImages();
        return this.filterAndConvertValues(imagesMap, predicate, fromDomainToAPITransformer);
    }

    public SortedMap getIncludes() {
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object o) {
                Map.Entry entry = (Map.Entry)o;
                Integer tempMetaId = (Integer)entry.getValue();
                return null != tempMetaId;
            }
        };
        Transformer fromDomainToAPITransformer = new Transformer(){

            public Object transform(Object o) {
                Integer tempMetaId = (Integer)o;
                return DocumentService.wrapDocumentDomainObject(TextDocument.this.getDocumentGetter().getDocument(tempMetaId), TextDocument.this.contentManagementSystem);
            }
        };
        Map includeMap = this.getInternalTextDocument().getIncludes();
        return this.filterAndConvertValues(includeMap, predicate, fromDomainToAPITransformer);
    }

    private DocumentGetter getDocumentGetter() {
        return this.contentManagementSystem.getInternal().getDocumentMapper();
    }

    private SortedMap filterAndConvertValues(Map map, Predicate predicate, Transformer transformer) {
        Collection nonEmptyTextFields = CollectionUtils.select(map.entrySet(), (Predicate)predicate);
        SortedMap sortedMap = TransformedSortedMap.decorate(new TreeMap(), (Transformer)CloneTransformer.INSTANCE, (Transformer)transformer);
        for (Map.Entry entry : nonEmptyTextFields) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public TextField getTextField(int textFieldIndexInDocument) {
        TextDomainObject imcmsText = this.getInternalTextDocument().getText(textFieldIndexInDocument);
        if (null == imcmsText) {
            imcmsText = new TextDomainObject("");
            this.getInternalTextDocument().setText(textFieldIndexInDocument, imcmsText);
        }
        return new TextField(imcmsText);
    }

    private TextDocumentDomainObject getInternalTextDocument() {
        return (TextDocumentDomainObject)this.getInternal();
    }

    public void setPlainTextField(int textFieldIndexInDocument, String newText) {
        this.setTextField(textFieldIndexInDocument, newText, TextField.Format.PLAIN);
    }

    public void setHtmlTextField(int textFieldIndexInDocument, String newText) {
        this.setTextField(textFieldIndexInDocument, newText, TextField.Format.HTML);
    }

    public void setTextField(int textFieldIndexInDocument, String newText, TextField.Format format) {
        TextDomainObject imcmsText = new TextDomainObject(newText, format.getType());
        this.getInternalTextDocument().setText(textFieldIndexInDocument, imcmsText);
    }

    public Image getImage(int imageIndexInDocument) {
        ImageDomainObject internalImage = this.getInternalTextDocument().getImage(imageIndexInDocument);
        if (null != internalImage) {
            return new Image(internalImage);
        }
        return null;
    }

    public Template getTemplate() {
        String templateName = this.getInternalTextDocument().getTemplateName();
        return this.contentManagementSystem.getTemplateService().getTemplate(templateName);
    }

    public void setTemplate(TemplateGroup templateGroup, Template template) {
        this.getInternalTextDocument().setTemplateName(template.getInternal().getName());
        if (null != templateGroup) {
            this.getInternalTextDocument().setTemplateGroupId(templateGroup.getId());
        }
    }

    public void setTemplate(Template template) {
        this.setTemplate(null, template);
    }

    public Document getInclude(int includeIndexInDocument) {
        DocumentDomainObject includedDocument;
        Integer includedDocumentId = this.getInternalTextDocument().getIncludedDocumentId(includeIndexInDocument);
        if (null != includedDocumentId && null != (includedDocument = this.getDocumentGetter().getDocument(new Integer(includedDocumentId)))) {
            return DocumentService.wrapDocumentDomainObject(includedDocument, this.contentManagementSystem);
        }
        return null;
    }

    public void setInclude(int includeIndexInDocument, TextDocument documentToBeIncluded) {
        if (null == documentToBeIncluded) {
            this.getInternalTextDocument().removeInclude(includeIndexInDocument);
        } else {
            this.getInternalTextDocument().setInclude(includeIndexInDocument, documentToBeIncluded.getId());
        }
    }

    public Menu getMenu(int menuIndexInDocument) {
        return new Menu(this, menuIndexInDocument);
    }

    public SortedMap getMenus() {
        Map<Integer, MenuDomainObject> internalMenus = this.getInternalTextDocument().getMenus();
        TreeMap<Integer, Menu> menus = new TreeMap<Integer, Menu>();
        for (Integer menuIndex : internalMenus.keySet()) {
            menus.put(menuIndex, new Menu(this, menuIndex));
        }
        return menus;
    }

    public void setImage(int imageIndex, Image image) {
        TextDocumentDomainObject textDocument = (TextDocumentDomainObject)this.getInternal();
        textDocument.setImage(imageIndex, image.getInternal());
    }

    ContentManagementSystem getContentManagementSystem() {
        return this.contentManagementSystem;
    }

    public static class Menu {
        public static final int SORT_BY_HEADLINE = 1;
        public static final int SORT_BY_MANUAL_ORDER_DESCENDING = 2;
        public static final int SORT_BY_MODIFIED_DATETIME_DESCENDING = 3;
        public static final int SORT_BY_TREE_ORDER_DESCENDING = 4;
        public static final int SORT_BY_TREE_ORDER_ASCENDING = 4;
        public static final int SORT_BY_PUBLISHED_DATETIME_DESCENDING = 5;
        private final TextDocumentDomainObject internalTextDocument;
        private final int menuIndex;
        private final ContentManagementSystem contentManagementSystem;

        Menu(TextDocument document, int menuIndex) {
            this.internalTextDocument = document.getInternalTextDocument();
            this.menuIndex = menuIndex;
            this.contentManagementSystem = document.getContentManagementSystem();
        }

        public void addDocument(Document documentToAdd) {
            DirectDocumentReference documentReference = new DirectDocumentReference(documentToAdd.getInternal());
            this.internalTextDocument.getMenu(this.menuIndex).addMenuItem(new MenuItemDomainObject(documentReference));
        }

        public void removeDocument(Document documentToRemove) {
            this.internalTextDocument.getMenu(this.menuIndex).removeMenuItemByDocumentId(documentToRemove.getId());
        }

        public void setSortOrder(int sortOrder) {
            this.internalTextDocument.getMenu(this.menuIndex).setSortOrder(sortOrder);
        }

        public int getSortOrder() {
            return this.internalTextDocument.getMenu(this.menuIndex).getSortOrder();
        }

        public MenuItem[] getVisibleMenuItems() {
            final UserDomainObject user = this.contentManagementSystem.getCurrentUser().getInternal();
            DocumentPredicate documentPredicate = new DocumentPredicate(){

                public boolean evaluateDocument(DocumentDomainObject document) {
                    return user.canSeeDocumentInMenus(document);
                }
            };
            return this.getMenuItems(documentPredicate);
        }

        public Document[] getVisibleDocuments() {
            MenuItem[] menuItems = this.getVisibleMenuItems();
            return this.getDocumentsFromMenuItems(menuItems);
        }

        public MenuItem[] getMenuItems() {
            final UserDomainObject user = this.contentManagementSystem.getCurrentUser().getInternal();
            return this.getMenuItems(new DocumentPredicate(){

                public boolean evaluateDocument(DocumentDomainObject document) {
                    return user.canSeeDocumentInMenus(document) || user.canEdit(document);
                }
            });
        }

        public MenuItem[] getPublishedMenuItems() {
            final UserDomainObject user = this.contentManagementSystem.getCurrentUser().getInternal();
            return this.getMenuItems(new DocumentPredicate(){

                public boolean evaluateDocument(DocumentDomainObject document) {
                    return document.isPublished() && user.canSeeDocumentWhenEditingMenus(document);
                }
            });
        }

        public Document[] getDocuments() {
            MenuItem[] menuItems = this.getMenuItems();
            return this.getDocumentsFromMenuItems(menuItems);
        }

        private MenuItem[] getMenuItems(DocumentPredicate documentPredicate) {
            MenuItemDomainObject[] menuItemsDomainObjects = this.internalTextDocument.getMenu(this.menuIndex).getMenuItems();
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>(menuItemsDomainObjects.length);
            for (MenuItemDomainObject menuItemDomainObject : menuItemsDomainObjects) {
                DocumentDomainObject document = menuItemDomainObject.getDocument();
                if (!documentPredicate.evaluateDocument(document)) continue;
                menuItems.add(new MenuItem(menuItemDomainObject, this.contentManagementSystem));
            }
            return menuItems.toArray(new MenuItem[menuItems.size()]);
        }

        private Document[] getDocumentsFromMenuItems(MenuItem[] menuItems) {
            Document[] documents = new Document[menuItems.length];
            for (int i = 0; i < menuItems.length; ++i) {
                MenuItem menuItem = menuItems[i];
                documents[i] = menuItem.getDocument();
            }
            return documents;
        }
    }

    public static class MenuItem {
        MenuItemDomainObject internalMenuItem;
        Document child;

        public MenuItem(MenuItemDomainObject internalMenuItem, ContentManagementSystem contentManagementSystem) {
            this.internalMenuItem = internalMenuItem;
            DocumentService.ApiWrappingDocumentVisitor visitor = new DocumentService.ApiWrappingDocumentVisitor(contentManagementSystem);
            internalMenuItem.getDocument().accept(visitor);
            this.child = visitor.getDocument();
        }

        public Document getDocument() {
            return this.child;
        }

        public int getManualNumber() {
            Integer sortKey = this.internalMenuItem.getSortKey();
            if (null == sortKey) {
                return 0;
            }
            return sortKey;
        }

        public Integer getSortKey() {
            return this.internalMenuItem.getSortKey();
        }

        public void setSortKey(Integer sortKey) {
            this.internalMenuItem.setSortKey(sortKey);
        }

        public TreeKey getTreeKey() {
            return new TreeKey(this.internalMenuItem.getTreeSortKey());
        }

        public void setTreeKey(TreeKey treeKey) {
            this.internalMenuItem.setTreeSortKey(treeKey.internalTreeSortKey);
        }

        public static class TreeKey {
            TreeSortKeyDomainObject internalTreeSortKey;

            public TreeKey(TreeSortKeyDomainObject internalTreeSortKey) {
                this.internalTreeSortKey = internalTreeSortKey;
            }

            public TreeKey(String treeSortKey) {
                this.internalTreeSortKey = new TreeSortKeyDomainObject(treeSortKey);
            }

            public int getLevelCount() {
                return this.internalTreeSortKey.getLevelCount();
            }

            public int getLevelKey(int level) {
                return this.internalTreeSortKey.getLevelKey(level - 1);
            }

            public String toString() {
                return this.internalTreeSortKey.toString();
            }
        }
    }

    public static class TextField {
        private final TextDomainObject imcmsText;

        private TextField(TextDomainObject imcmsText) {
            this.imcmsText = imcmsText;
        }

        public void setHtmlFormat() {
            this.imcmsText.setType(1);
        }

        public void setPlainFormat() {
            this.imcmsText.setType(0);
        }

        public Format getFormat() {
            return this.imcmsText.getType() == 0 ? Format.PLAIN : Format.HTML;
        }

        public void setFormat(Format format) {
            this.imcmsText.setType(format.getType());
        }

        public String getText() {
            return this.imcmsText.getText();
        }

        public String getHtmlFormattedText() {
            return this.imcmsText.toHtmlString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Format {
            PLAIN(0),
            HTML(1);

            private final int type;

            private Format(int type) {
                this.type = type;
            }

            public int getType() {
                return this.type;
            }
        }
    }
}

