/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.db.Database;
import com.imcode.db.mock.MockDatabase;
import com.imcode.db.mock.MockResultSet;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryAlreadyExistsException;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.MockContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.MockDocumentIndex;
import imcode.server.MockImcmsServices;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.MockRoleGetter;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestDocumentService
extends TestCase {
    private DocumentService documentService;
    private MockDatabase database;
    private User user;
    private MockImcmsServices imcmsServices;
    private MockContentManagementSystem contentManagementSystem;

    public void setUp() throws Exception {
        super.setUp();
        this.contentManagementSystem = new MockContentManagementSystem();
        this.user = new User(new UserDomainObject());
        this.contentManagementSystem.setCurrentUser(this.user);
        this.imcmsServices = new MockImcmsServices();
        this.imcmsServices.setRoleGetter(new MockRoleGetter());
        this.database = new MockDatabase();
        DocumentMapper documentMapper = new DocumentMapper(this.imcmsServices, (Database)this.database);
        documentMapper.setDocumentIndex(new MockDocumentIndex());
        this.imcmsServices.setDocumentMapper(documentMapper);
        this.imcmsServices.setCategoryMapper(documentMapper.getCategoryMapper());
        this.contentManagementSystem.setInternal(this.imcmsServices);
        this.documentService = new DocumentService(this.contentManagementSystem);
    }

    public void testSaveCategory() throws CategoryAlreadyExistsException, NoPermissionException {
        MockResultSet allCategoryTypesResult = new MockResultSet((Object[][])new Object[][]{{new Integer(1), "test", new Integer(0), new Integer(0), new Integer(0)}});
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.MatchesRegexSqlCallPredicate("SELECT category_types.category_type_id"), (Object)allCategoryTypesResult);
        CategoryType categoryType = this.documentService.getAllCategoryTypes()[0];
        TestDocumentService.assertEquals((boolean)false, (boolean)categoryType.isInherited());
        String categoryName = "name";
        Category category = new Category(categoryName, categoryType);
        category.setDescription("description");
        category.setImage("image");
        this.user.addRole(new Role(this.imcmsServices.getRoleGetter().getRole(RoleId.SUPERADMIN)));
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableSqlCallPredicate("categories"), (Object)new Integer(1));
        this.documentService.saveCategory(category);
        this.database.assertExpectedSqlCalls();
        MockResultSet categoryResult = new MockResultSet((Object[][])new Object[][]{{new Integer(1), category.getName(), category.getDescription(), category.getImage(), new Integer(categoryType.getId()), categoryType.getName(), new Integer(categoryType.getInternal().getMaxChoices()), new Integer(categoryType.isInherited() ? 1 : 0), new Integer(categoryType.isImageArchive() ? 1 : 0)}});
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.EqualsSqlCallPredicate("SELECT categories.category_id, categories.name, categories.description, categories.image, category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited, category_types.is_image_archive\nFROM categories\nJOIN category_types\nON categories.category_type_id = category_types.category_type_id\nWHERE categories.name = ?\nAND category_types.category_type_id = ?"), (Object)categoryResult);
        Category otherCategory = new Category(categoryName, categoryType);
        try {
            this.documentService.saveCategory(otherCategory);
            TestDocumentService.fail();
        }
        catch (CategoryAlreadyExistsException e) {
            // empty catch block
        }
        this.database.assertExpectedSqlCalls();
        String otherName = "other name";
        category.setName(otherName);
        category.setDescription("other description");
        category.setImage("other image");
        this.documentService.saveCategory(category);
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("categories", (Object)otherName));
    }

    public void testApiWrappingList() {
        ArrayList<TextDocumentDomainObject> list = new ArrayList<TextDocumentDomainObject>();
        DocumentService.ApiDocumentWrappingList apiDocumentWrappingList = new DocumentService.ApiDocumentWrappingList(list, this.contentManagementSystem);
        list.add(new TextDocumentDomainObject());
        TestDocumentService.assertNotNull((Object)apiDocumentWrappingList.get(0));
        TextDocument document = new TextDocument(new TextDocumentDomainObject(), (ContentManagementSystem)this.contentManagementSystem);
        apiDocumentWrappingList.set(0, document);
        TestDocumentService.assertNotNull((Object)apiDocumentWrappingList.get(0));
        TestDocumentService.assertEquals((Object)document, (Object)apiDocumentWrappingList.remove(0));
        TestDocumentService.assertTrue((boolean)list.isEmpty());
    }
}

