/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.AliasAlreadyExistsException;
import com.imcode.imcms.api.BadQueryException;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryAlreadyExistsException;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.CategoryTypeAlreadyExistsException;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.FileDocument;
import com.imcode.imcms.api.LuceneParsedQuery;
import com.imcode.imcms.api.MaxCategoriesOfTypeExceededException;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.SearchException;
import com.imcode.imcms.api.SearchQuery;
import com.imcode.imcms.api.Section;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.UrlDocument;
import com.imcode.imcms.mapping.AliasAlreadyExistsInternalException;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.MaxCategoryDomainObjectsOfTypeExceededException;
import imcode.server.document.SectionDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.XmlDocumentBuilder;
import imcode.server.document.index.DocumentQuery;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.AbstractList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class DocumentService {
    private final ContentManagementSystem contentManagementSystem;

    public DocumentService(ContentManagementSystem contentManagementSystem) {
        this.contentManagementSystem = contentManagementSystem;
    }

    static Document wrapDocumentDomainObject(DocumentDomainObject document, ContentManagementSystem contentManagementSystem) {
        if (null == document) {
            return null;
        }
        ApiWrappingDocumentVisitor apiWrappingDocumentVisitor = new ApiWrappingDocumentVisitor(contentManagementSystem);
        document.accept(apiWrappingDocumentVisitor);
        return apiWrappingDocumentVisitor.getDocument();
    }

    public Document getDocument(String documentIdString) throws NoPermissionException {
        DocumentDomainObject doc = this.getDocumentMapper().getDocument(documentIdString);
        Document result = null;
        if (null != doc) {
            result = DocumentService.wrapDocumentDomainObject(doc, this.contentManagementSystem);
        }
        return result;
    }

    public Document getDocument(int documentId) throws NoPermissionException {
        return this.getDocument("" + documentId);
    }

    public TextDocument getTextDocument(String documentIdString) throws NoPermissionException {
        return (TextDocument)this.getDocument(documentIdString);
    }

    public TextDocument getTextDocument(int documentId) throws NoPermissionException {
        return (TextDocument)this.getDocument("" + documentId);
    }

    public UrlDocument getUrlDocument(String documentIdString) throws NoPermissionException {
        return (UrlDocument)this.getDocument(documentIdString);
    }

    public UrlDocument getUrlDocument(int documentId) throws NoPermissionException {
        return (UrlDocument)this.getDocument(documentId);
    }

    public TextDocument createNewTextDocument(Document parent) throws NoPermissionException {
        return (TextDocument)this.createNewDocument(2, parent);
    }

    public UrlDocument createNewUrlDocument(Document parent) throws NoPermissionException {
        return (UrlDocument)this.createNewDocument(5, parent);
    }

    public FileDocument createNewFileDocument(Document parent) throws NoPermissionException {
        return (FileDocument)this.createNewDocument(8, parent);
    }

    private Document createNewDocument(int doctype, Document parent) throws NoPermissionException {
        return DocumentService.wrapDocumentDomainObject(this.getDocumentMapper().createDocumentOfTypeFromParent(doctype, parent.getInternal(), this.contentManagementSystem.getCurrentUser().getInternal()), this.contentManagementSystem);
    }

    public synchronized void saveChanges(Document document) throws NoPermissionException, SaveException {
        try {
            if (0 == document.getId()) {
                this.getDocumentMapper().saveNewDocument(document.getInternal(), this.contentManagementSystem.getCurrentUser().getInternal(), false);
            } else {
                this.getDocumentMapper().saveDocument(document.getInternal(), this.contentManagementSystem.getCurrentUser().getInternal());
            }
        }
        catch (MaxCategoryDomainObjectsOfTypeExceededException e) {
            throw new MaxCategoriesOfTypeExceededException(e);
        }
        catch (AliasAlreadyExistsInternalException e) {
            throw new AliasAlreadyExistsException(e);
        }
        catch (DocumentSaveException e) {
            throw new SaveException(e);
        }
    }

    public Category getCategory(CategoryType categoryType, String categoryName) {
        CategoryDomainObject category = this.getCategoryMapper().getCategoryByTypeAndName(categoryType.getInternal(), categoryName);
        if (null != category) {
            return new Category(category);
        }
        return null;
    }

    private CategoryMapper getCategoryMapper() {
        return this.contentManagementSystem.getInternal().getCategoryMapper();
    }

    public Category getCategory(int categoryId) {
        CategoryDomainObject category = this.getCategoryMapper().getCategoryById(categoryId);
        if (null != category) {
            return new Category(category);
        }
        return null;
    }

    public CategoryType getCategoryType(int categoryTypeId) {
        CategoryTypeDomainObject categoryType = this.getCategoryMapper().getCategoryTypeById(categoryTypeId);
        return this.returnCategoryTypeAPIObjectOrNull(categoryType);
    }

    public CategoryType getCategoryType(String categoryTypeName) {
        CategoryTypeDomainObject categoryType = this.getCategoryMapper().getCategoryTypeByName(categoryTypeName);
        return this.returnCategoryTypeAPIObjectOrNull(categoryType);
    }

    private CategoryType returnCategoryTypeAPIObjectOrNull(CategoryTypeDomainObject categoryType) {
        if (null != categoryType) {
            return new CategoryType(categoryType);
        }
        return null;
    }

    public Category[] getAllCategoriesOfType(CategoryType categoryType) {
        CategoryDomainObject[] categoryDomainObjects = this.getCategoryMapper().getAllCategoriesOfType(categoryType.getInternal());
        Category[] categories = new Category[categoryDomainObjects.length];
        for (int i = 0; i < categoryDomainObjects.length; ++i) {
            CategoryDomainObject categoryDomainObject = categoryDomainObjects[i];
            categories[i] = new Category(categoryDomainObject);
        }
        return categories;
    }

    public CategoryType[] getAllCategoryTypes() {
        CategoryTypeDomainObject[] categoryTypeDomainObjects = this.getCategoryMapper().getAllCategoryTypes();
        CategoryType[] categoryTypes = new CategoryType[categoryTypeDomainObjects.length];
        for (int i = 0; i < categoryTypeDomainObjects.length; ++i) {
            CategoryTypeDomainObject categoryTypeDomainObject = categoryTypeDomainObjects[i];
            categoryTypes[i] = new CategoryType(categoryTypeDomainObject);
        }
        return categoryTypes;
    }

    public CategoryType createNewCategoryType(String name, int maxChoices) throws NoPermissionException, CategoryTypeAlreadyExistsException {
        if (this.getCategoryMapper().isUniqueCategoryTypeName(name)) {
            CategoryTypeDomainObject newCategoryTypeDO = new CategoryTypeDomainObject(0, name, maxChoices, false, false);
            newCategoryTypeDO = this.getCategoryMapper().addCategoryTypeToDb(newCategoryTypeDO);
            return new CategoryType(newCategoryTypeDO);
        }
        throw new CategoryTypeAlreadyExistsException("A category with name " + name + " already exists.");
    }

    public Section getSection(int sectionId) {
        SectionDomainObject section = this.getDocumentMapper().getSectionById(sectionId);
        if (null == section) {
            return null;
        }
        return new Section(section);
    }

    public Section getSection(String name) {
        SectionDomainObject section = this.getDocumentMapper().getSectionByName(name);
        if (null == section) {
            return null;
        }
        return new Section(section);
    }

    public List getDocuments(final SearchQuery query) throws SearchException {
        try {
            List documentList = this.getDocumentMapper().getDocumentIndex().search(new DocumentQuery(){

                public Query getQuery() {
                    return query.getQuery();
                }

                public Sort getSort() {
                    return query.getSort();
                }

                public boolean isLogged() {
                    return query.isLogged();
                }
            }, this.contentManagementSystem.getCurrentUser().getInternal());
            return new ApiDocumentWrappingList(documentList, this.contentManagementSystem);
        }
        catch (RuntimeException e) {
            throw new SearchException(e);
        }
    }

    public Document[] search(SearchQuery query) throws SearchException {
        List documents = this.getDocuments(query);
        return documents.toArray(new Document[documents.size()]);
    }

    private DocumentMapper getDocumentMapper() {
        return this.contentManagementSystem.getInternal().getDocumentMapper();
    }

    public SearchQuery parseLuceneSearchQuery(String query) throws BadQueryException {
        return new LuceneParsedQuery(query);
    }

    public org.w3c.dom.Document getXmlDomForDocument(Document document) {
        XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder(this.contentManagementSystem.getCurrentUser().getInternal());
        xmlDocumentBuilder.addDocument(document.getInternal());
        return xmlDocumentBuilder.getXmlDocument();
    }

    public void saveCategory(Category category) throws NoPermissionException, CategoryAlreadyExistsException {
        this.getCategoryMapper().saveCategory(category.getInternal());
    }

    public void deleteDocument(Document document) throws NoPermissionException {
        UserDomainObject internalUser = this.contentManagementSystem.getCurrentUser().getInternal();
        this.getDocumentMapper().deleteDocument(document.getInternal(), internalUser);
    }

    static class ApiDocumentWrappingList
    extends AbstractList {
        private final List documentList;
        private ContentManagementSystem contentManagementSystem;

        ApiDocumentWrappingList(List documentList, ContentManagementSystem contentManagementSystem) {
            this.documentList = documentList;
            this.contentManagementSystem = contentManagementSystem;
        }

        public Object get(int index) {
            DocumentDomainObject document = (DocumentDomainObject)this.documentList.get(index);
            return DocumentService.wrapDocumentDomainObject(document, this.contentManagementSystem);
        }

        public int size() {
            return this.documentList.size();
        }

        public Object remove(int index) {
            return DocumentService.wrapDocumentDomainObject((DocumentDomainObject)this.documentList.remove(index), this.contentManagementSystem);
        }

        public Object set(int index, Object element) {
            return DocumentService.wrapDocumentDomainObject(this.documentList.set(index, ((Document)element).getInternal()), this.contentManagementSystem);
        }
    }

    static class ApiWrappingDocumentVisitor
    extends DocumentVisitor {
        private ContentManagementSystem contentManagementSystem;
        private Document document;

        ApiWrappingDocumentVisitor(ContentManagementSystem contentManagementSystem) {
            this.contentManagementSystem = contentManagementSystem;
        }

        public void visitFileDocument(FileDocumentDomainObject fileDocument) {
            this.document = new FileDocument(fileDocument, this.contentManagementSystem);
        }

        public void visitTextDocument(TextDocumentDomainObject textDocument) {
            this.document = new TextDocument(textDocument, this.contentManagementSystem);
        }

        public void visitUrlDocument(UrlDocumentDomainObject urlDocument) {
            this.document = new UrlDocument(urlDocument, this.contentManagementSystem);
        }

        protected void visitOtherDocument(DocumentDomainObject otherDocument) {
            this.document = new Document(otherDocument, this.contentManagementSystem);
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

