/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.treemenu;

import com.imcode.imcms.addon.treemenu.BreadCrumbItem;
import com.imcode.imcms.addon.treemenu.TreeMenuItem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.TextDocument;
import java.util.ArrayList;
import java.util.List;

public class ImcmsTreeMenu {
    TextDocument thisDoc;
    TextDocument.MenuItem[] allMenuItems;
    List<TreeMenuItem> visibleTreeMenuItems;
    List<BreadCrumbItem> breadCrumbItems;
    String activeTreeKeyString = "";
    boolean useFoldInOut = true;
    boolean useLevelOneTwoOnly = false;

    public ImcmsTreeMenu(TextDocument thisDoc, TextDocument.MenuItem[] allMenuItems) {
        this(thisDoc, allMenuItems, false, false);
    }

    public ImcmsTreeMenu(TextDocument thisDoc, TextDocument.MenuItem[] allMenuItems, boolean useFoldInOut, boolean useLevelOneTwoOnly) {
        this.init(thisDoc, thisDoc, allMenuItems, useFoldInOut, useLevelOneTwoOnly);
    }

    public ImcmsTreeMenu(TextDocument thisDocForBranch, TextDocument thisDocForActive, TextDocument.MenuItem[] allMenuItems, boolean useFoldInOut, boolean useLevelOneTwoOnly) {
        this.init(thisDocForBranch, thisDocForActive, allMenuItems, useFoldInOut, useLevelOneTwoOnly);
    }

    private void init(TextDocument thisDocForBranch, TextDocument thisDocForActive, TextDocument.MenuItem[] allMenuItems, boolean useFoldInOut, boolean useLevelOneTwoOnly) {
        this.useFoldInOut = useFoldInOut;
        this.thisDoc = thisDocForActive;
        this.allMenuItems = allMenuItems;
        this.visibleTreeMenuItems = new ArrayList<TreeMenuItem>();
        this.breadCrumbItems = new ArrayList<BreadCrumbItem>();
        boolean thisDocInMenu = false;
        if (null != allMenuItems && allMenuItems.length > 0) {
            boolean hasSub;
            int nextLevel;
            int thisLevel;
            String thisTreeKey;
            TextDocument.MenuItem.TreeKey treeKey;
            Document menuDocument;
            int i;
            for (i = 0; i < allMenuItems.length; ++i) {
                menuDocument = allMenuItems[i].getDocument();
                treeKey = allMenuItems[i].getTreeKey();
                if (null == thisDocForBranch || menuDocument.getId() != thisDocForBranch.getId() || null == treeKey || "".equals(treeKey.toString())) continue;
                thisDocInMenu = true;
                thisTreeKey = treeKey.toString();
                thisLevel = treeKey.getLevelCount();
                nextLevel = this.getNextLevel(allMenuItems, i + 1);
                hasSub = nextLevel > thisLevel;
                String string = this.activeTreeKeyString = thisTreeKey.matches("^\\d+(\\.\\d+)*$") ? thisTreeKey : "";
                if (hasSub) break;
                if (thisLevel == 4) {
                    this.activeTreeKeyString = treeKey.getLevelKey(1) + "." + treeKey.getLevelKey(2) + "." + treeKey.getLevelKey(3);
                    break;
                }
                if (thisLevel == 3) {
                    this.activeTreeKeyString = treeKey.getLevelKey(1) + "." + treeKey.getLevelKey(2);
                    break;
                }
                if (thisLevel == 2) {
                    this.activeTreeKeyString = treeKey.getLevelKey(1) + "";
                    break;
                }
                if (thisLevel != 1) break;
                this.activeTreeKeyString = "";
                break;
            }
            if (!thisDocInMenu) {
                for (i = 0; i < allMenuItems.length; ++i) {
                    menuDocument = allMenuItems[i].getDocument();
                    treeKey = allMenuItems[i].getTreeKey();
                    if (null == thisDocForActive || menuDocument.getId() != thisDocForActive.getId() || null == treeKey || "".equals(treeKey.toString())) continue;
                    thisTreeKey = treeKey.toString();
                    thisLevel = treeKey.getLevelCount();
                    nextLevel = this.getNextLevel(allMenuItems, i + 1);
                    hasSub = nextLevel > thisLevel;
                    String string = this.activeTreeKeyString = thisTreeKey.matches("^\\d+(\\.\\d+)*$") ? thisTreeKey : "";
                    if (hasSub) break;
                    if (thisLevel == 4) {
                        this.activeTreeKeyString = treeKey.getLevelKey(1) + "." + treeKey.getLevelKey(2) + "." + treeKey.getLevelKey(3);
                        break;
                    }
                    if (thisLevel == 3) {
                        this.activeTreeKeyString = treeKey.getLevelKey(1) + "." + treeKey.getLevelKey(2);
                        break;
                    }
                    if (thisLevel == 2) {
                        this.activeTreeKeyString = treeKey.getLevelKey(1) + "";
                        break;
                    }
                    if (thisLevel != 1) break;
                    this.activeTreeKeyString = "";
                    break;
                }
            }
            int actLev = this.getLevel(this.activeTreeKeyString);
            for (int i2 = 0; i2 < allMenuItems.length; ++i2) {
                BreadCrumbItem breadCrumbItem;
                boolean hasSubLevels;
                treeKey = allMenuItems[i2].getTreeKey();
                if (null == treeKey || "".equals(treeKey.toString())) continue;
                int thisLevel2 = treeKey.getLevelCount();
                if (useLevelOneTwoOnly && thisLevel2 > 2) continue;
                int nextLevel2 = this.getNextLevel(allMenuItems, i2 + 1);
                boolean bl = hasSubLevels = nextLevel2 > thisLevel2;
                if (useFoldInOut && !this.menuItemIsVisible(treeKey.toString())) continue;
                Document menuItemDoc = allMenuItems[i2].getDocument();
                boolean isThisDoc = null != thisDocForActive && menuItemDoc.getId() == thisDocForActive.getId();
                boolean hasVisibleSubLevels = (treeKey + ".").startsWith(this.activeTreeKeyString.replaceFirst("\\.\\d+$", "") + ".") && thisLevel2 < actLev || (treeKey + ".").startsWith(this.activeTreeKeyString + ".") && thisLevel2 == actLev;
                this.visibleTreeMenuItems.add(new TreeMenuItem(allMenuItems[i2], isThisDoc, hasSubLevels, hasVisibleSubLevels));
                int actLevOne = null != this.activeTreeKeyString && this.activeTreeKeyString.matches(".*\\d+.*") ? Integer.parseInt(this.activeTreeKeyString.split("\\.")[0]) : 0;
                int iLevOneSort = treeKey.getLevelKey(1);
                if (!isThisDoc && thisLevel2 == 1 && iLevOneSort == actLevOne) {
                    breadCrumbItem = new BreadCrumbItem(menuItemDoc.getHeadline(), menuItemDoc.getName(), false);
                    this.breadCrumbItems.add(breadCrumbItem);
                    continue;
                }
                if (!isThisDoc && thisLevel2 == 2 && hasVisibleSubLevels) {
                    breadCrumbItem = new BreadCrumbItem(menuItemDoc.getHeadline(), menuItemDoc.getName(), false);
                    this.breadCrumbItems.add(breadCrumbItem);
                    continue;
                }
                if (isThisDoc || thisLevel2 != 3 || !hasVisibleSubLevels) continue;
                breadCrumbItem = new BreadCrumbItem(menuItemDoc.getHeadline(), menuItemDoc.getName(), false);
                this.breadCrumbItems.add(breadCrumbItem);
            }
        }
        if (null != this.thisDoc) {
            BreadCrumbItem breadCrumbItem = new BreadCrumbItem(this.thisDoc.getHeadline(), this.thisDoc.getName(), true);
            this.breadCrumbItems.add(breadCrumbItem);
        }
    }

    public List<TreeMenuItem> getVisibleTreeMenuItems() {
        return this.visibleTreeMenuItems;
    }

    public List<TreeMenuItem> getVisibleTreeMenuItemsOfLevel(int level) {
        ArrayList<TreeMenuItem> treeMenuItems = new ArrayList<TreeMenuItem>();
        for (TreeMenuItem treeMenuItem : this.visibleTreeMenuItems) {
            if (level != treeMenuItem.getMenuItem().getTreeKey().getLevelCount()) continue;
            treeMenuItems.add(treeMenuItem);
        }
        return treeMenuItems;
    }

    public String getActiveTreeKeyString() {
        return this.activeTreeKeyString;
    }

    public List<BreadCrumbItem> getBreadCrumbItems() {
        return this.breadCrumbItems;
    }

    public List<BreadCrumbItem> getBreadCrumbItems(String rootNameToAddIfNotEmpty, String aliasToRoot, boolean isRoot) {
        if (null != rootNameToAddIfNotEmpty && !"".equals(rootNameToAddIfNotEmpty) && !this.breadCrumbItems.contains(new BreadCrumbItem("", aliasToRoot, false))) {
            this.breadCrumbItems.add(0, new BreadCrumbItem(rootNameToAddIfNotEmpty, aliasToRoot, isRoot));
        }
        return this.breadCrumbItems;
    }

    public boolean useFoldInOut() {
        return this.useFoldInOut;
    }

    public boolean useLevelOneTwoOnly() {
        return this.useLevelOneTwoOnly;
    }

    private int getLevel(String sTreeSort) {
        int ret = 0;
        if (sTreeSort != null && !sTreeSort.equals("")) {
            ret = 1;
            for (int i = 0; i < sTreeSort.length(); ++i) {
                char actChar = sTreeSort.charAt(i);
                if (actChar != '.') continue;
                ++ret;
            }
        }
        return ret;
    }

    private int getNextLevel(TextDocument.MenuItem[] menu, int nextIdx) {
        int ret = 0;
        try {
            ret = menu[nextIdx].getTreeKey().getLevelCount();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private boolean menuItemIsVisible(String treeKey) {
        int actLev = this.getLevel(this.activeTreeKeyString);
        int thisLev = this.getLevel(treeKey);
        if (thisLev == 1) {
            return true;
        }
        if ((treeKey.replaceFirst("\\.\\d+$", "") + ".").startsWith(this.activeTreeKeyString + ".") && thisLev - 1 <= actLev) {
            return true;
        }
        if ((treeKey + ".").startsWith(this.activeTreeKeyString.replaceFirst("\\.\\d+$", "") + ".") && thisLev <= actLev) {
            return true;
        }
        return thisLev == 2 && this.activeTreeKeyString.startsWith(treeKey.split("\\.")[0] + ".");
    }
}

