/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.treemenu;

import com.imcode.imcms.addon.treemenu.TreeMenuItem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.TextDocument;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ImcmsTreeMenuFormatted {
    String menuId = "";
    List<TreeMenuItem> visibleTreeMenuItems;
    HttpServletRequest request;
    String templateFirstUl_0 = "";
    String templateFirstUl_1 = "";
    String templateSubUl_0 = "";
    String templateSubUl_1 = "";
    String templateLiRoot = "";
    String templateLiWithSub = "";
    String templateLiNoSub = "";

    public ImcmsTreeMenuFormatted(String menuId, List<TreeMenuItem> visibleTreeMenuItems, HttpServletRequest request) {
        this.menuId = menuId;
        this.visibleTreeMenuItems = visibleTreeMenuItems;
        this.request = request;
    }

    private String parseTemplate(String template, Document doc, TextDocument.MenuItem.TreeKey treeKey, int level, int ulCount, int liCount, int iCount) {
        return template.replace("#MENU#", this.menuId).replace("#LEVEL#", level + "").replace("#TREEKEY#", treeKey.toString().replace(".", "_") + "").replace("#TREEKEY_PREV#", this.getTreeKeyOneLevelUp(treeKey).replace(".", "_") + "").replace("#UL#", ulCount + "").replace("#LI#", liCount + "").replace("#ID#", iCount + "").replace("#HREF#", this.request.getContextPath() + "/" + doc.getName()).replace("#HEADING#", doc.getHeadline().replaceAll("\\s+&\\s+", " &amp; ")).replace("#TARGET#", doc.getTarget());
    }

    private String getTreeKeyOneLevelUp(TextDocument.MenuItem.TreeKey treeKey) {
        String newKey = treeKey.toString();
        newKey = newKey.indexOf(".") != -1 ? newKey.replaceFirst("\\.\\d+$", "") : "";
        return newKey;
    }

    public void setTemplateFirstUl_0(String templateFirstUl_0) {
        this.templateFirstUl_0 = templateFirstUl_0;
    }

    public void setTemplateFirstUl_1(String templateFirstUl_1) {
        this.templateFirstUl_1 = templateFirstUl_1;
    }

    public void setTemplateSubUl_0(String templateSubUl_0) {
        this.templateSubUl_0 = templateSubUl_0;
    }

    public void setTemplateSubUl_1(String templateSubUl_1) {
        this.templateSubUl_1 = templateSubUl_1;
    }

    public void setTemplateLiRoot(String templateLiRoot) {
        this.templateLiRoot = templateLiRoot;
    }

    public void setTemplateLiWithSub(String templateLiWithSub) {
        this.templateLiWithSub = templateLiWithSub;
    }

    public void setTemplateLiNoSub(String templateLiNoSub) {
        this.templateLiNoSub = templateLiNoSub;
    }

    public String asFormattedString() {
        String ret = "";
        int itemCount = 0;
        boolean subLevVisible = false;
        if (null == this.visibleTreeMenuItems || this.visibleTreeMenuItems.isEmpty()) {
            return "";
        }
        int ulCount = 0;
        int liCount = 0;
        int iCount = 0;
        Document ulDoc0 = null;
        Document ulDoc = null;
        for (TreeMenuItem treeMenuItem : this.visibleTreeMenuItems) {
            try {
                boolean isLast;
                TextDocument.MenuItem menuItem = treeMenuItem.getMenuItem();
                Document doc = menuItem.getDocument();
                TextDocument.MenuItem.TreeKey treeKey = menuItem.getTreeKey();
                int level = treeKey.getLevelCount();
                String tabUl = StringUtils.repeat((String)"\t", (int)level);
                String tabLi = StringUtils.repeat((String)"\t", (int)level);
                if (0 == ulCount && !"".equals(this.templateFirstUl_0)) {
                    ulDoc0 = doc;
                    ret = ret + this.parseTemplate(this.templateFirstUl_0, ulDoc0, treeKey, level, ulCount, liCount, iCount) + "\n";
                    ++ulCount;
                }
                boolean hasSubLevels = treeMenuItem.hasSubLevels();
                boolean bl = isLast = itemCount == this.visibleTreeMenuItems.size() - 1;
                if (hasSubLevels) {
                    if (!"".equals(this.templateLiWithSub)) {
                        ret = ret + tabUl + this.parseTemplate(this.templateLiWithSub, doc, treeKey, level, ulCount, liCount, iCount) + "\n";
                    }
                    if (!"".equals(this.templateSubUl_0)) {
                        ulDoc = doc;
                        ret = ret + tabUl + this.parseTemplate(this.templateSubUl_0, ulDoc, treeKey, level, ulCount, liCount, iCount) + "\n";
                    }
                    subLevVisible = true;
                    ++ulCount;
                } else {
                    if (subLevVisible && 1 == level) {
                        if (!"".equals(this.templateSubUl_1)) {
                            ret = ret + tabUl + this.parseTemplate(this.templateSubUl_1, ulDoc, treeKey, level, ulCount, liCount, iCount) + "\n";
                        }
                        subLevVisible = false;
                        ++ulCount;
                        liCount = 0;
                    }
                    if (1 == level && !"".equals(this.templateLiRoot)) {
                        ret = ret + tabLi + this.parseTemplate(this.templateLiRoot, doc, treeKey, level, ulCount, liCount, iCount) + "\n";
                    } else if (!"".equals(this.templateLiNoSub)) {
                        ret = ret + tabLi + this.parseTemplate(this.templateLiNoSub, doc, treeKey, level, ulCount, liCount, iCount) + "\n";
                    }
                }
                ++liCount;
                if (subLevVisible && isLast) {
                    if (!"".equals(this.templateSubUl_1)) {
                        ret = ret + tabUl + this.parseTemplate(this.templateSubUl_1, ulDoc, treeKey, level, ulCount, liCount, iCount) + "\n";
                    }
                    subLevVisible = false;
                    ++ulCount;
                    liCount = 0;
                }
                if (isLast && !"".equals(this.templateFirstUl_1)) {
                    ret = ret + this.parseTemplate(this.templateFirstUl_1, ulDoc0, treeKey, level, ulCount, liCount, iCount) + "\n";
                }
                ++itemCount;
            }
            catch (Exception e) {}
        }
        return ret;
    }

    public String asUnorderedListNested(int indentTabs) {
        String ret = "";
        int itemCount = 0;
        int lastLev = 0;
        int ulSubCount = 0;
        if (null == this.visibleTreeMenuItems || this.visibleTreeMenuItems.isEmpty()) {
            return "";
        }
        String tabIndent = StringUtils.repeat((String)"\t", (int)indentTabs);
        ret = ret + "\n";
        ret = ret + tabIndent + "<ul" + (null != this.menuId && !"".equals(this.menuId) ? " id=\"" + this.menuId + "\"" : "") + ">\n";
        for (TreeMenuItem treeMenuItem : this.visibleTreeMenuItems) {
            try {
                int sc;
                TextDocument.MenuItem menuItem = treeMenuItem.getMenuItem();
                Document doc = menuItem.getDocument();
                boolean hasSubLevels = treeMenuItem.hasSubLevels();
                boolean hasVisibleSubLevels = treeMenuItem.hasVisibleSubLevels();
                boolean isThisDoc = treeMenuItem.isThisDoc();
                TextDocument.MenuItem.TreeKey treeKey = menuItem.getTreeKey();
                int level = treeKey.getLevelCount();
                boolean isFirst = 0 == itemCount;
                boolean isLast = itemCount == this.visibleTreeMenuItems.size() - 1;
                String tabUl = StringUtils.repeat((String)"\t", (int)level);
                String tabLi = StringUtils.repeat((String)"\t", (int)level);
                if (ulSubCount > 0 && level < lastLev) {
                    ret = ret + tabIndent + tabUl + "</ul></li>\n";
                    --ulSubCount;
                }
                if (hasSubLevels && hasVisibleSubLevels) {
                    ret = ret + tabIndent + tabUl + "<li class=\"branch_act lev" + level + (isFirst ? " first" : "") + (isThisDoc ? " selected" : "") + "\">" + this.makeLink(doc, isThisDoc) + "\n";
                    ret = ret + tabIndent + tabUl + "<ul>\n";
                    ++ulSubCount;
                } else {
                    if (ulSubCount > 0 && 1 == level) {
                        for (sc = 0; sc < ulSubCount; --ulSubCount, ++sc) {
                            ret = ret + tabIndent + tabUl + "</ul></li>\n";
                        }
                    }
                    ret = ret + tabIndent + tabLi + "<li class=\"" + (hasSubLevels ? "branch_inact" : "leaf") + " lev" + level + (isFirst ? " first" : "") + (isThisDoc ? " selected" : "") + "\">" + this.makeLink(doc, isThisDoc) + "</li>\n";
                }
                if (ulSubCount > 0 && isLast) {
                    for (sc = 0; sc < ulSubCount; ++sc) {
                        ret = ret + tabIndent + tabUl + "</ul></li>\n";
                    }
                    ulSubCount = 0;
                }
                lastLev = level;
                ++itemCount;
            }
            catch (Exception e) {}
        }
        ret = ret + tabIndent + "</ul>";
        return ret;
    }

    private String makeLink(Document document, boolean isThisDoc) {
        return "<a href=\"" + this.request.getContextPath() + "/" + document.getName() + "\" target=\"" + document.getTarget() + "\"" + (isThisDoc ? " class=\"selected\"" : "") + "><span>" + document.getHeadline().replaceAll("\\s+&\\s+", " &amp; ") + "</span></a>";
    }
}

