/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.sms;

import com.imcode.imcms.addon.smssystem.job.Job;
import com.imcode.imcms.addon.smssystem.job.JobMapper;
import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.imcms.addon.smssystem.sms.ImSmsSender;
import com.imcode.imcms.addon.smssystem.sms.ImSmsSenderFactory;
import com.imcode.imcms.addon.smssystem.sms.SimpleSmsDestination;
import com.imcode.imcms.addon.smssystem.sms.SmsDestination;
import com.imcode.imcms.addon.smssystem.sms.SmsSender;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SmsServlet
extends HttpServlet {
    static final String PATH_LOGS = "/WEB-INF/logs";
    private static final Logger LOG = Logger.getLogger(SmsServlet.class);

    public static void writeLog(String str) {
        FileOutputStream fos;
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "SmsServlet.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
            return;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String message = request.getParameter("message");
        String originator = request.getParameter("originator");
        String jobId = null != request.getParameter("jobId") ? request.getParameter("jobId") : "0";
        List<SmsDestination> smsDestinations = this.getDestinations(request);
        String client = "";
        SmsServlet.writeLog("starting doPost. jobId: " + jobId);
        if (jobId.equals("0")) {
            SmsServlet.writeLog("getting client from session");
            client = (String)request.getSession().getAttribute("client");
        } else {
            JobMapper jobMapper = new JobMapper(request);
            Job job = jobMapper.getJob(Integer.parseInt(jobId));
            if (job == null) {
                SmsServlet.writeLog("job is null");
            } else {
                SmsServlet.writeLog("job exists. jobId: " + job.getName());
            }
            client = job.getAccount().getClientCategory().getName();
        }
        if (client == null || client.equals("")) {
            SmsServlet.writeLog("Error: client is null");
            return;
        }
        SmsServlet.writeLog("Client: " + client);
        SmsServlet.forwardToSmsSender(request, response, ImSmsSender.getInstance(new ImSmsSenderFactory(), client, request), message, originator, smsDestinations, Integer.parseInt(jobId));
    }

    public static void forwardToSmsSender(HttpServletRequest request, HttpServletResponse response, SmsSender smsSender, String message, String originator, List<SmsDestination> smsDestinations, int jobId) throws ServletException, IOException {
        request.setAttribute("message", (Object)message);
        request.setAttribute("originator", (Object)originator);
        request.setAttribute("smsDestinations", smsDestinations);
        request.setAttribute("smsSender", (Object)smsSender);
        request.setAttribute("jobId", (Object)jobId);
        SmsServlet.writeLog("forwardToSmsSender called");
        request.getRequestDispatcher("/WEB-INF/jsp/smsworkflow/sms/sms_send.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<SmsDestination> getDestinations(HttpServletRequest request) {
        ArrayList<String> smsNumbers = new ArrayList<String>();
        String[] personIds = request.getParameterValues(Job.Parameter.PERSON_ID.toString());
        if (null != personIds) {
            JobMapper jobMapper = new JobMapper(request);
            for (String personId : personIds) {
                Person person = jobMapper.getPerson(Integer.parseInt(personId));
                smsNumbers.add(person.getMobile());
            }
        }
        String extraSmsDestinationsString = request.getParameter("tel_mobile_extra");
        smsNumbers.addAll(Arrays.asList(extraSmsDestinationsString.split("\r\n|\r|\n")));
        LOG.debug((Object)("Got numbers " + StringUtils.join(smsNumbers.iterator(), (String)", ")));
        return this.createDestinations(request, smsNumbers);
    }

    private List<SmsDestination> createDestinations(HttpServletRequest request, List<String> smsNumbers) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = cms.getUserService();
        ArrayList<SmsDestination> smsDestinations = new ArrayList<SmsDestination>();
        for (String smsNumber : smsNumbers) {
            User user = userService.getUser(smsNumber);
            String cleanedSmsNumber = smsNumber.replaceAll("\\D+", "");
            if (StringUtils.isBlank((String)cleanedSmsNumber)) continue;
            cleanedSmsNumber = cleanedSmsNumber.replaceFirst("^0", "46");
            SimpleSmsDestination smsDestination = new SimpleSmsDestination(null == user ? "" : user.getFirstName() + " " + user.getLastName(), cleanedSmsNumber);
            smsDestinations.add(smsDestination);
        }
        return smsDestinations;
    }
}

