/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.sms;

import com.imcode.db.DataSourceDatabase;
import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.SystemUtils;
import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountMapper;
import com.imcode.imcms.addon.smssystem.account.AccountUtils;
import com.imcode.imcms.addon.smssystem.job.Job;
import com.imcode.imcms.addon.smssystem.job.JobMapper;
import com.imcode.imcms.addon.smssystem.job.PersonAssignment;
import com.imcode.imcms.addon.smssystem.job.TableCreatingDatabase;
import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.imcms.addon.smssystem.person.PersonUtils;
import com.imcode.imcms.addon.smssystem.sms.ImSmsSender;
import com.imcode.imcms.addon.smssystem.sms.ImSmsSenderFactory;
import com.imcode.imcms.addon.smssystem.sms.SimpleSms;
import com.imcode.imcms.addon.smssystem.sms.Sms;
import com.imcode.imcms.addon.smssystem.sms.SmsException;
import com.imcode.imcms.addon.smssystem.sms.SmsSender;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class SmsReceiverServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((String)"SmsReceiverServlet");

    public boolean writeLog(HttpServletRequest request, String jobId, String destination, String status, String message, String user, int accountId, String[] responseValues) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);
        String ericssonId = "No ID returned";
        for (int i = 0; i < responseValues.length; ++i) {
            if (responseValues[i].indexOf("messageId: ") == -1) continue;
            ericssonId = responseValues[i].replaceAll("messageId: ", "");
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        if (message.length() >= 45) {
            message = message.substring(0, 44);
        }
        try {
            String sql = "INSERT INTO _smsworkflow_sms_log (date, job_id, destination, status, ericsson_id, message, user, account_id) VALUES (?,?,?,?,?,?,?,?)";
            dbUtil.sqlUpdateQuery(sql, new Object[]{logDate, jobId, destination, status, ericssonId, message, user, accountId});
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean writeReceiveLog(HttpServletRequest request, int jobId, int accountId, String originatorAddress, String status, String message, String ericssonId, String error, String originalMessage, String prefix, String code) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        try {
            String sql = "INSERT INTO _smsworkflow_received_sms_log (date, job_id, account_id, originator_address, status, ericsson_id, message, error, original_message, prefix, code) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            dbUtil.sqlUpdateQuery(sql, new Object[]{logDate, jobId, accountId, originatorAddress, status, ericssonId, message, error, originalMessage, prefix, code});
        }
        catch (Exception e) {
            this.writeLog("Error writing to database: " + e.toString());
            return false;
        }
        return true;
    }

    public void writeLog(String str) {
        FileOutputStream fos;
        String PATH_LOGS = "/WEB-INF/logs";
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "smsreceiverlog.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
            return;
        }
    }

    public String checkAnswer(Job job, String answer) {
        return answer;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.writeLog("doPost receiver called");
        this.doGet(request, response);
    }

    /*
     * WARNING - void declaration
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block84: {
            String answer;
            String code;
            String timeStamp;
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            DocumentService documentService = imcmsSystem.getDocumentService();
            DatabaseService databaseService = imcmsSystem.getDatabaseService();
            UserService userService = imcmsSystem.getUserService();
            DBUtil dbUtil = new DBUtil(databaseService);
            this.writeLog("doGet receiver called");
            request.setCharacterEncoding("UTF-8");
            JobMapper jobMapper = new JobMapper(request);
            String originatorAddress = request.getParameter("OriginatorAddress");
            if (originatorAddress.startsWith("46")) {
                originatorAddress = originatorAddress.replaceFirst("46", "0");
            }
            this.writeLog("originatorAddress: " + originatorAddress);
            String ericssonId = request.getParameter("MessageId") != null ? request.getParameter("MessageId") : "";
            String string = timeStamp = request.getParameter("TimeStamp") != null ? request.getParameter("TimeStamp") : "";
            if (null == originatorAddress) {
                this.writeReceiveLog(request, 0, 0, originatorAddress, "", "", ericssonId, "No originator address", request.getParameter("message") != null ? request.getParameter("message") : "", "", "");
                LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:-, code:-, answer:-, ERROR: MISSING_ORIGINATORADDRESS"));
                return;
            }
            String message = request.getParameter("Message");
            this.writeLog("Message: " + message);
            LOG.error((Object)("Incoming SMS message - first: " + message));
            if (null == message) {
                this.writeReceiveLog(request, 0, 0, originatorAddress, "", "", ericssonId, "No message", "", "", "");
                LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:-, code:-, answer:-, ERROR: MISSING_MESSAGE"));
                return;
            }
            try {
                String tempMess = request.getParameter("Message");
                LOG.error((Object)("Incoming SMS message - org: " + tempMess));
                LOG.error((Object)("Incoming SMS message - isoToUtf: " + SystemUtils.convertIsoToUtf8(tempMess)));
                LOG.error((Object)("Incoming SMS message - utfToIso: " + SystemUtils.convertUtf8ToIso(tempMess)));
                tempMess = URLDecoder.decode(request.getParameter("Message"), "iso-8859-1");
                LOG.error((Object)("Incoming SMS message - DECODE ISO org: " + tempMess));
                LOG.error((Object)("Incoming SMS message - DECODE ISO isoToUtf: " + SystemUtils.convertIsoToUtf8(tempMess)));
                LOG.error((Object)("Incoming SMS message - DECODE ISO utfToIso: " + SystemUtils.convertUtf8ToIso(tempMess)));
                tempMess = URLDecoder.decode(request.getParameter("Message"), "UTF-8");
                LOG.error((Object)("Incoming SMS message - DECODE UTF org: " + tempMess));
                LOG.error((Object)("Incoming SMS message - DECODE UTF isoToUtf: " + SystemUtils.convertIsoToUtf8(tempMess)));
                LOG.error((Object)("Incoming SMS message - DECODE UTF utfToIso: " + SystemUtils.convertUtf8ToIso(tempMess)));
            }
            catch (Exception e) {
                this.writeReceiveLog(request, 0, 0, originatorAddress, "", "", ericssonId, "Error decoding message", message, "", "");
                LOG.error((Object)"Error decoding message");
                return;
            }
            String strippedMessage = message.replaceAll("\\W+", "");
            this.writeLog("Message received: " + strippedMessage);
            String sJobCodeLength = "";
            for (SystemProperties.Prop property : SystemProperties.Prop.values()) {
                Object pValue;
                String pName = property.getPropertyName();
                try {
                    pValue = property.getString();
                }
                catch (Exception e) {
                    pValue = "";
                }
                if (pName.indexOf("job.code.length") == -1) continue;
                sJobCodeLength = pValue;
            }
            int jobCodeLength = 5;
            if (!sJobCodeLength.equals("")) {
                try {
                    jobCodeLength = Integer.parseInt(sJobCodeLength);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.writeLog("sJobCodeLength: " + sJobCodeLength);
            String prefix = "";
            try {
                CategoryType clientCategoryType = documentService.getCategoryType("client");
                Category[] clientCategories = documentService.getAllCategoriesOfType(clientCategoryType);
                ArrayList<TextDocument> clientDocs = new ArrayList<TextDocument>();
                for (Category clientCategory : clientCategories) {
                    clientDocs.add(documentService.getTextDocument(clientCategory.getName()));
                }
                for (TextDocument doc : clientDocs) {
                    for (String sPrefix : doc.getTextField(10101).getText().split(",")) {
                        sPrefix = sPrefix.trim();
                        this.writeLog("ClientDoc: " + doc.getAlias() + ". prefix: " + sPrefix + ". StrippedMessage: " + strippedMessage);
                        if (sPrefix.equals("") || !strippedMessage.toUpperCase().startsWith(sPrefix.toUpperCase())) continue;
                        prefix = sPrefix;
                        try {
                            jobCodeLength = Integer.parseInt(doc.getTextField(10104).getText());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.writeLog("Prefix: " + prefix);
            }
            catch (Exception e) {
                this.writeLog("Error occured finging prefix: " + e.toString());
            }
            if (prefix.equals("")) {
                this.writeReceiveLog(request, 0, 0, originatorAddress, "", "", ericssonId, "Prefix could not be found", message, "", "");
                return;
            }
            try {
                code = strippedMessage.substring(prefix.length(), prefix.length() + jobCodeLength).trim();
                answer = strippedMessage.substring(prefix.length() + jobCodeLength).trim();
                this.writeLog("Prefix: " + prefix + " code: " + code + " answer: " + answer);
                LOG.debug((Object)("Prefix: " + prefix + " code: " + code + " answer: " + answer));
            }
            catch (IndexOutOfBoundsException e) {
                this.writeReceiveLog(request, 0, 0, originatorAddress, "", "", ericssonId, "Could not parse code", message, prefix, "");
                this.writeLog("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:-, answer:-, ERROR: MESSAGE_TOO_SHORT");
                LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:-, answer:-, ERROR: MESSAGE_TOO_SHORT"));
                return;
            }
            Job job = jobMapper.getJobByCode(prefix, code);
            String client = "";
            try {
                client = job.getAccount().getClientCategory().getName();
            }
            catch (Exception doc) {
                // empty catch block
            }
            SmsSender smsSender = ImSmsSender.getInstance(new ImSmsSenderFactory(), client, request);
            AccountMapper accountMapper = new AccountMapper(request);
            Account account = null;
            Perl5Util re = new Perl5Util();
            try {
                if (re.match("m/^([\\w]{6})\\s*REP([\\w]{2})([\\s\\S]*)$/i", message)) {
                    String accountCode = re.group(2);
                    answer = re.group(3).trim();
                    account = accountMapper.getAccountByCode(accountCode);
                    LOG.debug((Object)("Match to REPXX. Account: " + (null != account ? account.getName() : "null")));
                } else {
                    LOG.debug((Object)("No match to REPXX. Message: " + message));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Incoming SMS REP match error: " + originatorAddress + ", mess:" + message), (Throwable)e);
            }
            if (null != account) {
                try {
                    boolean isMessengerForAccount = AccountUtils.isMessengerForAccount(originatorAddress, account, request);
                    boolean isInfoMessage = answer.trim().equalsIgnoreCase("INFO");
                    if (isMessengerForAccount) {
                        ArrayList<SimpleSms> allSms = new ArrayList<SimpleSms>();
                        if (null != account) {
                            List<Person> personList = PersonUtils.getAllPersonnelForAccount(account, true, request);
                            for (Person person : personList) {
                                String string2 = person.getMobileStripped();
                                SimpleSms simpleSms = new SimpleSms(string2, answer, "");
                                if (allSms.contains(simpleSms)) continue;
                                allSms.add(simpleSms);
                            }
                        }
                        boolean isRealSending = false;
                        int sendCount = 0;
                        if (!isInfoMessage && !allSms.isEmpty()) {
                            for (SimpleSms simpleSms : allSms) {
                                String[] stringArray = new String[]{};
                                try {
                                    String[] stringArray2 = smsSender.sendSms(simpleSms);
                                    ++sendCount;
                                    this.writeLog(request, String.valueOf(job.getId()), simpleSms.getDestination(), "OK", simpleSms.getMessage(), originatorAddress, job.getAccount().getId(), stringArray2);
                                }
                                catch (Exception e) {
                                    LOG.error((Object)("Send repeated SMS to " + simpleSms.getDestination() + " failed!"), (Throwable)e);
                                    this.writeLog(request, String.valueOf(job.getId()), simpleSms.getDestination(), "Error", simpleSms.getMessage(), originatorAddress, job.getAccount().getId(), stringArray);
                                }
                            }
                            isRealSending = true;
                            isInfoMessage = true;
                        }
                        if (isInfoMessage) {
                            void var30_64;
                            String string3 = "Incoming repeater SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", text:" + answer + ".\n" + "Konto: " + account.getName() + "\nPersoner: " + allSms.size() + "st.\n(Alla godk\u00e4nda)\n" + "" + (isRealSending ? "Skickar skarpt till" : "EJ skickat skarpt. Skulle skickat till") + ":";
                            for (Sms sms : allSms) {
                                String string4 = (String)var30_64 + "\nNbr: " + sms.getDestination();
                            }
                            LOG.debug((Object)var30_64);
                            SimpleSms simpleSms = new SimpleSms(originatorAddress, "Konto: " + account.getName() + "\nPersoner: " + allSms.size() + "st. (bara godk\u00e4nda)\nSkickade: " + sendCount + "st.\n" + (isRealSending ? "Skickat skarpt." : "EJ skickat skarpt."), "");
                            String[] stringArray = new String[]{};
                            try {
                                String[] stringArray3 = smsSender.sendSms(simpleSms);
                                this.writeLog(request, String.valueOf(job.getId()), simpleSms.getDestination(), "OK", simpleSms.getMessage(), originatorAddress, job.getAccount().getId(), stringArray3);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Send repeater SMS info error:\n" + (String)var30_64 + "\n"), (Throwable)e);
                                this.writeLog(request, String.valueOf(job.getId()), simpleSms.getDestination(), "Error", simpleSms.getMessage(), originatorAddress, job.getAccount().getId(), stringArray);
                            }
                        }
                        break block84;
                    }
                    LOG.error((Object)"Send repeater SMS info error: Not messenger for account!");
                }
                catch (Exception e) {
                    this.sendError(originatorAddress, request, response, client, SystemProperties.Prop.MESS_COULD_NOT_FIND_JOB_FOR_CODE.getString() + " \"" + code + "\".", " Repeater handling crashed. Error: " + e.toString() + " Message: " + message);
                    LOG.error((Object)("Repeater SMS handling crashed! Error: " + e.toString()));
                }
            } else {
                String personAssignmentStatus = "";
                try {
                    this.writeLog("started message handling");
                    if (null == job) {
                        this.writeReceiveLog(request, 0, 0, originatorAddress, "", strippedMessage, ericssonId, "Could not find job", message, prefix, code);
                        this.writeLog("Error. Job is null. Code: " + code + " message: " + strippedMessage);
                        LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: COULD_NOT_FIND_JOB_FOR_CODE"));
                        this.sendError(originatorAddress, request, response, client, SystemProperties.Prop.MESS_COULD_NOT_FIND_JOB_FOR_CODE.getString() + " \"" + code + "\"", "Job is null");
                        return;
                    }
                    this.writeLog("Job: " + job.getName());
                    JobMapper.SmsMessageTexts smsMessageTexts = jobMapper.getSmsMessageTexts(job);
                    if (job.getPersonAssignments(request) == null) {
                        this.writeReceiveLog(request, job.getId(), job.getAccount().getId(), originatorAddress, "", strippedMessage, ericssonId, "job.getPersonAssignments() is null", message, prefix, code);
                        LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not save freetext message: job.getPersonAssignments(request) is null"));
                        return;
                    }
                    this.writeLog("Getting personassignment");
                    PersonAssignment personAssignment = null;
                    try {
                        personAssignment = this.getPersonAssignmentForNumber(job.getPersonAssignments(request), originatorAddress);
                    }
                    catch (Exception e) {
                        this.writeLog("Error getting personassignment for number " + originatorAddress + ": " + e);
                    }
                    if (null == personAssignment && job.getRegistrationRequired()) {
                        this.writeReceiveLog(request, job.getId(), job.getAccount().getId(), originatorAddress, "", strippedMessage, ericssonId, "Personassignment is null and registration is required", message, prefix, code);
                        this.writeLog("personassignment is null and registration is required");
                        LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: COULD_NOT_FIND_EMPLOYEE_ASSIGNMENT_FOR_JOB"));
                        this.sendError(originatorAddress, request, response, client, SystemProperties.Prop.MESS_COULD_NOT_FIND_EMPLOYEE_ASSIGNMENT_FOR_JOB.getString(), "personAssignment is null");
                        return;
                    }
                    if (null == personAssignment && !job.getRegistrationRequired()) {
                        this.writeLog("personassignment is null and registration is NOT required");
                        LOG.debug((Object)("Incoming SMS: " + originatorAddress + " User does not exist, but registration is not required"));
                        Person person = null;
                        this.writeLog("getting user");
                        User user = userService.getUser(originatorAddress);
                        if (user == null) {
                            this.writeLog("user is null");
                            try {
                                void var31_87;
                                this.writeLog("trying to register user");
                                user = userService.createNewUser(originatorAddress, originatorAddress);
                                userService.saveUser(user);
                                user = userService.getUser(originatorAddress);
                                TextDocument textDocument = documentService.createNewTextDocument((Document)documentService.getTextDocument(Imcms.getServices().getSystemData().getStartDocument()));
                                textDocument.setAlias("tmpuserdocalias" + Thread.currentThread().getId());
                                this.writeLog("Temporary alias: " + textDocument.getAlias() + " id: " + textDocument.getId());
                                documentService.saveChanges((Document)textDocument);
                                TextDocument textDocument2 = documentService.getTextDocument("tmpuserdocalias" + Thread.currentThread().getId());
                                textDocument2.setAlias("" + textDocument2.getId());
                                documentService.saveChanges((Document)textDocument2);
                                this.writeLog("Meta_id: " + textDocument2.getId());
                                user.setOtherPhone("" + textDocument2.getId());
                                user.setMobilePhone(originatorAddress);
                                user.setCompany(client);
                                Role role = userService.getRole("smsworkflow_unregisteredRole");
                                if (role == null) {
                                    Role role2 = userService.createNewRole("smsworkflow_unregisteredRole");
                                    userService.saveRole(role2);
                                }
                                user.addRole((Role)var31_87);
                                userService.saveUser(user);
                                person = new Person(user, textDocument2);
                                person.setFirstname("");
                                person.setLastname("");
                                person.setMobile(originatorAddress);
                                person.setPassword(originatorAddress);
                                person.setStatus(Person.Status.NEW);
                                ArrayList<Account> arrayList = new ArrayList<Account>();
                                arrayList.add(job.getAccount());
                                person.setPersonAccounts(arrayList);
                                person.setPersonAccountCategories(job.getAccount().getAccountCategories(true));
                                Person.save(person, true, request);
                                this.writeLog("Incoming SMS: " + originatorAddress + " User did not exist, new user created");
                            }
                            catch (Exception exception) {
                                this.writeLog("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not create new person: " + exception.toString());
                            }
                        } else {
                            this.writeLog("trying to load user: " + user.getLoginName());
                            person = Person.fromUser(user, request);
                            try {
                                List<Account> list = person.getPersonAccounts();
                                list.add(job.getAccount());
                                person.setPersonAccounts(list);
                                Person.save(person, false, request);
                            }
                            catch (Exception exception) {
                                this.writeLog("error trying to load user " + user.getLoginName() + ": " + exception);
                                LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not add this account to the user: " + exception.toString()));
                            }
                            this.writeLog("Incoming SMS: " + originatorAddress + " User existed, but not registered to this job.");
                        }
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            TableCreatingDatabase tableCreatingDatabase = new TableCreatingDatabase((Database)new DataSourceDatabase(imcmsSystem.getDatabaseService().getDataSource()));
                            tableCreatingDatabase.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("_smsworkflow_person_assignments", (Object[][])new Object[][]{{"job_id", job.getId()}, {"person_id", person.getId()}, {"status", "2"}, {"last_updated", simpleDateFormat.format(Calendar.getInstance().getTime())}}));
                        }
                        catch (Exception exception) {
                            this.writeLog("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not create new personAssignment: " + exception.toString());
                        }
                        try {
                            personAssignment = this.getPersonAssignmentForNumber(job.getPersonAssignments(request), originatorAddress);
                        }
                        catch (Exception exception) {
                            this.writeLog("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: getPersonAssignmentForNumber: " + exception.toString());
                        }
                        if (personAssignment == null) {
                            this.writeLog("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not get personAssignment");
                        }
                    }
                    String clarifiedAnswer = this.checkAnswer(job, answer);
                    this.writeLog("answer: " + answer + " clarifiedanswer: " + clarifiedAnswer);
                    boolean messageHasBeenMatched = false;
                    String string5 = "SELECT id, code FROM _smsworkflow_status WHERE meta_id=? and `group`=2 ORDER by sort_key DESC";
                    String[][] stringArray = dbUtil.sqlQueryMulti(string5, (Object[])new String[]{"" + job.getId()});
                    this.writeLog("Statuses loaded: " + stringArray.length);
                    for (String[] status : stringArray) {
                        String trimmedStatus = status[1].replaceAll("\\s+", "");
                        if (!job.getAllowFreeText()) {
                            this.writeLog("Freetext not allowed. Checking if " + clarifiedAnswer.toUpperCase() + " starts with " + trimmedStatus.toUpperCase());
                            if (clarifiedAnswer.toUpperCase().startsWith(trimmedStatus.toUpperCase())) {
                                messageHasBeenMatched = true;
                                personAssignmentStatus = status[0];
                                this.writeLog("Status selected: " + status[0]);
                            }
                        }
                        if (!job.getAllowFreeText()) continue;
                        this.writeLog("Freetext allowed. Checking if " + clarifiedAnswer.toUpperCase() + " equals " + trimmedStatus.toUpperCase());
                        if (!clarifiedAnswer.trim().equalsIgnoreCase(trimmedStatus)) continue;
                        messageHasBeenMatched = true;
                        personAssignmentStatus = status[0];
                        this.writeLog("Status selected: " + status[0]);
                    }
                    if (!messageHasBeenMatched && job.getAllowFreeText()) {
                        void var32_104;
                        messageHasBeenMatched = true;
                        this.writeLog("Freetextmessage");
                        Object var32_102 = null;
                        try {
                            SimpleDateFormat dfRaw = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
                            Date date = dfRaw.parse(timeStamp);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not parse timeStamp"));
                        }
                        if (null == var32_104) {
                            LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not parse timeStamp"));
                        }
                        try {
                            Calendar calendar = Calendar.getInstance();
                            if (dbUtil == null) {
                                this.writeLog("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not save freetext message: dbUtil is null");
                                LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not save freetext message: dbUtil is null"));
                                return;
                            }
                            if (personAssignment == null) {
                                this.writeReceiveLog(request, job.getId(), job.getAccount().getId(), originatorAddress, "", strippedMessage, ericssonId, "Could not save freetext message: personAssignment is null", message, prefix, code);
                                this.writeLog("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not save freetext message: personAssignment is null");
                                LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not save freetext message: personAssignment is null"));
                                return;
                            }
                            if (personAssignment.getPerson() == null) {
                                this.writeReceiveLog(request, job.getId(), job.getAccount().getId(), originatorAddress, "", strippedMessage, ericssonId, "Could not save freetext message: personAssignment.getPerson() is null", message, prefix, code);
                                this.writeLog("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not save freetext message: personAssignment.getPerson() is null");
                                LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not save freetext message: personAssignment.getPerson() is null"));
                                return;
                            }
                            SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            String string6 = "INSERT INTO _smsworkflow_freetext_messages (senddate, receiveddate, job_id, originator, ericsson_id, message, user, account_id) VALUES (?,?,?,?,?,?,?,?)";
                            String freeTextMessage = message;
                            int posInCode = 0;
                            int posInMessage = 0;
                            while (posInCode < code.length() + prefix.length()) {
                                ++posInCode;
                                while (freeTextMessage.charAt(posInMessage) == ' ') {
                                    ++posInMessage;
                                }
                                ++posInMessage;
                            }
                            freeTextMessage = freeTextMessage.substring(posInMessage, freeTextMessage.length());
                            dbUtil.sqlUpdateQuery(string6, new Object[]{dfD.format((Date)var32_104), dfD.format(calendar.getTime()), job.getId(), originatorAddress, ericssonId, freeTextMessage.trim(), personAssignment.getPerson().getId(), job.getAccount().getId()});
                            personAssignmentStatus = "";
                            this.writeLog("Message saved");
                        }
                        catch (Exception e) {
                            this.writeReceiveLog(request, job.getId(), job.getAccount().getId(), originatorAddress, "", strippedMessage, ericssonId, "Could not save freetext message: Database error", message, prefix, code);
                            this.writeLog("error receiving freetext: " + e);
                            LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: Could not save freetext message: " + e.toString()));
                            return;
                        }
                    }
                    if (!messageHasBeenMatched) {
                        this.writeReceiveLog(request, job.getId(), job.getAccount().getId(), originatorAddress, "", strippedMessage, ericssonId, "Could not be matched with predefined answer", message, prefix, code);
                        this.writeLog("error reading message yesorno");
                        LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: MISSING_YES_NO"));
                        this.sendError(originatorAddress, request, response, client, SystemProperties.Prop.MESS_MISSING_YES_NO.getString(), "Missing yesorno");
                        return;
                    }
                    if (!personAssignmentStatus.equals("")) {
                        jobMapper.updatePersonAssignmentStatus(personAssignment.getId(), personAssignmentStatus);
                    }
                    response.setStatus(204);
                    if (!job.getMessageReceiveSuccess().trim().equals("")) {
                        SimpleSms simpleSms = new SimpleSms(originatorAddress, smsMessageTexts.getReseivedMessage(), "");
                        String[] responseValues = new String[]{};
                        try {
                            responseValues = smsSender.sendSms(simpleSms);
                            this.writeLog(request, String.valueOf(job.getId()), simpleSms.getDestination(), "OK", simpleSms.getMessage(), originatorAddress, job.getAccount().getId(), responseValues);
                        }
                        catch (SmsException e) {
                            this.writeLog("Error while sending reply: " + e.toString() + " Error message: " + e.getMessage() + " SMS: " + simpleSms.getMessage() + " Destination: " + simpleSms.getDestination() + " Originator: " + originatorAddress);
                            this.writeLog(request, String.valueOf(job.getId()), simpleSms.getDestination(), "Error", simpleSms.getMessage(), originatorAddress, job.getAccount().getId(), responseValues);
                        }
                    } else {
                        this.writeLog("Automated response is not sent, message was empty");
                    }
                }
                catch (Exception e) {
                    this.writeReceiveLog(request, job.getId(), job.getAccount().getId(), originatorAddress, "", strippedMessage, ericssonId, "Error occured", message, prefix, code);
                    this.writeLog("Error: " + e);
                    LOG.error((Object)("Incoming SMS: " + originatorAddress + ", mess:" + strippedMessage + ", code:" + code + ", answer:" + answer + ", ERROR: " + e.toString()));
                    this.sendError(originatorAddress, request, response, client, SystemProperties.Prop.MESS_COULD_NOT_FIND_JOB_FOR_CODE.getString() + " \"" + code + "\".", "Handling crashed. Error: " + e.toString() + ". message: " + message);
                }
                try {
                    this.writeReceiveLog(request, job.getId(), job.getAccount().getId(), originatorAddress, personAssignmentStatus, strippedMessage, ericssonId, "", message, prefix, code);
                }
                catch (Exception e) {
                    this.writeLog("Error: " + e.toString());
                }
            }
        }
        this.writeLog("done ");
    }

    private PersonAssignment getPersonAssignmentForNumber(Collection<PersonAssignment> personAssignments, String originatorAddress) {
        for (PersonAssignment personAssignment : personAssignments) {
            Person person = personAssignment.getPerson();
            String fixedMobileNumber = person.getMobile();
            if (!originatorAddress.equals(fixedMobileNumber)) continue;
            return personAssignment;
        }
        return null;
    }

    private void sendError(String originatorAddress, HttpServletRequest request, HttpServletResponse response, String client, String errorMessage, String extra) throws IOException {
        if (null != originatorAddress) {
            SmsSender smsSender = ImSmsSender.getInstance(new ImSmsSenderFactory(), client, request);
            SimpleSms simpleSms = new SimpleSms(originatorAddress, SystemProperties.Prop.MESS_COULD_NOT_INTERPRET_MESSAGE.getString(), "");
            String[] responseValues = smsSender.sendSms(simpleSms);
            this.writeLog(request, "0", simpleSms.getDestination(), "OK", simpleSms.getMessage(), originatorAddress, 0, responseValues);
        }
        response.sendError(400, errorMessage);
    }
}

