/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.job;

import com.imcode.db.DataSourceDatabase;
import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.handlers.CollectionHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.db.handlers.SingleObjectHandler;
import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.SystemUtils;
import com.imcode.imcms.addon.smssystem.comparators.TextFieldComparator;
import com.imcode.imcms.addon.smssystem.job.Job;
import com.imcode.imcms.addon.smssystem.job.PersonAssignment;
import com.imcode.imcms.addon.smssystem.job.TableCreatingDatabase;
import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.imcms.api.BadQueryException;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.LuceneParsedQuery;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.SearchException;
import com.imcode.imcms.api.SearchQuery;
import com.imcode.imcms.api.TextDocument;
import imcode.server.Imcms;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

public class JobMapper {
    static final String PATH_LOGS = "/WEB-INF/logs";
    static final String SMS_DEFAULT_MESSAGE_INQUIRE = "Kan du jobba?";
    private HttpServletRequest request;
    private final ContentManagementSystem imcmsSystem;

    public void writeLog(String str) {
        FileOutputStream fos;
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "jobmapperlog.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
            return;
        }
    }

    public JobMapper(HttpServletRequest request) {
        this.request = request;
        this.imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
    }

    public SmsMessageTexts getSmsMessageTexts(Job job) {
        final String sms_message_inquire = job.getMessageText1();
        final String sms_message_reseived = job.getMessageReceiveSuccess();
        return new SmsMessageTexts(){

            @Override
            public String getInquiryMessage() {
                return StringUtils.isNotBlank((String)sms_message_inquire) ? sms_message_inquire : JobMapper.SMS_DEFAULT_MESSAGE_INQUIRE;
            }

            @Override
            public String getReseivedMessage() {
                return sms_message_reseived;
            }
        };
    }

    public String getInquiryMessage(Job job) {
        String returnString = job.getMessageText1();
        if (job.getAppendDateTimeToMessage()) {
            returnString = returnString + job.getDateTimeTextWithLineBreak();
        }
        if (job.getAppendNumberToMessage()) {
            returnString = returnString + "\nSMSa till 71160";
        }
        if (job.getAppendStatusesToMessage()) {
            returnString = returnString + "\n" + this.getStatuses(job);
        }
        return returnString;
    }

    public String getStatuses(Job job) {
        String prefix = "";
        String returnString = "";
        try {
            if (job.getPrefix() == null || job.getPrefix().equals("")) {
                String client = job.getAccount().getTextDoc().getCategoriesOfType(this.imcmsSystem.getDocumentService().getCategoryType("client"))[0].getName();
                TextDocument clientDoc = this.imcmsSystem.getDocumentService().getTextDocument(client);
                prefix = clientDoc.getTextField(10101).getText().split(",")[0];
            } else {
                prefix = job.getPrefix();
            }
        }
        catch (Exception e) {
            prefix = "";
        }
        try {
            String[][] statuses;
            DatabaseService databaseService = this.imcmsSystem.getDatabaseService();
            DBUtil dbUtil = new DBUtil(databaseService);
            String sql = "SELECT * FROM _smsworkflow_status WHERE meta_id=? AND `group`=? ORDER by sort_key DESC";
            for (String[] status : statuses = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{"" + job.getId(), "2"})) {
                returnString = returnString + "Om " + status[2] + " skriv\n" + prefix + " " + job.getSmsCode() + " " + status[5] + "\n";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnString;
    }

    public Job getJob(int jobId) {
        return Job.fromDocument(this.imcmsSystem.getDocumentService().getTextDocument(jobId), this.request);
    }

    public Collection<PersonAssignment> getPersonAssignments(int jobId) {
        SqlQueryCommand sqlQueryCommand = new SqlQueryCommand("SELECT id, person_id, status, last_updated FROM _smsworkflow_person_assignments WHERE job_id = ?", new Object[]{jobId}, (ResultSetHandler)new CollectionHandler(new ArrayList(), (RowTransformer)new PersonAssignmentFactory()));
        return (Collection)this.getDatabase().execute((DatabaseCommand)sqlQueryCommand);
    }

    public Collection<Person> getAssignedPersons(int jobId) {
        return CollectionUtils.collect(this.getPersonAssignments(jobId), (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((PersonAssignment)object).getPerson();
            }
        }, new ArrayList());
    }

    private Database getDatabase() {
        return new TableCreatingDatabase((Database)new DataSourceDatabase(this.imcmsSystem.getDatabaseService().getDataSource()));
    }

    public Person getPerson(int personId) {
        Document personDocument = this.imcmsSystem.getDocumentService().getDocument(personId);
        if (!(personDocument instanceof TextDocument)) {
            return null;
        }
        return Person.fromDocument((TextDocument)personDocument, this.request);
    }

    void addPerson(int jobId, int personId) {
        try {
            this.writeLog("addPerson(jobId: " + jobId + " personId: " + personId);
            SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.getDatabase().execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("_smsworkflow_person_assignments", (Object[][])new Object[][]{{"job_id", jobId}, {"person_id", personId}, {"status", "1"}, {"last_updated", dfD.format(Calendar.getInstance().getTime())}}));
        }
        catch (Exception e) {
            this.writeLog("Error in addPerson(jobId: " + jobId + " personId: " + personId);
        }
    }

    public Job getJobByCode(String prefix, String code) {
        this.writeLog("getJobByCode called. prefix: " + prefix + " code: " + code);
        DatabaseService databaseService = this.imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);
        String sql = "SELECT doc_id FROM imcms_text_doc_texts WHERE no = 28001 AND text = ?";
        String[] job_ids = dbUtil.sqlQuery(sql, (Object[])new String[]{code});
        this.writeLog("antal job_ids med samma jobbkod: " + job_ids.length);
        if (job_ids.length == 1 || prefix.equals("")) {
            this.writeLog("returning job: " + job_ids[0] + " job_ids.length: " + job_ids.length);
            return Job.fromDocument((TextDocument)this.imcmsSystem.getDocumentService().getDocument(job_ids[0]), this.request);
        }
        for (String job_id : job_ids) {
            this.writeLog("Checking prefix " + prefix + " and job_id " + job_id);
            DocumentService documentService = this.imcmsSystem.getDocumentService();
            TextDocument jobDoc = (TextDocument)documentService.getDocument(job_id);
            this.writeLog("jobDoc: " + jobDoc.getId());
            TextDocument clientDoc = documentService.getTextDocument(jobDoc.getCategoriesOfType(documentService.getCategoryType("client"))[0].getName());
            this.writeLog("clientDoc: " + clientDoc.getName());
            sql = "SELECT text FROM imcms_text_doc_texts WHERE no = 10101 AND doc_id = ?";
            String prefixesString = dbUtil.sqlQueryStr(sql, (Object[])new String[]{"" + clientDoc.getId()});
            if (prefixesString == null || prefixesString.equals("")) continue;
            this.writeLog("prefixesString: " + prefixesString);
            for (String prefixString : prefixesString.split(",")) {
                if (!prefixString.trim().equalsIgnoreCase(prefix.trim())) continue;
                this.writeLog("Found job: " + job_id + " with prefix: " + prefix);
                return Job.fromDocument((TextDocument)this.imcmsSystem.getDocumentService().getDocument(job_id), this.request);
            }
        }
        return null;
    }

    public void updatePersonAssignmentStatus(int id, String status_id) {
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("UPDATE _smsworkflow_person_assignments SET status = ?, last_updated=? WHERE id = ?", new Object[]{status_id, dfD.format(Calendar.getInstance().getTime()), id}));
    }

    public PersonAssignment getPersonAssignment(int personAssignmentId) {
        SqlQueryCommand sqlQueryCommand = new SqlQueryCommand("SELECT id, person_id, status FROM _smsworkflow_person_assignments WHERE id = ?", new Object[]{personAssignmentId}, (ResultSetHandler)new SingleObjectHandler((RowTransformer)new PersonAssignmentFactory()));
        return (PersonAssignment)this.getDatabase().execute((DatabaseCommand)sqlQueryCommand);
    }

    public List<Job> getJobs(Job.Status status, String date0, String date1) {
        Document[] documents = this.getDocuments(date0, date1);
        ArrayList<Job> jobs = new ArrayList<Job>();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date lastMidnight = calendar.getTime();
        for (Document document : documents) {
            Job job = Job.fromDocument((TextDocument)document, this.request);
            if (null != job.getDate() && job.getDate().before(lastMidnight) && !Job.Status.CLOSED.equals((Object)job.getStatus())) {
                TextDocument textDoc = (TextDocument)document;
                textDoc.setHtmlTextField(28000, Job.Status.CLOSED.toString());
                textDoc.setHtmlTextField(28001, "");
                try {
                    this.imcmsSystem.getDocumentService().saveChanges((Document)textDoc);
                    job = Job.fromDocument(textDoc, this.request);
                }
                catch (SaveException e) {
                    throw new UnhandledException((Throwable)e);
                }
            }
            if (!Job.Status.NONE.equals((Object)status) && !job.getStatus().equals((Object)status)) continue;
            jobs.add(job);
        }
        return jobs;
    }

    private Document[] getDocuments(String date0, String date1) {
        String query = "+category:" + SystemProperties.Prop.JOB_CATEGORY_NAME.getString() + " " + "+status:" + Document.PublicationStatus.APPROVED + "";
        String luceneDate0 = SystemUtils.stripHyphens(date0);
        String luceneDate1 = SystemUtils.stripHyphens(date1);
        if (luceneDate0.matches("^\\d{8}")) {
            SimpleDateFormat dfL = new SimpleDateFormat("yyyyMMdd");
            try {
                Date dDate0 = dfL.parse(luceneDate0);
                Calendar cal = Calendar.getInstance();
                cal.setTime(dDate0);
                cal.add(5, -1);
                luceneDate0 = dfL.format(cal.getTime());
            }
            catch (ParseException e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        if (!date0.equals("") && !date1.equals("")) {
            query = query + " +text28022:[" + luceneDate0 + " TO " + luceneDate1 + "]";
        } else if (!date0.equals("")) {
            query = query + " +text28022:[" + luceneDate0 + " TO 20991231]";
        } else if (!date1.equals("")) {
            query = query + " +text28022:[19000101 TO " + luceneDate1 + "]";
        }
        TextFieldComparator textFieldComparator = new TextFieldComparator(28022);
        this.request.getSession().setAttribute("SEARCH_JOBS_DEBUG", (Object)query);
        return this.getDocuments(query, textFieldComparator);
    }

    private Document[] getDocuments(String query, Comparator comp) {
        Document[] docArr;
        try {
            LuceneParsedQuery sq = new LuceneParsedQuery(query);
            docArr = this.imcmsSystem.getDocumentService().search((SearchQuery)sq);
            Arrays.sort(docArr, comp);
        }
        catch (SearchException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (BadQueryException e) {
            throw new UnhandledException((Throwable)e);
        }
        return docArr;
    }

    public static interface SmsMessageTexts {
        public String getInquiryMessage();

        public String getReseivedMessage();
    }

    private class PersonAssignmentFactory
    implements RowTransformer {
        private PersonAssignmentFactory() {
        }

        public Object createObjectFromResultSetRow(ResultSet rs) throws SQLException {
            String status;
            final int id = rs.getInt("id");
            try {
                status = rs.getString("status");
            }
            catch (IllegalArgumentException e) {
                status = "1";
            }
            final Person person = JobMapper.this.getPerson(rs.getInt("person_id"));
            final String status1 = status;
            Date tmpDate = Calendar.getInstance().getTime();
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                tmpDate = df.parse(df.format(rs.getDate("last_updated").getTime() + rs.getTime("last_updated").getTime()));
            }
            catch (Exception df) {
                // empty catch block
            }
            final Date lastUpdate = tmpDate;
            return new PersonAssignment(){

                @Override
                public int getId() {
                    return id;
                }

                @Override
                public Person getPerson() {
                    return person;
                }

                @Override
                public String getStatusId() {
                    return status1;
                }

                @Override
                public Date getLastUpdate() {
                    return lastUpdate;
                }
            };
        }

        public Class getClassOfCreatedObjects() {
            return PersonAssignment.class;
        }
    }
}

