/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.account;

import com.imcode.db.DataSourceDatabase;
import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.db.handlers.SingleObjectHandler;
import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountUtils;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.TextDocument;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.dbutils.ResultSetHandler;

public class AccountMapper {
    private HttpServletRequest request;
    private final ContentManagementSystem imcmsSystem;

    public AccountMapper(HttpServletRequest request) {
        this.request = request;
        this.imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
    }

    private Database getDatabase() {
        return new DataSourceDatabase(this.imcmsSystem.getDatabaseService().getDataSource());
    }

    public Account getAccountByCode(String code) {
        try {
            return (Account)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT doc_id FROM imcms_text_doc_texts WHERE no = 10041 AND text = ?", new Object[]{code}, (ResultSetHandler)new SingleObjectHandler(new RowTransformer(){

                public Object createObjectFromResultSetRow(ResultSet rs) throws SQLException {
                    int documentId = rs.getInt("doc_id");
                    return AccountUtils.fromDocument((TextDocument)AccountMapper.this.imcmsSystem.getDocumentService().getDocument(documentId), AccountMapper.this.request);
                }

                public Class getClassOfCreatedObjects() {
                    return Account.class;
                }
            })));
        }
        catch (Exception e) {
            return null;
        }
    }
}

