/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class PageView {
    public static final String PARAM_VIEW = "page";
    public static final String PARAM_VIEW_LOGIN = "pageViewLogin";
    public static final String PARAM_USER = "pageViewUserId";
    public static final String PARAM_SESSION_LAST_DOCUMENTS = "LAST_DOCUMENTS_VIEWED";
    public static final String PARAM_SESSION_LOGIN_NEXT_URL = "LOGIN_NEXT_URL";

    public static View fromRequest(HttpServletRequest request) {
        View returnView = View.EMPTY;
        try {
            if (null != request.getAttribute(PARAM_VIEW)) {
                request.getSession().setAttribute(PARAM_VIEW, request.getAttribute(PARAM_VIEW));
                returnView = (View)((Object)request.getAttribute(PARAM_VIEW));
            } else if (null != request.getParameter(PARAM_VIEW)) {
                String param = StringUtils.defaultString((String)request.getParameter(PARAM_VIEW));
                for (View view : View.values()) {
                    if (!((Object)((Object)view) + "").equals(param)) continue;
                    request.getSession().setAttribute(PARAM_VIEW, (Object)view);
                    returnView = view;
                    break;
                }
            } else if (null != request.getSession().getAttribute(PARAM_VIEW)) {
                returnView = (View)((Object)request.getSession().getAttribute(PARAM_VIEW));
            }
            return returnView;
        }
        catch (Exception exception) {
            return View.EMPTY;
        }
    }

    public static View swapView(View toView, HttpServletRequest request) {
        request.removeAttribute(PARAM_VIEW);
        request.getSession().setAttribute(PARAM_VIEW, (Object)toView);
        return PageView.fromRequest(request);
    }

    public static enum View {
        EMPTY("", "", "", ""),
        PERSONNEL_SEND_SMS("Skicka SMS", "/smsworkflow/admin/personnel/sendsms", "/^\\/personnel\\/sendsms$/", "/WEB-INF/jsp/smsworkflow/personnel/tab_send_sms.jsp"),
        PERSONNEL_REGISTER("Personalregister", "/smsworkflow/admin/personnel", "/^\\/personnel$/", "/WEB-INF/jsp/smsworkflow/personnel/tab_personnel_register.jsp"),
        PERSON_CREATE("Skapa person", "/smsworkflow/admin/personnel/create", "/^\\/personnel\\/create$/", "/WEB-INF/jsp/smsworkflow/personnel/tab_create_alter_person.jsp"),
        PERSON_CREATE_SUBMIT("PATH ONLY", "/smsworkflow/admin/personnel/create/submit", "/^\\/personnel\\/create\\/submit$/", "/WEB-INF/jsp/smsworkflow/personnel/person_save.jsp"),
        PERSON_SHOW("Visa person", "/smsworkflow/admin/personnel/show/#META_ID#", "/^\\/personnel\\/show\\/([\\d]+)$/", "/WEB-INF/jsp/smsworkflow/personnel/tab_create_alter_person.jsp"),
        PERSON_EDIT("&Auml;ndra person", "/smsworkflow/admin/personnel/edit/#META_ID#", "/^\\/personnel\\/edit\\/([\\d]+)$/", "/WEB-INF/jsp/smsworkflow/personnel/tab_create_alter_person.jsp"),
        PERSON_EDIT_SUBMIT("PATH ONLY", "/smsworkflow/admin/personnel/edit/#META_ID#/submit", "/^\\/personnel\\/edit\\/([\\d]+)\\/submit$/", "/WEB-INF/jsp/smsworkflow/personnel/person_save.jsp"),
        PERSON_DELETE("PATH ONLY", "/smsworkflow/admin/personnel/edit/#META_ID#/delete", "/^\\/personnel\\/edit\\/([\\d]+)\\/delete/", "/WEB-INF/jsp/smsworkflow/personnel/person_delete.jsp"),
        MY_PAGE_CREATE("PATH ONLY", "/smsworkflow/profile/apply", "/^\\/apply$/", "/WEB-INF/jsp/smsworkflow/personnel/tab_create_alter_person.jsp"),
        MY_PAGE_CREATE_SUBMIT("PATH ONLY", "/smsworkflow/profile/apply/submit", "/^\\/apply\\/submit$/", "/WEB-INF/jsp/smsworkflow/personnel/person_save.jsp"),
        MY_PAGE_EDIT("Din profil", "/smsworkflow/profile/#META_ID#", "/^\\/([\\d]+)$/", "/WEB-INF/jsp/smsworkflow/personnel/tab_create_alter_person.jsp"),
        MY_PAGE_EDIT_SUBMIT("PATH ONLY", "/smsworkflow/profile/#META_ID#/submit", "/^\\/([\\d]+)\\/submit$/", "/WEB-INF/jsp/smsworkflow/personnel/person_save.jsp"),
        MY_PAGE_DELETE("PATH ONLY", "/smsworkflow/profile/#META_ID#/delete", "/^\\/([\\d]+)\\/delete/", "/WEB-INF/jsp/smsworkflow/personnel/person_delete.jsp"),
        JOB_LIST("Jobblista", "/smsworkflow/admin/jobs/list", "/^\\/jobs\\/list$/", "/WEB-INF/jsp/smsworkflow/job/tab_job_list.jsp"),
        JOB_CREATE("Skapa jobb", "/smsworkflow/admin/jobs/create", "/^\\/jobs\\/create$/", "/WEB-INF/jsp/smsworkflow/job/tab_job.jsp"),
        JOB_CREATE_SUBMIT("PATH ONLY", "/smsworkflow/admin/jobs/create/submit", "/^\\/jobs\\/create\\/submit$/", "/WEB-INF/jsp/smsworkflow/job/job_save.jsp"),
        JOB_EDIT("Visa/&auml;ndra jobb", "/smsworkflow/admin/jobs/edit/#META_ID#", "/^\\/jobs\\/edit\\/([\\d]+)$/", "/WEB-INF/jsp/smsworkflow/job/tab_job.jsp"),
        JOB_EDIT_SUBMIT("PATH ONLY", "/smsworkflow/admin/jobs/edit/#META_ID#/submit", "/^\\/jobs\\/edit\\/([\\d]+)\\/submit$/", "/WEB-INF/jsp/smsworkflow/job/job_save.jsp"),
        JOB_SMS_MESSAGE1("PATH ONLY", "/smsworkflow/admin/jobs/#META_ID#/sms1", "/^\\/jobs\\/([\\d]+)\\/sms1/", "/WEB-INF/jsp/smsworkflow/job/tab_job_sms.jsp"),
        JOB_SMS_MESSAGE2("PATH ONLY", "/smsworkflow/admin/jobs/#META_ID#/sms2", "/^\\/jobs\\/([\\d]+)\\/sms2/", "/WEB-INF/jsp/smsworkflow/job/tab_job_sms.jsp"),
        ACCOUNT_LIST("Konton", "/smsworkflow/admin/accounts/list", "/^\\/accounts\\/list$/", "/WEB-INF/jsp/smsworkflow/account/tab_accounts_list.jsp"),
        ACCOUNT_CREATE("Skapa konto", "/smsworkflow/admin/accounts/create", "/^\\/accounts\\/create$/", "/WEB-INF/jsp/smsworkflow/account/tab_account.jsp"),
        ACCOUNT_CREATE_SUBMIT("PATH ONLY", "/smsworkflow/admin/accounts/create/submit", "/^\\/accounts\\/create\\/submit$/", "/WEB-INF/jsp/smsworkflow/account/account_save.jsp"),
        ACCOUNT_EDIT("&Auml;ndra konto", "/smsworkflow/admin/accounts/edit/#META_ID#", "/^\\/accounts\\/edit\\/([\\d]+)$/", "/WEB-INF/jsp/smsworkflow/account/tab_account.jsp"),
        ACCOUNT_EDIT_SUBMIT("PATH ONLY", "/smsworkflow/admin/accounts/edit/#META_ID#/submit", "/^\\/accounts\\/edit\\/([\\d]+)\\/submit$/", "/WEB-INF/jsp/smsworkflow/account/account_save.jsp"),
        SYSTEM_SETTINGS("Inst&auml;llningar", "/smsworkflow/admin/settings", "/^\\/settings$/", "/WEB-INF/jsp/smsworkflow/settings/tab_settings.jsp"),
        SYSTEM_RIGHTS("R&auml;ttigheter", "/smsworkflow/admin/rights", "/^\\/rights$/", "/WEB-INF/jsp/smsworkflow/rights/tab_rights.jsp"),
        SYSTEM_RIGHTS_FILTER("PATH ONLY", "/smsworkflow/admin/rights/filter", "/^\\/rights\\/filter$/", "/WEB-INF/jsp/smsworkflow/rights/iframe_get_users.jsp"),
        SYSTEM_RIGHTS_SUBMIT("PATH ONLY", "/smsworkflow/admin/rights/submit", "/^\\/rights\\/submit$/", "/WEB-INF/jsp/smsworkflow/rights/tab_rights.jsp"),
        SYSTEM_LOG("Logg", "/smsworkflow/admin/log", "/^\\/log$/", "/WEB-INF/jsp/smsworkflow/admin/tab_log.jsp"),
        SYSTEM_EXPORT_LOG("Export csv", "/smsworkflow/admin/export", "/^\\/admin\\/export$/", "/WEB-INF/jsp/smsworkflow/admin/export_csv.jsp"),
        SYSTEM_EXPORT_LIST("Export csv list", "/smsworkflow/admin/personnel/export", "/^\\/personnel\\/export$/", "/WEB-INF/jsp/smsworkflow/personnel/export_csv_list.jsp");

        private final String label;
        private final String linkHref;
        private final String pathRegExp;
        private final String jspPath;

        private View(String label, String linkHref, String pathRegExp, String jspPath) {
            this.label = label;
            this.linkHref = linkHref;
            this.pathRegExp = pathRegExp;
            this.jspPath = jspPath;
        }

        public String getLabel() {
            return this.label;
        }

        public String getLinkHref(String contextPath) {
            return contextPath + this.linkHref;
        }

        public String getLinkHrefTranslated(int metaId, String contextPath) {
            return contextPath + this.linkHref.replace("#META_ID#", metaId + "");
        }

        public String getLinkHrefTranslated(String metaId, String contextPath) {
            return contextPath + this.linkHref.replace("#META_ID#", metaId);
        }

        public String getPathRegExp() {
            return this.pathRegExp;
        }

        public String getJspPath() {
            return this.jspPath;
        }
    }
}

