/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem;

import com.imcode.imcms.addon.smssystem.PageView;
import com.imcode.imcms.addon.smssystem.RightsChecker;
import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.SystemUtils;
import com.imcode.imcms.addon.smssystem.account.AccountUtils;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.TextDocument;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.perl.Perl5Util;

public class AdminServlet
extends HttpServlet {
    public static final String PARAM_DOC = "adminServletDoc";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, true);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response, boolean isPOST) throws ServletException, IOException {
        boolean isAdmin = "/smsworkflow/admin".equals(request.getServletPath());
        boolean isProfile = "/smsworkflow/profile".equals(request.getServletPath());
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        String pathInfo = StringUtils.defaultString((String)request.getPathInfo());
        if (pathInfo.length() > 1 && pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        if (null != request.getParameter("btnCreate")) {
            request.getSession().removeAttribute("ACCOUNT_SELECTED");
        }
        request.getSession().removeAttribute("TEMP_debug");
        Perl5Util re = new Perl5Util();
        if (isAdmin && !RightsChecker.userMayAdmin(request)) {
            request.getSession().setAttribute("TEMP_debug", (Object)("NO ADMIN: |" + request.getServletPath() + "|" + pathInfo + "| isAdmin:" + isAdmin + ", isProfile:" + isProfile));
            Utility.forwardToLogin((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            request.getSession().setAttribute("pathInfo", (Object)pathInfo);
            for (PageView.View view : PageView.View.values()) {
                if (PageView.View.EMPTY.equals((Object)view)) continue;
                if (pathInfo.matches(".*(submit|delete|exec).*") && !isPOST) {
                    request.getSession().setAttribute("TEMP_debug", (Object)"NO POST");
                    Utility.forwardToLogin((HttpServletRequest)request, (HttpServletResponse)response);
                    continue;
                }
                if (!re.match(view.getPathRegExp(), pathInfo)) continue;
                Document doc = null;
                if (view.getLinkHref("").indexOf("#META_ID#") != -1) {
                    doc = this.getDocumentFromPath(re, documentService);
                    request.setAttribute(PARAM_DOC, (Object)doc);
                } else {
                    request.removeAttribute(PARAM_DOC);
                }
                boolean isMyPageOrHasAdminRights = true;
                if (isProfile && null != doc) {
                    isMyPageOrHasAdminRights = RightsChecker.userMayAdminDocument(doc, request);
                }
                request.getSession().setAttribute("TEMP_debug", (Object)("isMyPageOrHasAdminRights: " + isMyPageOrHasAdminRights + ", view:" + (Object)((Object)view)));
                if (PageView.View.SYSTEM_EXPORT_LOG.equals((Object)view)) {
                    request.getRequestDispatcher(view.getJspPath()).forward((ServletRequest)request, (ServletResponse)response);
                    continue;
                }
                if (!isMyPageOrHasAdminRights) {
                    Utility.forwardToLogin((HttpServletRequest)request, (HttpServletResponse)response);
                    continue;
                }
                if (PageView.View.SYSTEM_RIGHTS_SUBMIT.equals((Object)view)) {
                    PageView.swapView(view, request);
                    boolean saveRights = "save_rights".equals(StringUtils.defaultString((String)request.getParameter("action")));
                    if (saveRights) {
                        this.saveAccountRights(request, response);
                        continue;
                    }
                    this.saveAccountMessengers(request, response);
                    continue;
                }
                if (view.getJspPath().indexOf("iframe") != -1 || view.toString().indexOf("_SUBMIT") != -1 || view.toString().indexOf("_DELETE") != -1) {
                    PageView.swapView(view, request);
                    request.getRequestDispatcher(view.getJspPath()).forward((ServletRequest)request, (ServletResponse)response);
                    continue;
                }
                if (null != doc && (view.toString().startsWith(PageView.View.ACCOUNT_EDIT.toString()) || view.toString().startsWith(PageView.View.PERSON_EDIT.toString()) || view.toString().startsWith(PageView.View.MY_PAGE_EDIT.toString()))) {
                    String[] userIds;
                    boolean isAdd;
                    if (StringUtils.defaultString((String)request.getParameter("action")).equals("save_rights")) {
                        int accountId = SystemUtils.getIntRequestParameter("account_id", 0, request);
                        isAdd = null != request.getParameter("add");
                        String[] stringArray = userIds = isAdd ? request.getParameterValues("user_id_add") : request.getParameterValues("user_id_remove");
                        if (isAdd) {
                            AccountUtils.addAdminUsersToAccount(accountId, userIds, request);
                        } else {
                            AccountUtils.removeAdminUsersFromAccount(accountId, userIds, request);
                        }
                    }
                    if (StringUtils.defaultString((String)request.getParameter("action")).equals("save_messengers")) {
                        int accountId = SystemUtils.getIntRequestParameter("account_id", 0, request);
                        isAdd = null != request.getParameter("add");
                        String[] stringArray = userIds = isAdd ? request.getParameterValues("user_id_add") : request.getParameterValues("user_id_remove");
                        if (isAdd) {
                            AccountUtils.addMessengerUsersToAccount(accountId, userIds, request);
                        } else {
                            AccountUtils.removeMessengerUsersFromAccount(accountId, userIds, request);
                        }
                    }
                    SystemUtils.forwardToGetDoc(doc.getId(), view, request, response);
                    continue;
                }
                if (PageView.View.MY_PAGE_CREATE.equals((Object)view) || PageView.View.MY_PAGE_CREATE_SUBMIT.equals((Object)view)) {
                    TextDocument applyDoc = documentService.getTextDocument(SystemProperties.Prop.SYSTEM_ALIAS_APPLY.getString());
                    SystemUtils.forwardToGetDoc(applyDoc.getId(), view, request, response);
                    continue;
                }
                SystemUtils.forwardToRoot(view, request, response);
            }
        }
        response.setContentType("text/plain");
        response.getWriter().write("\n" + request.getServletPath() + pathInfo);
    }

    private void saveAccountRights(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] userIds;
        int accountId = SystemUtils.getIntRequestParameter("account_id", 0, request);
        boolean isAdd = null != request.getParameter("add");
        String[] stringArray = userIds = isAdd ? request.getParameterValues("user_id_add") : request.getParameterValues("user_id_remove");
        if (isAdd) {
            AccountUtils.addAdminUsersToAccount(accountId, userIds, request);
        } else {
            AccountUtils.removeAdminUsersFromAccount(accountId, userIds, request);
        }
        response.sendRedirect(PageView.View.SYSTEM_RIGHTS.getLinkHref(request.getContextPath()));
    }

    private void saveAccountMessengers(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] userIds;
        int accountId = SystemUtils.getIntRequestParameter("account_id", 0, request);
        boolean isAdd = null != request.getParameter("add");
        String[] stringArray = userIds = isAdd ? request.getParameterValues("user_id_add") : request.getParameterValues("user_id_remove");
        if (isAdd) {
            AccountUtils.addMessengerUsersToAccount(accountId, userIds, request);
        } else {
            AccountUtils.removeMessengerUsersFromAccount(accountId, userIds, request);
        }
        response.sendRedirect(PageView.View.SYSTEM_RIGHTS.getLinkHref(request.getContextPath()));
    }

    private Document getDocumentFromPath(Perl5Util re, DocumentService documentService) {
        try {
            return documentService.getDocument(Integer.parseInt(re.group(1)));
        }
        catch (Exception e) {
            return null;
        }
    }
}

