/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.sms;

import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.sms.Sms;
import com.imcode.imcms.addon.smssystem.sms.SmsException;
import com.imcode.imcms.addon.smssystem.sms.SmsSender;
import com.imcode.imcms.addon.smssystem.sms.SmsSenderFactory;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.TextDocument;
import imcode.server.Imcms;
import imcode.util.ShouldNotBeThrownException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImSmsSender
implements SmsSender {
    private static final Logger LOG = Logger.getLogger(ImSmsSender.class);
    private final String username;
    private final String password;
    private final String originatorAddress;

    public ImSmsSender(String username, String password) {
        this.username = username;
        this.password = password;
        this.originatorAddress = "";
    }

    public ImSmsSender(String username, String password, String originatorAddress) {
        this.username = username;
        this.password = password;
        this.originatorAddress = originatorAddress;
    }

    public static SmsSender getInstance(SmsSenderFactory smsSenderFactory, String client, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        TextDocument clientDoc = documentService.getTextDocument(client);
        if (clientDoc != null) {
            String username = clientDoc.getTextField(10102).getHtmlFormattedText();
            String password = clientDoc.getTextField(10103).getHtmlFormattedText();
            String originatorAddress = clientDoc.getTextField(10105).getHtmlFormattedText();
            return smsSenderFactory.createSmsSender(username, password, originatorAddress);
        }
        String username = SystemProperties.Prop.SMS_GATEWAY_SENDER_USERNAME.getString();
        String password = SystemProperties.Prop.SMS_GATEWAY_SENDER_PASSWORD.getString();
        return smsSenderFactory.createSmsSender(username, password, "");
    }

    public void writeLog(String str) {
        FileOutputStream fos;
        String PATH_LOGS = "/WEB-INF/logs";
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "smssenderlog.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public String[] sendSms(Sms sms) throws SmsException {
        String[] returnValues = null;
        try {
            String fixedDestination = sms.getDestination();
            if (fixedDestination.startsWith("0")) {
                fixedDestination = fixedDestination.replaceFirst("0", "46");
            }
            String url = SystemProperties.Prop.SMS_GATEWAY_SEND_SERVLET_URL.getString() + "?destination=" + fixedDestination + "&message=" + URLEncoder.encode(sms.getMessage(), "UTF-8") + "&username=" + this.username + "&password=" + this.password;
            if (!this.originatorAddress.equals("")) {
                url = this.originatorAddress.matches("[^a-z]+") && this.originatorAddress.length() == 5 ? url + "&originatortype=0" : (this.originatorAddress.matches("[^a-z]+") && this.originatorAddress.length() > 5 ? url + "&originatortype=2" : url + "&originatortype=1");
                url = sms.getOriginatorAddress().equals("") ? url + "&originator=" + URLEncoder.encode(this.originatorAddress, "UTF-8") : url + "&originator=" + URLEncoder.encode(sms.getOriginatorAddress(), "UTF-8");
            }
            try {
                HttpClient httpClient = new HttpClient();
                GetMethod getMethod = new GetMethod(url);
                LOG.debug((Object)("Sending to " + url));
                this.writeLog("URL: " + url);
                httpClient.executeMethod((HttpMethod)getMethod);
                String responseCode = "";
                String responseMessage = "";
                String messageId = "";
                try {
                    Element element;
                    Node node;
                    int index;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = factory.newDocumentBuilder();
                    Document doc = db.parse(getMethod.getResponseBodyAsStream());
                    NodeList nodeList = doc.getElementsByTagName("responsecode");
                    for (index = 0; index < nodeList.getLength(); ++index) {
                        node = nodeList.item(index);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        responseCode = element.getFirstChild().getNodeValue().trim();
                    }
                    nodeList = doc.getElementsByTagName("responsemessage");
                    for (index = 0; index < nodeList.getLength(); ++index) {
                        node = nodeList.item(index);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        responseMessage = element.getFirstChild().getNodeValue().trim();
                    }
                    nodeList = doc.getElementsByTagName("messageid");
                    for (index = 0; index < nodeList.getLength(); ++index) {
                        node = nodeList.item(index);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        messageId = element.getFirstChild().getNodeValue().trim();
                    }
                    try {
                        this.writeLog("value: " + doc.toString());
                    }
                    catch (Exception e) {
                        this.writeLog("Error checking response: " + e.toString());
                    }
                }
                catch (Exception e) {
                    this.writeLog("Error: " + e.toString() + " Body: " + getMethod.getResponseBodyAsStream());
                }
                returnValues = new String[]{"messageId: " + messageId, "responseMessage: " + responseMessage, "responseCode: " + responseCode};
                this.writeLog("responseCode: " + responseCode + " responseMessage: " + responseMessage);
                boolean ok = responseCode.equals("0");
                if (!ok) {
                    this.writeLog("Failed to send to " + url + " response message is " + responseMessage);
                    LOG.error((Object)("Failed to send to " + url + " response message is " + responseMessage));
                    throw new SmsException(responseMessage);
                }
            }
            catch (IOException e) {
                this.writeLog("Error occured while sending sms to " + url + ": " + e.toString());
                LOG.error((Object)("Failed to send to " + url), (Throwable)e);
                throw new SmsException(e);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ShouldNotBeThrownException((Throwable)e);
        }
        return returnValues;
    }
}

