/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.person;

import com.imcode.addon.db.DBUtil;
import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.SystemUtils;
import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountCategory;
import com.imcode.imcms.addon.smssystem.account.AccountUtils;
import com.imcode.imcms.addon.smssystem.account.AccountVisibleFilterPredicate;
import com.imcode.imcms.addon.smssystem.account.ClientSpecificText;
import com.imcode.imcms.addon.smssystem.comparators.ImcmsUsersLastnameFirstnameComparator;
import com.imcode.imcms.addon.smssystem.filters.PersonStatusForAccountFilterPredicate;
import com.imcode.imcms.addon.smssystem.filters.PersonVisiblePredicate;
import com.imcode.imcms.addon.smssystem.job.Job;
import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.imcms.addon.smssystem.person.PersonComparator;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.Mail;
import com.imcode.imcms.api.MailService;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public class PersonUtils {
    private static final Logger LOG = Logger.getLogger(PersonUtils.class);

    public static Category getPersonMainCategory(DocumentService documentService) {
        String catTypeName = SystemProperties.Prop.PERSON_CATEGORY_TYPE_NAME.getString();
        String catName = SystemProperties.Prop.PERSON_CATEGORY_NAME.getString();
        return documentService.getCategory(documentService.getCategoryType(catTypeName), catName);
    }

    public static String getRandomPassword(int charCount) {
        char[] arrLettersNumbers = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};
        String pw = "";
        for (int i = 0; i < charCount; ++i) {
            int idx = (int)(Math.random() * (double)arrLettersNumbers.length);
            pw = pw + arrLettersNumbers[idx] + "";
        }
        return pw.toLowerCase();
    }

    public static void deletePerson(Person person, HttpServletRequest request) {
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            DocumentService documentService = imcmsSystem.getDocumentService();
            UserService userService = imcmsSystem.getUserService();
            User user = person.getUser();
            Role[] userRoles = user.getRoles();
            if (userRoles != null && userRoles.length > 0) {
                for (int i = 0; i < userRoles.length; ++i) {
                    user.removeRole(userRoles[i]);
                }
            }
            user.setLoginName("X_inaktiverad_" + new Date().getTime());
            user.setActive(false);
            userService.saveUser(user);
            documentService.deleteDocument((Document)person.getTextDoc());
        }
        catch (NoPermissionException e) {
        }
        catch (SaveException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cleanUpUsers(HttpServletRequest request) {
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            String debug = "";
            UserService userService = imcmsSystem.getUserService();
            for (User user : userService.getAllUsers()) {
                if (!user.getLoginName().matches("^0[\\d]{7,}$") || null != user.getOtherPhone() && user.getOtherPhone().matches("^[\\d]{4,}$")) continue;
                try {
                    debug = debug + "<br/>User cleaned! UN:" + user.getLoginName() + ", name: " + (user.getFirstName() + " " + user.getLastName()).trim() + ", otherPhone: " + user.getOtherPhone();
                    Role[] userRoles = user.getRoles();
                    if (userRoles != null && userRoles.length > 0) {
                        for (int i = 0; i < userRoles.length; ++i) {
                            user.removeRole(userRoles[i]);
                        }
                    }
                    user.setLoginName("X_cleaned_up_" + new Date().getTime());
                    user.setActive(false);
                    userService.saveUser(user);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            request.getSession().setAttribute("TEMP_debug_cleanup", (Object)debug);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<User> getAllUsersAndPersons(HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        List<User> imcmsUsers = Arrays.asList(userService.getAllUsers());
        ArrayList<User> allUsersAndPersons = new ArrayList<User>();
        for (User imcmsUser : imcmsUsers) {
            String fullName = (imcmsUser.getLastName() + " " + imcmsUser.getFirstName()).trim();
            if (!imcmsUser.isActive() || imcmsUser.isDefaultUser() || "".equals(fullName)) continue;
            allUsersAndPersons.add(imcmsUser);
        }
        Collections.sort(allUsersAndPersons, new ImcmsUsersLastnameFirstnameComparator());
        return allUsersAndPersons;
    }

    private static List<Person> getAllPersons(Account account, boolean onlyApprovedForAccount, Job job, boolean onlyWorkersForJob, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        Role rolePerson = Person.getRolePerson(request);
        List<User> imcmsUsers = Arrays.asList(userService.getAllUsers());
        ArrayList<Person> allPersons = new ArrayList<Person>();
        for (User imcmsUser : imcmsUsers) {
            List<Account> personAccounts;
            Person person;
            String fullName = (imcmsUser.getLastName() + " " + imcmsUser.getFirstName()).trim();
            boolean hasOwnPage = false;
            if (null != imcmsUser.getOtherPhone()) {
                hasOwnPage = imcmsUser.getOtherPhone().matches("^\\d{4,6}$");
            }
            if (!imcmsUser.isActive() || imcmsUser.isDefaultUser() || !hasOwnPage || "".equals(fullName) || !imcmsUser.hasRole(rolePerson) || null == (person = Person.fromUser(imcmsUser, request)) || null == account || !(personAccounts = person.getPersonAccounts()).contains(account)) continue;
            if (onlyApprovedForAccount) {
                if (!person.isApprovedForAccount(account)) continue;
                allPersons.add(person);
                continue;
            }
            allPersons.add(person);
        }
        Collections.sort(allPersons, PersonComparator.LASTNAME_FIRSTNAME.nullsLast());
        return allPersons;
    }

    public static List<Person> getAllPersonnel(HttpServletRequest request) {
        return PersonUtils.getAllPersons(null, false, null, false, request);
    }

    public static List<Person> getAllPersonnelForAccount(Account account, boolean onlyApprovedForAccount, HttpServletRequest request) {
        return PersonUtils.getAllPersons(account, onlyApprovedForAccount, null, false, request);
    }

    public static List<Person> getAllPersonnelForJob(Job job, boolean onlyWorkersForJob, HttpServletRequest request) {
        return PersonUtils.getAllPersons(null, false, job, onlyWorkersForJob, request);
    }

    public static List<Person> getPersons(String search_string, Person.Status status, Account account, int accountCatId, HttpServletRequest request, String gender) {
        ArrayList<Person> persons = new ArrayList<Person>();
        String query = "";
        List docs = Collections.EMPTY_LIST;
        PersonVisiblePredicate personVisiblePredicate = null;
        String debug = "";
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            DocumentService documentService = imcmsSystem.getDocumentService();
            query = "+doc_type_id:2 +category_id:" + PersonUtils.getPersonMainCategory(documentService).getId();
            if (null == account && !Person.Status.NONE.equals((Object)status)) {
                query = query + " +text10020:(" + status.toString() + ")";
                if (Person.Status.APPROVED_AND_ACTIVE.equals((Object)status)) {
                    debug = debug + "<br/>new PersonVisiblePredicate(request)";
                    personVisiblePredicate = new PersonVisiblePredicate(request);
                }
            }
            if (null != account) {
                AccountCategory defaultAccountCategory = AccountUtils.getDefaultAccountCategory(account, documentService);
                if (null != defaultAccountCategory) {
                    query = query + " +category_id:" + defaultAccountCategory.getId();
                }
            } else {
                List<Account> allAccountsForAdministrator = AccountUtils.getAccountsForAdministrators(imcmsSystem.getCurrentUser(), request);
                CollectionUtils.filter(allAccountsForAdministrator, (Predicate)new AccountVisibleFilterPredicate(true));
                debug = debug + "<br/>CollectionUtils.filter(allAccountsForAdministrator, new AccountVisibleFilterPredicate(true)) ;";
                query = query + " +(";
                int catCount = 0;
                for (Account adminAccount : allAccountsForAdministrator) {
                    AccountCategory defaultAccountCategory = AccountUtils.getDefaultAccountCategory(adminAccount, documentService);
                    if (null == defaultAccountCategory) continue;
                    query = query + (catCount > 0 ? " category_id:" + defaultAccountCategory.getId() : "category_id:" + defaultAccountCategory.getId());
                    ++catCount;
                }
                query = query + ")";
            }
            if (accountCatId > 0) {
                query = query + " +category_id:" + accountCatId;
            }
            if (!gender.equals("both")) {
                query = query + " +text10019:(" + gender + ")";
            }
            if (!search_string.equals("")) {
                query = query + " +(text10014:(" + search_string + "*) " + "text" + 10001 + ":(" + search_string + "*) " + "text" + 10002 + ":(" + search_string + "*) " + "text" + 10004 + ":(" + search_string + "*) " + "text" + 10003 + ":(" + search_string + "*) " + "text" + 10010 + ":(" + search_string + "*) " + "text" + 10012 + ":(" + search_string + "*) " + "text" + 10013 + ":(" + search_string + "*) " + "text" + 10015 + ":(" + search_string + "*) " + "text" + 10017 + ":(" + search_string + "*) " + "text" + 10018 + ":(" + search_string + "*) " + "text" + 10021 + ":(" + search_string + "*) " + "text" + 10031 + ":(" + search_string + "*) ";
                List<Account> allAccounts = AccountUtils.getAllAccounts(request);
                for (Account theAccount : allAccounts) {
                    List<ClientSpecificText> clientSpecificTexts = theAccount.getClientSpecificTexts(false);
                    if (clientSpecificTexts.isEmpty()) continue;
                    for (ClientSpecificText clientSpecificText : clientSpecificTexts) {
                        int textField = clientSpecificText.getTextFieldNumber();
                        query = query + "text" + textField + ":(" + search_string + "*) ";
                    }
                }
                query = query.trim() + ")";
            }
            docs = SystemUtils.getDocuments(query, (Comparator)Document.Comparator.HEADLINE, personVisiblePredicate, documentService);
            for (TextDocument document : docs) {
                Person person = Person.fromDocument(document, request);
                if (!person.getUser().isActive()) continue;
                persons.add(person);
            }
            Collections.sort(persons, PersonComparator.LASTNAME_FIRSTNAME.nullsLast());
            if (null != account) {
                PersonStatusForAccountFilterPredicate personStatusForAccountFilterPredicate = null;
                if (Person.Status.APPROVED_AND_ACTIVE.equals((Object)status) || Person.Status.APPROVED_AND_INACTIVE.equals((Object)status)) {
                    personStatusForAccountFilterPredicate = new PersonStatusForAccountFilterPredicate(account, Person.AccountStatus.APPROVED, request);
                    debug = debug + "<br/>Person.Status.APPROVED_X";
                } else if (Person.Status.DISAPPROVED.equals((Object)status)) {
                    personStatusForAccountFilterPredicate = new PersonStatusForAccountFilterPredicate(account, Person.AccountStatus.DISAPPROVED, request);
                    debug = debug + "<br/>Person.Status.DISAPPROVED";
                } else if (Person.Status.NEW.equals((Object)status)) {
                    personStatusForAccountFilterPredicate = new PersonStatusForAccountFilterPredicate(account, Person.AccountStatus.NEW, request);
                    debug = debug + "<br/>Person.Status.NEW";
                }
                if (null != personStatusForAccountFilterPredicate) {
                    CollectionUtils.filter(persons, (Predicate)personStatusForAccountFilterPredicate);
                    debug = debug + "<br/>CollectionUtils.filter(persons, personStatusForAccountFilterPredicate) ;";
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("getPersons(\"" + search_string + "\", " + (null != status ? "Status." + status.toString() : "null") + ", " + (null != account ? account.getId() + "" : "null") + ", " + accountCatId + ")"), (Throwable)e);
        }
        request.getSession().setAttribute("PERSONNEL_REGISTER_QUERY", (Object)(query.replace("+", "<br/>+") + "<hr/>docs: " + docs.size() + "<hr/>personVisiblePredicate: " + (null != personVisiblePredicate ? "AKTIV" : "null") + "<hr/>debug: " + debug));
        return persons;
    }

    public static void sendApplyMail(Person person, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        MailService mailService = imcmsSystem.getMailService();
        List<Account> accounts = person.getPersonAccounts();
        if (null != accounts && !accounts.isEmpty()) {
            String un = person.getUser().getLoginName();
            String pw = person.getPassword();
            String name = person.getFirstname() + " " + person.getLastname();
            String phone = person.getTel1();
            String email = person.getEmail();
            if (null == pw) {
                pw = PersonUtils.getPersonPassword(person, request);
            }
            for (Account account : accounts) {
                String mailBody = account.getApplyMailBody0() + " \n" + "------------------------------------------------------------ \n" + "Anv\u00e4ndarnamn:  " + un + " \n" + "L\u00f6senord:      " + pw + " \n";
                if (!name.equals("")) {
                    mailBody = mailBody + "Namn:               " + name + " \n";
                }
                if (!phone.equals("")) {
                    mailBody = mailBody + "Telefon:            " + phone + " \n";
                }
                if (!email.equals("")) {
                    mailBody = mailBody + "E-post:             " + email + " \n";
                }
                mailBody = mailBody + "------------------------------------------------------------ \n" + account.getApplyMailBody1();
                try {
                    Mail mail = new Mail(account.getApplyMailFrom(), new String[]{person.getEmail()}, account.getApplyMailSubject(), mailBody);
                    mail.setBccAddresses(new String[]{account.getApplyMailFrom()});
                    mailService.sendMail(mail);
                }
                catch (Exception e) {}
            }
        }
    }

    private static String getPersonPassword(Person person, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DBUtil dbUtil = new DBUtil(imcmsSystem.getDatabaseService());
        return dbUtil.sqlQueryStr("SELECT login_password FROM users WHERE user_id = ?", (Object[])new String[]{person.getUser().getId() + ""});
    }

    public static void sendApprovedMail(Person person, List<Account> approveMailAccounts, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        MailService mailService = imcmsSystem.getMailService();
        CollectionUtils.filter(approveMailAccounts, (Predicate)new AccountVisibleFilterPredicate(false));
        if (null != approveMailAccounts && !approveMailAccounts.isEmpty()) {
            for (Account account : approveMailAccounts) {
                try {
                    String un = person.getUser().getLoginName();
                    String name = person.getFirstname() + " " + person.getLastname();
                    String phone = person.getTel1();
                    String email = person.getEmail();
                    String mailBody = "\n------------------------------------------------------------ \nAnv\u00e4ndarnamn:  " + un + " \n";
                    if (!name.equals("")) {
                        mailBody = mailBody + "Namn:               " + name + " \n";
                    }
                    if (!phone.equals("")) {
                        mailBody = mailBody + "Telefon:            " + phone + " \n";
                    }
                    if (!email.equals("")) {
                        mailBody = mailBody + "E-post:             " + email + " \n";
                    }
                    mailBody = mailBody + "------------------------------------------------------------ \n";
                    Mail mail = new Mail(account.getApproveMailFrom(), new String[]{person.getEmail()}, account.getApproveMailSubject(), account.getApproveMailBody() + mailBody);
                    mail.setBccAddresses(new String[]{account.getApproveMailFrom()});
                    mailService.sendMail(mail);
                }
                catch (Exception e) {}
            }
        }
    }
}

