/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.person;

import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.util.ChainableReversibleNullComparator;
import org.apache.commons.lang.NullArgumentException;

public abstract class PersonComparator
extends ChainableReversibleNullComparator {
    private final String name;
    public static final PersonComparator META_ID = new PersonComparator("META_ID"){

        @Override
        protected int comparePersons(Person p1, Person p2) {
            return p1.getTextDoc().getId() - p2.getTextDoc().getId();
        }
    };
    public static final PersonComparator LASTNAME_FIRSTNAME = new PersonComparator("LASTNAME_FIRSTNAME"){

        @Override
        protected int comparePersons(Person p1, Person p2) {
            return p1.getLastnameFirstname().compareToIgnoreCase(p2.getLastnameFirstname());
        }
    };
    public static final PersonComparator FIRSTNAME_LASTNAME = new PersonComparator("FIRSTNAME_LASTNAME"){

        @Override
        protected int comparePersons(Person p1, Person p2) {
            return p1.getFirstnameLastname().compareToIgnoreCase(p2.getFirstnameLastname());
        }
    };
    public static final PersonComparator MOBILE = new PersonComparator("MOBILE"){

        @Override
        protected int comparePersons(Person p1, Person p2) {
            return p1.getMobileStripped().compareToIgnoreCase(p2.getMobileStripped());
        }
    };
    public static final PersonComparator STATUS = new PersonComparator("STATUS"){

        @Override
        protected int comparePersons(Person p1, Person p2) {
            return p1.getStatus().getLabel().compareToIgnoreCase(p2.getStatus().getLabel());
        }
    };
    public static final PersonComparator PROFESSION = new PersonComparator("PROFESSION"){

        @Override
        protected int comparePersons(Person p1, Person p2) {
            return p1.getProfession().compareToIgnoreCase(p2.getProfession());
        }
    };
    public static final PersonComparator DATE_CREATED = new PersonComparator("DATE_CREATED"){

        @Override
        protected int comparePersons(Person p1, Person p2) {
            return p1.getTextDoc().getCreatedDatetime().compareTo(p2.getTextDoc().getCreatedDatetime());
        }
    };
    public static final PersonComparator DATE_MODIFIED = new PersonComparator("DATE_MODIFIED"){

        @Override
        protected int comparePersons(Person p1, Person p2) {
            return p1.getTextDoc().getModifiedDatetime().compareTo(p2.getTextDoc().getModifiedDatetime());
        }
    };

    protected PersonComparator(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name.toLowerCase();
    }

    public static PersonComparator fromString(String name) {
        if ("LASTNAME_FIRSTNAME".equals(name)) {
            return LASTNAME_FIRSTNAME;
        }
        if ("FIRSTNAME_LASTNAME".equals(name)) {
            return FIRSTNAME_LASTNAME;
        }
        if ("MOBILE".equals(name)) {
            return MOBILE;
        }
        if ("STATUS".equals(name)) {
            return STATUS;
        }
        if ("PROFESSION".equals(name)) {
            return PROFESSION;
        }
        if ("DATE_CREATED".equals(name)) {
            return DATE_CREATED;
        }
        if ("DATE_MODIFIED".equals(name)) {
            return DATE_MODIFIED;
        }
        return META_ID;
    }

    public int compare(Object o1, Object o2) {
        if (null == o1 || null == o2) {
            throw new NullArgumentException("o1 and o2");
        }
        Person p1 = (Person)o1;
        Person p2 = (Person)o2;
        try {
            return this.comparePersons(p1, p2);
        }
        catch (NullPointerException npe) {
            NullPointerException nullPointerException = new NullPointerException("Tried sorting on null fields! You need to call .nullsFirst() or .nullsLast() on your Comparator.");
            nullPointerException.initCause(npe);
            throw nullPointerException;
        }
    }

    protected abstract int comparePersons(Person var1, Person var2);
}

