/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.person;

import com.imcode.imcms.addon.smssystem.PageView;
import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.SystemUtils;
import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountCategoriesFilterPredicate;
import com.imcode.imcms.addon.smssystem.account.AccountCategory;
import com.imcode.imcms.addon.smssystem.account.AccountCategoryNotDefaultFilterPredicate;
import com.imcode.imcms.addon.smssystem.account.AccountUtils;
import com.imcode.imcms.addon.smssystem.account.ClientSpecificText;
import com.imcode.imcms.addon.smssystem.person.ClientSpecificTextfield;
import com.imcode.imcms.addon.smssystem.person.PersonUtils;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.Image;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TemplateService;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserAlreadyExistsException;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public class Person
implements Serializable {
    private static final Logger LOG = Logger.getLogger(Person.class);
    public static final int TXT_FIRSTNAME = 10001;
    public static final int TXT_LASTNAME = 10002;
    public static final int TXT_FIRSTNAMELASTNAME = 10003;
    public static final int TXT_LASTNAMEFIRSTNAME = 10004;
    public static final int TXT_ADDRESS1 = 10010;
    public static final int TXT_ZIP = 10012;
    public static final int TXT_CITY = 10013;
    public static final int TXT_BIRTHDATE = 10014;
    public static final int TXT_TEL1 = 10015;
    public static final int TXT_MOBILE = 10017;
    public static final int TXT_EMAIL = 10018;
    public static final int TXT_GENDER = 10019;
    public static final int TXT_STATUS = 10020;
    public static final int TXT_OTHER = 10021;
    public static final int TXT_PROFESSION = 10031;
    public static final int TXT_OFFSET_CONFIRMER = 10000000;
    public static final int TXT_OFFSET_CLIENT_SPEC_QUESTION = 20000000;
    public static final int TXT_OFFSET_COMMENT = 30000000;
    public static final int IMG_IMAGE = 10011;
    public static final int MENU_ACCOUNTS = 10011;
    public static final int TXT_ACCOUNT_STATUS_OFFSET = 7000000;
    public static final String TEMPLATE_NAME = SystemUtils.TEMPLATE_NAME;
    public static String DUMMY_PASSWORD = "******";
    public static final String PERSON_PARAM_ERROR = "PERSON_ERROR";
    public static final String ROLE_NAME_PERSON = SystemProperties.Prop.SYSTEM_ROLE_NAME_PERSON.getString();
    public static final String ROLE_NAME_PERSON_VISIBLE = SystemProperties.Prop.SYSTEM_ROLE_NAME_PERSON_VISIBLE.getString();
    public static final String ROLE_NAME_PERSON_APPROVED_ACTIVE = SystemProperties.Prop.SYSTEM_ROLE_NAME_PERSON_APPROVED_ACTIVE.getString();
    User user;
    TextDocument textDoc;
    String firstname = "";
    String lastname = "";
    String firstnameLastname = "";
    String lastnameFirstname = "";
    String birthdate = "";
    String gender = "";
    String address1 = "";
    String zip = "";
    String city = "";
    String tel1 = "";
    String mobile = "";
    String email = "";
    String profession = "";
    String other = "";
    String password = null;
    boolean visibleProfile = true;
    Image image;
    List<Account> personAccounts;
    List<AccountCategory> personAccountCategories;
    List<ClientSpecificTextfield> clientSpecificTextfields;
    String client = "";
    Status status = Status.NONE;
    static final String PATH_LOGS = "/WEB-INF/logs";

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person person = (Person)o;
        return this.getUser().getId() == person.getUser().getId();
    }

    public Person() {
    }

    public Person(User user, TextDocument textDoc) {
        this.user = user;
        this.textDoc = textDoc;
    }

    public User getUser() {
        return this.user;
    }

    public TextDocument getTextDoc() {
        return this.textDoc;
    }

    public int getId() {
        return this.textDoc.getId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isNew() {
        return null == this.status || Status.NEW.equals((Object)this.status) || Status.NONE.equals((Object)this.status) || this.isNewForAllAccounts();
    }

    public boolean isNewForAllAccounts() {
        List<Account> personAccountList = this.getPersonAccounts();
        if (null != personAccountList && !personAccountList.isEmpty()) {
            for (Account account : personAccountList) {
                if (AccountStatus.NEW.equals((Object)account.getPersonAccountStatus())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isApproved() {
        return this.isApprovedForAnyAccount();
    }

    public boolean isApprovedForAccount(Account account) {
        List<Account> personAccounts = this.getPersonAccounts();
        Account personAccount = AccountUtils.getPersonAccountFromList(account, personAccounts);
        return AccountStatus.APPROVED.equals((Object)personAccount.getPersonAccountStatus());
    }

    public boolean isApprovedForAnyAccount() {
        List<Account> personAccountList = this.getPersonAccounts();
        if (null != personAccountList && !personAccountList.isEmpty()) {
            for (Account account : personAccountList) {
                if (!AccountStatus.APPROVED.equals((Object)account.getPersonAccountStatus())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDisapproved() {
        return Status.DISAPPROVED.equals((Object)this.status);
    }

    public boolean isDisapprovedForAllAccounts() {
        List<Account> personAccountList = this.getPersonAccounts();
        if (null != personAccountList && !personAccountList.isEmpty()) {
            for (Account account : personAccountList) {
                if (AccountStatus.DISAPPROVED.equals((Object)account.getPersonAccountStatus())) continue;
                return false;
            }
        }
        return true;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getFirstnameLastname() {
        return this.firstname + " " + this.lastname;
    }

    public String getLastnameFirstname() {
        return this.lastname + " " + this.firstname;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getTel1() {
        return this.tel1;
    }

    public void setTel1(String tel1) {
        this.tel1 = tel1;
    }

    public String getMobile() {
        return this.getMobileStripped();
    }

    public String getMobileStripped() {
        return this.mobile.replaceAll("[^\\d]", "").trim();
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getProfession() {
        return this.profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasVisibleProfile() {
        return this.visibleProfile;
    }

    public void setVisibleProfile(boolean visibleProfile) {
        this.visibleProfile = visibleProfile;
    }

    public List<Account> getPersonAccounts() {
        return this.personAccounts;
    }

    public void setPersonAccounts(List<Account> personAccounts) {
        this.personAccounts = personAccounts;
    }

    public List<AccountCategory> getPersonAccountCategories(boolean showDefaultCategory) {
        if (showDefaultCategory) {
            return this.personAccountCategories;
        }
        ArrayList<AccountCategory> accountCategoriesFiltered = new ArrayList<AccountCategory>();
        accountCategoriesFiltered.addAll(this.personAccountCategories);
        CollectionUtils.filter(accountCategoriesFiltered, (Predicate)new AccountCategoryNotDefaultFilterPredicate());
        return accountCategoriesFiltered;
    }

    public void setPersonAccountCategories(List<AccountCategory> personAccountCategories) {
        this.personAccountCategories = personAccountCategories;
    }

    public List<ClientSpecificTextfield> getClientSpecificTextfields() {
        return this.clientSpecificTextfields;
    }

    public void setClientSpecificTextfields(List<ClientSpecificTextfield> clientSpecificTextfields) {
        this.clientSpecificTextfields = clientSpecificTextfields;
    }

    public static Role getRolePerson(HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        return userService.getRole(ROLE_NAME_PERSON);
    }

    public static Role getRolePersonVisible(HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        return userService.getRole(ROLE_NAME_PERSON_VISIBLE);
    }

    public static Role getRolePersonApprovedAndVisible(HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        return userService.getRole(ROLE_NAME_PERSON_APPROVED_ACTIVE);
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public static List<Error> save(Person person, boolean isNew, HttpServletRequest request) {
        ArrayList<Error> errors = new ArrayList<Error>();
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        UserService userService = imcmsSystem.getUserService();
        TemplateService templateService = imcmsSystem.getTemplateService();
        try {
            Category[] accountCatsOld;
            Document[] accountDocsOld;
            User personUser = person.getUser();
            if (!person.getMobileStripped().equals(personUser.getLoginName())) {
                personUser.setLoginName(person.getMobileStripped());
            }
            if (null != person.getPassword()) {
                personUser.setPassword(person.getPassword());
            }
            personUser.setFirstName(person.getFirstname());
            personUser.setLastName(person.getLastname());
            Role rolePerson = Person.getRolePerson(request);
            Role roleVisible = Person.getRolePersonVisible(request);
            Role roleApprovedVisible = Person.getRolePersonApprovedAndVisible(request);
            if (!personUser.hasRole(rolePerson)) {
                personUser.addRole(rolePerson);
            }
            personUser.removeRole(roleVisible);
            personUser.removeRole(roleApprovedVisible);
            if (person.hasVisibleProfile()) {
                personUser.addRole(roleVisible);
            }
            if (person.isApprovedForAnyAccount() && person.hasVisibleProfile()) {
                personUser.addRole(roleApprovedVisible);
                person.setStatus(Status.APPROVED_AND_ACTIVE);
            } else if (person.isApprovedForAnyAccount()) {
                person.setStatus(Status.APPROVED_AND_INACTIVE);
            } else if (person.isDisapprovedForAllAccounts()) {
                person.setStatus(Status.DISAPPROVED);
            } else {
                person.setStatus(Status.NEW);
            }
            personUser.setCompany(person.getClient());
            userService.saveUser(personUser);
            TextDocument personDoc = person.getTextDoc();
            personDoc.setHeadline(SystemProperties.Prop.PERSON_NAME_PREFIX.getString().trim() + " " + person.getLastnameFirstname());
            personDoc.setPublisher(personUser);
            personDoc.setPublicationStatus(Document.PublicationStatus.APPROVED);
            personDoc.addCategory(PersonUtils.getPersonMainCategory(documentService));
            personDoc.setTemplate(templateService.getTemplate(Account.TEMPLATE_NAME));
            personDoc.setHtmlTextField(10020, person.getStatus().toString());
            personDoc.setHtmlTextField(10001, person.getFirstname());
            personDoc.setHtmlTextField(10002, person.getLastname());
            personDoc.setHtmlTextField(10014, person.getBirthdate());
            personDoc.setHtmlTextField(10019, person.getGender());
            personDoc.setHtmlTextField(10010, person.getAddress1());
            personDoc.setHtmlTextField(10012, person.getZip());
            personDoc.setHtmlTextField(10013, person.getCity());
            personDoc.setHtmlTextField(10015, person.getTel1());
            personDoc.setHtmlTextField(10017, person.getMobile());
            personDoc.setHtmlTextField(10018, person.getEmail());
            personDoc.setHtmlTextField(10031, person.getProfession());
            personDoc.setHtmlTextField(10021, person.getOther());
            if (null != person.getImage()) {
                personDoc.setImage(10011, person.getImage());
            }
            TextDocument.Menu accountMenu = personDoc.getMenu(10011);
            for (Document doc : accountDocsOld = accountMenu.getDocuments()) {
                accountMenu.removeDocument(doc);
            }
            for (Account account : AccountUtils.getAllAccounts(request)) {
                personDoc.setHtmlTextField(7000000 + account.getTextDoc().getId(), "");
            }
            List<Account> newAccounts = person.getPersonAccounts();
            for (Account newAccount : newAccounts) {
                accountMenu.addDocument((Document)newAccount.getTextDoc());
                personDoc.setHtmlTextField(7000000 + newAccount.getTextDoc().getId(), newAccount.getPersonAccountStatus().toString());
            }
            CategoryType catTypeAccountCats = documentService.getCategoryType(SystemProperties.Prop.ACCOUNT_CATEGORIES_TYPE_NAME.getString());
            for (Category oldCat : accountCatsOld = personDoc.getCategoriesOfType(catTypeAccountCats)) {
                personDoc.removeCategory(oldCat);
            }
            List<AccountCategory> newAccountCategories = person.getPersonAccountCategories(true);
            for (AccountCategory newAccountCategory : newAccountCategories) {
                personDoc.addCategory(newAccountCategory.getCategory());
            }
            List<Account> allAccounts = AccountUtils.getAllAccounts(request);
            for (Account account : allAccounts) {
                List<ClientSpecificText> clientSpecificTexts = account.getClientSpecificTexts(false);
                if (clientSpecificTexts.isEmpty()) continue;
                for (ClientSpecificText clientSpecificText : clientSpecificTexts) {
                    int textField = clientSpecificText.getTextFieldNumber();
                    personDoc.setHtmlTextField(textField, "");
                }
            }
            person.writeLog("Accounts added");
            List<ClientSpecificTextfield> clientSpecificTextfields = person.getClientSpecificTextfields();
            if (null != clientSpecificTextfields && !clientSpecificTextfields.isEmpty()) {
                for (ClientSpecificTextfield clientSpecificTextfield : clientSpecificTextfields) {
                    int textField = clientSpecificTextfield.getTextFieldNumber();
                    personDoc.setPlainTextField(textField, clientSpecificTextfield.getText());
                }
            }
            documentService.saveChanges((Document)personDoc);
            person.writeLog("document saved");
            personUser.setOtherPhone(personDoc.getId() + "");
            userService.saveUser(personUser);
        }
        catch (UserAlreadyExistsException uaee) {
            person.writeLog("Person.save() UserAlreadyExistsException:\n" + SystemUtils.getException((Exception)((Object)uaee), "", false));
            LOG.error((Object)("Person.save() UserAlreadyExistsException:\n" + SystemUtils.getException((Exception)((Object)uaee), "", false)));
            errors.add(Error.MOBILE_EXISTS);
        }
        catch (Exception e) {
            person.writeLog("Person.save() ERROR:\n" + SystemUtils.getException(e, "", false));
            LOG.error((Object)("Person.save() ERROR:\n" + SystemUtils.getException(e, "", false)));
            errors.add(isNew ? Error.COULD_NOT_BE_CREATED : Error.COULD_NOT_BE_SAVED);
        }
        return errors;
    }

    public static Person fromUser(User theUser, HttpServletRequest request) {
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            DocumentService documentService = imcmsSystem.getDocumentService();
            Role roleVisible = Person.getRolePersonVisible(request);
            TextDocument personDoc = documentService.getTextDocument(Integer.parseInt(theUser.getOtherPhone()));
            Person person = new Person(theUser, personDoc);
            try {
                person.setStatus(Status.valueOf(personDoc.getTextField(10020).getHtmlFormattedText()));
            }
            catch (Exception se) {
                person.setStatus(Status.NEW);
            }
            person.setClient(theUser.getCompany());
            person.setVisibleProfile(theUser.hasRole(roleVisible));
            person.setFirstname(personDoc.getTextField(10001).getHtmlFormattedText());
            person.setLastname(personDoc.getTextField(10002).getHtmlFormattedText());
            person.setBirthdate(personDoc.getTextField(10014).getHtmlFormattedText());
            person.setGender(personDoc.getTextField(10019).getHtmlFormattedText());
            person.setAddress1(personDoc.getTextField(10010).getHtmlFormattedText());
            person.setZip(personDoc.getTextField(10012).getHtmlFormattedText());
            person.setCity(personDoc.getTextField(10013).getHtmlFormattedText());
            person.setTel1(personDoc.getTextField(10015).getHtmlFormattedText());
            person.setMobile(personDoc.getTextField(10017).getHtmlFormattedText());
            person.setEmail(personDoc.getTextField(10018).getHtmlFormattedText());
            person.setProfession(personDoc.getTextField(10031).getHtmlFormattedText());
            person.setOther(personDoc.getTextField(10021).getHtmlFormattedText());
            person.setImage(personDoc.getImage(10011));
            ArrayList<Account> personAccounts = new ArrayList<Account>();
            Document[] accountDocsInPersonMenu = personDoc.getMenu(10011).getDocuments();
            CategoryType catTypeAccountCats = documentService.getCategoryType(SystemProperties.Prop.ACCOUNT_CATEGORIES_TYPE_NAME.getString());
            Category[] arrCats = personDoc.getCategoriesOfType(catTypeAccountCats);
            ArrayList<Category> allAccountCategoriesForPerson = new ArrayList<Category>();
            ArrayList<AccountCategory> personAccountCategories = new ArrayList<AccountCategory>();
            for (Document accountDocInPersonMenu : accountDocsInPersonMenu) {
                try {
                    TextDocument accountTextDoc = (TextDocument)accountDocInPersonMenu;
                    Account account = AccountUtils.fromDocument(accountTextDoc, request);
                    String sAccountStatusForPerson = personDoc.getTextField(7000000 + accountTextDoc.getId()).getHtmlFormattedText();
                    if (!"".equals(sAccountStatusForPerson)) {
                        try {
                            account.setPersonAccountStatus(AccountStatus.valueOf(sAccountStatusForPerson));
                        }
                        catch (Exception aex) {
                            // empty catch block
                        }
                    }
                    personAccounts.add(account);
                    if (null == arrCats || arrCats.length <= 0) continue;
                    allAccountCategoriesForPerson.addAll(Arrays.asList(arrCats));
                    CollectionUtils.filter(allAccountCategoriesForPerson, (Predicate)new AccountCategoriesFilterPredicate(account.getId()));
                    for (Category accountCategoryImcms : allAccountCategoriesForPerson) {
                        AccountCategory accountCategory = new AccountCategory(account, accountCategoryImcms);
                        personAccountCategories.add(accountCategory);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            person.setPersonAccounts(personAccounts);
            person.setPersonAccountCategories(personAccountCategories);
            return person;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Person fromDocument(TextDocument personDoc, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        Role roleVisible = Person.getRolePersonVisible(request);
        User theUser = personDoc.getPublisher();
        Person person = new Person(theUser, personDoc);
        try {
            person.setStatus(Status.valueOf(personDoc.getTextField(10020).getHtmlFormattedText()));
        }
        catch (Exception se) {
            person.setStatus(Status.NEW);
        }
        person.setClient(theUser.getCompany());
        person.setVisibleProfile(theUser.hasRole(roleVisible));
        person.setFirstname(personDoc.getTextField(10001).getHtmlFormattedText());
        person.setLastname(personDoc.getTextField(10002).getHtmlFormattedText());
        person.setBirthdate(personDoc.getTextField(10014).getHtmlFormattedText());
        person.setGender(personDoc.getTextField(10019).getHtmlFormattedText());
        person.setAddress1(personDoc.getTextField(10010).getHtmlFormattedText());
        person.setZip(personDoc.getTextField(10012).getHtmlFormattedText());
        person.setCity(personDoc.getTextField(10013).getHtmlFormattedText());
        person.setTel1(personDoc.getTextField(10015).getHtmlFormattedText());
        person.setMobile(personDoc.getTextField(10017).getHtmlFormattedText());
        person.setEmail(personDoc.getTextField(10018).getHtmlFormattedText());
        person.setProfession(personDoc.getTextField(10031).getHtmlFormattedText());
        person.setOther(personDoc.getTextField(10021).getHtmlFormattedText());
        person.setImage(personDoc.getImage(10011));
        ArrayList<Account> personAccounts = new ArrayList<Account>();
        Document[] accountDocsInPersonMenu = personDoc.getMenu(10011).getDocuments();
        CategoryType catTypeAccountCats = documentService.getCategoryType(SystemProperties.Prop.ACCOUNT_CATEGORIES_TYPE_NAME.getString());
        Category[] arrCats = personDoc.getCategoriesOfType(catTypeAccountCats);
        ArrayList<Category> allAccountCategoriesForPerson = new ArrayList<Category>();
        ArrayList<AccountCategory> personAccountCategories = new ArrayList<AccountCategory>();
        for (Document accountDocInPersonMenu : accountDocsInPersonMenu) {
            try {
                TextDocument accountTextDoc = (TextDocument)accountDocInPersonMenu;
                Account account = AccountUtils.fromDocument(accountTextDoc, request);
                String sAccountStatusForPerson = personDoc.getTextField(7000000 + accountTextDoc.getId()).getHtmlFormattedText();
                if (!"".equals(sAccountStatusForPerson)) {
                    try {
                        account.setPersonAccountStatus(AccountStatus.valueOf(sAccountStatusForPerson));
                    }
                    catch (Exception aex) {
                        // empty catch block
                    }
                }
                personAccounts.add(account);
                if (null == arrCats || arrCats.length <= 0) continue;
                allAccountCategoriesForPerson.addAll(Arrays.asList(arrCats));
                CollectionUtils.filter(allAccountCategoriesForPerson, (Predicate)new AccountCategoriesFilterPredicate(account.getId()));
                for (Category accountCategoryImcms : allAccountCategoriesForPerson) {
                    AccountCategory accountCategory = new AccountCategory(account, accountCategoryImcms);
                    personAccountCategories.add(accountCategory);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        person.setPersonAccounts(personAccounts);
        person.setPersonAccountCategories(personAccountCategories);
        return person;
    }

    public static void addError(PageView.View pageView, Error error, HttpServletRequest request) {
        ArrayList<Error> errors;
        List<Error> list = errors = null == request.getAttribute(PERSON_PARAM_ERROR + pageView.toString()) ? new ArrayList<Error>() : (List)request.getAttribute(PERSON_PARAM_ERROR + pageView.toString());
        if (!errors.contains((Object)error)) {
            errors.add(error);
        }
        request.setAttribute(PERSON_PARAM_ERROR + pageView.toString(), errors);
    }

    public static void addErrorAll(PageView.View pageView, List<Error> errorList, HttpServletRequest request) {
        ArrayList<Error> errors;
        List<Error> list = errors = null == request.getAttribute(PERSON_PARAM_ERROR + pageView.toString()) ? new ArrayList<Error>() : (List)request.getAttribute(PERSON_PARAM_ERROR + pageView.toString());
        if (null != errorList) {
            for (Error error : errorList) {
                if (errors.contains((Object)error)) continue;
                errors.add(error);
            }
        }
        request.setAttribute(PERSON_PARAM_ERROR + pageView.toString(), errors);
    }

    public static List<Error> getErrors(PageView.View pageView, HttpServletRequest request) {
        return null == request.getAttribute(PERSON_PARAM_ERROR + pageView.toString()) ? new ArrayList<Error>() : (List)request.getAttribute(PERSON_PARAM_ERROR + pageView.toString());
    }

    public static void clearErrors(PageView.View pageView, HttpServletRequest request) {
        request.removeAttribute(PERSON_PARAM_ERROR + pageView.toString());
    }

    public void writeLog(String str) {
        FileOutputStream fos;
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "Personlog.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
            return;
        }
    }

    public static enum AccountStatus {
        NEW("Ny"),
        APPROVED("Godk&auml;nd"),
        DISAPPROVED("Ej&nbsp;godk&auml;nd");

        private final String label;

        private AccountStatus(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum Status {
        NONE("", ""),
        APPROVED_AND_ACTIVE("Godk&auml;nd & aktiv", "Godk&auml;nda & aktiva"),
        APPROVED_AND_INACTIVE("Godk&auml;nd & inaktiv", "Godk&auml;nda & inaktiva"),
        NEW("Ny", "Nya"),
        DISAPPROVED("Ej godk&auml;nd", "Ej godk&auml;nda");

        private final String label;
        private final String searchLabel;

        private Status(String label, String searchLabel) {
            this.label = label;
            this.searchLabel = searchLabel;
        }

        public String getLabel() {
            return this.label;
        }

        public String getSearchLabel() {
            return this.searchLabel;
        }
    }

    public static enum Gender {
        F,
        M;

    }

    public static enum Error {
        MOBILE_MANDATORY,
        MOBILE_EXISTS,
        FIRSTNAME_MANDATORY,
        LASTNAME_MANDATORY,
        BIRTHDATE_MANDATORY,
        EMAIL_MANDATORY,
        TELEPHONE_MANDATORY,
        ADDRESS_MANDATORY,
        ZIPCODE_MANDATORY,
        CITY_MANDATORY,
        ROLE_MANDATORY,
        PICTURE_MANDATORY,
        GENDER_MANDATORY,
        PASSWORD_NOT_THE_SAME,
        ACCOUNT_MANDATORY,
        TERMS_MANDATORY,
        COULD_NOT_BE_CREATED,
        COULD_NOT_BE_SAVED,
        MOBILE_WRONG_FORMAT,
        OTHER_MANDATORY,
        QUESTION_MANDATORY;

    }
}

