/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.job;

import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.SystemUtils;
import com.imcode.imcms.addon.smssystem.job.Job;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.TextDocument;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class JobUtils {
    private static final Logger LOG = Logger.getLogger(JobUtils.class);

    public static List<Job> getAllAccounts(HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        ArrayList<Job> returnList = new ArrayList<Job>();
        String query = "+doc_type_id:2 +category_id:" + JobUtils.getJobMainCategory(documentService).getId();
        List accountDocs = SystemUtils.getDocuments(query, (Comparator)Document.Comparator.HEADLINE, null, documentService);
        for (Document doc : accountDocs) {
            TextDocument textDoc = (TextDocument)doc;
            Job job = Job.fromDocument(textDoc, request);
            returnList.add(job);
        }
        return returnList;
    }

    public static Category getJobMainCategory(DocumentService documentService) {
        String catTypeName = SystemProperties.Prop.JOB_CATEGORY_TYPE_NAME.getString();
        String catName = SystemProperties.Prop.JOB_CATEGORY_NAME.getString();
        return documentService.getCategory(documentService.getCategoryType(catTypeName), catName);
    }
}

