/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.job;

import com.imcode.addon.db.DBUtil;
import com.imcode.imcms.addon.smssystem.job.Job;
import com.imcode.imcms.addon.smssystem.job.JobMapper;
import com.imcode.imcms.addon.smssystem.job.PersonAssignment;
import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.imcms.addon.smssystem.sms.ImSmsSender;
import com.imcode.imcms.addon.smssystem.sms.ImSmsSenderFactory;
import com.imcode.imcms.addon.smssystem.sms.Sms;
import com.imcode.imcms.addon.smssystem.sms.SmsDestination;
import com.imcode.imcms.addon.smssystem.sms.SmsException;
import com.imcode.imcms.addon.smssystem.sms.SmsSender;
import com.imcode.imcms.addon.smssystem.sms.SmsServlet;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class JobServlet
extends HttpServlet {
    static final String PATH_LOGS = "/WEB-INF/logs";

    public void writeLog(String str) {
        FileOutputStream fos;
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "jobservletlog.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
            return;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        if ("assign".equals(action)) {
            this.assign(request, response);
        } else if ("send".equals(action)) {
            this.confirm(request, response);
        }
    }

    private void confirm(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] freetextmessageBoxes;
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        UserService userService = imcmsSystem.getUserService();
        DBUtil dbUtil = new DBUtil(databaseService);
        Job job = this.getJob(request);
        final String statusId = request.getParameter(Parameter.MESSAGE_TYPE.toString());
        String message = null;
        final JobMapper jobMapper = new JobMapper(request);
        if ("".equals(statusId) || statusId.equals("free")) {
            message = request.getParameter(Parameter.MESSAGE_TEXT.toString());
        } else {
            try {
                String[][] statuses;
                String sql = "SELECT id, message FROM _smsworkflow_status WHERE meta_id=? and `group`=?";
                for (String[] tmpstatus : statuses = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{"" + job.getId(), "1"})) {
                    if (!statusId.equals(tmpstatus[0])) continue;
                    message = tmpstatus[1] + job.getDateTimeText(true);
                }
            }
            catch (Exception e) {
                this.writeLog("Error in confirm: " + e.toString());
            }
        }
        String[] personAssignmentIdStringsArray = request.getParameterValues(Job.Parameter.PERSON_ASSIGNMENT_ID.toString());
        ArrayList<String> personAssignmentIdStrings = personAssignmentIdStringsArray != null ? Arrays.asList(personAssignmentIdStringsArray) : new ArrayList<String>();
        for (String id : freetextmessageBoxes = request.getParameterValues("freetextmessage") != null ? request.getParameterValues("freetextmessage") : new String[]{}) {
            String sql = "SELECT user FROM _smsworkflow_freetext_messages WHERE id=?";
            sql = "SELECT id FROM _smsworkflow_person_assignments WHERE person_id=?";
            String user = dbUtil.sqlQueryStr(sql, (Object[])new String[]{id});
            String personAssignmentsId = dbUtil.sqlQueryStr(sql, (Object[])new String[]{user});
            if (personAssignmentIdStrings.contains(personAssignmentsId)) continue;
            personAssignmentIdStrings.add(personAssignmentsId);
        }
        if (personAssignmentIdStrings.size() == 0) {
            return;
        }
        ArrayList<SmsDestination> smsDestinations = new ArrayList<SmsDestination>();
        for (String personAssignmentIdString : personAssignmentIdStrings) {
            int personAssignmentId = Integer.parseInt(personAssignmentIdString);
            PersonAssignment employeeAssignment = jobMapper.getPersonAssignment(personAssignmentId);
            smsDestinations.add(new PersonAssignmentSmsDestination(employeeAssignment));
        }
        if (StringUtils.isNotBlank((String)message)) {
            SmsDestinationCommand smsDestinationCommand = new SmsDestinationCommand(){

                @Override
                public void handleSmsDestination(SmsDestination smsDestination) {
                    if (null != statusId && !statusId.equals("free")) {
                        PersonAssignmentSmsDestination personAssignmentSmsDestination = (PersonAssignmentSmsDestination)smsDestination;
                        jobMapper.updatePersonAssignmentStatus(personAssignmentSmsDestination.getPersonAssignment().getId(), statusId);
                    }
                }
            };
            String client = job.getAccount().getClientCategory().getName();
            TextDocument clientDoc = documentService.getTextDocument(client);
            SmsServlet.forwardToSmsSender(request, response, this.createSmsSender(smsDestinations, smsDestinationCommand, client, request), message, clientDoc.getTextField(105).getText(), smsDestinations, job.getId());
        }
    }

    private Job getJob(HttpServletRequest request) {
        JobMapper jobMapper = new JobMapper(request);
        int jobId = Integer.parseInt(request.getParameter(Job.Parameter.JOB_ID.toString()));
        return jobMapper.getJob(jobId);
    }

    private void assign(final HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        JobMapper jobMapper = new JobMapper(request);
        String jobIdParameter = request.getParameter(Job.Parameter.JOB_ID.toString());
        final Job job = jobMapper.getJob(Integer.parseInt(jobIdParameter));
        String[] personIdStrings = request.getParameterValues(Job.Parameter.PERSON_ID.toString());
        ArrayList<SmsDestination> smsDestinations = new ArrayList<SmsDestination>();
        if (null != personIdStrings) {
            for (String personIdString : personIdStrings) {
                int personId = Integer.parseInt(personIdString);
                Person person = jobMapper.getPerson(personId);
                if (null == person || job.getAssignedPersons(request).contains(person)) continue;
                smsDestinations.add(new PersonSmsDestination(person));
            }
        }
        String client = job.getAccount().getClientCategory().getName();
        SmsSender smsSender = this.createSmsSender(smsDestinations, new SmsDestinationCommand(){

            @Override
            public void handleSmsDestination(SmsDestination smsDestination) {
                Person person = ((PersonSmsDestination)smsDestination).getPerson();
                job.addPerson(person.getId(), request);
            }
        }, client, request);
        TextDocument clientDoc = documentService.getTextDocument(client);
        SmsServlet.forwardToSmsSender(request, response, smsSender, jobMapper.getInquiryMessage(job), clientDoc.getTextField(105).getText(), smsDestinations, job.getId());
    }

    private SmsSender createSmsSender(final List<SmsDestination> smsDestinations, final SmsDestinationCommand smsDestinationCommand, String client, HttpServletRequest request) {
        return ImSmsSender.getInstance(new ImSmsSenderFactory(){

            @Override
            public SmsSender createSmsSender(String username, String password, String originatorAddress) {
                return new ImSmsSender(username, password, originatorAddress){

                    @Override
                    public String[] sendSms(Sms sms) throws SmsException {
                        String[] returns = super.sendSms(sms);
                        for (SmsDestination smsDestination : smsDestinations) {
                            if (!smsDestination.getNumber().equals(sms.getDestination())) continue;
                            smsDestinationCommand.handleSmsDestination(smsDestination);
                        }
                        return returns;
                    }
                };
            }
        }, client, request);
    }

    private static class PersonAssignmentSmsDestination
    extends PersonSmsDestination {
        private PersonAssignment personAssignment;

        public PersonAssignmentSmsDestination(PersonAssignment personAssignment) {
            super(personAssignment.getPerson());
            this.personAssignment = personAssignment;
        }

        public PersonAssignment getPersonAssignment() {
            return this.personAssignment;
        }
    }

    private static class PersonSmsDestination
    implements SmsDestination {
        private final Person person;

        public PersonSmsDestination(Person person) {
            this.person = person;
        }

        public Person getPerson() {
            return this.person;
        }

        @Override
        public String getName() {
            return this.person.getLastname() + ", " + this.person.getFirstname();
        }

        @Override
        public String getNumber() {
            return this.person.getMobileStripped();
        }
    }

    private static interface SmsDestinationCommand {
        public void handleSmsDestination(SmsDestination var1);
    }

    public static enum Parameter {
        MESSAGE_TYPE,
        MESSAGE_TEXT;

    }
}

