/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.job;

import com.imcode.addon.db.DBUtil;
import com.imcode.imcms.addon.smssystem.PageView;
import com.imcode.imcms.addon.smssystem.SystemUtils;
import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountUtils;
import com.imcode.imcms.addon.smssystem.job.JobMapper;
import com.imcode.imcms.addon.smssystem.job.JobUtils;
import com.imcode.imcms.addon.smssystem.job.PersonAssignment;
import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.TemplateService;
import com.imcode.imcms.api.TextDocument;
import imcode.server.Imcms;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Job
implements Serializable {
    private static final Logger LOG = Logger.getLogger(Job.class);
    public static final int TXT_NAME = 1;
    public static final int TXT_STATUS = 28000;
    public static final int TXT_CODE = 28001;
    public static final int TXT_DESCRIPTION = 28002;
    public static final int TXT_MESSAGETEXT1 = 28003;
    public static final int TXT_MESSAGERECEIVESUCCESS = 28004;
    public static final int TXT_APPENDDATETIMETOMESSAGE = 28018;
    public static final int TXT_JOBDATETEXT = 28019;
    public static final int TXT_JOBTIME0 = 28020;
    public static final int TXT_JOBTIME1 = 28021;
    public static final int TXT_JOBDATETEXTLUCENE = 28022;
    public static final int TXT_MESSAGE2ISACTIVE = 28023;
    public static final int TXT_MESSAGE1ISACTIVE = 28024;
    public static final int TXT_REGISTRATIONREQUIRED = 28025;
    public static final int TXT_ALLOWFREETEXT = 28026;
    public static final int TXT_MESSAGEMOBILEREPLYLIST = 28027;
    public static final int TXT_USEPREDEFINED = 28028;
    public static final int TXT_APPENDNUMBERTOMESSAGE = 28029;
    public static final int TXT_APPENDSTATUSESTOMESSAGE = 28030;
    public static final int TXT_SHOWDATEINSCRIPT = 28031;
    public static final int TXT_SHOWFREETEXTINSCRIPT = 28032;
    public static final int TXT_SHOWTOTALINSCRIPT = 28033;
    public static final int TXT_PREFIX = 28034;
    public static final int MENU_ACCOUNT = 28000;
    public static final String TEMPLATE_NAME = SystemUtils.TEMPLATE_NAME;
    public static final String JOB_PARAM_ERROR = "JOB_ERROR";
    TextDocument textDoc;
    Account account;
    String name;
    String code;
    Status status;
    String description;
    String messageText1;
    String messageReceiveSuccess;
    String[][] inStatusList;
    String[][] outStatusList;
    boolean appendDateTimeToMessage;
    boolean appendNumberToMessage;
    boolean appendStatusesToMessage;
    String jobDateText;
    String jobTime0;
    String jobTime1;
    String dateTimeText;
    boolean allowFreeText;
    boolean usePredefined;
    boolean registrationRequired;
    boolean showDateInScript;
    boolean showFreetextInScript;
    boolean showTotalInScript;
    String prefix;
    boolean message1IsActive;
    boolean message2IsActive;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isShowFreetextInScript() {
        return this.showFreetextInScript;
    }

    public void setShowFreetextInScript(boolean showFreetextInScript) {
        this.showFreetextInScript = showFreetextInScript;
    }

    public boolean isShowTotalInScript() {
        return this.showTotalInScript;
    }

    public void setShowTotalInScript(boolean showTotalInScript) {
        this.showTotalInScript = showTotalInScript;
    }

    public boolean isShowDateInScript() {
        return this.showDateInScript;
    }

    public void setShowDateInScript(boolean showDateInScript) {
        this.showDateInScript = showDateInScript;
    }

    public static void writeLog(String str) {
        FileOutputStream fos;
        String PATH_LOGS = "/WEB-INF/logs";
        File webappPath = Imcms.getPath();
        File dir = new File(webappPath, PATH_LOGS).getAbsoluteFile();
        File log_file = new File(dir, "job_save_log.txt").getAbsoluteFile();
        if (!log_file.exists()) {
            try {
                log_file.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            fos = new FileOutputStream(log_file, true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        SimpleDateFormat dfD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String logDate = dfD.format(new Date());
        str = !str.equals("") ? logDate + " " + str + "\n" : "\n";
        try {
            fos.write(str.getBytes());
        }
        catch (Exception e) {
            return;
        }
        try {
            fos.close();
        }
        catch (Exception e) {
            return;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job job = (Job)o;
        return this.getId() == job.getId();
    }

    public Job() {
    }

    public Job(TextDocument textDoc) {
        this.textDoc = textDoc;
    }

    public TextDocument getTextDoc() {
        return this.textDoc;
    }

    public void setTextDoc(TextDocument textDoc) {
        this.textDoc = textDoc;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public int getId() {
        return this.textDoc.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessageReceiveSuccess() {
        return this.messageReceiveSuccess;
    }

    public void setMessageReceiveSuccess(String messageReceiveSuccess) {
        this.messageReceiveSuccess = messageReceiveSuccess;
    }

    public String getCode() {
        return StringUtils.defaultString((String)this.code).toUpperCase();
    }

    public String getSmsCode() {
        return this.getCode();
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMessageText1() {
        return this.messageText1;
    }

    public void setMessageText1(String messageText1) {
        this.messageText1 = messageText1;
    }

    public void setInStatusList(String[][] inStatusList) {
        this.inStatusList = inStatusList;
    }

    public String[][] getInStatusList() {
        return this.inStatusList;
    }

    public String[][] getOutStatusList() {
        return this.outStatusList;
    }

    public void setOutStatusList(String[][] outStatusList) {
        this.outStatusList = outStatusList;
    }

    public boolean getAppendDateTimeToMessage() {
        return this.appendDateTimeToMessage;
    }

    public void setAppendDateTimeToMessage(boolean appendDateTimeToMessage) {
        this.appendDateTimeToMessage = appendDateTimeToMessage;
    }

    public boolean getAppendNumberToMessage() {
        return this.appendNumberToMessage;
    }

    public void setAppendNumberToMessage(boolean appendNumberToMessage) {
        this.appendNumberToMessage = appendNumberToMessage;
    }

    public boolean getAppendStatusesToMessage() {
        return this.appendStatusesToMessage;
    }

    public void setAppendStatusesToMessage(boolean appendStatusesToMessage) {
        this.appendStatusesToMessage = appendStatusesToMessage;
    }

    public boolean getAllowFreeText() {
        return this.allowFreeText;
    }

    public void setAllowFreeText(boolean allowFreeText) {
        this.allowFreeText = allowFreeText;
    }

    public boolean getUsePredefined() {
        return this.usePredefined;
    }

    public void setUsePredefined(boolean usePredefined) {
        this.usePredefined = usePredefined;
    }

    public boolean getRegistrationRequired() {
        return this.registrationRequired;
    }

    public void setRegistrationRequired(boolean registrationRequired) {
        this.registrationRequired = registrationRequired;
    }

    public String getJobDateText() {
        return this.jobDateText;
    }

    public String getJobDateTextLucene() {
        return SystemUtils.stripHyphens(this.getJobDateText());
    }

    public void setJobDateText(String jobDateText) {
        this.jobDateText = jobDateText;
    }

    public String getJobTime0() {
        return this.jobTime0;
    }

    public void setJobTime0(String jobTime0) {
        this.jobTime0 = jobTime0;
    }

    public String getJobTime1() {
        return this.jobTime1;
    }

    public void setJobTime1(String jobTime1) {
        this.jobTime1 = jobTime1;
    }

    public String getDateTimeText(boolean forceShowDateTime) {
        if (!this.appendDateTimeToMessage && !forceShowDateTime) {
            return "";
        }
        if (!"".equals(this.jobTime0) && !"".equals(this.jobTime1)) {
            return (this.jobDateText + " kl. " + this.jobTime0 + " - " + this.jobTime1).trim();
        }
        if (!"".equals(this.jobTime0)) {
            return (this.jobDateText + " kl. " + this.jobTime0).trim();
        }
        return this.jobDateText;
    }

    public String getDateTimeText() {
        return this.getDateTimeText(false);
    }

    public Date getDate() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(this.getJobDateText());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getDateTimeTextWithLineBreak() {
        String retVal = this.getDateTimeText();
        if (!"".equals(retVal)) {
            return "\n" + retVal;
        }
        return "";
    }

    public boolean isNew() {
        return Status.NEW.equals((Object)this.status) || Status.NONE.equals((Object)this.status);
    }

    public boolean isActive() {
        return Status.ACTIVE.equals((Object)this.status);
    }

    public boolean isClosed() {
        return Status.CLOSED.equals((Object)this.status);
    }

    public Collection<PersonAssignment> getPersonAssignments(HttpServletRequest request) {
        JobMapper jobMapper = new JobMapper(request);
        return jobMapper.getPersonAssignments(this.getId());
    }

    public Collection<Person> getAssignedPersons(HttpServletRequest request) {
        JobMapper jobMapper = new JobMapper(request);
        return jobMapper.getAssignedPersons(this.getId());
    }

    public void addPerson(int employeeId, HttpServletRequest request) {
        Job.writeLog("Job.addPerson called");
        JobMapper jobMapper = new JobMapper(request);
        jobMapper.addPerson(this.getId(), employeeId);
    }

    public void setMessage1IsActive(boolean message1IsActive) {
        this.message1IsActive = message1IsActive;
    }

    public boolean getMessage1IsActive() {
        return this.message1IsActive;
    }

    public void setMessage2IsActive(boolean message2IsActive) {
        this.message2IsActive = message2IsActive;
    }

    public boolean getMessage2IsActive() {
        return this.message2IsActive;
    }

    public static List<Error> save(Job job, boolean isNew, HttpServletRequest request) {
        Job.writeLog("Starting save");
        ArrayList<Error> errors = new ArrayList<Error>();
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);
        TemplateService templateService = imcmsSystem.getTemplateService();
        try {
            Document[] accountDocsOld;
            TextDocument jobDoc = job.getTextDoc();
            jobDoc.setHeadline(job.getName());
            jobDoc.setPublicationStatus(Document.PublicationStatus.APPROVED);
            jobDoc.addCategory(JobUtils.getJobMainCategory(documentService));
            jobDoc.setTemplate(templateService.getTemplate(Account.TEMPLATE_NAME));
            jobDoc.setPublisher(imcmsSystem.getCurrentUser());
            TextDocument.Menu accountMenu = jobDoc.getMenu(28000);
            for (Document doc : accountDocsOld = accountMenu.getDocuments()) {
                accountMenu.removeDocument(doc);
            }
            Account newAccount = job.getAccount();
            if (null != newAccount) {
                accountMenu.addDocument((Document)newAccount.getTextDoc());
            }
            jobDoc.setHtmlTextField(1, job.getName());
            jobDoc.setHtmlTextField(28001, job.getCode());
            jobDoc.setHtmlTextField(28000, job.getStatus().toString());
            jobDoc.setHtmlTextField(28002, job.getDescription());
            jobDoc.setHtmlTextField(28003, job.getMessageText1());
            jobDoc.setHtmlTextField(28004, job.getMessageReceiveSuccess());
            jobDoc.setHtmlTextField(28018, job.getAppendDateTimeToMessage() + "");
            jobDoc.setHtmlTextField(28029, job.getAppendNumberToMessage() + "");
            jobDoc.setHtmlTextField(28030, job.getAppendStatusesToMessage() + "");
            jobDoc.setHtmlTextField(28019, job.getJobDateText());
            jobDoc.setHtmlTextField(28022, job.getJobDateTextLucene());
            jobDoc.setHtmlTextField(28020, job.getJobTime0());
            jobDoc.setHtmlTextField(28021, job.getJobTime1());
            jobDoc.setHtmlTextField(28025, job.getRegistrationRequired() ? "true" : "false");
            jobDoc.setHtmlTextField(28026, job.getAllowFreeText() ? "true" : "false");
            jobDoc.setHtmlTextField(28028, job.getUsePredefined() ? "true" : "false");
            jobDoc.setHtmlTextField(28024, job.getMessage1IsActive() ? "true" : "false");
            jobDoc.setHtmlTextField(28023, job.getMessage2IsActive() ? "true" : "false");
            jobDoc.setHtmlTextField(28031, job.isShowDateInScript() ? "true" : "false");
            jobDoc.setHtmlTextField(28033, job.isShowTotalInScript() ? "true" : "false");
            jobDoc.setHtmlTextField(28032, job.isShowFreetextInScript() ? "true" : "false");
            jobDoc.setHtmlTextField(28034, job.getPrefix());
            documentService.saveChanges((Document)jobDoc);
            try {
                int i;
                String[][] statuses = job.getInStatusList();
                String sql = "UPDATE _smsworkflow_status SET name=?, text=?, mark=?, color=?, code=?, message=?, display_color=? WHERE id=?";
                for (i = 0; i < statuses.length; ++i) {
                    if (statuses[i][1].equals("") && statuses[i][2].equals("") && statuses[i][3].equals("") && statuses[i][4].equals("")) {
                        dbUtil.sqlUpdateQuery("DELETE FROM _smsworkflow_status WHERE id=?", (Object[])new String[]{statuses[i][0]});
                        continue;
                    }
                    Job.writeLog("SQL: " + sql + ", " + statuses[i][1] + ", " + statuses[i][1] + ", " + statuses[i][3] + ", " + statuses[i][4] + ", " + statuses[i][2] + ", " + "\"\"" + ", " + statuses[i][5] + ", " + statuses[i][0]);
                    dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{statuses[i][1], statuses[i][1], statuses[i][3], statuses[i][4], statuses[i][2], "", statuses[i][5], statuses[i][0]});
                }
                statuses = job.getOutStatusList();
                for (i = 0; i < statuses.length; ++i) {
                    if (statuses[i][1].equals("") && statuses[i][2].equals("") && statuses[i][3].equals("") && statuses[i][4].equals("")) {
                        dbUtil.sqlUpdateQuery("DELETE FROM _smsworkflow_status WHERE id=?", (Object[])new String[]{statuses[i][0]});
                        continue;
                    }
                    dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{statuses[i][1], statuses[i][1], statuses[i][3], statuses[i][4], "", statuses[i][2], "black", statuses[i][0]});
                }
            }
            catch (Exception e) {
                Job.writeLog("Error: " + e.toString());
                LOG.error((Object)("Job.save() ERROR:\n" + SystemUtils.getException(e, "", false)));
            }
        }
        catch (Exception e) {
            Job.writeLog("Error: " + e.toString());
            LOG.error((Object)("Job.save() ERROR:\n" + SystemUtils.getException(e, "", false)));
            errors.add(isNew ? Error.COULD_NOT_BE_CREATED : Error.COULD_NOT_BE_SAVED);
        }
        return errors;
    }

    public static Job fromDocument(TextDocument jobDoc, HttpServletRequest request) {
        Job job = new Job(jobDoc);
        Document[] accountDocsInJobMenu = jobDoc.getMenu(28000).getDocuments();
        Account account = null;
        if (null != accountDocsInJobMenu && accountDocsInJobMenu.length > 0) {
            try {
                TextDocument accountTextDoc = (TextDocument)accountDocsInJobMenu[0];
                account = AccountUtils.fromDocument(accountTextDoc, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        job.setAccount(account);
        job.setName(jobDoc.getTextField(1).getHtmlFormattedText());
        job.setCode(jobDoc.getTextField(28001).getHtmlFormattedText());
        try {
            job.setStatus(Status.valueOf(jobDoc.getTextField(28000).getHtmlFormattedText()));
        }
        catch (Exception se) {
            job.setStatus(Status.NEW);
        }
        job.setDescription(jobDoc.getTextField(28002).getHtmlFormattedText());
        job.setMessageText1(jobDoc.getTextField(28003).getHtmlFormattedText());
        job.setMessageReceiveSuccess(jobDoc.getTextField(28004).getHtmlFormattedText());
        job.setAppendDateTimeToMessage(!"false".equals(jobDoc.getTextField(28018).getHtmlFormattedText()));
        job.setAppendNumberToMessage(!"false".equals(jobDoc.getTextField(28029).getHtmlFormattedText()));
        job.setAppendStatusesToMessage(!"false".equals(jobDoc.getTextField(28030).getHtmlFormattedText()));
        job.setJobDateText(jobDoc.getTextField(28019).getHtmlFormattedText());
        job.setJobTime0(jobDoc.getTextField(28020).getHtmlFormattedText());
        job.setJobTime1(jobDoc.getTextField(28021).getHtmlFormattedText());
        job.setRegistrationRequired(jobDoc.getTextField(28025).getHtmlFormattedText().trim().equalsIgnoreCase("true"));
        job.setAllowFreeText(jobDoc.getTextField(28026).getHtmlFormattedText().trim().equalsIgnoreCase("true"));
        job.setUsePredefined(jobDoc.getTextField(28028).getHtmlFormattedText().trim().equalsIgnoreCase("true"));
        job.setMessage1IsActive(jobDoc.getTextField(28024).getHtmlFormattedText().trim().equalsIgnoreCase("true"));
        job.setMessage2IsActive(jobDoc.getTextField(28023).getHtmlFormattedText().trim().equalsIgnoreCase("true"));
        job.setShowDateInScript(jobDoc.getTextField(28031).getHtmlFormattedText().trim().equalsIgnoreCase("true"));
        job.setShowFreetextInScript(jobDoc.getTextField(28032).getHtmlFormattedText().trim().equalsIgnoreCase("true"));
        job.setShowTotalInScript(jobDoc.getTextField(28033).getHtmlFormattedText().trim().equalsIgnoreCase("true"));
        job.setPrefix(jobDoc.getTextField(28034).getHtmlFormattedText());
        return job;
    }

    public static void addError(PageView.View pageView, Error error, HttpServletRequest request) {
        ArrayList<Error> errors;
        List<Error> list = errors = null == request.getAttribute(JOB_PARAM_ERROR + pageView.toString()) ? new ArrayList<Error>() : (List)request.getAttribute(JOB_PARAM_ERROR + pageView.toString());
        if (!errors.contains((Object)error)) {
            errors.add(error);
        }
        request.setAttribute(JOB_PARAM_ERROR + pageView.toString(), errors);
    }

    public static void addErrorAll(PageView.View pageView, List<Error> errorList, HttpServletRequest request) {
        ArrayList<Error> errors;
        List<Error> list = errors = null == request.getAttribute(JOB_PARAM_ERROR + pageView.toString()) ? new ArrayList<Error>() : (List)request.getAttribute(JOB_PARAM_ERROR + pageView.toString());
        if (null != errorList) {
            for (Error error : errorList) {
                if (errors.contains((Object)error)) continue;
                errors.add(error);
            }
        }
        request.setAttribute(JOB_PARAM_ERROR + pageView.toString(), errors);
    }

    public static List<Error> getErrors(PageView.View pageView, HttpServletRequest request) {
        return null == request.getAttribute(JOB_PARAM_ERROR + pageView.toString()) ? new ArrayList<Error>() : (List)request.getAttribute(JOB_PARAM_ERROR + pageView.toString());
    }

    public static void clearErrors(PageView.View pageView, HttpServletRequest request) {
        request.removeAttribute(JOB_PARAM_ERROR + pageView.toString());
    }

    public static enum Status {
        NONE("", ""),
        NEW("Opublicerad", "Opublicerade"),
        ACTIVE("Aktuell", "Aktuella"),
        CLOSED("Genomf&ouml;rd", "Genomf&ouml;rda");

        private final String label;
        private final String searchLabel;

        private Status(String label, String searchLabel) {
            this.label = label;
            this.searchLabel = searchLabel;
        }

        public String getLabel() {
            return this.label;
        }

        public String getSearchLabel() {
            return this.searchLabel;
        }
    }

    public static enum Error {
        ACCOUNT_EMPTY,
        NAME_EMPTY,
        CODE_EXISTS,
        CODE_EMPTY,
        CODE_WRONG_FORMAT,
        CODE_CHAR_COUNT,
        DATE_FAILED,
        EMPTY_messageText1,
        COULD_NOT_BE_CREATED,
        COULD_NOT_BE_SAVED,
        TIME_WRONG_FORMAT;

    }

    public static enum Parameter {
        PERSON_ID,
        PERSON_ASSIGNMENT_ID,
        JOB_ID,
        JOB_NAME,
        JOB_CODE,
        JOB_DESCRIPTION,
        JOB_DATE,
        JOB_START_TIME,
        JOB_END_TIME,
        JOB_MAX_EMPLOYEE_COUNT,
        JOB_STATUS,
        MESSAGE_TYPE,
        MESSAGE_TEXT;

    }
}

