/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.account;

import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountUtils;
import com.imcode.imcms.addon.smssystem.job.Job;
import com.imcode.imcms.addon.smssystem.person.Person;
import java.util.List;
import org.apache.commons.collections.Predicate;

public class AccountVisibleForPersonFilterPredicate
implements Predicate {
    List<Account> personAccounts;

    public AccountVisibleForPersonFilterPredicate(List<Account> personAccounts) {
        this.personAccounts = personAccounts;
    }

    public boolean evaluate(Object object) {
        try {
            Account account = object instanceof Job ? ((Job)object).getAccount() : (Account)object;
            if (!this.personAccounts.contains(account)) {
                return false;
            }
            Account personAccount = AccountUtils.getPersonAccountFromList(account, this.personAccounts);
            boolean isApproved = false;
            if (null != personAccount) {
                isApproved = Person.AccountStatus.APPROVED.equals((Object)personAccount.getPersonAccountStatus());
            }
            return isApproved && Account.Status.ACTIVE.equals((Object)account.getStatus());
        }
        catch (Exception e) {
            return true;
        }
    }
}

