/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem.account;

import com.imcode.addon.db.DBUtil;
import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.SystemUtils;
import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountCategoriesFilterPredicate;
import com.imcode.imcms.addon.smssystem.account.AccountCategory;
import com.imcode.imcms.addon.smssystem.account.AccountCategoryNameComparator;
import com.imcode.imcms.addon.smssystem.comparators.ImcmsUsersLastnameFirstnameComparator;
import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TemplateService;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.DocumentDomainObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AccountUtils {
    private static final Logger LOG = Logger.getLogger(AccountUtils.class);

    public static List<Account> getAllAccounts(HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        ArrayList<Account> returnList = new ArrayList<Account>();
        String query = "+status:" + Document.PublicationStatus.APPROVED + " " + "+doc_type_id:" + 2 + " " + "+category_id:" + AccountUtils.getAccountMainCategory(documentService).getId();
        List accountDocs = SystemUtils.getDocuments(query, (Comparator)Document.Comparator.HEADLINE, null, documentService);
        if (null != accountDocs) {
            for (Document doc : accountDocs) {
                TextDocument textDoc = (TextDocument)doc;
                if (!textDoc.isPublished() || !textDoc.isActive()) continue;
                Account account = AccountUtils.fromDocument(textDoc, request);
                returnList.add(account);
            }
        }
        return returnList;
    }

    public static Category getAccountMainCategory(DocumentService documentService) {
        String catTypeName = SystemProperties.Prop.ACCOUNT_CATEGORY_TYPE_NAME.getString();
        String catName = SystemProperties.Prop.ACCOUNT_CATEGORY_NAME.getString();
        return documentService.getCategory(documentService.getCategoryType(catTypeName), catName);
    }

    public static Category getDefaultAccountImcmsCategory(Account account, DocumentService documentService) {
        try {
            String catTypeName = SystemProperties.Prop.ACCOUNT_CATEGORIES_TYPE_NAME.getString();
            String catName = account.getId() + AccountCategory.META_ID_CAT_NAME_SPLITTER + AccountCategory.DEFAULT_CATEGORY_NAME;
            return documentService.getCategory(documentService.getCategoryType(catTypeName), catName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static AccountCategory getDefaultAccountCategory(Account account, DocumentService documentService) {
        try {
            String catTypeName = SystemProperties.Prop.ACCOUNT_CATEGORIES_TYPE_NAME.getString();
            String catName = account.getId() + AccountCategory.META_ID_CAT_NAME_SPLITTER + AccountCategory.DEFAULT_CATEGORY_NAME;
            return new AccountCategory(account, documentService.getCategory(documentService.getCategoryType(catTypeName), catName));
        }
        catch (Exception e) {
            LOG.error((Object)("getDefaultAccountCategory(" + (null != account ? account.getId() + "" : "null") + ")"), (Throwable)e);
            return null;
        }
    }

    public static Category newDefaultAccountCategory(Account account, DocumentService documentService) {
        String catTypeName = SystemProperties.Prop.ACCOUNT_CATEGORIES_TYPE_NAME.getString();
        String catName = account.getId() + AccountCategory.META_ID_CAT_NAME_SPLITTER + AccountCategory.DEFAULT_CATEGORY_NAME;
        return new Category(catName, documentService.getCategoryType(catTypeName));
    }

    public static List<Account.Error> save(Account account, boolean isNew, HttpServletRequest request) {
        ArrayList<Account.Error> errors = new ArrayList<Account.Error>();
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        TemplateService templateService = imcmsSystem.getTemplateService();
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        DBUtil dbUtil = new DBUtil(databaseService);
        try {
            int i;
            TextDocument accountDoc = account.getTextDoc();
            CategoryType catTypeAccountCats = documentService.getCategoryType(SystemProperties.Prop.ACCOUNT_CATEGORIES_TYPE_NAME.getString());
            List<Category> accountCategories = account.getAccountCategoriesImcms();
            ArrayList<Category> accountCatsRemove = new ArrayList<Category>();
            Category[] arrCatsOld = accountDoc.getCategoriesOfType(catTypeAccountCats);
            Category defaultAccountCategory = AccountUtils.getDefaultAccountImcmsCategory(account, documentService);
            for (Category oldCat : arrCatsOld) {
                if (null != defaultAccountCategory && oldCat.getId() == defaultAccountCategory.getId()) continue;
                if (!accountCategories.contains(oldCat)) {
                    accountCatsRemove.add(oldCat);
                }
                accountDoc.removeCategory(oldCat);
            }
            if (null != accountCategories && accountCategories.size() > 0) {
                for (Category newCat : accountCategories) {
                    accountDoc.addCategory(newCat);
                }
            }
            if (null != accountCatsRemove && accountCatsRemove.size() > 0) {
                CategoryMapper categoryMapper = new CategoryMapper(Imcms.getServices().getDatabase());
                DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
                for (Category removeCat : accountCatsRemove) {
                    CategoryDomainObject removeCatDO = categoryMapper.getCategoryById(removeCat.getId());
                    if (null == removeCatDO) continue;
                    String[] documentsOfOneCategory = categoryMapper.getAllDocumentsOfOneCategory(removeCatDO);
                    for (int i2 = 0; i2 < documentsOfOneCategory.length; ++i2) {
                        DocumentDomainObject documentDO = documentMapper.getDocument(Integer.parseInt(documentsOfOneCategory[i2]));
                        categoryMapper.deleteOneCategoryFromDocument(documentDO, removeCatDO);
                    }
                    categoryMapper.deleteCategoryFromDb(removeCatDO);
                }
            }
            for (Category removeCat : documentService.getAllCategoriesOfType(documentService.getCategoryType("service"))) {
                accountDoc.removeCategory(removeCat);
            }
            accountDoc.addCategory(account.getServiceCategory());
            for (Category removeCat : documentService.getAllCategoriesOfType(documentService.getCategoryType("client"))) {
                accountDoc.removeCategory(removeCat);
            }
            accountDoc.addCategory(account.getClientCategory());
            accountDoc.setPublicationStatus(Document.PublicationStatus.APPROVED);
            accountDoc.addCategory(AccountUtils.getAccountMainCategory(documentService));
            accountDoc.setTemplate(templateService.getTemplate(Account.TEMPLATE_NAME));
            accountDoc.setHeadline(account.getName());
            accountDoc.setHtmlTextField(10041, account.getCode());
            accountDoc.setHtmlTextField(100412, account.getCategoryHeadline());
            accountDoc.setHtmlTextField(10040, account.getStatus().toString());
            accountDoc.setHtmlTextField(10011, account.getAccountResponsibleEmail());
            accountDoc.setHtmlTextField(10014, account.getMessageText1());
            accountDoc.setHtmlTextField(10017, account.getMessageReceiveSuccess());
            accountDoc.setHtmlTextField(28018, account.getAppendDateTimeToMessage() + "");
            accountDoc.setHtmlTextField(28025, account.getAppendNumberToMessage() + "");
            accountDoc.setHtmlTextField(28026, account.getAppendStatusesToMessage() + "");
            accountDoc.setHtmlTextField(10018, account.getApplyMailFrom());
            accountDoc.setHtmlTextField(10019, account.getApplyMailSubject());
            accountDoc.setHtmlTextField(10020, account.getApplyMailBody0());
            accountDoc.setHtmlTextField(10021, account.getApplyMailBody1());
            accountDoc.setHtmlTextField(10022, account.getApproveMailFrom());
            accountDoc.setHtmlTextField(10023, account.getApproveMailSubject());
            accountDoc.setHtmlTextField(10024, account.getApproveMailBody());
            accountDoc.setHtmlTextField(10050, account.getAdminMailAddress());
            accountDoc.setHtmlTextField(10051, account.getAdminMailFrom());
            accountDoc.setHtmlTextField(10052, account.getAdminMailSubject());
            accountDoc.setHtmlTextField(10053, account.getAdminMailBody());
            accountDoc.setHtmlTextField(10025, account.getClientSpecificLabel1());
            accountDoc.setHtmlTextField(10026, account.getClientSpecificLabel2());
            accountDoc.setHtmlTextField(10027, account.getClientSpecificLabel3());
            accountDoc.setHtmlTextField(10028, account.getClientSpecificLabel4());
            accountDoc.setHtmlTextField(10029, account.getClientSpecificLabel5());
            accountDoc.setHtmlTextField(10030, account.getClientSpecificRowcount1());
            accountDoc.setHtmlTextField(10031, account.getClientSpecificRowcount2());
            accountDoc.setHtmlTextField(10032, account.getClientSpecificRowcount3());
            accountDoc.setHtmlTextField(10033, account.getClientSpecificRowcount4());
            accountDoc.setHtmlTextField(10034, account.getClientSpecificRowcount5());
            accountDoc.setHtmlTextField(10060, account.getClientSpecificMandatory1());
            accountDoc.setHtmlTextField(10061, account.getClientSpecificMandatory2());
            accountDoc.setHtmlTextField(10062, account.getClientSpecificMandatory3());
            accountDoc.setHtmlTextField(10063, account.getClientSpecificMandatory4());
            accountDoc.setHtmlTextField(10064, account.getClientSpecificMandatory5());
            accountDoc.setHtmlTextField(28020, account.getAllowFreeText() + "");
            accountDoc.setHtmlTextField(28021, account.getShowJobtypeSetting() + "");
            accountDoc.setHtmlTextField(28022, account.getRegistrationRequired() + "");
            accountDoc.setHtmlTextField(28024, account.getUsePredefined() + "");
            accountDoc.setHtmlTextField(28027, account.getAllowDestinations() + "");
            accountDoc.setHtmlTextField(28028, account.getAllowOriginator() + "");
            accountDoc.setHtmlTextField(10035, account.getHelpText1());
            accountDoc.setHtmlTextField(10036, account.getHelpText2());
            accountDoc.setHtmlTextField(10037, account.getHelpText3());
            if (account.getMessage1IsActive()) {
                accountDoc.setHtmlTextField(28023, "true");
            } else {
                accountDoc.setHtmlTextField(28023, "false");
            }
            if (account.getMessage2IsActive()) {
                accountDoc.setHtmlTextField(28019, "true");
            } else {
                accountDoc.setHtmlTextField(28019, "false");
            }
            documentService.saveChanges((Document)accountDoc);
            String[][] statuses = account.getInStatusList();
            String sql = "UPDATE _smsworkflow_status SET name=?, text=?, mark=?, color=?, code=?, message=? WHERE id=?";
            for (i = 0; i < statuses.length; ++i) {
                if (statuses[i][1].equals("") && statuses[i][2].equals("") && statuses[i][3].equals("") && statuses[i][4].equals("")) {
                    dbUtil.sqlUpdateQuery("DELETE FROM _smsworkflow_status WHERE id=?", (Object[])new String[]{statuses[i][0]});
                    continue;
                }
                dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{statuses[i][1], statuses[i][1], statuses[i][3], statuses[i][4], statuses[i][2], "", statuses[i][0]});
            }
            statuses = account.getOutStatusList();
            sql = "UPDATE _smsworkflow_status SET name=?, text=?, mark=?, color=?, code=?, message=? WHERE id=?";
            for (i = 0; i < statuses.length; ++i) {
                if (statuses[i][1].equals("") && statuses[i][2].equals("") && statuses[i][3].equals("") && statuses[i][4].equals("")) {
                    dbUtil.sqlUpdateQuery("DELETE FROM _smsworkflow_status WHERE id=?", (Object[])new String[]{statuses[i][0]});
                    continue;
                }
                dbUtil.sqlUpdateQuery(sql, (Object[])new String[]{statuses[i][1], statuses[i][1], statuses[i][3], statuses[i][4], "", statuses[i][2], statuses[i][0]});
            }
        }
        catch (Exception e) {
            LOG.error((Object)("AccountUtils.save() ERROR:\n" + SystemUtils.getException(e, "", false)));
            errors.add(isNew ? Account.Error.COULD_NOT_BE_CREATED : Account.Error.COULD_NOT_BE_SAVED);
        }
        return errors;
    }

    public static Account fromDocument(TextDocument accountDoc, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        Account account = new Account(accountDoc);
        ArrayList<Category> accountCategoriesImcms = new ArrayList<Category>();
        CategoryType catTypeAccountCats = documentService.getCategoryType(SystemProperties.Prop.ACCOUNT_CATEGORIES_TYPE_NAME.getString());
        Category[] arrCats = accountDoc.getCategoriesOfType(catTypeAccountCats);
        if (null != arrCats && arrCats.length > 0) {
            accountCategoriesImcms.addAll(Arrays.asList(arrCats));
            CollectionUtils.filter(accountCategoriesImcms, (Predicate)new AccountCategoriesFilterPredicate(account.getId()));
            Collections.sort(accountCategoriesImcms, new AccountCategoryNameComparator(account.getId()));
        }
        account.setAccountCategoriesImcms(accountCategoriesImcms);
        ArrayList<AccountCategory> accountCategories = new ArrayList<AccountCategory>();
        for (Category imcmsCat : accountCategoriesImcms) {
            AccountCategory accountCategory = new AccountCategory(account, imcmsCat);
            accountCategories.add(accountCategory);
        }
        try {
            account.setStatus(Account.Status.valueOf(accountDoc.getTextField(10040).getHtmlFormattedText()));
        }
        catch (Exception se) {
            account.setStatus(Account.Status.ACTIVE);
        }
        try {
            account.setServiceCategory(accountDoc.getCategoriesOfType(documentService.getCategoryType("service"))[0]);
            account.setClientCategory(accountDoc.getCategoriesOfType(documentService.getCategoryType("client"))[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        account.setCode(accountDoc.getTextField(10041).getHtmlFormattedText().toUpperCase());
        account.setCategoryHeadline(accountDoc.getTextField(100412).getHtmlFormattedText());
        account.setAccountCategories(accountCategories);
        account.setAccountResponsibleEmail(accountDoc.getTextField(10011).getHtmlFormattedText());
        account.setMessageText1(accountDoc.getTextField(10014).getHtmlFormattedText());
        account.setMessageReceiveSuccess(accountDoc.getTextField(10017).getHtmlFormattedText());
        account.setAppendDateTimeToMessage(!"false".equals(accountDoc.getTextField(28018).getHtmlFormattedText()));
        account.setAppendNumberToMessage(!"false".equals(accountDoc.getTextField(28025).getHtmlFormattedText()));
        account.setAppendStatusesToMessage(!"false".equals(accountDoc.getTextField(28026).getHtmlFormattedText()));
        account.setApplyMailFrom(accountDoc.getTextField(10018).getHtmlFormattedText());
        account.setApplyMailSubject(accountDoc.getTextField(10019).getHtmlFormattedText());
        account.setApplyMailBody0(accountDoc.getTextField(10020).getHtmlFormattedText());
        account.setApplyMailBody1(accountDoc.getTextField(10021).getHtmlFormattedText());
        account.setApproveMailFrom(accountDoc.getTextField(10022).getHtmlFormattedText());
        account.setApproveMailSubject(accountDoc.getTextField(10023).getHtmlFormattedText());
        account.setApproveMailBody(accountDoc.getTextField(10024).getHtmlFormattedText());
        account.setAdminMailAddress(accountDoc.getTextField(10050).getHtmlFormattedText());
        account.setAdminMailFrom(accountDoc.getTextField(10051).getHtmlFormattedText());
        account.setAdminMailSubject(accountDoc.getTextField(10052).getHtmlFormattedText());
        account.setAdminMailBody(accountDoc.getTextField(10053).getHtmlFormattedText());
        account.setClientSpecificLabel1(accountDoc.getTextField(10025).getHtmlFormattedText());
        account.setClientSpecificLabel2(accountDoc.getTextField(10026).getHtmlFormattedText());
        account.setClientSpecificLabel3(accountDoc.getTextField(10027).getHtmlFormattedText());
        account.setClientSpecificLabel4(accountDoc.getTextField(10028).getHtmlFormattedText());
        account.setClientSpecificLabel5(accountDoc.getTextField(10029).getHtmlFormattedText());
        account.setClientSpecificRowcount1(accountDoc.getTextField(10030).getHtmlFormattedText());
        account.setClientSpecificRowcount2(accountDoc.getTextField(10031).getHtmlFormattedText());
        account.setClientSpecificRowcount3(accountDoc.getTextField(10032).getHtmlFormattedText());
        account.setClientSpecificRowcount4(accountDoc.getTextField(10033).getHtmlFormattedText());
        account.setClientSpecificRowcount5(accountDoc.getTextField(10034).getHtmlFormattedText());
        account.setClientSpecificMandatory1(accountDoc.getTextField(10060).getHtmlFormattedText());
        account.setClientSpecificMandatory2(accountDoc.getTextField(10061).getHtmlFormattedText());
        account.setClientSpecificMandatory3(accountDoc.getTextField(10062).getHtmlFormattedText());
        account.setClientSpecificMandatory4(accountDoc.getTextField(10063).getHtmlFormattedText());
        account.setClientSpecificMandatory5(accountDoc.getTextField(10064).getHtmlFormattedText());
        account.setAllowFreeText(!"false".equals(accountDoc.getTextField(28020).getHtmlFormattedText()));
        account.setShowJobtypeSetting(!"false".equals(accountDoc.getTextField(28021).getHtmlFormattedText()));
        account.setRegistrationRequired(!"false".equals(accountDoc.getTextField(28022).getHtmlFormattedText()));
        account.setUsePredefined(!"false".equals(accountDoc.getTextField(28024).getHtmlFormattedText()));
        account.setAllowDestinations("true".equals(accountDoc.getTextField(28027).getHtmlFormattedText()));
        account.setAllowOriginator("true".equals(accountDoc.getTextField(28028).getHtmlFormattedText()));
        account.setHelpText1(accountDoc.getTextField(10035).getHtmlFormattedText());
        account.setHelpText2(accountDoc.getTextField(10036).getHtmlFormattedText());
        account.setHelpText3(accountDoc.getTextField(10037).getHtmlFormattedText());
        if (accountDoc.getTextField(28023).getHtmlFormattedText().equals("true")) {
            account.setMessage1IsActive(true);
        } else {
            account.setMessage1IsActive(false);
        }
        if (accountDoc.getTextField(28019).getHtmlFormattedText().equals("true")) {
            account.setMessage2IsActive(true);
        } else {
            account.setMessage2IsActive(false);
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Account> getAccountsForAdministrators(User theUser, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        Role clientAdminRole = userService.getRole("kund_admin");
        Role serviceAdminRole = userService.getRole("service_admin_smsworkflow");
        if (theUser.isSuperAdmin() || theUser.hasRole(clientAdminRole) || theUser.hasRole(serviceAdminRole)) {
            return AccountUtils.getAllAccounts(request);
        }
        ArrayList<Account> returnList = new ArrayList<Account>();
        try {
            DocumentService documentService = imcmsSystem.getDocumentService();
            DatabaseService databaseService = imcmsSystem.getDatabaseService();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                connection = databaseService.getConnection();
                preparedStatement = connection.prepareStatement("SELECT DISTINCT account_id FROM _smsworkflow_account_rights WHERE user_id = ?");
                preparedStatement.setInt(1, theUser.getId());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    TextDocument textDoc = documentService.getTextDocument(resultSet.getInt(1));
                    if (!textDoc.isPublished() || !textDoc.isActive()) continue;
                    Account account = AccountUtils.fromDocument(textDoc, request);
                    returnList.add(account);
                }
            }
            catch (Exception ex) {
                LOG.debug((Object)("AccountUtils.getAccountsForAdministrators() ERROR 1: " + ex.getMessage()));
            }
            finally {
                try {
                    if (null != resultSet) {
                        resultSet.close();
                    }
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("AccountUtils.getAccountsForAdministrators() ERROR 2: " + e.getMessage()));
        }
        return returnList;
    }

    public static List<User> getAllImcmsUsersNotPersonnel(HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        Role rolePerson = Person.getRolePerson(request);
        Role rolePersonVisible = Person.getRolePersonVisible(request);
        Role rolePersonApproved = Person.getRolePersonApprovedAndVisible(request);
        List<User> imcmsUsers = Arrays.asList(userService.getAllUsers());
        ArrayList<User> allImcmsUsersNotPersonnel = new ArrayList<User>();
        for (User imcmsUser : imcmsUsers) {
            String fullName = (imcmsUser.getLastName() + " " + imcmsUser.getFirstName()).trim();
            boolean hasOwnPage = false;
            if (null != imcmsUser.getOtherPhone()) {
                hasOwnPage = imcmsUser.getOtherPhone().matches("^\\d{4,6}$");
            }
            if (!imcmsUser.isActive() || imcmsUser.isDefaultUser() || hasOwnPage || "".equals(fullName) || rolePerson != null && imcmsUser.hasRole(rolePerson) || rolePersonVisible != null && imcmsUser.hasRole(rolePersonVisible) || rolePersonApproved != null && imcmsUser.hasRole(rolePersonApproved)) continue;
            allImcmsUsersNotPersonnel.add(imcmsUser);
        }
        Collections.sort(allImcmsUsersNotPersonnel, new ImcmsUsersLastnameFirstnameComparator());
        return allImcmsUsersNotPersonnel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> getAdministratorsForAccount(Account account, HttpServletRequest request) {
        ArrayList<User> returnList = new ArrayList<User>();
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            UserService userService = imcmsSystem.getUserService();
            DatabaseService databaseService = imcmsSystem.getDatabaseService();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                connection = databaseService.getConnection();
                preparedStatement = connection.prepareStatement("SELECT DISTINCT user_id FROM _smsworkflow_account_rights WHERE account_id = ?");
                preparedStatement.setInt(1, account.getId());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    returnList.add(userService.getUser(resultSet.getInt(1)));
                }
                if (!returnList.isEmpty()) {
                    ImcmsUsersLastnameFirstnameComparator imcmsUsersLastnameFirstnameComparator = new ImcmsUsersLastnameFirstnameComparator();
                    Collections.sort(returnList, imcmsUsersLastnameFirstnameComparator);
                }
            }
            catch (Exception ex) {
                LOG.debug((Object)("AccountUtils.getAdministratorsForAccount() ERROR 1: " + ex.getMessage()));
            }
            finally {
                try {
                    if (null != resultSet) {
                        resultSet.close();
                    }
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("AccountUtils.getAdministratorsForAccount() ERROR 2: " + e.getMessage()));
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdminUsersToAccount(int accountId, String[] userIds, HttpServletRequest request) {
        if (null == userIds || userIds.length == 0) {
            return;
        }
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            DatabaseService databaseService = imcmsSystem.getDatabaseService();
            Connection connection = null;
            Statement preparedStatement = null;
            try {
                connection = databaseService.getConnection();
                for (String userId : userIds) {
                    if ("".equals(userId) || !StringUtils.isNumeric((String)userId)) continue;
                    preparedStatement = connection.prepareStatement("INSERT INTO _smsworkflow_account_rights (account_id, user_id) VALUES (?, ?)");
                    preparedStatement.setInt(1, accountId);
                    preparedStatement.setInt(2, Integer.parseInt(userId));
                    preparedStatement.executeUpdate();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("AccountUtils.addAdminUsersToAccount() ERROR 1: " + ex.getMessage()));
            }
            finally {
                try {
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            LOG.error((Object)("AccountUtils.addAdminUsersToAccount() ERROR 2: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAdminUsersFromAccount(int accountId, String[] userIds, HttpServletRequest request) {
        if (null == userIds || userIds.length == 0) {
            return;
        }
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            DatabaseService databaseService = imcmsSystem.getDatabaseService();
            Connection connection = null;
            Statement preparedStatement = null;
            try {
                connection = databaseService.getConnection();
                for (String userId : userIds) {
                    if (!StringUtils.isNumeric((String)userId)) continue;
                    preparedStatement = connection.prepareStatement("DELETE FROM _smsworkflow_account_rights WHERE account_id = ? AND user_id = ?");
                    preparedStatement.setInt(1, accountId);
                    preparedStatement.setInt(2, Integer.parseInt(userId));
                    preparedStatement.executeUpdate();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("AccountUtils.removeAdminUsersFromAccount() ERROR 1: " + ex.getMessage()));
            }
            finally {
                try {
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            LOG.error((Object)("AccountUtils.removeAdminUsersFromAccount() ERROR 2: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> getMessengersForAccount(Account account, HttpServletRequest request) {
        ArrayList<User> returnList = new ArrayList<User>();
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            UserService userService = imcmsSystem.getUserService();
            DatabaseService databaseService = imcmsSystem.getDatabaseService();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                connection = databaseService.getConnection();
                preparedStatement = connection.prepareStatement("SELECT DISTINCT user_id FROM _smsworkflow_account_messengers WHERE account_id = ?");
                preparedStatement.setInt(1, account.getId());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    returnList.add(userService.getUser(resultSet.getInt(1)));
                }
                if (!returnList.isEmpty()) {
                    ImcmsUsersLastnameFirstnameComparator imcmsUsersLastnameFirstnameComparator = new ImcmsUsersLastnameFirstnameComparator();
                    Collections.sort(returnList, imcmsUsersLastnameFirstnameComparator);
                }
            }
            catch (Exception ex) {
                LOG.debug((Object)("AccountUtils.getMessengersForAccount() ERROR 1: " + ex.getMessage()));
            }
            finally {
                try {
                    if (null != resultSet) {
                        resultSet.close();
                    }
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("AccountUtils.getMessengersForAccount() ERROR 2: " + e.getMessage()));
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessengerUsersToAccount(int accountId, String[] userIds, HttpServletRequest request) {
        if (null == userIds || userIds.length == 0) {
            return;
        }
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            DatabaseService databaseService = imcmsSystem.getDatabaseService();
            Connection connection = null;
            Statement preparedStatement = null;
            try {
                connection = databaseService.getConnection();
                for (String userId : userIds) {
                    if ("".equals(userId) || !StringUtils.isNumeric((String)userId)) continue;
                    preparedStatement = connection.prepareStatement("INSERT INTO _smsworkflow_account_messengers (account_id, user_id) VALUES (?, ?)");
                    preparedStatement.setInt(1, accountId);
                    preparedStatement.setInt(2, Integer.parseInt(userId));
                    preparedStatement.executeUpdate();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("AccountUtils.addMessengerUsersToAccount() ERROR 1: " + ex.getMessage()));
            }
            finally {
                try {
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            LOG.error((Object)("AccountUtils.addMessengerUsersToAccount() ERROR 2: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMessengerUsersFromAccount(int accountId, String[] userIds, HttpServletRequest request) {
        if (null == userIds || userIds.length == 0) {
            return;
        }
        try {
            ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
            DatabaseService databaseService = imcmsSystem.getDatabaseService();
            Connection connection = null;
            Statement preparedStatement = null;
            try {
                connection = databaseService.getConnection();
                for (String userId : userIds) {
                    if (!StringUtils.isNumeric((String)userId)) continue;
                    preparedStatement = connection.prepareStatement("DELETE FROM _smsworkflow_account_messengers WHERE account_id = ? AND user_id = ?");
                    preparedStatement.setInt(1, accountId);
                    preparedStatement.setInt(2, Integer.parseInt(userId));
                    preparedStatement.executeUpdate();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("AccountUtils.removeMessengerUsersFromAccount() ERROR 1: " + ex.getMessage()));
            }
            finally {
                try {
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            LOG.error((Object)("AccountUtils.removeMessengerUsersFromAccount() ERROR 2: " + e.getMessage()));
        }
    }

    public static boolean isMessengerForAccount(String mobilePhone, Account account, HttpServletRequest request) {
        List<User> users = AccountUtils.getMessengersForAccount(account, request);
        mobilePhone = SystemUtils.getMobileNumberFromString(mobilePhone);
        if (null != users && !users.isEmpty()) {
            for (User user : users) {
                String mobile = SystemUtils.getMobileNumberFromString(user.getMobilePhone());
                if ("".equals(mobile)) {
                    mobile = SystemUtils.getMobileNumberFromString(user.getLoginName());
                }
                if (!mobilePhone.equals(mobile)) continue;
                return true;
            }
        }
        return false;
    }

    public static Account getPersonAccountFromList(Account account, List<Account> personsAccounts) {
        if (personsAccounts.contains(account)) {
            for (Account personsAccount : personsAccounts) {
                if (!account.equals(personsAccount)) continue;
                return personsAccount;
            }
        }
        return null;
    }

    public static String getStatuses(Account account, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DatabaseService databaseService = imcmsSystem.getDatabaseService();
        String prefix = "";
        String returnString = "";
        try {
            String client = account.getTextDoc().getCategoriesOfType(imcmsSystem.getDocumentService().getCategoryType("client"))[0].getName();
            TextDocument clientDoc = imcmsSystem.getDocumentService().getTextDocument(client);
            prefix = clientDoc.getTextField(10101).getText().split(",")[0];
        }
        catch (Exception e) {
            prefix = "";
        }
        try {
            String[][] statuses;
            DBUtil dbUtil = new DBUtil(databaseService);
            String sql = "SELECT * FROM _smsworkflow_status WHERE meta_id=? AND `group`=? ORDER by sort_key DESC";
            for (String[] status : statuses = dbUtil.sqlQueryMulti(sql, (Object[])new String[]{"" + account.getId(), "2"})) {
                returnString = returnString + "Om " + status[2] + " skriv\n" + prefix + " " + account.getCode() + " " + status[5] + "\n";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return returnString;
    }
}

