/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem;

import com.imcode.imcms.addon.smssystem.PageView;
import com.imcode.imcms.addon.smssystem.SystemProperties;
import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountMapper;
import com.imcode.imcms.addon.smssystem.filters.PersonVisiblePredicate;
import com.imcode.imcms.addon.smssystem.job.Job;
import com.imcode.imcms.addon.smssystem.job.JobMapper;
import com.imcode.imcms.addon.smssystem.person.Person;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.LuceneParsedQuery;
import com.imcode.imcms.api.SearchQuery;
import com.imcode.imcms.api.TextDocument;
import imcode.util.Utility;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class SystemUtils {
    public static final String TEMPLATE_NAME = SystemProperties.Prop.SYSTEM_TEMPLATE_NAME.getString();
    public static final String STARTPAGE_ALIAS = SystemProperties.Prop.SYSTEM_ALIAS_START.getString();

    private SystemUtils() {
    }

    public static int getIntRequestParameter(String param, int defaultVal, HttpServletRequest request) {
        if (null != request.getParameter(param) && StringUtils.isNumeric((String)request.getParameter(param))) {
            try {
                return Integer.parseInt(request.getParameter(param));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public static int[] getIntRequestParameterValues(String param, HttpServletRequest request) {
        if (null != request.getParameterValues(param)) {
            String[] arrStrings = Utility.getParameterValues((HttpServletRequest)request, (String)param);
            try {
                return Utility.convertStringArrayToIntArray((String[])arrStrings);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new int[0];
    }

    public static boolean hasOneOfCategories(Document doc, List<String> catNames) {
        try {
            for (Category cat : doc.getCategories()) {
                if (!catNames.contains(cat.getName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static List getDocuments(String query, Comparator comp, Predicate filterPredicate, DocumentService documentService) {
        try {
            LuceneParsedQuery sq = new LuceneParsedQuery(query);
            ArrayList documents = new ArrayList(documentService.getDocuments((SearchQuery)sq));
            if (null != filterPredicate) {
                CollectionUtils.filter(documents, (Predicate)filterPredicate);
            }
            if (null != comp) {
                Collections.sort(documents, comp);
            }
            return documents;
        }
        catch (Exception ex) {
            System.out.print(ex.toString());
            return Collections.EMPTY_LIST;
        }
    }

    public static String getException(Exception e, String errorType, boolean hide) {
        String ret = "";
        if (errorType == null || "".equalsIgnoreCase(errorType)) {
            errorType = "ExceptionError";
        }
        ret = ret + (hide ? "<!--\n" : "<pre>");
        ret = ret + errorType + ": " + e.getMessage() + "\n";
        ret = ret + "StackTrace:\n";
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            ret = ret + stackTrace[i] + "\n";
        }
        ret = ret + (hide ? "-->" : "</pre>");
        return ret;
    }

    public static String getSimpleImageSize(long size) {
        String sSize = size + "&nbsp;b";
        try {
            double dFileSize = size;
            DecimalFormat df = new DecimalFormat("#.0");
            if (dFileSize >= 1048576.0) {
                sSize = df.format(dFileSize /= 1048576.0);
                sSize = sSize.replaceAll(",", ".") + "&nbsp;MB";
            } else if (dFileSize >= 1024.0) {
                sSize = df.format(dFileSize /= 1024.0);
                sSize = sSize.replaceAll(",", ".") + "&nbsp;kB";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sSize;
    }

    public static String stripHyphens(String input) {
        return input.replaceAll("-", "");
    }

    public static List<Person> getPersons(HttpServletRequest request, String search_string, String search_char, String status, String cat_id) {
        PersonVisiblePredicate personVisiblePredicate = null;
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        boolean isCharSearch = StringUtils.isNotBlank((String)search_char);
        String query = "+category:" + SystemProperties.Prop.PERSON_CATEGORY_NAME.getString();
        if ("vis".equals(status)) {
            personVisiblePredicate = new PersonVisiblePredicate(request);
        } else if (!status.equals("")) {
            query = query + " +status:" + status;
        }
        if (cat_id.matches("^\\d+$")) {
            query = query + " +category_id:" + cat_id;
        }
        if (!search_string.equals("")) {
            query = query + " +(text10014:(" + search_string + "*) " + "text" + 10001 + ":(" + search_string + "*) " + "text" + 10002 + ":(" + search_string + "*) " + "text" + 10003 + ":(" + search_string + "*) " + "text" + 10004 + ":(" + search_string + "*) " + "text" + 10010 + ":(" + search_string + "*) " + "text" + 10012 + ":(" + search_string + "*) " + "text" + 10013 + ":(" + search_string + "*) " + "text" + 10015 + ":(" + search_string + "*) " + "text" + 10017 + ":(" + search_string + "*) " + "text" + 10018 + ":(" + search_string + "*) " + "text" + 10021 + ":(" + search_string + "*) " + "text" + 10031 + ":(" + search_string + "*)" + ")";
        }
        ArrayList<Person> persons = new ArrayList<Person>();
        List docs = SystemUtils.getDocuments(query, (Comparator)Document.Comparator.HEADLINE, personVisiblePredicate, cms.getDocumentService());
        for (TextDocument document : docs) {
            persons.add(Person.fromDocument(document, request));
        }
        return persons;
    }

    public static boolean codeExists(String code, TextDocument jobOrAccountDoc, HttpServletRequest request) {
        try {
            Job jobByCode;
            Account accountByCode;
            AccountMapper accountMapper = new AccountMapper(request);
            Account account = accountByCode = "".equals(code) ? null : accountMapper.getAccountByCode(code);
            if (null != accountByCode && accountByCode.getCode().equalsIgnoreCase(code) && accountByCode.getId() != jobOrAccountDoc.getId()) {
                return true;
            }
            JobMapper jobMapper = new JobMapper(request);
            Job job = jobByCode = "".equals(code) ? null : jobMapper.getJobByCode("", code);
            if (null != jobByCode && jobByCode.getSmsCode().equalsIgnoreCase(code) && jobByCode.getId() != jobOrAccountDoc.getId()) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static String getMobileNumberFromString(String mobilePhoneString) {
        if ((mobilePhoneString = StringUtils.defaultString((String)mobilePhoneString).replaceAll("[^\\d]", "").trim()).startsWith("46")) {
            mobilePhoneString = mobilePhoneString.replaceFirst("^46", "0");
        }
        return mobilePhoneString.matches("^0\\d{9,10}$") ? mobilePhoneString : "";
    }

    public static String convertUtf8ToIso(String string) {
        try {
            return new String(string.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public static String convertIsoToUtf8(String string) {
        try {
            byte[] bytes = string.getBytes("ISO-8859-1");
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            return string;
        }
    }

    public static void forwardToRoot(PageView.View actView, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (null != actView) {
            request.setAttribute("page", (Object)actView);
        }
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService documentService = imcmsSystem.getDocumentService();
        Document doc = documentService.getDocument(STARTPAGE_ALIAS);
        request.getRequestDispatcher("/servlet/GetDoc?meta_id=" + doc.getId()).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void forwardToGetDoc(String sMetaId, PageView.View actView, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (null != actView) {
            request.setAttribute("page", (Object)actView);
        }
        request.getRequestDispatcher("/servlet/GetDoc?meta_id=" + sMetaId).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void forwardToGetDoc(int metaId, PageView.View actView, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (null != actView) {
            request.setAttribute("page", (Object)actView);
        }
        request.getRequestDispatcher("/servlet/GetDoc?meta_id=" + metaId).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static enum Color {
        BLACK("Svart"),
        BLUE("Bl&aring;"),
        GREEN("Gr&ouml;n"),
        RED("R&ouml;d");

        private final String nameSwe;

        private Color(String nameSwe) {
            this.nameSwe = nameSwe;
        }

        public String getNameSwe() {
            return this.nameSwe;
        }

        public String getNameEng() {
            return this.name().toLowerCase();
        }
    }
}

