/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.smssystem;

import com.imcode.imcms.addon.smssystem.account.Account;
import com.imcode.imcms.addon.smssystem.account.AccountUtils;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RightsChecker {
    public static boolean userMayAdmin(HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        User currentUser = imcmsSystem.getCurrentUser();
        Role clientAdminRole = userService.getRole("kund_admin");
        Role serviceAdminRole = userService.getRole("service_admin_smsworkflow");
        if (currentUser.isDefaultUser()) {
            return false;
        }
        if (currentUser.isSuperAdmin() || currentUser.hasRole(clientAdminRole) || currentUser.hasRole(serviceAdminRole)) {
            return true;
        }
        List<Account> allAccounts = AccountUtils.getAccountsForAdministrators(currentUser, request);
        return !allAccounts.isEmpty();
    }

    public static boolean userMayAdminDocument(Document doc, HttpServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        User currentUser = imcmsSystem.getCurrentUser();
        if (RightsChecker.userMayAdmin(request)) {
            return true;
        }
        try {
            return doc.getPublisher().getId() == currentUser.getId();
        }
        catch (Exception e) {
            return false;
        }
    }
}

