/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.newsletter.imcms;

import com.imcode.imcms.addon.newsletter.Issue;
import com.imcode.imcms.addon.newsletter.NewsLetter;
import com.imcode.imcms.addon.newsletter.imcms.ImcmsNewsLetterRepository;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.FileDocument;
import com.imcode.imcms.api.TextDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.activation.DataSource;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocumentIssue
implements Issue {
    private final ImcmsNewsLetterRepository repository;
    private final TextDocument textDocument;
    private NewsLetter newsLetter;
    public static final int BODY_TEXT_INDEX = 1;

    public TextDocumentIssue(ImcmsNewsLetterRepository repository, TextDocument textDocument) {
        this.repository = repository;
        this.textDocument = textDocument;
    }

    @Override
    public Date getDateTime() {
        return this.textDocument.getPublicationStartDatetime();
    }

    @Override
    public String getId() {
        return "" + this.textDocument.getId();
    }

    @Override
    public String getSubject() {
        return this.textDocument.getHeadline();
    }

    @Override
    public String getBody() {
        return this.getBodyTextField().getHtmlFormattedText();
    }

    private TextDocument.TextField getBodyTextField() {
        return this.textDocument.getTextField(1);
    }

    @Override
    public Issue.Format getFormat() {
        TextDocument.TextField.Format format = this.getBodyTextField().getFormat();
        return format == TextDocument.TextField.Format.HTML ? Issue.Format.HTML : Issue.Format.TEXT;
    }

    @Override
    public Collection<? extends DataSource> getAttachments() {
        ArrayList<FileDocument.FileDocumentFile> attachments = new ArrayList<FileDocument.FileDocumentFile>();
        TextDocument.Menu menu = this.textDocument.getMenu(1);
        for (Document document : menu.getDocuments()) {
            if (!(document instanceof FileDocument)) continue;
            FileDocument fileDocument = (FileDocument)document;
            attachments.add(fileDocument.getDefaultFile());
        }
        return attachments;
    }

    @Override
    public void setSubject(String subject) {
        this.textDocument.setHeadline(subject);
    }

    @Override
    public void setBody(String body) {
        if (this.getFormat() == Issue.Format.HTML) {
            this.textDocument.setHtmlTextField(1, body);
        } else {
            this.textDocument.setPlainTextField(1, body);
        }
    }

    @Override
    public void save() {
        this.repository.saveDocument(this.textDocument);
    }

    @Override
    public void setFormat(Issue.Format format) {
        this.getBodyTextField().setFormat(format == Issue.Format.HTML ? TextDocument.TextField.Format.HTML : TextDocument.TextField.Format.PLAIN);
    }

    @Override
    public void addAttachment(DataSource dataSource) {
        FileDocument attachmentDocument = this.repository.createAttachment(dataSource, this.textDocument);
        this.textDocument.getMenu(1).addDocument((Document)attachmentDocument);
    }

    @Override
    public NewsLetter getNewsLetter() {
        if (null == this.newsLetter) {
            this.newsLetter = this.repository.getNewsLetterForIssue(this.getId());
        }
        return this.newsLetter;
    }

    @Override
    public void clearAttachments() {
        TextDocument.Menu menu = this.textDocument.getMenu(1);
        for (Document document : menu.getDocuments()) {
            menu.removeDocument(document);
        }
    }

    @Override
    public void addSent(Collection<String> addresses) {
        String sentText = this.textDocument.getTextField(2).getText();
        ArrayList<String> sentAddresses = new ArrayList<String>(Arrays.asList(sentText.split("\\s+")));
        sentAddresses.addAll(addresses);
        this.textDocument.setHtmlTextField(2, StringUtils.join(sentAddresses.iterator(), (String)"\n"));
    }

    @Override
    public void setSent() {
        this.textDocument.setPublicationStartDatetime(new Date());
        this.save();
    }

    @Override
    public void delete() {
        this.repository.deleteIssue((Document)this.textDocument);
    }
}

