/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.newsletter.imcms;

import com.imcode.imcms.addon.newsletter.Issue;
import com.imcode.imcms.addon.newsletter.NewsLetter;
import com.imcode.imcms.addon.newsletter.NewsLetterRepository;
import com.imcode.imcms.addon.newsletter.imcms.MailSendingException;
import com.imcode.imcms.addon.newsletter.imcms.TextDocumentIssue;
import com.imcode.imcms.addon.newsletter.imcms.TextDocumentNewsLetter;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentPermissionSetType;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.FileDocument;
import com.imcode.imcms.api.LuceneQuery;
import com.imcode.imcms.api.Mail;
import com.imcode.imcms.api.MailException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.SearchException;
import com.imcode.imcms.api.SearchQuery;
import com.imcode.imcms.api.TextDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.activation.DataSource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImcmsNewsLetterRepository
implements NewsLetterRepository {
    private static final Logger LOG = Logger.getLogger(ImcmsNewsLetterRepository.class);
    private ContentManagementSystem cms;

    public ImcmsNewsLetterRepository(HttpServletRequest request) {
        this.cms = ContentManagementSystem.fromRequest((ServletRequest)request);
    }

    @Override
    public NewsLetter getNewsLetter(String id) {
        return new TextDocumentNewsLetter(this, this.getDocument(id));
    }

    @Override
    public Iterable<? extends Issue> getIssues(String id) {
        Document[] documents = this.getDocument(id).getMenu(1).getDocuments();
        LOG.debug((Object)("Issues: " + documents.length));
        ArrayList<TextDocumentIssue> issues = new ArrayList<TextDocumentIssue>();
        for (Document document : documents) {
            if (!(document instanceof TextDocument)) continue;
            issues.add(new TextDocumentIssue(this, (TextDocument)document));
        }
        Collections.sort(issues, new Comparator<Issue>(){

            @Override
            public int compare(Issue i1, Issue i2) {
                Date d1 = i1.getDateTime();
                Date d2 = i2.getDateTime();
                if (null == d1 && null == d2) {
                    return 0;
                }
                if (null == d1) {
                    return -1;
                }
                if (null == d2) {
                    return 1;
                }
                return d2.compareTo(d1);
            }
        });
        return issues;
    }

    private TextDocument getDocument(String id) {
        return this.getDocumentService().getTextDocument(Integer.parseInt(id));
    }

    @Override
    public Issue createIssue(NewsLetter newsLetter) {
        TextDocument newsLetterDocument = this.getDocument(newsLetter.getId());
        TextDocument issueDocument = this.getDocumentService().createNewTextDocument((Document)newsLetterDocument);
        issueDocument.setTemplate(this.cms.getTemplateService().getTemplate("newsletterissue"));
        issueDocument.setPublicationStatus(Document.PublicationStatus.APPROVED);
        issueDocument.setPublicationStartDatetime(null);
        try {
            this.getDocumentService().saveChanges((Document)issueDocument);
        }
        catch (SaveException e) {
            throw new UnhandledException((Throwable)e);
        }
        TextDocumentIssue issue = new TextDocumentIssue(this, issueDocument);
        newsLetter.addIssue(issue.getId());
        return issue;
    }

    @Override
    public void addIssue(String newsLetterId, String issueId) {
        TextDocument newsLetterDocument = this.getDocument(newsLetterId);
        newsLetterDocument.getMenu(1).addDocument((Document)this.getDocument(issueId));
        try {
            this.getDocumentService().saveChanges((Document)newsLetterDocument);
        }
        catch (SaveException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    @Override
    public Issue getIssue(String id) {
        return new TextDocumentIssue(this, this.getDocument(id));
    }

    @Override
    public void send(Issue issue, String[] addresses) throws MailSendingException {
        NewsLetter newsLetter = issue.getNewsLetter();
        Mail mail = new Mail(newsLetter.getFromAddress());
        mail.setToAddresses(addresses);
        mail.setSubject(issue.getSubject());
        String body = ImcmsNewsLetterRepository.buildBody(newsLetter, issue);
        mail.setHtmlBody(body);
        mail.setAttachments(issue.getAttachments().toArray(new DataSource[issue.getAttachments().size()]));
        try {
            this.cms.getMailService().sendMail(mail);
            issue.addSent(Arrays.asList(addresses));
        }
        catch (MailException e) {
            throw new MailSendingException(e);
        }
    }

    public static String buildBody(NewsLetter newsLetter, Issue issue) {
        return ImcmsNewsLetterRepository.htmlify(newsLetter.getHeader() + "\n") + issue.getBody() + ImcmsNewsLetterRepository.htmlify("\n" + newsLetter.getFooter());
    }

    private static String htmlify(String string) {
        return StringEscapeUtils.escapeHtml((String)string).replaceAll("\r\n|\r|\n", "<br />\n");
    }

    private DocumentService getDocumentService() {
        return this.cms.getDocumentService();
    }

    void saveDocument(TextDocument textDocument) {
        try {
            this.getDocumentService().saveChanges((Document)textDocument);
        }
        catch (SaveException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    FileDocument createAttachment(DataSource fileItem, TextDocument parentDocument) {
        FileDocument attachmentDocument = this.getDocumentService().createNewFileDocument((Document)parentDocument);
        attachmentDocument.addFile(fileItem.getName(), new FileDocument.FileDocumentFile(fileItem));
        attachmentDocument.setPublicationStatus(Document.PublicationStatus.APPROVED);
        try {
            this.getDocumentService().saveChanges((Document)attachmentDocument);
        }
        catch (SaveException e) {
            throw new UnhandledException((Throwable)e);
        }
        return attachmentDocument;
    }

    public NewsLetter getNewsLetterForIssue(String id) {
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add((Query)new TermQuery(new Term("child_id", id)), true, false);
        booleanQuery.add((Query)new TermQuery(new Term("template", "newsletter")), true, false);
        try {
            List documents = this.cms.getDocumentService().getDocuments((SearchQuery)new LuceneQuery((Query)booleanQuery));
            return this.getNewsLetter("" + ((Document)documents.get(0)).getId());
        }
        catch (SearchException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public void removeEditRole(Document document, String roleId) {
        Role role = this.cms.getUserService().getRole(Integer.parseInt(roleId));
        document.setPermissionSetTypeForRole(role, DocumentPermissionSetType.NONE);
    }

    public void addEditRole(Document document, String roleId) {
        Role role = this.cms.getUserService().getRole(Integer.parseInt(roleId));
        document.setPermissionSetTypeForRole(role, DocumentPermissionSetType.FULL);
    }

    public void deleteIssue(Document document) {
        this.getDocumentService().deleteDocument(document);
    }
}

