/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.newsletter.imcms;

import com.imcode.imcms.addon.newsletter.AddressList;
import com.imcode.imcms.addon.newsletter.Issue;
import com.imcode.imcms.addon.newsletter.NewsLetter;
import com.imcode.imcms.addon.newsletter.SimpleAddressList;
import com.imcode.imcms.addon.newsletter.imcms.ImcmsNewsLetterRepository;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentPermissionSet;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TextDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocumentNewsLetter
implements NewsLetter {
    private final ImcmsNewsLetterRepository repository;
    private final TextDocument textDocument;

    public TextDocumentNewsLetter(ImcmsNewsLetterRepository repository, TextDocument textDocument) {
        this.repository = repository;
        this.textDocument = textDocument;
    }

    @Override
    public Iterable<? extends Issue> getIssues() {
        return this.repository.getIssues(this.getId());
    }

    @Override
    public Issue createIssue() {
        return this.repository.createIssue(this);
    }

    @Override
    public String getId() {
        return "" + this.textDocument.getId();
    }

    @Override
    public void addIssue(String issueId) {
        this.repository.addIssue(this.getId(), issueId);
    }

    @Override
    public String getFromAddress() {
        return this.getText(2);
    }

    private String getText(int i) {
        return this.textDocument.getTextField(i).getText();
    }

    @Override
    public List<String> getCcAddresses() {
        return Arrays.asList(this.getText(3).split("\\s"));
    }

    @Override
    public List<String> getBccAddresses() {
        return Arrays.asList(this.getText(4).split("\\s"));
    }

    @Override
    public String getHeader() {
        return this.textDocument.getTextField(5).getText();
    }

    @Override
    public String getFooter() {
        return this.textDocument.getTextField(6).getText();
    }

    private void setText(int index, String text) {
        this.textDocument.setHtmlTextField(index, text);
    }

    @Override
    public void setFromAddress(String fromAddress) {
        this.setText(2, fromAddress);
    }

    @Override
    public void setCcAddresses(Iterable<String> ccAddresses) {
        this.setText(3, StringUtils.join(ccAddresses.iterator(), (String)" "));
    }

    @Override
    public void setBccAddresses(Iterable<String> bccAddresses) {
        this.setText(4, StringUtils.join(bccAddresses.iterator(), (String)" "));
    }

    @Override
    public void setHeader(String header) {
        this.textDocument.setPlainTextField(5, header);
    }

    @Override
    public void setFooter(String footer) {
        this.textDocument.setPlainTextField(6, footer);
    }

    @Override
    public void save() {
        this.repository.saveDocument(this.textDocument);
    }

    @Override
    public Map<String, AddressList> getRecipientLists() {
        return TextDocumentNewsLetter.getRecipientLists(this.getText(7));
    }

    static Map<String, AddressList> getRecipientLists(String text) {
        String[] blocks;
        TreeMap<String, AddressList> recipientLists = new TreeMap<String, AddressList>();
        for (String block : blocks = text.split("\n\n")) {
            String[] nameAndAddresses;
            String listName;
            if (StringUtils.isBlank((String)block) || !StringUtils.isNotBlank((String)(listName = (nameAndAddresses = block.split("\n"))[0])) || nameAndAddresses.length < 2 || !StringUtils.isNotBlank((String)nameAndAddresses[1])) continue;
            ArrayList<String> addresses = new ArrayList<String>(Arrays.asList(nameAndAddresses[1].split(" ")));
            recipientLists.put(listName, new SimpleAddressList(listName, addresses));
        }
        return recipientLists;
    }

    @Override
    public void addRecipientList(AddressList addressList) {
        Map<String, AddressList> recipientLists = this.getRecipientLists();
        recipientLists.put(addressList.getName(), addressList);
        this.setRecipientLists(recipientLists);
    }

    @Override
    public void removeRecipientList(String recipientListName) {
        Map<String, AddressList> recipientLists = this.getRecipientLists();
        recipientLists.remove(recipientListName);
        this.setRecipientLists(recipientLists);
    }

    @Override
    public Collection<Role> getEditRoles() {
        ArrayList<Role> rolesWithEditPermission = new ArrayList<Role>();
        Map rolesMappedToPermissions = this.textDocument.getRolesMappedToPermissions();
        for (Role role : rolesMappedToPermissions.keySet()) {
            if (this.textDocument.getPermissionSetIdForRole(role) != DocumentPermissionSet.FULL) continue;
            rolesWithEditPermission.add(role);
        }
        return rolesWithEditPermission;
    }

    @Override
    public void removeEditRole(String roleId) {
        this.repository.removeEditRole((Document)this.textDocument, roleId);
    }

    @Override
    public void addEditRole(String roleId) {
        this.repository.addEditRole((Document)this.textDocument, roleId);
    }

    private void setRecipientLists(Map<String, AddressList> recipientLists) {
        StringBuilder storage = new StringBuilder();
        for (AddressList rl : recipientLists.values()) {
            storage.append(rl.getName()).append("\n").append(StringUtils.join(rl.getAddresses().iterator(), (String)" ")).append("\n\n");
        }
        this.setText(7, storage.toString());
    }
}

