/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.newsletter;

import com.imcode.imcms.addon.newsletter.AddressList;
import com.imcode.imcms.addon.newsletter.Issue;
import com.imcode.imcms.addon.newsletter.NewsLetter;
import com.imcode.imcms.addon.newsletter.NewsLetterRepository;
import com.imcode.imcms.addon.newsletter.Recipient;
import com.imcode.imcms.addon.newsletter.SimpleAddressList;
import com.imcode.imcms.addon.newsletter.imcms.ImcmsNewsLetterRepository;
import com.imcode.imcms.addon.newsletter.imcms.MailSendingException;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TextDocumentViewing;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import com.imcode.util.MultipartHttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.activation.DataSource;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsLetterServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if ("/issue/list".equals(pathInfo)) {
            NewsLetterServlet.list(request, response);
        } else if ("/issue/edit".equals(pathInfo)) {
            NewsLetterServlet.edit(request, response, NewsLetterServlet.getIssue(request));
        } else if ("/settings".equals(pathInfo)) {
            this.settingsview(request, response, NewsLetterServlet.getNewsLetter(request));
        } else if ("/permissions".equals(pathInfo)) {
            this.permissionsview(request, response, NewsLetterServlet.getNewsLetter(request));
        } else {
            response.setContentType("text/plain");
            response.getWriter().write(pathInfo);
        }
    }

    protected void doPost(HttpServletRequest r, HttpServletResponse response) throws ServletException, IOException {
        MultipartHttpServletRequest request = new MultipartHttpServletRequest(r);
        ImcmsNewsLetterRepository repository = NewsLetterServlet.getRepository((HttpServletRequest)request);
        String pathInfo = request.getPathInfo();
        if ("/issue/list".equals(pathInfo)) {
            NewsLetterServlet.edit((HttpServletRequest)request, response, NewsLetterServlet.getNewsLetter((HttpServletRequest)request).createIssue());
        } else if ("/issue/edit".equals(pathInfo)) {
            this.postEdit(request, response);
        } else if ("/issue/send".equals(pathInfo)) {
            this.postSend(request, response, repository);
        } else if ("/settings".equals(pathInfo)) {
            this.postSettings(request, response);
        } else if ("/permissions".equals(pathInfo)) {
            this.postPermissions(request, response);
        } else {
            response.setContentType("text/plain");
            response.getWriter().write(pathInfo);
        }
    }

    private void permissionsview(HttpServletRequest request, HttpServletResponse response, NewsLetter newsLetter) throws IOException, ServletException {
        User currentUser = ContentManagementSystem.fromRequest((ServletRequest)request).getCurrentUser();
        if (!currentUser.isSuperAdmin()) {
            NewsLetterServlet.sendForbidden(request, response);
            return;
        }
        request.setAttribute("newsLetter", (Object)newsLetter);
        request.getRequestDispatcher("/WEB-INF/jsp/newsletter/permissions.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private static void sendForbidden(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(request.getContextPath() + "/login/");
    }

    private static boolean isAdmin(NewsLetter newsLetter, User currentUser) {
        if (currentUser.isSuperAdmin()) {
            return true;
        }
        Collection<Role> editRoles = newsLetter.getEditRoles();
        for (Role role : currentUser.getRoles()) {
            if (!editRoles.contains(role)) continue;
            return true;
        }
        return false;
    }

    private void postPermissions(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        NewsLetter newsLetter = NewsLetterServlet.getNewsLetter((HttpServletRequest)request);
        User currentUser = ContentManagementSystem.fromRequest((ServletRequest)request).getCurrentUser();
        if (!currentUser.isSuperAdmin()) {
            NewsLetterServlet.sendForbidden((HttpServletRequest)request, response);
            return;
        }
        if (Parameter.REMOVE_EDIT_ROLE.isIn((HttpServletRequest)request)) {
            List<String> roleIdsWithPermission = Parameter.ROLE_IDS_WITH_PERMISSION.valuesFrom((HttpServletRequest)request);
            for (String roleIdWithPermission : roleIdsWithPermission) {
                newsLetter.removeEditRole(roleIdWithPermission);
            }
            newsLetter.save();
        } else if (Parameter.ADD_EDIT_ROLE.isIn((HttpServletRequest)request)) {
            List<String> roleIdsWithoutPermission = Parameter.ROLE_IDS_WITHOUT_PERMISSION.valuesFrom((HttpServletRequest)request);
            for (String roleIdWithoutPermission : roleIdsWithoutPermission) {
                newsLetter.addEditRole(roleIdWithoutPermission);
            }
            newsLetter.save();
        }
        this.permissionsview((HttpServletRequest)request, response, newsLetter);
    }

    private void postSettings(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        User currentUser;
        NewsLetter newsLetter = NewsLetterServlet.getNewsLetter((HttpServletRequest)request);
        if (!NewsLetterServlet.isAdmin(newsLetter, currentUser = ContentManagementSystem.fromRequest((ServletRequest)request).getCurrentUser())) {
            NewsLetterServlet.sendForbidden((HttpServletRequest)request, response);
            return;
        }
        newsLetter.setFromAddress(Parameter.FROM_ADDRESS.from((HttpServletRequest)request));
        newsLetter.setCcAddresses(this.splitOnWhitespaceAndCommas(Parameter.CC_ADDRESSES.from((HttpServletRequest)request)));
        newsLetter.setBccAddresses(this.splitOnWhitespaceAndCommas(Parameter.BCC_ADDRESSES.from((HttpServletRequest)request)));
        newsLetter.setHeader(Parameter.HEADER.from((HttpServletRequest)request));
        newsLetter.setFooter(Parameter.FOOTER.from((HttpServletRequest)request));
        newsLetter.save();
        NewsLetterServlet.list((HttpServletRequest)request, response, newsLetter);
    }

    private void postEdit(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Issue issue = NewsLetterServlet.getIssue((HttpServletRequest)request);
        User currentUser = ContentManagementSystem.fromRequest((ServletRequest)request).getCurrentUser();
        NewsLetter newsLetter = issue.getNewsLetter();
        if (!NewsLetterServlet.isAdmin(newsLetter, currentUser)) {
            NewsLetterServlet.sendForbidden((HttpServletRequest)request, response);
            return;
        }
        if (null != Parameter.REMOVE_ATTACHMENTS.from((HttpServletRequest)request)) {
            issue.clearAttachments();
        }
        this.updateIssueFromRequest(issue, request);
        issue.save();
        if (null != Parameter.PREVIOUS.from((HttpServletRequest)request)) {
            NewsLetterServlet.redirectToList((HttpServletRequest)request, response, newsLetter.getId());
        } else if (null != Parameter.NEXT.from((HttpServletRequest)request)) {
            this.sendview((HttpServletRequest)request, response, issue);
        } else if (null != Parameter.DELETE_ISSUE.from((HttpServletRequest)request)) {
            issue.delete();
            NewsLetterServlet.list((HttpServletRequest)request, response, newsLetter);
        } else {
            NewsLetterServlet.edit((HttpServletRequest)request, response, issue);
        }
    }

    private void postSend(MultipartHttpServletRequest request, HttpServletResponse response, NewsLetterRepository repository) throws IOException, ServletException {
        String[] addresses;
        Issue issue = NewsLetterServlet.getIssue((HttpServletRequest)request);
        if (null != Parameter.PREVIOUS.from((HttpServletRequest)request)) {
            NewsLetterServlet.edit((HttpServletRequest)request, response, issue);
            return;
        }
        User currentUser = ContentManagementSystem.fromRequest((ServletRequest)request).getCurrentUser();
        NewsLetter newsLetter = issue.getNewsLetter();
        if (!NewsLetterServlet.isAdmin(newsLetter, currentUser)) {
            NewsLetterServlet.sendForbidden((HttpServletRequest)request, response);
            return;
        }
        SendTo sendTo = SendTo.valueOf(Parameter.SEND_TO.from((HttpServletRequest)request));
        SimpleSendPage sendPage = new SimpleSendPage(issue);
        sendPage.setSendTo(sendTo);
        if (null != Parameter.SEND_TEST.from((HttpServletRequest)request)) {
            String testAddress = Parameter.TEST_ADDRESS.from((HttpServletRequest)request);
            try {
                repository.send(issue, new String[]{testAddress});
            }
            catch (MailSendingException e) {
                throw new UnhandledException((Throwable)e);
            }
            sendPage.setTestMailSent(true);
        } else if (null != Parameter.USE_ROLES_AS_SEND_LIST.from((HttpServletRequest)request)) {
            List<String> roleIds = Parameter.ROLE_IDS.valuesFrom((HttpServletRequest)request);
            ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
            UserService userService = cms.getUserService();
            TreeSet<Recipient> recipients = new TreeSet<Recipient>();
            int countOfRecipientsWithoutAddresses = 0;
            for (String roleId : roleIds) {
                Role role = userService.getRole(Integer.parseInt(roleId));
                if (null == role) continue;
                List usersWithRole = userService.getUsersWithRole(role);
                for (User user : usersWithRole) {
                    String emailAddress = user.getEmailAddress();
                    if (StringUtils.isNotBlank((String)emailAddress)) {
                        recipients.add(new SimpleRecipient(user.getFirstName() + " " + user.getLastName(), emailAddress));
                        continue;
                    }
                    ++countOfRecipientsWithoutAddresses;
                }
            }
            if (!roleIds.isEmpty()) {
                sendPage.setCountOfRecipientsWithoutAddresses(countOfRecipientsWithoutAddresses);
            }
            sendPage.setRecipients(recipients);
        } else if (null != Parameter.SHOW_ADDRESS_LIST.from((HttpServletRequest)request)) {
            String recipientListName = Parameter.ADDRESS_LIST_NAME.from((HttpServletRequest)request);
            AddressList addressList = newsLetter.getRecipientLists().get(recipientListName);
            if (null != addressList) {
                sendPage.setCurrentAddressList(addressList);
            }
        } else if (null != Parameter.DELETE_ADDRESS_LIST.from((HttpServletRequest)request)) {
            String recipientListName = Parameter.ADDRESS_LIST_NAME.from((HttpServletRequest)request);
            newsLetter.removeRecipientList(recipientListName);
            newsLetter.save();
        } else if (null != Parameter.SAVE_ADDRESS_LIST.from((HttpServletRequest)request)) {
            String[] recipientAddresses = Parameter.ADDRESS_LIST.from((HttpServletRequest)request).split("\\s+");
            String recipientListName = Parameter.NEW_ADDRESS_LIST_NAME.from((HttpServletRequest)request);
            if (StringUtils.isNotBlank((String)recipientListName)) {
                SimpleAddressList addressList = new SimpleAddressList(recipientListName, Arrays.asList(recipientAddresses));
                newsLetter.addRecipientList(addressList);
                newsLetter.save();
                sendPage.setCurrentAddressList(addressList);
            }
            List<Recipient> recipients = this.buildRecipients(recipientAddresses);
            sendPage.setRecipients(recipients);
        } else if (null != Parameter.USE_ADDRESS_LIST.from((HttpServletRequest)request)) {
            String[] recipientAddresses = Parameter.ADDRESS_LIST.from((HttpServletRequest)request).split("\\s+");
            List<Recipient> recipients = this.buildRecipients(recipientAddresses);
            String recipientListName = Parameter.NEW_ADDRESS_LIST_NAME.from((HttpServletRequest)request);
            sendPage.setRecipients(recipients);
            SimpleAddressList addressList = new SimpleAddressList(recipientListName, Arrays.asList(recipientAddresses));
            sendPage.setCurrentAddressList(addressList);
        } else if (null != Parameter.SEND.from((HttpServletRequest)request) && null != (addresses = request.getParameterValues(Parameter.RECIPIENT.toString()))) {
            issue.setSent();
            this.sendprogress((HttpServletRequest)request, response, issue, addresses, repository);
            return;
        }
        this.sendview((HttpServletRequest)request, response, sendPage);
    }

    private List<Recipient> buildRecipients(String[] recipientAddresses) {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        for (String recipientAddress : recipientAddresses) {
            if (!StringUtils.isNotBlank((String)recipientAddress)) continue;
            recipients.add(new SimpleRecipient("", recipientAddress));
        }
        return recipients;
    }

    private List<String> splitOnWhitespaceAndCommas(String string) {
        return Arrays.asList(string.split("[\\s,]+"));
    }

    private void sendview(HttpServletRequest request, HttpServletResponse response, SendPage sendPage) throws IOException, ServletException {
        request.setAttribute("sendPage", (Object)sendPage);
        request.getRequestDispatcher("/WEB-INF/jsp/newsletter/send.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void sendprogress(HttpServletRequest request, HttpServletResponse response, Issue issue, String[] addresses, NewsLetterRepository repository) throws IOException, ServletException {
        request.setAttribute("issue", (Object)issue);
        request.setAttribute("addresses", Arrays.asList(addresses));
        request.setAttribute("repository", (Object)repository);
        request.getRequestDispatcher("/WEB-INF/jsp/newsletter/sendprogress.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void settingsview(HttpServletRequest request, HttpServletResponse response, NewsLetter newsLetter) throws IOException, ServletException {
        User currentUser = ContentManagementSystem.fromRequest((ServletRequest)request).getCurrentUser();
        if (!NewsLetterServlet.isAdmin(newsLetter, currentUser)) {
            NewsLetterServlet.sendForbidden(request, response);
            return;
        }
        request.setAttribute("newsLetter", (Object)newsLetter);
        request.getRequestDispatcher("/WEB-INF/jsp/newsletter/settings.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void updateIssueFromRequest(Issue issue, MultipartHttpServletRequest request) {
        issue.setSubject(Parameter.SUBJECT.from((HttpServletRequest)request));
        MultipartHttpServletRequest.DataSourceFileItem parameterFileItem = request.getParameterFileItem(Parameter.ATTACHMENT.toString());
        if (0L != parameterFileItem.getSize()) {
            issue.addAttachment((DataSource)parameterFileItem);
        }
    }

    private void sendview(HttpServletRequest request, HttpServletResponse response, Issue issue) throws IOException, ServletException {
        this.sendview(request, response, new SimpleSendPage(issue));
    }

    public static String getPathToSettings(HttpServletRequest request, String newsLetterId) {
        return request.getContextPath() + "/newsletter/settings?" + (Object)((Object)Parameter.ID) + "=" + newsLetterId;
    }

    public static String getPathToPermissions(HttpServletRequest request, String newsLetterId) {
        return request.getContextPath() + "/newsletter/permissions?" + (Object)((Object)Parameter.ID) + "=" + newsLetterId;
    }

    public static void list(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        User currentUser;
        NewsLetter newsLetter = NewsLetterServlet.getNewsLetter(request);
        if (!NewsLetterServlet.isAdmin(newsLetter, currentUser = ContentManagementSystem.fromRequest((ServletRequest)request).getCurrentUser())) {
            NewsLetterServlet.sendForbidden(request, response);
            return;
        }
        NewsLetterServlet.list(request, response, newsLetter);
    }

    private static Issue getIssue(HttpServletRequest request) {
        ImcmsNewsLetterRepository repository = NewsLetterServlet.getRepository(request);
        String id = Parameter.ID.from(request);
        return repository.getIssue(id);
    }

    public static void edit(HttpServletRequest request, HttpServletResponse response, Issue issue) throws IOException, ServletException {
        User currentUser = ContentManagementSystem.fromRequest((ServletRequest)request).getCurrentUser();
        if (!NewsLetterServlet.isAdmin(issue.getNewsLetter(), currentUser)) {
            NewsLetterServlet.sendForbidden(request, response);
            return;
        }
        if (NewsLetterServlet.isNotGet(request)) {
            response.sendRedirect(NewsLetterServlet.getPathToEditIssue(request, issue.getId()));
            return;
        }
        request.setAttribute("issue", (Object)issue);
        request.getRequestDispatcher("/WEB-INF/jsp/newsletter/edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static String getPathToEditIssue(HttpServletRequest request, String issueId) {
        return request.getContextPath() + "/newsletter/issue/edit?" + (Object)((Object)Parameter.ID) + "=" + issueId;
    }

    private static void list(HttpServletRequest request, HttpServletResponse response, NewsLetter newsLetter) throws IOException, ServletException {
        if (NewsLetterServlet.isNotGet(request)) {
            NewsLetterServlet.redirectToList(request, response, newsLetter.getId());
            return;
        }
        request.setAttribute("newsLetter", (Object)newsLetter);
        request.getRequestDispatcher("/WEB-INF/jsp/newsletter/list.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void redirectToList(HttpServletRequest request, HttpServletResponse response, String newsLetterId) throws IOException {
        response.sendRedirect(NewsLetterServlet.getPathToList(request, newsLetterId));
    }

    public static String getPathToList(HttpServletRequest request, String newsLetterId) {
        return request.getContextPath() + "/newsletter/issue/list?" + (Object)((Object)Parameter.ID) + "=" + newsLetterId;
    }

    private static boolean isNotGet(HttpServletRequest request) {
        return !NewsLetterServlet.isGet(request);
    }

    private static boolean isGet(HttpServletRequest request) {
        return "GET".equals(request.getMethod());
    }

    private static NewsLetter getNewsLetter(HttpServletRequest request) {
        ImcmsNewsLetterRepository repository = NewsLetterServlet.getRepository(request);
        String id = request.getParameter(Parameter.ID.toString());
        if (null == id) {
            TextDocumentViewing viewing = TextDocumentViewing.fromRequest((HttpServletRequest)request);
            id = "" + viewing.getTextDocument().getId();
        }
        return repository.getNewsLetter(id);
    }

    public static ImcmsNewsLetterRepository getRepository(HttpServletRequest request) {
        return new ImcmsNewsLetterRepository(request);
    }

    private static class SimpleRecipient
    implements Recipient,
    Comparable {
        private final String emailAddress;
        private final String name;

        SimpleRecipient(String name, String emailAddress) {
            this.emailAddress = emailAddress;
            this.name = name;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public String getName() {
            return this.name;
        }

        public int compareTo(Object o) {
            SimpleRecipient other = (SimpleRecipient)o;
            return this.emailAddress.compareToIgnoreCase(other.getEmailAddress());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullAddressList
    implements AddressList {
        private NullAddressList() {
        }

        public String getId() {
            return "";
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public Collection<String> getAddresses() {
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleSendPage
    implements SendPage {
        private final Issue issue;
        private SendTo sendTo = SendTo.ROLES;
        private Collection<Recipient> recipients = Collections.EMPTY_LIST;
        private AddressList currentAddressList = new NullAddressList();
        private Integer countOfRecipientsWithoutAddresses;
        private boolean testMailSent;

        SimpleSendPage(Issue issue) {
            this.issue = issue;
        }

        @Override
        public Issue getIssue() {
            return this.issue;
        }

        @Override
        public SendTo getSendTo() {
            return this.sendTo;
        }

        @Override
        public Collection<Recipient> getRecipients() {
            return this.recipients;
        }

        @Override
        public AddressList getCurrentSendList() {
            return this.currentAddressList;
        }

        @Override
        public Integer getCountOfRecipientsWithoutAddresses() {
            return this.countOfRecipientsWithoutAddresses;
        }

        @Override
        public boolean isTestMailSent() {
            return this.testMailSent;
        }

        public void setRecipients(Collection<Recipient> recipients) {
            this.recipients = recipients;
        }

        public void setCurrentAddressList(AddressList currentAddressList) {
            this.currentAddressList = currentAddressList;
        }

        public void setSendTo(SendTo sendTo) {
            this.sendTo = sendTo;
        }

        public void setCountOfRecipientsWithoutAddresses(Integer countOfRecipientsWithoutAddresses) {
            this.countOfRecipientsWithoutAddresses = countOfRecipientsWithoutAddresses;
        }

        public void setTestMailSent(boolean testMailSent) {
            this.testMailSent = testMailSent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SendPage {
        public Issue getIssue();

        public SendTo getSendTo();

        public Collection<Recipient> getRecipients();

        public AddressList getCurrentSendList();

        public Integer getCountOfRecipientsWithoutAddresses();

        public boolean isTestMailSent();
    }

    public class Error {
        private String description;

        public Error(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SendTo {
        ROLES,
        REGISTERED,
        CUSTOM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter {
        ID,
        OK,
        SEND_TO,
        SUBJECT,
        BODY,
        ATTACHMENT,
        NEW_ISSUE,
        SAVE,
        PREVIOUS,
        NEXT,
        TEST_ADDRESS,
        SEND_TEST,
        FROM_ADDRESS,
        CC_ADDRESSES,
        BCC_ADDRESSES,
        HEADER,
        FOOTER,
        INCLUDE_LOGIN_INFO,
        USE_ROLES_AS_SEND_LIST,
        ROLE_IDS,
        USE_REGISTERED_RECIPIENTS,
        ADDRESS_LIST_NAME,
        SHOW_ADDRESS_LIST,
        DELETE_ADDRESS_LIST,
        ADDRESS_LIST,
        USE_ADDRESS_LIST,
        SAVE_ADDRESS_LIST,
        RECIPIENT,
        SEND,
        ADD_ATTACHMENT,
        REMOVE_ATTACHMENTS,
        NEW_ADDRESS_LIST_NAME,
        ROLE_IDS_WITHOUT_PERMISSION,
        ROLE_IDS_WITH_PERMISSION,
        REMOVE_EDIT_ROLE,
        ADD_EDIT_ROLE,
        DELETE_ISSUE;


        public String from(HttpServletRequest request) {
            return request.getParameter(this.toString());
        }

        public List<String> valuesFrom(HttpServletRequest request) {
            String[] parameterValues = request.getParameterValues(this.toString());
            return null == parameterValues ? Collections.EMPTY_LIST : Arrays.asList(parameterValues);
        }

        public boolean isIn(HttpServletRequest request) {
            return null != request.getParameter(this.toString());
        }
    }
}

