/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.listeners;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.addon.imsurvey.services.ClientDetailsService;
import com.imcode.imcms.addon.imsurvey.services.RightsChecker;
import com.imcode.imcms.addon.imsurvey.services.RightsCheckerImpl;
import com.imcode.imcms.addon.imsurvey.services.StaticClientDetailServiceImpl;
import com.imcode.imcms.addon.imsurvey.utils.ImSurveyUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class StartupListener
implements ServletContextListener {
    public void contextInitialized(final ServletContextEvent servletContextEvent) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"propertiesPath")).to(servletContextEvent.getServletContext().getRealPath("/WEB-INF/conf/server.properties"));
                this.bind(ClientDetailsService.class).to(StaticClientDetailServiceImpl.class);
                this.bind(RightsChecker.class).to(RightsCheckerImpl.class);
            }
        }});
        injector.getInstance(ImSurveyUtils.class);
        Properties props = new Properties();
        try {
            props.load(servletContextEvent.getServletContext().getResourceAsStream("/WEB-INF/conf/server.properties"));
            SystemProperties.ONEFLOW_BASE_URL = props.getProperty("OneflowBaseURL");
            SystemProperties.ONEFLOW_SECURITY_TOKEN = props.getProperty("OneflowSecurityToken");
            SystemProperties.ONEFLOW_CURRENT_POSITION = props.getProperty("OneflowCurrentPosition");
            SystemProperties.ONEFLOW_SYSTEM_POSITION = props.getProperty("OneflowSystemPosition");
            SystemProperties.ONEFLOW_CREATOR_POSITION = props.getProperty("OneflowCreatorPosition");
            SystemProperties.ONEFLOW_CREATOR_TYPE = props.getProperty("OneflowCreatorType");
            SystemProperties.currentAPI = Utils.getAPI(props.getProperty("ActiveAPI"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

