package com.imcode.imcms.addon.imsurvey.oneflow;

import java.util.HashMap;
import java.util.Map;

/**
 * Possible Oneflow user data
 * Created by dmizem from Ubrainians for ImCode on 20.01.17
 *
 * @author dmizem
 */
public enum UserField {
	COMPANY_NAME("company_name"), COUNTRY_CODE("country_code"), IDENTIFICATION_NUMBER("identification_number"), SELF("self"), NAME("name"),
	POSITION_ID("position_id"), TYPE("type"), TITLE("title"), EMAIL("email"), PHONE_NUMBER("phone_number"),
	DELIVERY_CHANNEL("delivery_channel"), SIGN_METHOD("sign_method");

    private final String id;
    private static Map<String, UserField> map = new HashMap<>();

    UserField(String id) {
        this.id = id;
    }

    public String getValue() {
        return id;
    }

    static {
        for (UserField signMethod : UserField.values()) {
            map.put(signMethod.id, signMethod);
        }
    }

    public static boolean isMember(String value) {
        for (String userField : map.keySet())
            if (userField.equals(value))
                return true;
        return false;
    }
}