package com.imcode.imcms.addon.imsurvey.listeners;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.name.Names;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.addon.imsurvey.services.ClientDetailsService;
import com.imcode.imcms.addon.imsurvey.services.RightsChecker;
import com.imcode.imcms.addon.imsurvey.services.RightsCheckerImpl;
import com.imcode.imcms.addon.imsurvey.services.StaticClientDetailServiceImpl;
import com.imcode.imcms.addon.imsurvey.utils.ImSurveyUtils;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import java.io.IOException;
import java.util.Properties;

public class StartupListener implements ServletContextListener {

    @Override
    public void contextInitialized(final ServletContextEvent servletContextEvent) {
        Injector injector = Guice.createInjector(new AbstractModule() {
            @Override
            protected void configure() {
                bindConstant().annotatedWith(Names.named("propertiesPath"))
                        .to(servletContextEvent.getServletContext().getRealPath("/WEB-INF/conf/server.properties"));
                bind(ClientDetailsService.class).to(StaticClientDetailServiceImpl.class);
                bind(RightsChecker.class).to(RightsCheckerImpl.class);
            }
        });

        injector.getInstance(ImSurveyUtils.class);

        Properties props = new Properties();
        try {
            //Getting server properties to get Oneflow API params
            props.load(servletContextEvent.getServletContext().getResourceAsStream("/WEB-INF/conf/server.properties"));
            SystemProperties.ONEFLOW_BASE_URL = props.getProperty("OneflowBaseURL");
            SystemProperties.ONEFLOW_SECURITY_TOKEN = props.getProperty("OneflowSecurityToken");
            SystemProperties.ONEFLOW_CURRENT_POSITION = props.getProperty("OneflowCurrentPosition");
            SystemProperties.ONEFLOW_SYSTEM_POSITION = props.getProperty("OneflowSystemPosition");
            SystemProperties.ONEFLOW_CREATOR_POSITION = props.getProperty("OneflowCreatorPosition");
            SystemProperties.ONEFLOW_CREATOR_TYPE = props.getProperty("OneflowCreatorType");
            SystemProperties.currentAPI = Utils.getAPI(props.getProperty("ActiveAPI"));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {

    }
}
