/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.services;

import com.google.inject.Singleton;
import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.addon.imsurvey.services.ClientDetailsService;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class SessionClientDetailsServiceImpl
implements ClientDetailsService {
    public static final String SESSION_ATTRIBUTE_NAME = "com.imcode.imcms.addon.imsurvey.client";

    @Override
    public User getClient(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = cms.getUserService();
        String clientName = (String)request.getSession().getAttribute(SESSION_ATTRIBUTE_NAME);
        return userService.getUser(clientName);
    }

    @Override
    public TextDocument getClientDoc(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService ds = cms.getDocumentService();
        String clientName = (String)request.getSession().getAttribute(SESSION_ATTRIBUTE_NAME);
        return ds.getTextDocument(clientName);
    }

    @Override
    public Category getCategory(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
        DocumentService ds = cms.getDocumentService();
        CategoryType clientCategoryType = Utils.getClientCategoryType(ds);
        String clientName = (String)request.getSession().getAttribute(SESSION_ATTRIBUTE_NAME);
        return ds.getCategory(clientCategoryType, clientName);
    }

    @Override
    public String getClientTitle(HttpServletRequest request) {
        TextDocument doc = this.getClientDoc(request);
        if (doc == null) {
            return "";
        }
        return doc.getTextField(95).getHtmlFormattedText();
    }

    @Override
    public String getClientDescription(HttpServletRequest request) {
        TextDocument doc = this.getClientDoc(request);
        if (doc == null) {
            return "";
        }
        return doc.getTextField(96).getHtmlFormattedText();
    }
}

