package com.imcode.imcms.addon.imsurvey;

/* *******************************************************************************************
 *         CLASS - ImcmsGuiTabs - Generates tabs for the imCMS-admin GUI                     *
 ******************************************************************************************* */

public class ImcmsGuiTabs {
	
	private ImcmsGuiTab[] tabs ;
	private static String IMG_PATH_NO_CONTEXTPATH = "/imcms/swe/images/admin/tabs/" ;
	private String IMG_PATH ;
	private String metaId ;
	private static String COLOR_ACT   = "#f5f5f7" ;
	private static String COLOR_INACT = "#4076ad" ;
	
	public ImcmsGuiTabs(String metaId, ImcmsGuiTab[] tabs, String contextPath) {
		this.metaId = metaId ;
		this.tabs = tabs;
		IMG_PATH  = contextPath + IMG_PATH_NO_CONTEXTPATH ;
	}
	
	public String getTabs( int actTabIdx ) {
		StringBuilder retVal = new StringBuilder();
		if (tabs != null && tabs.length > 0) {

			retVal.append("<a href=\"").append(tabs[0].getTabHref()).append("\" class=\"item0 ").append(actTabIdx == 0 ? "act" : "").append("\">").append(tabs[0].getTabText()).append("</a>");
			for(int i = 1; i < tabs.length; i++){
				retVal.append("<a href=\"").append(tabs[i].getTabHref()).append("\" class=\"").append(actTabIdx == i ? "act" : "").append("\">").append(tabs[i].getTabText()).append("</a>");
			}
		//	retVal += createNavBar("", "", "START"  , false, (actTabIdx == 0), 25) ;
		//	for (int i = 0; i < tabs.length; i++) {
		//		boolean thisAct     = (i == actTabIdx) ;
		//		boolean nextAct     = ((i+1) == actTabIdx) ;
		//		String leftMidRight = (i == 0) ? "L" : (i == tabs.length - 1) ? "R" : "M" ;
		 //   retVal += createNavBar(tabs[i].getTabText(), tabs[i].getTabHref(), leftMidRight, thisAct , nextAct, 0) ;

		//	}
		//  retVal += createNavBar("", "", "END", false, false, 0) ;
		}
		return retVal.toString().replaceAll("#META_ID#", metaId) ;
	}
	
	private String createNavBar( String text, String url, String pos, boolean thisAct, boolean nextAct, int width) {
		String sRet, topImg, midRightImg, sClass, sEvent ;
		int btnH, totH, row1height, row2height, midRightImgW, itype ;
		pos = pos.toUpperCase() ;
		itype = 2 ; // all grey
		if (width <= 0) { // ***** width depends on text-length if 0
			width = (text.length() * 7) + 30 ;
		}
		btnH = 20 ;
		totH = btnH ;
		if (url.length() > 0) { // && !thisAct
			text = "<a href=\"" + url + "\">" + text + "</a>" ;
			sEvent = " onclick=\"document.location = '" + url + "';\"" ;
		} else {
			text = "<span style=\"cursor:default; color:#bbbbbb;\">" + text + "</span>" ;
			sEvent = "" ;
		}
		midRightImgW = 5 ;
		if (thisAct) {
			row1height = 1 ;
			topImg = "1x1_ffffff.gif" ;
			sClass = "NavBtnTextAct" ;
			if (pos.equals("R")) {
				midRightImg = "nav_right_act" + itype + ".gif" ;
				midRightImgW = 3 ;
			} else {
				midRightImg = "nav_mid_act_inact" + itype + ".gif" ;
			}
		} else {
			row1height = 3 ;
			topImg = "nav_top_line.gif" ;
			sClass = "NavBtnTextInact" ;
			if (pos.equals("R")) {
				midRightImg = "nav_right_inact" + itype + ".gif" ;
				midRightImgW = 3 ;
			} else {
				if (nextAct) {
					midRightImg = "nav_mid_inact_act" + itype + ".gif" ;
				} else {
					midRightImg = "nav_mid_inact_inact" + itype + ".gif" ;
				}
			}
		}
		row2height = btnH - row1height ;
		sRet = "" ;
		if (pos.equals("START")) {
			sRet += "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:100%; background-image:url(" + IMG_PATH + "nav_bg_line" + itype + ".gif);\">\n" ;
			sRet += "<tr>\n" ;
			sRet += "	<td>\n" ;
			sRet += "	<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n" ;
			sRet += "	<tr>\n" ;
			if (width > 0) {
				sRet += "		<td><img src=\"" + IMG_PATH + "1x1.gif\" width=\"" + width + "\" height=\"1\" alt=\"\"></td>\n" ;
			}
		}
		if (!pos.equals("START") && !pos.equals("END")) {
			sRet += "		<td>\n" ;
			sRet += "		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"height:" + totH + "px;\">\n" ;
			sRet += "		<tr>\n" ;
			if (pos.equals("L") && thisAct) {
				sRet += "			<td rowspan=\"2\"><img src=\"" + IMG_PATH + "nav_left_act" + itype + ".gif\" width=\"5\" height=\"" + totH + "\" alt=\"\"></td>\n" ;
			} else if (pos.equals("L")) {
				sRet += "			<td rowspan=\"2\"><img src=\"" + IMG_PATH + "nav_left_inact" + itype + ".gif\" width=\"5\" height=\"" + totH + "\" alt=\"\"></td>\n" ;
			}
			sRet += "			<td height=\"" + row1height + "\"><img src=\"" + IMG_PATH + topImg + "\" width=\"" + width + "\" height=\"" + row1height + "\" alt=\"\"></td>\n" ;
			sRet += "			<td rowspan=\"2\"><img src=\"" + IMG_PATH + midRightImg + "\" width=\"" + midRightImgW + "\" height=\"" + totH + "\" alt=\"\"></td>\n" ;
			sRet += "		</tr>\n" ;
			sRet += "		<tr>\n" ;
			sRet += "			<td height=\"" + row2height + "\" align=\"center\" bgcolor=\"" + (thisAct ? COLOR_ACT : COLOR_INACT) + "\" class=\"" + sClass + "\"" + sEvent + ">" ;
			sRet +=      "<span class=\"" + sClass + "\">" + text + "</span></td>\n" ;
			sRet += "		</tr>\n" ;
			sRet += "		</table></td>\n" ;
		}
		if (pos.equals("END")) {
			sRet += "	</tr>\n" ;
			sRet += "	</table></td>\n" ;
			sRet += "	<td><img src=\"" + IMG_PATH + "1x1.gif\" width=\"1\" height=\"1\" alt=\"\"></td>\n" ;
			sRet += "</tr>\n" ;
			sRet += "</table>" ;
		}
		return sRet ;
	}

}
