/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.services;

import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.addon.imsurvey.services.RightsChecker;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import javax.servlet.ServletRequest;

public class RightsCheckerImpl
implements RightsChecker {
    @Override
    public boolean userCanAdminSurvey(Document doc, User user, ServletRequest request) {
        ContentManagementSystem imcmsSystem = ContentManagementSystem.fromRequest((ServletRequest)request);
        UserService userService = imcmsSystem.getUserService();
        if (user == null || user.isDefaultUser()) {
            return false;
        }
        if (user.isSuperAdmin()) {
            return true;
        }
        try {
            if (doc.getPublisher().getId() == user.getId()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String client = "";
        try {
            DocumentService documentService = imcmsSystem.getDocumentService();
            CategoryType clientCategoryType = Utils.getClientCategoryType(documentService);
            Category clientCategory = doc.getCategoriesOfType(clientCategoryType)[0];
            client = clientCategory.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (client.isEmpty() || client.equalsIgnoreCase(user.getCompany())) {
            return user.hasRole(Utils.getClientAdminRole(userService)) || user.hasRole(Utils.getServiceAdminRole(userService));
        }
        return false;
    }
}

