/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.addon.imsurvey.oneflow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.oneflow.DeliveryChannel;
import com.imcode.imcms.addon.imsurvey.oneflow.Document;
import com.imcode.imcms.addon.imsurvey.oneflow.Field;
import com.imcode.imcms.addon.imsurvey.oneflow.OneflowParticipant;
import com.imcode.imcms.addon.imsurvey.oneflow.SignMethod;
import com.imcode.imcms.addon.imsurvey.oneflow.UserField;
import com.imcode.imcms.addon.imsurvey.utils.OneflowFields;
import com.imcode.imcms.api.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OneflowService {
    private static final Logger log = Logger.getLogger(OneflowService.class);
    private static final int FAILURE_HTTP_RESPONSE_CODE = 390;
    private static final OneflowService instance = new OneflowService();
    private Map<String, Document> templateCache = new HashMap<String, Document>();
    private Map<String, Document> templateGroupFieldCache = new HashMap<String, Document>();
    private Map<String, Document> templateGroupCache = new HashMap<String, Document>();
    private Map<String, List<Field>> templateFieldCache = new HashMap<String, List<Field>>();
    private boolean isSwappedToEmail = false;

    private OneflowService() {
    }

    public static OneflowService getInstance() {
        return instance;
    }

    public boolean isSurveyInSyncWithOneflow(int surveyId, DatabaseService databaseService) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDocumentURI(String signSuccessUrl, String templateId, Map<String, String> props, HttpServletRequest request) throws Exception {
        JsonPrimitive id;
        Integer agreementId;
        if (props.containsKey("imSurveyId")) {
            try {
                props.remove("imSurveyId");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (templateId == null || templateId.length() <= 4) {
            throw new IllegalArgumentException("Oneflow template id is either missing or invalid: " + templateId);
        }
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + templateId, "GET");
        int responseCode = connection.getResponseCode();
        boolean parserError = false;
        long docId = 0L;
        JsonObject fetchedAgreement = null;
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + templateId + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (parsedReturn != null && parsedReturn.isJsonObject()) {
            fetchedAgreement = parsedReturn.getAsJsonObject();
            JsonObject id2 = fetchedAgreement.getAsJsonObject("template_group");
            docId = id2.getAsJsonPrimitive("id").getAsLong();
        } else {
            parserError = true;
        }
        if (parserError) {
            throw new Exception("Error template has changed! Can't create document.");
        }
        if (docId <= 0L) return null;
        String urlParameters = fetchedAgreement.toString();
        JsonObject contract = this.buildContract(templateId, props);
        connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
        OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
        streamWriter.write(contract.toString());
        streamWriter.close();
        responseCode = connection.getResponseCode();
        log.debug((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + ":" + responseCode + connection.getResponseMessage()));
        if (responseCode > 390) {
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + ":" + responseCode + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
            throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
        }
        JsonElement agreementResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (null != agreementResponse && agreementResponse.isJsonObject() && (agreementId = Integer.valueOf((id = agreementResponse.getAsJsonObject().getAsJsonPrimitive("id")).getAsInt())) > 0) {
            connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + agreementId + "/publish");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            JsonObject publishContent = new JsonObject();
            publishContent.addProperty("subject", "Babs Paylink - Avtal att signera");
            publishContent.addProperty("message", "Hej! <br /><br />Roligt att du vill teckna avtal med oss.<br />V&auml;nligen l&auml;s igenom och signera ditt avtal.<br /><br />Om du inte &auml;r juridisk part i detta avtal s&aring; beh&ouml;ver du inte g&ouml;ra n&aring;got mer just nu.");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            outputStreamWriter.write(publishContent.toString());
            outputStreamWriter.close();
            connection.disconnect();
            if (connection.getResponseCode() < 390) {
                log.info((Object)("Agreement with id " + agreementId + " was published: " + connection.getResponseCode() + ":" + connection.getResponseMessage()));
                DeliveryChannel deliveryChannel = this.getDeliveryChannelFromContract(contract, 1);
                if (null == deliveryChannel) {
                    log.error((Object)("Can't obtain delivery method for agreement: " + agreementId));
                    connection.disconnect();
                    throw new IOException("Can't obtain delivery method for agreement: " + agreementId);
                }
                if (deliveryChannel != DeliveryChannel.NONE && !this.isSwappedToEmail) return signSuccessUrl;
                JsonElement publishResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                if (publishResponse.isJsonObject()) {
                    String participantId = this.getParticipantId(publishResponse.getAsJsonObject());
                    String userToken = this.getUserToken(agreementId.toString(), participantId);
                    if (!userToken.isEmpty()) {
                        log.debug((Object)("Agreement id:" + agreementId + "\t Participant id: " + participantId + "\t User token:" + userToken));
                        return "/contracts/" + agreementId + "/at/" + userToken;
                    }
                }
            } else {
                log.error((Object)("Agreement with id " + agreementId + " wasn't published: " + connection.getResponseCode() + ":" + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
                connection.disconnect();
                throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
            }
        }
        connection.disconnect();
        return null;
    }

    private JsonObject buildContract(String templateId, Map<String, String> props) {
        JsonObject contract = new JsonObject();
        contract.addProperty("template_id", (Number)Integer.valueOf(templateId));
        JsonArray parties = new JsonArray();
        JsonObject party = new JsonObject();
        party.addProperty("self", (Number)1);
        JsonArray participants = new JsonArray();
        JsonObject participant = new JsonObject();
        participant.addProperty("position_id", (Number)Integer.parseInt(SystemProperties.ONEFLOW_CREATOR_POSITION));
        participant.addProperty("type", (Number)Integer.parseInt(SystemProperties.ONEFLOW_CREATOR_TYPE));
        participants.add((JsonElement)participant);
        party.add("participants", (JsonElement)participants);
        parties.add((JsonElement)party);
        ArrayList<OneflowParticipant> participantsData = new ArrayList<OneflowParticipant>();
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (entry.getValue().isEmpty() || !entry.getKey().matches("user_[0-9]+_.+")) continue;
            String[] splittedData = entry.getKey().split("user_");
            String userId = splittedData[1].substring(0, splittedData[1].indexOf(95));
            String string = splittedData[1].substring(splittedData[1].indexOf(95) + 1);
            if (!userId.isEmpty() && !string.isEmpty()) {
                OneflowParticipant oneflowParticipant = null;
                boolean isNew = true;
                for (OneflowParticipant op : participantsData) {
                    if (!op.getId().equals(userId)) continue;
                    oneflowParticipant = op;
                    isNew = false;
                }
                if (oneflowParticipant == null) {
                    oneflowParticipant = new OneflowParticipant(userId);
                }
                if (UserField.isMember(string.toLowerCase())) {
                    UserField userField = UserField.valueOf(string.toUpperCase());
                    if (userField.equals((Object)UserField.DELIVERY_CHANNEL)) {
                        oneflowParticipant.addValues(userField, String.valueOf((Object)DeliveryChannel.valueOf(entry.getValue())));
                    }
                    if (userField.equals((Object)UserField.SIGN_METHOD)) {
                        oneflowParticipant.addValues(userField, String.valueOf((Object)SignMethod.valueOf(entry.getValue())));
                    } else {
                        oneflowParticipant.addValues(userField, entry.getValue());
                    }
                }
                if (isNew) {
                    participantsData.add(oneflowParticipant);
                }
            }
            it.remove();
        }
        Collections.sort(participantsData);
        for (OneflowParticipant entity : participantsData) {
            JsonObject partyClient = new JsonObject();
            participants = new JsonArray();
            participant = new JsonObject();
            for (Map.Entry entry : entity.getValues().entrySet()) {
                String value = (String)entry.getValue();
                Integer intValue = null;
                if (((Enum)entry.getKey()).equals((Object)UserField.NAME) || ((Enum)entry.getKey()).equals((Object)UserField.COUNTRY) || ((Enum)entry.getKey()).equals((Object)UserField.ORGNR)) {
                    partyClient.addProperty(((UserField)((Object)entry.getKey())).getValue(), (String)entry.getValue());
                    continue;
                }
                if (((Enum)entry.getKey()).equals((Object)UserField.DELIVERY_CHANNEL) && DeliveryChannel.isMember((String)entry.getValue())) {
                    if (DeliveryChannel.valueOf(value) == DeliveryChannel.NONE) {
                        intValue = DeliveryChannel.EMAIL.getValue();
                        this.isSwappedToEmail = true;
                    } else {
                        intValue = DeliveryChannel.valueOf(value).getValue();
                    }
                }
                if (((Enum)entry.getKey()).equals((Object)UserField.SIGN_METHOD) && SignMethod.isMember((String)entry.getValue())) {
                    intValue = SignMethod.valueOf(value).getValue();
                }
                if (((Enum)entry.getKey()).equals((Object)UserField.TYPE)) {
                    intValue = Integer.parseInt(value);
                }
                if (intValue != null && (((Enum)entry.getKey()).equals((Object)UserField.DELIVERY_CHANNEL) || ((Enum)entry.getKey()).equals((Object)UserField.SIGN_METHOD) || ((Enum)entry.getKey()).equals((Object)UserField.TYPE))) {
                    participant.addProperty(((UserField)((Object)entry.getKey())).getValue(), (Number)intValue);
                    continue;
                }
                participant.addProperty(((UserField)((Object)entry.getKey())).getValue(), value);
            }
            JsonElement tmpName = participant.get(UserField.FULLNAME.getValue());
            JsonElement jsonElement = participant.get(UserField.EMAIL.getValue());
            if (null == tmpName || tmpName.getAsString().isEmpty() || null == jsonElement || jsonElement.getAsString().isEmpty()) continue;
            participants.add((JsonElement)participant);
            partyClient.add("participants", (JsonElement)participants);
            parties.add((JsonElement)partyClient);
        }
        contract.add("parties", (JsonElement)parties);
        JsonArray dataList = new JsonArray();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            JsonObject dataItem = new JsonObject();
            dataItem.addProperty("key", "data_field");
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("external_key", entry.getKey());
            jsonObject.addProperty("value", entry.getValue());
            dataItem.add("value", (JsonElement)jsonObject);
            dataList.add((JsonElement)dataItem);
        }
        contract.add("data", (JsonElement)dataList);
        log.info((Object)("contract:" + contract));
        return contract;
    }

    private String getUserToken(String agreementId, String userId) throws IOException {
        JsonObject tokenBody = new JsonObject();
        tokenBody.addProperty("type", "form");
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + agreementId + "/participants/" + userId + "/tokens");
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
        streamWriter.write(tokenBody.toString());
        streamWriter.close();
        int responseCode = connection.getResponseCode();
        log.debug((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + agreementId + "/participants/" + userId + "/tokens :" + responseCode + connection.getResponseMessage()));
        if (responseCode > 390) {
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + agreementId + "/participants/" + userId + "/tokens :" + responseCode + connection.getResponseMessage() + "\n" + IOUtils.toString((InputStream)connection.getErrorStream())));
            throw new IOException(IOUtils.toString((InputStream)connection.getErrorStream()));
        }
        String tokenValue = "";
        JsonElement tokenResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (tokenResponse.isJsonObject()) {
            JsonPrimitive token = tokenResponse.getAsJsonObject().getAsJsonPrimitive("token");
            tokenValue = token.getAsString();
        }
        return tokenValue;
    }

    private String getParticipantId(JsonObject publishedAgreementResponse) {
        String participantId = "";
        JsonArray parties = publishedAgreementResponse.getAsJsonArray("parties");
        if (null != parties) {
            for (JsonElement tmpParty : parties) {
                JsonObject participant;
                JsonObject party = tmpParty.getAsJsonObject();
                if (null != party.get("self") || (participant = party.getAsJsonArray("participants").get(0).getAsJsonObject()).get("type").getAsInt() != 1) continue;
                JsonElement idElement = participant.get("id");
                participantId = idElement.getAsString();
            }
        }
        return participantId;
    }

    private DeliveryChannel getDeliveryChannelFromContract(JsonObject contract, Integer participantNumber) {
        JsonObject userParty = contract.getAsJsonArray("parties").get(participantNumber.intValue()).getAsJsonObject();
        JsonObject userData = userParty.getAsJsonArray("participants").get(0).getAsJsonObject();
        JsonElement deliveryChannel = userData.get(UserField.DELIVERY_CHANNEL.getValue());
        if (null == deliveryChannel) {
            for (JsonElement party : contract.getAsJsonArray("parties")) {
                JsonObject tmpUserData = party.getAsJsonObject().getAsJsonArray("participants").get(0).getAsJsonObject();
                deliveryChannel = tmpUserData.get(UserField.DELIVERY_CHANNEL.getValue());
                if (null == deliveryChannel) continue;
                DeliveryChannel.valueOf(deliveryChannel.getAsInt());
            }
        }
        return DeliveryChannel.valueOf(deliveryChannel.getAsInt());
    }

    public List<SignMethod> getAvailableSignMethods(String id) throws IOException {
        JsonArray signMethods;
        JsonObject optionsElem;
        ArrayList<SignMethod> availableMethods = new ArrayList<SignMethod>();
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + ":" + responseCode + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement signMethodsResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (signMethodsResponse.isJsonObject() && null != (optionsElem = signMethodsResponse.getAsJsonObject().getAsJsonObject("available_options")) && null != (signMethods = optionsElem.getAsJsonArray("sign_methods"))) {
            for (JsonElement signMethod : signMethods) {
                SignMethod method = SignMethod.valueOf(signMethod.getAsInt());
                if (null == method) continue;
                availableMethods.add(method);
            }
        }
        return availableMethods;
    }

    public List<DeliveryChannel> getAvailableDeliveryChannels(String id) throws IOException {
        JsonArray deliveryChannels;
        JsonObject optionsElem;
        ArrayList<DeliveryChannel> availableDeliveries = new ArrayList<DeliveryChannel>();
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + id + ":" + responseCode + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement deliveryChannelResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (deliveryChannelResponse.isJsonObject() && null != (optionsElem = deliveryChannelResponse.getAsJsonObject().getAsJsonObject("available_options")) && null != (deliveryChannels = optionsElem.getAsJsonArray("delivery_channels"))) {
            for (JsonElement deliveryChannel : deliveryChannels) {
                DeliveryChannel channel = DeliveryChannel.valueOf(deliveryChannel.getAsInt());
                if (null == channel) continue;
                availableDeliveries.add(channel);
            }
        }
        return availableDeliveries;
    }

    public List<Document> getTemplates() throws IOException {
        JsonArray templateListElem;
        ArrayList<Document> templates = new ArrayList<Document>();
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/ext/templategroups/", "GET", true);
        if (connection.getResponseCode() > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/ext/templategroups/" + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement templateGroupsResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (templateGroupsResponse.isJsonObject() && null != (templateListElem = templateGroupsResponse.getAsJsonObject().getAsJsonArray("collection"))) {
            for (JsonElement templateElem : templateListElem) {
                if (null == templateElem || !templateElem.isJsonObject()) continue;
                JsonObject templateObj = templateElem.getAsJsonObject();
                JsonPrimitive title = templateObj.getAsJsonPrimitive("name");
                JsonPrimitive templateId = templateObj.getAsJsonPrimitive("id");
                if (null == templateId || null == title) continue;
                Document template = new Document();
                template.setId(templateId.getAsString());
                template.setTitle(title.getAsString());
                JsonObject templateFieldObj = templateObj.getAsJsonObject("data_field_set");
                if (null != templateFieldObj) {
                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive("id");
                    template.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                }
                templates.add(template);
            }
        }
        return templates;
    }

    public Document getDocument(String id) throws IOException {
        Document document = null;
        HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + id, "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;
        }
        if (responseCode > 390) {
            String error = IOUtils.toString((InputStream)connection.getErrorStream());
            connection.disconnect();
            log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/agreements/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
            throw new IOException(error);
        }
        JsonElement parsedReturn = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        connection.disconnect();
        if (parsedReturn.isJsonObject()) {
            document = this.parseDocument(parsedReturn);
            document.setFields(this.getTemplateFields(id));
        }
        return document;
    }

    public Document getTemplateGroup(String id) throws IOException {
        Document templateGroup;
        if (this.templateGroupCache.get(id) != null) {
            templateGroup = this.templateGroupCache.get(id);
        } else {
            templateGroup = new Document();
            HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/ext/templategroups/" + id, "GET", true);
            if (connection.getResponseCode() > 390) {
                String error = IOUtils.toString((InputStream)connection.getErrorStream());
                connection.disconnect();
                log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/ext/templategroups/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
                throw new IOException(error);
            }
            JsonElement templateGroupResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            connection.disconnect();
            if (templateGroupResponse.isJsonObject() && null != templateGroupResponse) {
                JsonObject templateGroupObj = templateGroupResponse.getAsJsonObject();
                JsonPrimitive title = templateGroupObj.getAsJsonPrimitive("name");
                JsonPrimitive templateGroupId = templateGroupObj.getAsJsonPrimitive("id");
                if (null != templateGroupId && null != title) {
                    templateGroup.setId(templateGroupId.getAsString());
                    templateGroup.setTitle(title.getAsString());
                    JsonObject fieldSetObj = templateGroupObj.getAsJsonObject("data_field_set");
                    if (null != fieldSetObj) {
                        JsonPrimitive fieldSetId = fieldSetObj.getAsJsonPrimitive("id");
                        templateGroup.setFields(this.getTemplateFields(fieldSetId.getAsString()));
                    }
                }
            }
            this.templateGroupCache.put(id, templateGroup);
        }
        return templateGroup;
    }

    public Document getTemplatesInGroupAsFields(String id) throws IOException {
        Document templateGroup;
        if (this.templateGroupFieldCache.get(id) != null) {
            templateGroup = this.templateGroupFieldCache.get(id);
        } else {
            JsonArray templateGroupCollection;
            templateGroup = this.getTemplateGroup(id);
            HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/templates/?template_group_id=" + id, "GET", true);
            if (connection.getResponseCode() > 390) {
                String error = IOUtils.toString((InputStream)connection.getErrorStream());
                connection.disconnect();
                log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/ext/templategroups/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
                throw new IOException(error);
            }
            JsonElement templateGroupResponse = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            connection.disconnect();
            if (null != templateGroupResponse && templateGroupResponse.isJsonObject() && null != (templateGroupCollection = templateGroupResponse.getAsJsonObject().getAsJsonArray("collection"))) {
                ArrayList<Field> templateList = new ArrayList<Field>();
                for (JsonElement templateElem : templateGroupCollection) {
                    JsonPrimitive templateId;
                    if (null == templateElem || !templateElem.isJsonObject()) continue;
                    JsonPrimitive name = templateElem.getAsJsonObject().getAsJsonPrimitive("name");
                    JsonObject agreementElem = templateElem.getAsJsonObject().getAsJsonObject("agreement");
                    if (null == agreementElem || null == (templateId = agreementElem.getAsJsonPrimitive("id")) || null == name) continue;
                    templateList.add(new Field(Field.Type.TEMPLATE, name.getAsString(), templateId.getAsString()));
                }
                templateGroup.setFields(templateList);
            }
            this.templateGroupFieldCache.put(id, templateGroup);
        }
        return templateGroup;
    }

    private List<Field> getTemplateFields(String id) throws IOException {
        LinkedList<Field> fields;
        if (this.templateFieldCache.get(id) != null) {
            fields = this.templateFieldCache.get(id);
        } else {
            JsonArray templateListElem;
            fields = new LinkedList();
            HttpURLConnection connection = this.getHttpURLConnection(SystemProperties.ONEFLOW_BASE_URL + "/api/data_field_sets/" + id + "/fields/", "GET", true);
            connection.setRequestProperty("Content-Type", "text/plain");
            int responseCode = connection.getResponseCode();
            if (responseCode == 404) {
                connection.disconnect();
                return null;
            }
            if (responseCode > 390) {
                String error = IOUtils.toString((InputStream)connection.getErrorStream());
                connection.disconnect();
                log.error((Object)(SystemProperties.ONEFLOW_BASE_URL + "/api/data_field_sets/" + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error));
                throw new IOException(error);
            }
            JsonElement agreementsFields = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            connection.disconnect();
            if (null != agreementsFields && agreementsFields.isJsonArray() && null != (templateListElem = agreementsFields.getAsJsonArray())) {
                for (JsonElement templateElem : templateListElem) {
                    JsonObject templateObj = templateElem.getAsJsonObject();
                    JsonPrimitive name = templateObj.getAsJsonPrimitive("name");
                    JsonPrimitive externalKey = templateObj.getAsJsonPrimitive("external_key");
                    if (null == name || null == externalKey) continue;
                    fields.add(new Field(Field.Type.TEXT, name.getAsString(), externalKey.getAsString()));
                }
            }
            this.templateFieldCache.put(id, fields);
        }
        return fields;
    }

    private Document parseDocument(JsonElement documentElement) {
        Document document = null;
        if (documentElement.isJsonObject()) {
            JsonPrimitive titleElem;
            document = new Document();
            JsonObject jsonObject = documentElement.getAsJsonObject();
            JsonPrimitive idElem = jsonObject.getAsJsonPrimitive("id");
            if (idElem != null) {
                document.setId(idElem.getAsString());
            }
            if ((titleElem = jsonObject.getAsJsonPrimitive("name")) != null) {
                document.setTitle(titleElem.getAsString());
            }
        }
        return document;
    }

    private HttpURLConnection getHttpURLConnection(String callUrl) throws IOException {
        return this.getHttpURLConnection(callUrl, "POST");
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method) throws IOException {
        return this.getHttpURLConnection(callUrl, method, false);
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method, boolean isSystemCall) throws IOException {
        URL url = new URL(callUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("X-Flow-API-Token", SystemProperties.ONEFLOW_SECURITY_TOKEN);
        connection.addRequestProperty("X-Flow-Current-Position", isSystemCall ? SystemProperties.ONEFLOW_SYSTEM_POSITION : SystemProperties.ONEFLOW_CURRENT_POSITION);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("charset", "utf-8");
        connection.setUseCaches(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementOptionTemplateFields(int optionId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> optionFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_OPTIONS_TEMPLATE_FIELDS);
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                Document template;
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                if (this.templateCache.get(templateId) != null) {
                    template = this.templateCache.get(templateId);
                } else {
                    this.templateCache.put(templateId, this.getTemplateGroup(templateId));
                    template = this.templateCache.get(templateId);
                }
                if (template == null) continue;
                List<Field> fields = (ArrayList<Field>)optionFields.get(template);
                if (fieldName.matches("user_[0-9]+_.+")) {
                    if (fields == null) {
                        fields = new ArrayList<Field>();
                        optionFields.put(template, fields);
                    }
                    fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, UserField.DELIVERY_CHANNEL.name(), UserField.DELIVERY_CHANNEL.name().toUpperCase()));
                    template.getFields().add(new Field(Field.Type.CHECKBOX, UserField.SIGN_METHOD.name(), UserField.SIGN_METHOD.name().toUpperCase()));
                    continue;
                }
                for (Field field : template.getFields()) {
                    fields = (List)optionFields.get(template);
                    if (!field.getName().equals(fieldName)) continue;
                    if (fields == null) {
                        fields = new ArrayList();
                        optionFields.put(template, fields);
                    }
                    fields.add(field);
                }
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return optionFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Document, List<Field>> getElementTemplateFields(int elementId, DatabaseService databaseService) throws IOException {
        HashMap<Document, List<Field>> templateFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_TEMPLATE_FIELDS);
            ps.setInt(1, elementId);
            rs = ps.executeQuery();
            while (rs.next()) {
                Document template;
                String templateId = rs.getString("template_id");
                String fieldName = rs.getString("field_name");
                if (this.templateCache.get(templateId) != null) {
                    template = this.templateCache.get(templateId);
                } else {
                    this.templateCache.put(templateId, this.getTemplateGroup(templateId));
                    template = this.templateCache.get(templateId);
                }
                if (template == null) continue;
                ArrayList<Field> fields = (ArrayList<Field>)templateFields.get(template);
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                if (fieldName.matches("[0-9]+")) {
                    List<Field> allFields = template.getFields();
                    List<Field> newFields = this.getTemplatesInGroupAsFields(templateId).getFields();
                    for (Field newField : newFields) {
                        if (allFields.contains(newField)) continue;
                        allFields.add(newField);
                    }
                    template.setFields(allFields);
                    fields.add(new Field(Field.Type.TEMPLATE, templateId, fieldName));
                }
                if (fieldName.matches("user_[0-9]+_.+")) {
                    Pattern fieldPattern = Pattern.compile("_([0-9]+)_(.+)");
                    Matcher matcher = fieldPattern.matcher(fieldName);
                    if (matcher.find()) {
                        fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                    }
                } else {
                    for (Field field : template.getFields()) {
                        if (!field.getName().equals(fieldName)) continue;
                        fields.add(field);
                    }
                }
                templateFields.put(template, fields);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getTemplateUsers(int surveyId, DatabaseService databaseService) {
        ArrayList<Field> templateFields = new ArrayList<Field>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_TEMPLATE_USERS);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String userId = rs.getString("id");
                String fieldName = rs.getString("el_text");
                if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)fieldName)) continue;
                templateFields.add(new Field(Field.Type.USER, fieldName, userId));
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return templateFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserElementIdByMetaId(int surveyId, DatabaseService databaseService) {
        String elId = "";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_ID_BY_META_ID);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                elId = rs.getString("id");
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection, ps, rs);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection, (Statement)ps, rs);
        }
        DbUtils.closeQuietly((Connection)connection, (Statement)ps, (ResultSet)rs);
        return elId;
    }

    public String getSignatureFormURL(String backToSiteURL, String templateId, Map<String, String> oneflowParams, HttpServletRequest request) throws Exception {
        String oneflowDocumentURI = this.getDocumentURI(backToSiteURL, templateId, oneflowParams, request);
        if (oneflowDocumentURI == null) {
            return null;
        }
        return SystemProperties.ONEFLOW_BASE_URL + oneflowDocumentURI;
    }
}

