package com.imcode.imcms.addon.imsurvey;

import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.api.TextDocument;
import org.apache.commons.lang.StringUtils;

/**
 * Created by IntelliJ IDEA.
 * User: tomull
 * Date: 2008-jan-18
 */

public class FormEngine {

	private int metaId ;
	private DBUtil dbUtil ;
	Object[] parameters ;
	public static String TABLE_PREFIX = "_imsurvey_" ; // "0_" or "_"
	public static String SESSION_PARAM_PREVIEW_PREFIX = "PREVIEW_COPY_" ;

	public FormEngine(TextDocument thisDoc, DBUtil dbUtil) {
		this.metaId = thisDoc.getId() ;
		this.dbUtil = dbUtil ;
	}

	public FormEngineSettings getSettings() {

		FormEngineSettings fes = new FormEngineSettings() ;
		String data ;

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_BUTTON_SEND } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setButtonSend(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_BUTTON_RESET } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setButtonReset(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_BUTTON_PREVIOUS} ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setButton_previous(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_BUTTON_NEXT } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setButton_next(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_TO } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailTo(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_FROM } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailFrom(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailFromField(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_CC } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailCc(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_BCC } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailBcc(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_SUBJECT } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailSubject(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_BODY_0 } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailBody0(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_BODY_1 } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailBody1(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_DONE } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailDone(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_ERROR } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailError(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_HEADING_FORM } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setHeadingForm(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_HEADING_SENT } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setHeadingSent(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_HEADING_ERROR } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setHeadingError(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_TEXT_FORM } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setTextForm(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_TEXT_SENT } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setTextSent(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_TEXT_ERROR } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setTextError(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_ROLE_IDS } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setRoleIds(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_spamCheckActive } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setSpamCheckActive(!StringUtils.defaultString(data).equals("false"));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_VALIDATION_CODE } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setValidationCode(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_VALIDATION_ON_SUBMIT } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setValidationOnSubmit(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_REQUIRE_LOGIN } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setRequireLogin(StringUtils.defaultString(data).equals("true"));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_IMAGE_FOLDER } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setImageFolder(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_LOGGING_ACTIVE } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setLoggingActive(!StringUtils.defaultString(data).equals("false"));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_SEND_COPY } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setSendCopy(StringUtils.defaultString(data).equals("true"));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_SHOW_COPY } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setShowCopy(StringUtils.defaultString(data).equals("true"));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_SUBJECT_COPY } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailSubjectCopy(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MAIL_BODY_COPY } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMailBodyCopy(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_TAB_COUNT } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setTabCount(Integer.parseInt(StringUtils.defaultIfEmpty(data, "0")));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_tabChangeAllow } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setTabChangeAllow(!StringUtils.defaultString(data).equals("false"));

		for(int i=0;i<20;i++){
			parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_tabText + i } ;
			data = dbUtil.sqlQueryStr(
						"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
			fes.setTabText(i, StringUtils.defaultString(data));
		}

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_tabEffect } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setTabEffect(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_CSS } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setCSS(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_COMMERCIALTEXT} ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setCommercial_text(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_PRETEXT} ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setPre_text(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_POSTTEXT} ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setPost_text(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_REMINDER_EMAILMESSAGE } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setReminder_emailmessage(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_REMINDER_SMSMESSAGE } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setReminder_smsmessage(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_REMINDER_EMAILSUBJECT } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setReminder_emailsubject(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_THANKS_EMAILMESSAGE } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setThanks_emailmessage(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_THANKS_SMSMESSAGE } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setThanks_smsmessage(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_THANKS_EMAILSUBJECT } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setThanks_emailsubject(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_SMS_ORIGINATOR_ADDRESS } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setSms_originator_address(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_SMS_GATEWAY_LOGIN } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setSmsgateway_login(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_SMS_GATEWAY_PASSWORD } ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setSmsgateway_password(StringUtils.defaultString(data));

		parameters = new Integer[] { metaId, FormEngineSettings.SETTINGS_ID_MOBILE_CSS} ;
		data = dbUtil.sqlQueryStr(
					"SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters) ;
		fes.setMobileCss(StringUtils.defaultString(data));

        parameters = new Integer[] {metaId, FormEngineSettings.SETTINGS_ID_SCRIVE_OUT_OF_SYNC_SUBJECT};
        data = dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters);
        fes.setScriveOutOfSyncSubject(StringUtils.defaultString(data));

        parameters = new Integer[] {metaId, FormEngineSettings.SETTINGS_ID_SCRIVE_OUT_OF_SYNC_BODY};
        data = dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", parameters);
        fes.setScriveOutOfSyncBody(StringUtils.defaultString(data));

		return fes ;
	}

	public void setFormEngineSettings( FormEngineSettings fes ) {

		parameters = new String[] { fes.getButtonSend(), metaId + "", FormEngineSettings.SETTINGS_ID_BUTTON_SEND + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_BUTTON_SEND + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getButtonReset(), metaId + "", FormEngineSettings.SETTINGS_ID_BUTTON_RESET + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_BUTTON_RESET + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getButton_previous(), metaId + "", FormEngineSettings.SETTINGS_ID_BUTTON_PREVIOUS + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_BUTTON_PREVIOUS + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getButton_next(), metaId + "", FormEngineSettings.SETTINGS_ID_BUTTON_NEXT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_BUTTON_NEXT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailTo(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_TO + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_TO + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailFrom(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_FROM + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_FROM + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailFromField(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_FROM_FIELD + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailCc(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_CC + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_CC + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailBcc(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_BCC + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_BCC + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailSubject(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_SUBJECT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_SUBJECT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailBody0(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_BODY_0 + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_BODY_0 + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailBody1(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_BODY_1 + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_BODY_1 + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailDone(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_DONE + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_DONE + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailError(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_ERROR + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_ERROR + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getHeadingForm(), metaId + "", FormEngineSettings.SETTINGS_ID_HEADING_FORM + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_HEADING_FORM + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getHeadingSent(), metaId + "", FormEngineSettings.SETTINGS_ID_HEADING_SENT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_HEADING_SENT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getHeadingError(), metaId + "", FormEngineSettings.SETTINGS_ID_HEADING_ERROR + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_HEADING_ERROR + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getTextForm(), metaId + "", FormEngineSettings.SETTINGS_ID_TEXT_FORM + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_TEXT_FORM + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getTextSent(), metaId + "", FormEngineSettings.SETTINGS_ID_TEXT_SENT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_TEXT_SENT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getTextError(), metaId + "", FormEngineSettings.SETTINGS_ID_TEXT_ERROR + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_TEXT_ERROR + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getRoleIds(), metaId + "", FormEngineSettings.SETTINGS_ID_ROLE_IDS + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_ROLE_IDS + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getSpamCheckActive() + "", metaId + "", FormEngineSettings.SETTINGS_ID_spamCheckActive + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_spamCheckActive + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getValidationCode(), metaId + "", FormEngineSettings.SETTINGS_ID_VALIDATION_CODE + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_VALIDATION_CODE + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getValidationOnSubmit(), metaId + "", FormEngineSettings.SETTINGS_ID_VALIDATION_ON_SUBMIT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_VALIDATION_ON_SUBMIT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getRequireLogin() + "", metaId + "", FormEngineSettings.SETTINGS_ID_REQUIRE_LOGIN + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_REQUIRE_LOGIN + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getImageFolder(), metaId + "", FormEngineSettings.SETTINGS_ID_IMAGE_FOLDER + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_IMAGE_FOLDER + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getLoggingActive() + "", metaId + "", FormEngineSettings.SETTINGS_ID_LOGGING_ACTIVE + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_LOGGING_ACTIVE + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getSendCopy() + "", metaId + "", FormEngineSettings.SETTINGS_ID_SEND_COPY + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_SEND_COPY + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getShowCopy() + "", metaId + "", FormEngineSettings.SETTINGS_ID_SHOW_COPY + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_SHOW_COPY + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailSubjectCopy(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_SUBJECT_COPY + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_SUBJECT_COPY + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMailBodyCopy(), metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_BODY_COPY + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MAIL_BODY_COPY + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getTabCount() + "", metaId + "", FormEngineSettings.SETTINGS_ID_TAB_COUNT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_TAB_COUNT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getTabChangeAllow() + "", metaId + "", FormEngineSettings.SETTINGS_ID_tabChangeAllow + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_tabChangeAllow + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		for(int i = 0; i<20; i++){
			parameters = new String[] { fes.getTabText(i), metaId + "", (FormEngineSettings.SETTINGS_ID_tabText + i) + "" } ;
			if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", (FormEngineSettings.SETTINGS_ID_tabText + i) + "" })) {
				dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
			} else {
				dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
			}
		}

		parameters = new String[] { fes.getTabEffect(), metaId + "", FormEngineSettings.SETTINGS_ID_tabEffect + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_tabEffect + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getCSS(), metaId + "", FormEngineSettings.SETTINGS_ID_CSS + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_CSS + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getCommercial_text(), metaId + "", FormEngineSettings.SETTINGS_ID_COMMERCIALTEXT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_COMMERCIALTEXT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getPre_text(), metaId + "", FormEngineSettings.SETTINGS_ID_PRETEXT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_PRETEXT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getPost_text(), metaId + "", FormEngineSettings.SETTINGS_ID_POSTTEXT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_POSTTEXT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getReminder_emailmessage(), metaId + "", FormEngineSettings.SETTINGS_ID_REMINDER_EMAILMESSAGE + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_REMINDER_EMAILMESSAGE + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getReminder_smsmessage(), metaId + "", FormEngineSettings.SETTINGS_ID_REMINDER_SMSMESSAGE + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_REMINDER_SMSMESSAGE + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getReminder_emailsubject(), metaId + "", FormEngineSettings.SETTINGS_ID_REMINDER_EMAILSUBJECT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_REMINDER_EMAILSUBJECT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getThanks_emailmessage(), metaId + "", FormEngineSettings.SETTINGS_ID_THANKS_EMAILMESSAGE + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_THANKS_EMAILMESSAGE + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getThanks_smsmessage(), metaId + "", FormEngineSettings.SETTINGS_ID_THANKS_SMSMESSAGE + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_THANKS_SMSMESSAGE + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getThanks_emailsubject(), metaId + "", FormEngineSettings.SETTINGS_ID_THANKS_EMAILSUBJECT + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_THANKS_EMAILSUBJECT + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getSms_originator_address(), metaId + "", FormEngineSettings.SETTINGS_ID_SMS_ORIGINATOR_ADDRESS + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_SMS_ORIGINATOR_ADDRESS + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getSmsgateway_login(), metaId + "", FormEngineSettings.SETTINGS_ID_SMS_GATEWAY_LOGIN + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_SMS_GATEWAY_LOGIN + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getSmsgateway_password(), metaId + "", FormEngineSettings.SETTINGS_ID_SMS_GATEWAY_PASSWORD + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_SMS_GATEWAY_PASSWORD + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

		parameters = new String[] { fes.getMobileCss(), metaId + "", FormEngineSettings.SETTINGS_ID_MOBILE_CSS + "" } ;
		if (null != dbUtil.sqlQueryStr("SELECT setting FROM " + TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?", new String[] { metaId + "", FormEngineSettings.SETTINGS_ID_MOBILE_CSS + "" })) {
			dbUtil.sqlUpdateQuery("UPDATE " + TABLE_PREFIX + "form_settings SET setting = ? WHERE meta_id = ? AND id = ?", parameters) ;
		} else {
			dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings (setting, meta_id, id) VALUES (?, ?, ?)", parameters) ;
		}

        dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings(setting, meta_id, id) VALUES(?, ?, ?) ON DUPLICATE KEY UPDATE setting = VALUES(setting)", new String[]{fes.getScriveOutOfSyncSubject(), String.valueOf(metaId), String.valueOf(FormEngineSettings.SETTINGS_ID_SCRIVE_OUT_OF_SYNC_SUBJECT)});
        dbUtil.sqlUpdateQuery("INSERT INTO " + TABLE_PREFIX + "form_settings(setting, meta_id, id) VALUES(?, ?, ?) ON DUPLICATE KEY UPDATE setting = VALUES(setting)", new String[]{fes.getScriveOutOfSyncBody(), String.valueOf(metaId), String.valueOf(FormEngineSettings.SETTINGS_ID_SCRIVE_OUT_OF_SYNC_BODY)});
	}
}
