package com.imcode.imcms.addon.imsurvey.services;

import com.imcode.imcms.addon.imsurvey.Utils;
import com.imcode.imcms.api.*;
import imcode.server.Imcms;

import javax.servlet.http.HttpServletRequest;

public class StaticClientDetailServiceImpl implements ClientDetailsService {

    private String imSurveyUserLoginName = "imsurvey_client";
    private String imSurveyUserCompany = "imsurvey_client";
    private String imSurveyDocumentAlias = "imsurvey_client";
    private String imSurveyCategoryName = "imsurvey_client";
    private String clientTitle = "Client title placeholder";
    private String clientDescription = "Client description placeholder";

    public User getClient(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest(request);
        UserService userService = cms.getUserService();
        DocumentService documentService = cms.getDocumentService();

        User clientUser = userService.getUser(getImSurveyUserLoginName());
        if (clientUser == null) {
            try {
                clientUser = createUser(userService);
                setup(request, userService, documentService);
            } catch (SaveException e) {
                e.printStackTrace();
                throw new IllegalStateException("Setup failed with message: " + e.getMessage());
            }
        }

        return clientUser;
    }

    public TextDocument getClientDoc(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest(request);
        DocumentService documentService = cms.getDocumentService();
        UserService userService = cms.getUserService();

        TextDocument clientDoc = documentService.getTextDocument(getImSurveyDocumentAlias());
        if (clientDoc == null) {
            try {
                clientDoc = createDocument(documentService);
                setup(request, userService, documentService);
            } catch (SaveException e) {
                e.printStackTrace();
                throw new IllegalStateException("Setup failed with message: " + e.getMessage());
            }
        }

        return clientDoc;
    }

    public Category getCategory(HttpServletRequest request) {
        ContentManagementSystem cms = ContentManagementSystem.fromRequest(request);
        DocumentService documentService = cms.getDocumentService();
        UserService userService = cms.getUserService();

        Category clientCategory = documentService.getCategory(Utils.getClientCategoryType(documentService), getImSurveyCategoryName());
        if (clientCategory == null) {
            try {
                clientCategory = createCategory(documentService);
                setup(request, userService, documentService);
            } catch (SaveException e) {
                e.printStackTrace();
                throw new IllegalStateException("Setup failed with message: " + e.getMessage());
            }
        }

        return clientCategory;
    }

    @Override
    public String getClientTitle(HttpServletRequest request) {
        return this.clientTitle;
    }

    public void setClientTitle(String clientTitle) {
        this.clientTitle = clientTitle;
    }

    @Override
    public String getClientDescription(HttpServletRequest request) {
        return this.clientDescription;
    }

    public void setClientDescription(String clientDescription) {
        this.clientDescription = clientDescription;
    }

    private void setup(HttpServletRequest request, UserService userService, DocumentService documentService) throws SaveException {
        if (getClient(request) == null) {
            createUser(userService);
        }

        if (getCategory(request) == null) {
            createCategory(documentService);
        }

        if (getClientDoc(request) == null) {
            createDocument(documentService);
        }
    }

    /* Set up user, document and category */
    private User createUser(UserService userService) throws SaveException {
        User user = userService.createNewUser(getImSurveyUserLoginName(), "admin");
        user.setCompany(getImSurveyUserCompany());
        userService.saveUser(user);
        return user;
    }

    private Category createCategory(DocumentService documentService) throws IllegalStateException, SaveException {
        Category category = new Category(getImSurveyCategoryName(), Utils.getClientCategoryType(documentService));
        documentService.saveCategory(category);
        return category;
    }

    private TextDocument createDocument(DocumentService documentService) throws SaveException, IllegalStateException {
        int startDocId = Imcms.getServices().getSystemData().getStartDocument();
        Document startDoc = documentService.getDocument(startDocId);
        if (startDoc == null) {
            throw new IllegalStateException("Start document not found: " + startDocId);
        }

        TextDocument userDoc = documentService.createNewTextDocument(startDoc);
        userDoc.setAlias(getImSurveyDocumentAlias());
        documentService.saveChanges(userDoc);
        return userDoc;
    }

    public String getImSurveyUserLoginName() {
        return imSurveyUserLoginName;
    }

    public void setImSurveyUserLoginName(String imSurveyUserLoginName) {
        this.imSurveyUserLoginName = imSurveyUserLoginName;
    }

    public String getImSurveyUserCompany() {
        return imSurveyUserCompany;
    }

    public void setImSurveyUserCompany(String imSurveyUserCompany) {
        this.imSurveyUserCompany = imSurveyUserCompany;
    }

    public String getImSurveyDocumentAlias() {
        return imSurveyDocumentAlias;
    }

    public void setImSurveyDocumentAlias(String imSurveyDocumentAlias) {
        this.imSurveyDocumentAlias = imSurveyDocumentAlias;
    }

    public String getImSurveyCategoryName() {
        return imSurveyCategoryName;
    }

    public void setImSurveyCategoryName(String imSurveyCategoryName) {
        this.imSurveyCategoryName = imSurveyCategoryName;
    }

}
