package com.imcode.imcms.addon.imsurvey.oneflow;

import java.util.HashMap;
import java.util.Map;

/**
 * Possible Oneflow sign methods
 * Created by dmizem from Ubrainians for ImCode on 17.01.17
 *
 * @author dmizem
 */
public enum SignMethod {
    STANDARD(0), SMS(1), BANK_ID(2);

    private final int id;
    private static Map<Integer, SignMethod> map = new HashMap<>();

    static {
        for (SignMethod signMethod : SignMethod.values()) {
            map.put(signMethod.id, signMethod);
        }
    }

    SignMethod(int id) {
        this.id = id;
    }

    public int getValue() {
        return id;
    }

    public static SignMethod valueOf(int id) {
        return map.get(id);
    }

    public static boolean isMember(String value) {
        for (SignMethod field : map.values())
            if (field.name().equals(value.toUpperCase()))
                return true;
        return false;
    }
}