package com.imcode.imcms.addon.imsurvey;

import com.imcode.imcms.addon.db.DBUtil;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;

/* *******************************************************************************************
 *         CLASS - FormEngineUser - Checks adminrights                                       *
 ******************************************************************************************* */

public class FormEngineUser {
	User currentUser ;
	TextDocument thisDoc ;
	UserService userService ;
	DBUtil dbUtil ;
	
	private final static int SETTINGS_ID_ROLE_IDS = 601 ;

	public FormEngineUser(User currentUser, TextDocument thisDoc, UserService userService, DBUtil dbUtil) {
		this.currentUser = currentUser ;
		this.thisDoc     = thisDoc ;
		this.userService = userService ;
		this.dbUtil      = dbUtil ;
	}
	public boolean hasRightToAdmin() {
		if (currentUser.isSuperAdmin()) {
			return true ;
		}
		Role clientAdminRole = Utils.getClientAdminRole(userService);
		if(clientAdminRole!=null && currentUser.hasRole(clientAdminRole)){
			return true;
		}
		Role serviceAdminRole = Utils.getServiceAdminRole(userService);
		if(serviceAdminRole!=null && currentUser.hasRole(serviceAdminRole)){
			return true;
		}/*
		String sSql = "SELECT setting FROM " + FormEngine.TABLE_PREFIX + "form_settings WHERE meta_id = ? AND id = ?" ;
		String role_ids_used = StringUtils.defaultString(dbUtil.sqlQueryStr(sSql, new String[] { thisDoc.getId() + "", SETTINGS_ID_ROLE_IDS + "" })) ;
		String[] roleIdsUsedArray = role_ids_used.split(",") ;
		if (roleIdsUsedArray != null && roleIdsUsedArray.length > 0) {
			for (int i = 0; i < roleIdsUsedArray.length; i++) {
				try {
					if (roleIdsUsedArray[i].matches("^\\d+$")) {
						int adminRoleId = Integer.parseInt(roleIdsUsedArray[i]) ;
						Role adminRole = userService.getRole(adminRoleId) ;
						if (currentUser.hasRole(adminRole)) {
							return true ;
						}
					}
				} catch (Exception e) {
					return false ;
				}
			}
		}*/

		for(String id : thisDoc.getTextField(SystemProperties.IMSURVEY_TEXTFIELD_OFFSET + 301).getText().split(",")){
			if((""+currentUser.getId()).equals(id)){
				return true;
			}
		}
		return false ;
	}
	public boolean isSuperAdmin() {
		return currentUser.isSuperAdmin() ;
	}
}
