package com.imcode.imcms.addon.imsurvey.oneflow;

import com.google.gson.*;
import com.imcode.imcms.addon.imsurvey.SystemProperties;
import com.imcode.imcms.addon.imsurvey.utils.OneflowFields;
import com.imcode.imcms.api.DatabaseService;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Oneflow API service
 * Created by dmizem from Ubrainians for ImCode
 *
 * @author dmizem.
 */
public class OneflowService {
    private static final int FAILURE_HTTP_RESPONSE_CODE = 390;

    private static final String ONEFLOW_BASE_URL = "https://app.oneflow.com";

    private OneflowService() {
    }

    public static OneflowService getInstance() {
        return new OneflowService();
    }

    private static final Logger log = Logger.getLogger(OneflowService.class);

    private Map<String, Document> templateCache = new HashMap<String, Document>();
    private Map<String, Document> templateGroupFieldCache = new HashMap<String, Document>();
    private Map<String, Document> templateGroupCache = new HashMap<String, Document>();
    private Map<String, List<Field>> templateFieldCache = new HashMap<String, List<Field>>();

    private boolean isSwappedToEmail = false;

    public boolean isSurveyInSyncWithOneflow(int surveyId, DatabaseService databaseService) {
        //TODO Probably remove since, oneflow template groups are not the same as on page and not correspond actual agreement template or try a way to implement it
//        Map<String, List<String>> surveyFields = getSurveyFields(surveyId, true, databaseService);
//        for (String templateId : surveyFields.keySet()) {
//            Document template;
//            try {
//                template = getTemplateGroup(templateId);
//            } catch (IOException e) {
//                e.printStackTrace();
//                return false;
//            }
//
//            if (template != null && !template.isDeleted()) {
//                List<String> fields = surveyFields.get(template.getId());
//                List<String> missingFields = getMissingFields(template, fields);
//                if (!missingFields.isEmpty()) {
//                    return false;
//                }
//            } else {
//                return false;
//            }
//        }

        return true;
    }

    //TODO: If check with template field not required can be removed
/*    public List<String> getMissingFields(Document document, List<String> fieldNames) {
        List<String> missingFields = new ArrayList<String>();

        for (String fieldName : fieldNames) {
            boolean hasField = false;
            for (Field field : document.getFields()) {
                if (field.getName().equals(fieldName)) {
                    hasField = true;
                }
            }
            if (!hasField) {
                missingFields.add(fieldName);
            }
        }
        return missingFields;
    }*/

//    TODO: Probably should be removed since there is no sync checking
    /*public Map<String, List<String>> getSurveyFields(int surveyId, boolean isOneFlowField, DatabaseService databaseService) {
        Map<String, List<String>> surveyFields = new HashMap<String, List<String>>();

        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(
                    "SELECT COALESCE(el_fields.template_id, opt_field.template_id) AS template_id, COALESCE(el_fields.field_name, opt_field.field_name) AS field_name" + (isOneFlowField ? ", el_fields.oneflow_field\n" : "\n") +
                            "FROM " + FormEngine.TABLE_PREFIX + "form_elements el \n" +
                            "LEFT JOIN " + FormEngine.TABLE_PREFIX + "form_elements_options opt ON el.id = opt.el_id \n" +
                            "LEFT JOIN " + FormEngine.TABLE_PREFIX + "element_scrive_fields el_fields ON el_fields.`element_id` = el.id \n" +
                            "LEFT JOIN " + FormEngine.TABLE_PREFIX + "element_option_scrive_fields opt_field ON opt_field.`option_id` = opt.id \n" +
                            "WHERE el.meta_id = ?"
                            + (isOneFlowField ? " AND el_fields.oneflow_field = 1" : ""));
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();

            while (rs.next()) {
                String templateId = rs.getString(OneflowFields.SQL_TEMPLATE_ID);
                String fieldName = rs.getString(OneflowFields.SQL_FIELD_NAME);

                if (!StringUtils.isEmpty(templateId) && !StringUtils.isEmpty(fieldName)) {
                    List<String> templateFields = surveyFields.get(templateId);
                    if (templateFields == null) {
                        templateFields = new ArrayList<String>();
                        surveyFields.put(templateId, templateFields);
                    }

                    templateFields.add(fieldName);
                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, rs);
        }

        return surveyFields;
    }*/

    //TODO !!!!
    private String getDocumentURI(String signSuccessUrl, String templateId, Map<String, String> props, HttpServletRequest request) throws Exception {
        if (props.containsKey(OneflowFields.PROPERTY_IM_SURVEY_ID)) {
            try {
//                TODO: probably needed for some technical stuff
//                int imSurveyId = Integer.parseInt(props.get(OneflowFields.PROPERTY_IM_SURVEY_ID));
                props.remove(OneflowFields.PROPERTY_IM_SURVEY_ID);
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        if (templateId == null || templateId.length() <= 4) {
            throw new IllegalArgumentException(OneflowFields.ERROR_WRONG_TEMPLATE_ID + templateId);
        }

        HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + templateId, "GET");

        int responseCode = connection.getResponseCode();

        boolean parserError = false;
        long docId = 0;
        JsonObject fetchedAgreement = null;

        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString(connection.getErrorStream());
            connection.disconnect();
            log.error(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + templateId + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error);
            throw new IOException(error);
        } else {
            JsonElement parsedReturn = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (parsedReturn != null && parsedReturn.isJsonObject()) {
                fetchedAgreement = parsedReturn.getAsJsonObject();

                JsonObject id = fetchedAgreement.getAsJsonObject(OneflowFields.JSON_TEMPLATE_GROUP);
                docId = id.getAsJsonPrimitive(OneflowFields.JSON_ID).getAsLong();
                //TODO: If check with template field not required can be removed
                /*changeDelivery(fetchedAgreement, Integer.toString(DeliveryChannel.EMAIL.getValue()));
                JsonElement signaturesTest = fetchedAgreement.get("signatories");
                if (null != signaturesTest && signaturesTest.isJsonArray()) {
                    JsonArray signatures = signaturesTest.getAsJsonArray();
                    if (signatures.size() == 2) {
                        *//* Use the second signatory for form data. The first one is the author *//*
                        JsonObject sign2 = signatures.get(1).getAsJsonObject();
                        changeDelivery(sign2, useEmailAuthentication ? Integer.toString(DeliveryChannel.EMAIL.getValue()) : Integer.toString(DeliveryChannel.NONE.getValue()));

                        //TODO Check that after getting example of agreement
                        JsonElement fieldsTest = sign2.get("fields");
                        if (null != fieldsTest && fieldsTest.isJsonArray()) {
                            JsonArray fields = fieldsTest.getAsJsonArray();
                            int valuesSet = 0;

                            for (int i = 0; i < fields.size(); i++) {
                                JsonElement elem2 = fields.get(i);
                                if (null != elem2 && elem2.isJsonObject()) {
                                    JsonObject field = elem2.getAsJsonObject();
                                    JsonElement elemName = field.get("name");
                                    JsonElement elemValue = field.get("value");
                                    JsonElement elemType = field.get("type");
//                                    TODO: Check is that possible to get at Oneflow
//                                    boolean hasPlacement = hasPlacement(field);
                                    boolean hasPlacement = false;

                                    if (null != elemName && null != elemValue && null != elemType &&
                                            elemName.isJsonPrimitive() && elemValue.isJsonPrimitive() && elemType.isJsonPrimitive() &&
                                            hasPlacement) {

                                        String fieldName = elemName.getAsString();
                                        if (props.containsKey(fieldName)) {
                                            boolean isCheckbox = "checkbox".equalsIgnoreCase(elemType.getAsString());
                                            String newValue = StringUtils.defaultString(props.get(fieldName));
                                            if (isCheckbox && !newValue.isEmpty()) {
                                                newValue = "true";
                                            }

                                            changeValue(field, newValue);
                                            valuesSet++;
                                        }
                                    }
                                }
                            }
                            if (nbrPropsToSet > 0 && valuesSet != nbrPropsToSet) {
                                parserError = true;
                            }
                        } else {
                            parserError = true;
                        }

                    } else {
                        parserError = true;
                    }
                }*/

            } else {
                parserError = true;
            }
        }

        if (parserError) {
            throw new Exception(OneflowFields.ERROR_TEMPLATE_CHANGED);
        } else {
            // Update the document with form data
            if (docId > 0) {
                String urlParameters = fetchedAgreement.toString();

                //Retrieving agreement data
//                List<Field> fields = getTemplateFields(String.valueOf(docId));
                JsonObject contract = buildContract(templateId, props);
                connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));

                OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
                streamWriter.write(contract.toString());
                streamWriter.close();

                responseCode = connection.getResponseCode();
                log.debug(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + ":" + responseCode + connection.getResponseMessage());

                if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
                    log.error(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + ":" + responseCode + connection.getResponseMessage() + "\n" + IOUtils.toString(connection.getErrorStream()));
                    throw new IOException(IOUtils.toString(connection.getErrorStream()));
                }

                JsonElement agreementResponse = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                connection.disconnect();

                //Getting id and publishing agreement
                if (null != agreementResponse && agreementResponse.isJsonObject()) {
                    JsonPrimitive id = agreementResponse.getAsJsonObject().getAsJsonPrimitive(OneflowFields.JSON_ID);
                    Integer agreementId = id.getAsInt();

                    if (agreementId > 0) {
                        connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + agreementId + "/publish");
                        connection.setRequestProperty("Content-Type", "application/json");
                        connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));

                        JsonObject publishContent = new JsonObject();
                        publishContent.addProperty(OneflowFields.JSON_SUBJECT, OneflowFields.PUBLICATION_SUBJECT);
                        publishContent.addProperty(OneflowFields.JSON_MESSAGE, OneflowFields.PUBLICATION_MESSAGE);

                        OutputStreamWriter streamWriter1 = new OutputStreamWriter(connection.getOutputStream());
                        streamWriter1.write(publishContent.toString());
                        streamWriter1.close();
                        connection.disconnect();

                        if (connection.getResponseCode() < FAILURE_HTTP_RESPONSE_CODE) {
                            log.info("Agreement with id " + agreementId + " was published: " + connection.getResponseCode() + ":" + connection.getResponseMessage());

                            DeliveryChannel deliveryChannel = getDeliveryChannelFromContract(contract, 1);
                            if (null == deliveryChannel) {
                                log.error(OneflowFields.ERROR_OBTAIN_DELIVERY_METHOD + agreementId);
                                connection.disconnect();
                                throw new IOException(OneflowFields.ERROR_OBTAIN_DELIVERY_METHOD + agreementId);
                            }
                            if (deliveryChannel == DeliveryChannel.NONE || isSwappedToEmail) {
                                // Generating user token and creating appropriate URl to redirect
                                JsonElement publishResponse = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                                if (publishResponse.isJsonObject()) {
                                    String participantId = getParticipantId(publishResponse.getAsJsonObject());
                                    String userToken = getUserToken(agreementId.toString(), participantId);
                                    if (!userToken.isEmpty()) {
                                        log.debug("Agreement id:" + agreementId + "\t Participant id: " + participantId + "\t User token:" + userToken);
                                        return "/contracts/" + agreementId + "/at/" + userToken;
                                    }
                                }
                            } else {
                                return signSuccessUrl;
                            }
                        } else {
                            log.error("Agreement with id " + agreementId + " wasn't published: " + connection.getResponseCode() + ":" + connection.getResponseMessage() + "\n" + IOUtils.toString(connection.getErrorStream()));
                            connection.disconnect();
                            throw new IOException(IOUtils.toString(connection.getErrorStream()));
                        }
                    }
                }
                connection.disconnect();
            }
        }
        return null;
    }


    private JsonObject buildContract(String templateId, Map<String, String> props) {
        JsonObject contract = new JsonObject();
        contract.addProperty(OneflowFields.JSON_TEMPLATE_ID, Integer.valueOf(templateId));

        //  Adding participants data
        JsonArray parties = new JsonArray();

        JsonObject party = new JsonObject();
        party.addProperty(OneflowFields.JSON_SELF, 1);

        JsonArray participants = new JsonArray();
        JsonObject participant = new JsonObject();

        participant.addProperty(OneflowFields.JSON_POSITION_ID, Integer.parseInt(SystemProperties.ONEFLOW_CREATOR_POSITION));
        participant.addProperty(OneflowFields.JSON_TYPE, Integer.parseInt(SystemProperties.ONEFLOW_CREATOR_TYPE));
        participants.add(participant);

        party.add(OneflowFields.JSON_PARTICIPANTS, participants);
        parties.add(party);

        List<OneflowParticipant> participantsData = new ArrayList<OneflowParticipant>();

        for (Iterator<Map.Entry<String, String>> it = props.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getValue().isEmpty()) {
                if (entry.getKey().matches(OneflowFields.REGEX_USER_FIELD)) {
                    String[] splittedData = entry.getKey().split(OneflowFields.REGEX_USER_DIVIDER);
                    String userId = splittedData[1].substring(0, splittedData[1].indexOf('_'));
                    String fieldName = splittedData[1].substring(splittedData[1].indexOf('_') + 1, splittedData[1].length());
                    if (!userId.isEmpty() && !fieldName.isEmpty()) {
                        OneflowParticipant oneflowParticipant = null;

                        boolean isNew = true;
                        for (OneflowParticipant op : participantsData) {
                            if (op.getId().equals(userId)) {
                                oneflowParticipant = op;
                                isNew = false;
                            }
                        }
                        if (oneflowParticipant == null) {
                            oneflowParticipant = new OneflowParticipant(userId);
                        }

                        if (UserField.isMember(fieldName.toLowerCase())) {

                            UserField userField = UserField.valueOf(fieldName.toUpperCase());
                            if (userField.equals(UserField.DELIVERY_CHANNEL)) {
                                oneflowParticipant.addValues(userField, String.valueOf(DeliveryChannel.valueOf(entry.getValue())));
                            }

                            if (userField.equals(UserField.SIGN_METHOD)) {
                                oneflowParticipant.addValues(userField, String.valueOf(SignMethod.valueOf(entry.getValue())));

                            } else {
                                oneflowParticipant.addValues(userField, entry.getValue());
                            }
                        }
                        if (isNew) {
                            participantsData.add(oneflowParticipant);
                        }
                    }
                    it.remove();
                }
            }
        }

        // Users in order as it must be
        Collections.sort(participantsData);

        for (OneflowParticipant entity : participantsData) {
            JsonObject partyClient = new JsonObject();
            participants = new JsonArray();
            participant = new JsonObject();
            for (Map.Entry<Enum, String> entry : entity.getValues().entrySet()) {
                String value = entry.getValue();
                Integer intValue = null;

                if (entry.getKey().equals(UserField.NAME) || entry.getKey().equals(UserField.COUNTRY) || entry.getKey().equals(UserField.ORGNR)) {
                    partyClient.addProperty(((UserField) entry.getKey()).getValue(), entry.getValue());
                } else {
                    if (entry.getKey().equals(UserField.DELIVERY_CHANNEL) && DeliveryChannel.isMember(entry.getValue())) {
                        if (DeliveryChannel.valueOf(value) == DeliveryChannel.NONE) {
                            intValue = DeliveryChannel.EMAIL.getValue();
                            isSwappedToEmail = true;
                        } else {
                            intValue = DeliveryChannel.valueOf(value).getValue();
                        }
                    }
                    if (entry.getKey().equals(UserField.SIGN_METHOD) && SignMethod.isMember(entry.getValue())) {
                        intValue = SignMethod.valueOf(value).getValue();
                    }

                    if (entry.getKey().equals(UserField.TYPE)) {
                        intValue = Integer.parseInt(value);
                    }

                    if (intValue != null && (entry.getKey().equals(UserField.DELIVERY_CHANNEL) || entry.getKey().equals(UserField.SIGN_METHOD) || entry.getKey().equals(UserField.TYPE))) {
                        participant.addProperty(((UserField) entry.getKey()).getValue(), intValue);
                    } else {
                        participant.addProperty(((UserField) entry.getKey()).getValue(), value);
                    }
                }
            }

            // Removing not user data w/o all required information form request
            JsonElement tmpName = participant.get(UserField.FULLNAME.getValue());
            JsonElement tmpEmail = participant.get(UserField.EMAIL.getValue());
            if ((null != tmpName && !tmpName.getAsString().isEmpty()) && (null != tmpEmail && !tmpEmail.getAsString().isEmpty())) {
                participants.add(participant);
                partyClient.add(OneflowFields.JSON_PARTICIPANTS, participants);
                parties.add(partyClient);
            }

        }
        contract.add(OneflowFields.JSON_PARTIES, parties);

        // Adding contract data
        JsonArray dataList = new JsonArray();

        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (!entry.getValue().isEmpty()) {
                JsonObject dataItem = new JsonObject();
                dataItem.addProperty(OneflowFields.JSON_KEY, OneflowFields.JSON_DATA_FIELD);

                JsonObject dataItemValue = new JsonObject();
                dataItemValue.addProperty(OneflowFields.JSON_EXTERNAL_KEY, entry.getKey());
                dataItemValue.addProperty(OneflowFields.JSON_VALUE, entry.getValue());
                dataItem.add(OneflowFields.JSON_VALUE, dataItemValue);

                dataList.add(dataItem);
            }
        }

        contract.add(OneflowFields.JSON_DATA, dataList);
        log.info("contract:" + contract);
        return contract;
    }

    private String getUserToken(String agreementId, String userId) throws IOException {
        JsonObject tokenBody = new JsonObject();
        tokenBody.addProperty(OneflowFields.JSON_TYPE, OneflowFields.JSON_FORM);

        HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + agreementId + "/participants/" + userId + "/tokens");
        connection.setRequestProperty("Content-Type", "application/json");

        OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream());
        streamWriter.write(tokenBody.toString());
        streamWriter.close();

        int responseCode = connection.getResponseCode();
        log.debug(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + agreementId + "/participants/" + userId + "/tokens " + ":" + responseCode + connection.getResponseMessage());

        if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            log.error(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + agreementId + "/participants/" + userId + "/tokens " + ":" + responseCode + connection.getResponseMessage() + "\n" + IOUtils.toString(connection.getErrorStream()));
            throw new IOException(IOUtils.toString(connection.getErrorStream()));
        }
        String tokenValue = "";
        JsonElement tokenResponse = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
        connection.disconnect();

        //Getting id and publishing agreement
        if (tokenResponse.isJsonObject()) {
            JsonPrimitive token = tokenResponse.getAsJsonObject().getAsJsonPrimitive(OneflowFields.JSON_TOKEN);
            tokenValue = token.getAsString();
        }

        return tokenValue;
    }

    private String getParticipantId(JsonObject publishedAgreementResponse) {
        String participantId = "";
        JsonArray parties = publishedAgreementResponse.getAsJsonArray(OneflowFields.JSON_PARTIES);
        if (null != parties) {
            for (JsonElement tmpParty : parties) {
                JsonObject party = tmpParty.getAsJsonObject();
                if (null != party.get(OneflowFields.JSON_SELF)) {
                    continue;
                } else {
                    JsonObject participant = party.getAsJsonArray(OneflowFields.JSON_PARTICIPANTS).get(0).getAsJsonObject();
                    // 1 is signatory type
                    if (participant.get(OneflowFields.JSON_TYPE).getAsInt() == 1) {
                        JsonElement idElement = participant.get(OneflowFields.JSON_ID);
                        participantId = idElement.getAsString();
                    }
                }
            }
        }
        return participantId;
    }

    private DeliveryChannel getDeliveryChannelFromContract(JsonObject contract, Integer participantNumber) {
        JsonObject userParty = contract.getAsJsonArray(OneflowFields.JSON_PARTIES).get(participantNumber).getAsJsonObject();
        JsonObject userData = userParty.getAsJsonArray(OneflowFields.JSON_PARTICIPANTS).get(0).getAsJsonObject();
        JsonElement deliveryChannel = userData.get(UserField.DELIVERY_CHANNEL.getValue());

        //If delivery channel wasn't obtained from chosen user, take first acceptable value
        if (null == deliveryChannel) {
            for (JsonElement party : contract.getAsJsonArray(OneflowFields.JSON_PARTIES)) {
                JsonObject tmpUserData = party.getAsJsonObject().getAsJsonArray(OneflowFields.JSON_PARTICIPANTS).get(0).getAsJsonObject();
                deliveryChannel = tmpUserData.get(UserField.DELIVERY_CHANNEL.getValue());
                if (null != deliveryChannel) {
                    DeliveryChannel.valueOf(deliveryChannel.getAsInt());
                }
            }
        }
        return DeliveryChannel.valueOf(deliveryChannel.getAsInt());
    }

    public List<SignMethod> getAvailableSignMethods(String id) throws IOException {
        List<SignMethod> availableMethods = new ArrayList<SignMethod>();

        HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + id, "GET");

        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;

        } else if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString(connection.getErrorStream());
            connection.disconnect();
            log.error(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + ":" + responseCode + connection.getResponseMessage() + "\n" + error);
            throw new IOException(error);
        } else {
            JsonElement signMethodsResponse = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (signMethodsResponse.isJsonObject()) {
                JsonObject optionsElem = signMethodsResponse.getAsJsonObject().getAsJsonObject(OneflowFields.JSON_AVAILABLE_OPTIONS);
                if (null != optionsElem) {
                    JsonArray signMethods = optionsElem.getAsJsonArray(OneflowFields.JSON_SIGN_METHODS);
                    if (null != signMethods) {
                        for (JsonElement signMethod : signMethods) {
                            SignMethod method = SignMethod.valueOf(signMethod.getAsInt());
                            if (null != method) {
                                availableMethods.add(method);
                            }
                        }
                    }
                }
            }
        }

        return availableMethods;
    }

    public List<DeliveryChannel> getAvailableDeliveryChannels(String id) throws IOException {
        List<DeliveryChannel> availableDeliveries = new ArrayList<DeliveryChannel>();

        HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + id, "GET");

        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;

        } else if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString(connection.getErrorStream());
            connection.disconnect();
            log.error(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + id + ":" + responseCode + connection.getResponseMessage() + "\n" + error);
            throw new IOException(error);
        } else {
            JsonElement deliveryChannelResponse = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (deliveryChannelResponse.isJsonObject()) {
                JsonObject optionsElem = deliveryChannelResponse.getAsJsonObject().getAsJsonObject(OneflowFields.JSON_AVAILABLE_OPTIONS);
                if (null != optionsElem) {
                    JsonArray deliveryChannels = optionsElem.getAsJsonArray(OneflowFields.JSON_DELIVERY_CHANNELS);
                    if (null != deliveryChannels) {
                        for (JsonElement deliveryChannel : deliveryChannels) {
                            DeliveryChannel channel = DeliveryChannel.valueOf(deliveryChannel.getAsInt());
                            if (null != channel) {
                                availableDeliveries.add(channel);
                            }
                        }
                    }
                }
            }
        }

        return availableDeliveries;
    }

    public List<Document> getTemplates() throws IOException {
        List<Document> templates = new ArrayList<Document>();

        HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_TEMPLATE_GROUPS_URL, "GET", true);
        if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString(connection.getErrorStream());
            connection.disconnect();
            log.error(ONEFLOW_BASE_URL + OneflowFields.API_TEMPLATE_GROUPS_URL + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error);
            throw new IOException(error);
        } else {
            JsonElement templateGroupsResponse = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (templateGroupsResponse.isJsonObject()) {
                JsonArray templateListElem = (templateGroupsResponse.getAsJsonObject()).getAsJsonArray(OneflowFields.JSON_COLLECTION);
                if (null != templateListElem) {
                    for (JsonElement templateElem : templateListElem) {

                        if (null != templateElem && templateElem.isJsonObject()) {
                            JsonObject templateObj = templateElem.getAsJsonObject();
                            //Getting name of template
                            JsonPrimitive title = templateObj.getAsJsonPrimitive(OneflowFields.JSON_NAME);
                            JsonPrimitive templateId = templateObj.getAsJsonPrimitive(OneflowFields.JSON_ID);

                            if (null != templateId && null != title) {
                                Document template = new Document();
                                template.setId(templateId.getAsString());
                                template.setTitle(title.getAsString());

                                JsonObject templateFieldObj = templateObj.getAsJsonObject(OneflowFields.JSON_DATA_FIELD_SET);
                                if (null != templateFieldObj) {
                                    JsonPrimitive fieldSetId = templateFieldObj.getAsJsonPrimitive(OneflowFields.JSON_ID);
                                    template.setFields(getTemplateFields(fieldSetId.getAsString()));
                                }
                                templates.add(template);
                            }
                        }
                    }
                }
            }
        }
        return templates;
    }

    public Document getDocument(String id) throws IOException {
//        TODO Here document title is not getting
        Document document = null;

        HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + id, "GET");

        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            connection.disconnect();
            return null;

        } else if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
            String error = IOUtils.toString(connection.getErrorStream());
            connection.disconnect();
            log.error(ONEFLOW_BASE_URL + OneflowFields.API_AGREEMENTS_URL + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error);
            throw new IOException(error);

        } else {
            JsonElement parsedReturn = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            connection.disconnect();
            if (parsedReturn.isJsonObject()) {
                document = parseDocument(parsedReturn);
                document.setFields(getTemplateFields(id));
            }
        }

        return document;
    }

    public Document getTemplateGroup(String id) throws IOException {
        Document templateGroup;
        if (templateGroupCache.get(id) != null) {
            templateGroup = templateGroupCache.get(id);
        } else {
            templateGroup = new Document();
            HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_TEMPLATE_GROUPS_URL + id, "GET", true);
            if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
                String error = IOUtils.toString(connection.getErrorStream());
                connection.disconnect();
                log.error(ONEFLOW_BASE_URL + OneflowFields.API_TEMPLATE_GROUPS_URL + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error);
                throw new IOException(error);
            } else {
                JsonElement templateGroupResponse = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                connection.disconnect();
                if (templateGroupResponse.isJsonObject()) {
                    if (null != templateGroupResponse) {
                        JsonObject templateGroupObj = templateGroupResponse.getAsJsonObject();
                        JsonPrimitive title = templateGroupObj.getAsJsonPrimitive(OneflowFields.JSON_NAME);
                        JsonPrimitive templateGroupId = templateGroupObj.getAsJsonPrimitive(OneflowFields.JSON_ID);
                        if (null != templateGroupId && null != title) {
                            templateGroup.setId(templateGroupId.getAsString());
                            templateGroup.setTitle(title.getAsString());
                            JsonObject fieldSetObj = templateGroupObj.getAsJsonObject(OneflowFields.JSON_DATA_FIELD_SET);
                            if (null != fieldSetObj) {
                                JsonPrimitive fieldSetId = fieldSetObj.getAsJsonPrimitive(OneflowFields.JSON_ID);
                                templateGroup.setFields(getTemplateFields(fieldSetId.getAsString()));
                            }
                        }
                    }
                }
            }
            templateGroupCache.put(id, templateGroup);
        }
        return templateGroup;
    }


    /**
     * Method to get list of templates as fields
     *
     * @param id ID of template group
     * @return Document with fields as templates id
     * @throws IOException Error during API reading
     */
    public Document getTemplatesInGroupAsFields(String id) throws IOException {
        Document templateGroup;
        if (templateGroupFieldCache.get(id) != null) {
            templateGroup = templateGroupFieldCache.get(id);
        } else {
            //Getting initial values
            templateGroup = getTemplateGroup(id);
            HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_TEMPLATE_GROUP_BY_ID_URL + id, "GET", true);
            if (connection.getResponseCode() > FAILURE_HTTP_RESPONSE_CODE) {
                String error = IOUtils.toString(connection.getErrorStream());
                connection.disconnect();
                log.error(ONEFLOW_BASE_URL + OneflowFields.API_TEMPLATE_GROUPS_URL + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error);
                throw new IOException(error);
            } else {
                JsonElement templateGroupResponse = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                connection.disconnect();
                if (null != templateGroupResponse && templateGroupResponse.isJsonObject()) {
                    JsonArray templateGroupCollection = templateGroupResponse.getAsJsonObject().getAsJsonArray(OneflowFields.JSON_COLLECTION);
                    if (null != templateGroupCollection) {
                        List<Field> templateList = new ArrayList<Field>();
                        for (JsonElement templateElem : templateGroupCollection) {
                            if (null != templateElem && templateElem.isJsonObject()) {
                                JsonPrimitive name = templateElem.getAsJsonObject().getAsJsonPrimitive(OneflowFields.JSON_NAME);
                                JsonObject agreementElem = templateElem.getAsJsonObject().getAsJsonObject(OneflowFields.JSON_AGREEMENT);
                                if (null != agreementElem) {
                                    //Getting name of template
                                    JsonPrimitive templateId = agreementElem.getAsJsonPrimitive(OneflowFields.JSON_ID);
                                    if (null != templateId && null != name) {
                                        templateList.add(new Field(Field.Type.TEMPLATE, name.getAsString(), templateId.getAsString()));
                                    }
                                }
                            }
                        }
                        templateGroup.setFields(templateList);
                    }
                }
            }
            templateGroupFieldCache.put(id, templateGroup);
        }
        return templateGroup;
    }

    private List<Field> getTemplateFields(String id) throws IOException {
        List<Field> fields = new LinkedList();

        if (templateFieldCache.get(id) != null) {
            fields = templateFieldCache.get(id);
        } else {
            //Getting initial values
            fields = new LinkedList<Field>();
            HttpURLConnection connection = getHttpURLConnection(ONEFLOW_BASE_URL + OneflowFields.API_DATA_SET_URL + id, "GET", true);
            connection.setRequestProperty("Content-Type", "text/plain");

            int responseCode = connection.getResponseCode();
            if (responseCode == 404) {
                connection.disconnect();
                return null;

            } else if (responseCode > FAILURE_HTTP_RESPONSE_CODE) {
                String error = IOUtils.toString(connection.getErrorStream());
                connection.disconnect();
                log.error(ONEFLOW_BASE_URL + OneflowFields.API_DATA_SET_URL + id + ":" + connection.getResponseCode() + connection.getResponseMessage() + "\n" + error);
                throw new IOException(error);

            } else {
                JsonElement agreementsFields = new JsonParser().parse(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                connection.disconnect();
                if (null != agreementsFields && agreementsFields.isJsonObject()) {
                    JsonArray templateListElem = agreementsFields.getAsJsonObject().getAsJsonArray(OneflowFields.JSON_DATA_FIELDS);
                    if (null != templateListElem) {
                        for (JsonElement templateElem : templateListElem) {
                            JsonObject templateObj = templateElem.getAsJsonObject();
                            JsonPrimitive name = templateObj.getAsJsonPrimitive(OneflowFields.JSON_NAME);
                            JsonPrimitive externalKey = templateObj.getAsJsonPrimitive(OneflowFields.JSON_EXTERNAL_KEY);
                            if (null != name && null != externalKey) {
                                fields.add(new Field(Field.Type.TEXT, name.getAsString(), externalKey.getAsString()));
                            }
                        }
                    }
                }
                templateFieldCache.put(id, fields);
            }
        }
        return fields;
    }

    private Document parseDocument(JsonElement documentElement) {
        Document document = null;

        if (documentElement.isJsonObject()) {
            document = new Document();
            JsonObject jsonObject = documentElement.getAsJsonObject();

            JsonPrimitive idElem = jsonObject.getAsJsonPrimitive(OneflowFields.JSON_ID);
            if (idElem != null) {
                document.setId(idElem.getAsString());
            }

            JsonPrimitive titleElem = jsonObject.getAsJsonPrimitive(OneflowFields.JSON_NAME);
            if (titleElem != null) {
                document.setTitle(titleElem.getAsString());
            }
            //TODO: Maybe that should be handled in some other way

   /*         boolean deleted = false;
            JsonElement deletedElem = jsonObject.get("deleted");
            if (deletedElem != null && deletedElem.isJsonPrimitive()) {
                deleted = deletedElem.getAsBoolean();
            }
            document.setDeleted(deleted);
*/
        }
        return document;
    }

    private HttpURLConnection getHttpURLConnection(String callUrl) throws IOException {
        return getHttpURLConnection(callUrl, "POST");
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method) throws IOException {
        return getHttpURLConnection(callUrl, method, false);
    }

    private HttpURLConnection getHttpURLConnection(String callUrl, String method, boolean isSystemCall) throws IOException {
        URL url = new URL(callUrl);
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.addRequestProperty("X-Flow-API-Token", SystemProperties.ONEFLOW_SECURITY_TOKEN);
        connection.addRequestProperty("X-Flow-Current-Position", isSystemCall ? SystemProperties.ONEFLOW_SYSTEM_POSITION : SystemProperties.ONEFLOW_CURRENT_POSITION);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("charset", "utf-8");
        connection.setUseCaches(false);
        return connection;
    }

    public Map<Document, List<Field>> getElementOptionTemplateFields(int optionId, DatabaseService databaseService) throws IOException {
        Map<Document, List<Field>> optionFields = new HashMap<Document, List<Field>>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_OPTIONS_TEMPLATE_FIELDS);
            ps.setInt(1, optionId);
            rs = ps.executeQuery();
            Document template;
            while (rs.next()) {
                String templateId = rs.getString(OneflowFields.SQL_TEMPLATE_ID);
                String fieldName = rs.getString(OneflowFields.SQL_FIELD_NAME);

                if (templateCache.get(templateId) != null) {
                    template = templateCache.get(templateId);
                } else {
                    templateCache.put(templateId, getTemplateGroup(templateId));
                    template = templateCache.get(templateId);
                }
                if (template != null) {
                    List<Field> fields = optionFields.get(template);
                    if (fieldName.matches(OneflowFields.REGEX_USER_FIELD)) {
                        if (fields == null) {
                            fields = new ArrayList<Field>();
                            optionFields.put(template, fields);
                        }
                        fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));
                        template.getFields().add(new Field(Field.Type.CHECKBOX, UserField.DELIVERY_CHANNEL.name(), UserField.DELIVERY_CHANNEL.name().toUpperCase()));
                        template.getFields().add(new Field(Field.Type.CHECKBOX, UserField.SIGN_METHOD.name(), UserField.SIGN_METHOD.name().toUpperCase()));
                    } else {
                        for (Field field : template.getFields()) {
                            fields = optionFields.get(template);
                            if (field.getName().equals(fieldName)) {
                                if (fields == null) {
                                    fields = new ArrayList<Field>();
                                    optionFields.put(template, fields);
                                }
                                fields.add(field);
                            }
                        }
                    }

                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, rs);
        }

        return optionFields;
    }

    public Map<Document, List<Field>> getElementTemplateFields(int elementId, DatabaseService databaseService) throws IOException {
        Map<Document, List<Field>> templateFields = new HashMap<Document, List<Field>>();

        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_TEMPLATE_FIELDS);
            ps.setInt(1, elementId);
            rs = ps.executeQuery();
            Document template;

            while (rs.next()) {
                String templateId = rs.getString(OneflowFields.SQL_TEMPLATE_ID);
                String fieldName = rs.getString(OneflowFields.SQL_FIELD_NAME);

                if (templateCache.get(templateId) != null) {
                    template = templateCache.get(templateId);
                } else {
                    templateCache.put(templateId, getTemplateGroup(templateId));
                    template = templateCache.get(templateId);
                }
                if (template != null) {
                    List<Field> fields = templateFields.get(template);
                    if (fields == null) {
                        fields = new ArrayList<Field>();

                    }
                    if (fieldName.matches(OneflowFields.REGEX_TEMPLATE_ID)) {
                        List<Field> allFields = template.getFields();
                        allFields.addAll(getTemplatesInGroupAsFields(templateId).getFields());
                        template.setFields(allFields);
                        fields.add(new Field(Field.Type.TEMPLATE, templateId, fieldName));
                    }
                    if (fieldName.matches(OneflowFields.REGEX_USER_FIELD)) {
//                        List<String> userFields = UserField.values();

                        Pattern fieldPattern = Pattern.compile(OneflowFields.REGEX_USER_DATA_BY_GROUPS);
                        Matcher matcher = fieldPattern.matcher(fieldName);
                        if (matcher.find()) {
//                            String userId = matcher.group(0);
                            fields.add(new Field(Field.Type.USER_FIELD, templateId, fieldName));

//                            TODO: Probably validate user id
//                        fieldName = matcher.group(2);
//                        for (Field field : template.getFields()) {
//                            for (UserField c : UserField.values()) {
//                                if (c.name().equals(fieldName.toString().toUpperCase())) {
//                                    fields.add(field);
//                                }
//                            }
//                        }
//                                }
                        }
                    } else {
                        for (Field field : template.getFields()) {
                            if (field.getName().equals(fieldName)) {
                                fields.add(field);
                            }
                        }
                    }
                    templateFields.put(template, fields);
                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, rs);
        }

        return templateFields;
    }

    public List<Field> getTemplateUsers(int surveyId, DatabaseService databaseService) {
        List<Field> templateFields = new ArrayList<Field>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_TEMPLATE_USERS);
            ps.setInt(1, surveyId);
            rs = ps.executeQuery();

            while (rs.next()) {
                String userId = rs.getString(OneflowFields.SQL_ID);
                String fieldName = rs.getString(OneflowFields.SQL_EL_TEXT);

                if (!StringUtils.isEmpty(userId) && !StringUtils.isEmpty(fieldName)) {
                    templateFields.add(new Field(Field.Type.USER, fieldName, userId));
                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, rs);
        }
        return templateFields;
    }

    public String getUserElementIdByMetaId(int surveyId, DatabaseService databaseService) {
        String elId = "";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try {
            connection = databaseService.getConnection();
            ps = connection.prepareStatement(OneflowFields.QUERY_ELEMENT_ID_BY_META_ID);

            ps.setInt(1, surveyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                elId = rs.getString(OneflowFields.SQL_ID);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbUtils.closeQuietly(connection, ps, rs);
        }
        return elId;
    }

    public String getSignatureFormURL(String backToSiteURL, String templateId, Map<String, String> oneflowParams, HttpServletRequest request) throws Exception {
        String oneflowDocumentURI = getDocumentURI(backToSiteURL, templateId, oneflowParams, request);
        if (oneflowDocumentURI == null) {
            return null;
        }

        return ONEFLOW_BASE_URL + oneflowDocumentURI;
    }

}